/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.nether.reputationhelper.kuudra;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.crimsonisle.ReputationHelperConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.jsonobjects.repo.ReputationQuest;
import at.hannibal2.skyhanni.events.kuudra.KuudraCompleteEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniRenderWorldEvent;
import at.hannibal2.skyhanni.features.nether.kuudra.KuudraTier;
import at.hannibal2.skyhanni.features.nether.reputationhelper.CrimsonIsleReputationHelper;
import at.hannibal2.skyhanni.features.nether.reputationhelper.dailyquest.DailyQuestHelper;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.NeuInternalName;
import at.hannibal2.skyhanni.utils.NeuItems;
import at.hannibal2.skyhanni.utils.collection.RenderableCollectionUtils;
import at.hannibal2.skyhanni.utils.render.WorldRenderUtils;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import at.hannibal2.skyhanni.utils.renderables.RenderableUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\u0006*\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0010\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0010\u0010\u0003J\u0015\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J!\u0010\u0019\u001a\u00020\u00062\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u001b\u0010\u0014J\u000f\u0010\u001c\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u0003J\u0019\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001d\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u0019\u0010#\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\"\u001a\u00020!H\u0002\u00a2\u0006\u0004\b#\u0010$R\u0017\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001e0%8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0018\u0010*\u001a\u0004\u0018\u00010)8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0016\u0010-\u001a\u00020,8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u0014\u00102\u001a\u00020/8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101\u00a8\u00063"}, d2={"Lat/hannibal2/skyhanni/features/nether/reputationhelper/kuudra/DailyKuudraBossHelper;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "event", "", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;)V", "Lat/hannibal2/skyhanni/events/kuudra/KuudraCompleteEvent;", "onKuudraDone", "(Lat/hannibal2/skyhanni/events/kuudra/KuudraCompleteEvent;)V", "", "Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "addKuudraBoss", "(Ljava/util/List;)V", "reset", "Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$CrimsonIsleStorage;", "storage", "saveConfig", "(Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$CrimsonIsleStorage;)V", "", "", "Lat/hannibal2/skyhanni/data/jsonobjects/repo/ReputationQuest;", "data", "onRepoReload", "(Ljava/util/Map;)V", "loadData", "updateAllKuudraDone", "name", "Lat/hannibal2/skyhanni/features/nether/kuudra/KuudraTier;", "getByDisplayName", "(Ljava/lang/String;)Lat/hannibal2/skyhanni/features/nether/kuudra/KuudraTier;", "", "number", "getByTier", "(I)Lat/hannibal2/skyhanni/features/nether/kuudra/KuudraTier;", "Lkotlin/enums/EnumEntries;", "getKuudraTiers", "()Lkotlin/enums/EnumEntries;", "kuudraTiers", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "kuudraLocation", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "", "allKuudraDone", "Z", "Lat/hannibal2/skyhanni/config/features/crimsonisle/ReputationHelperConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/crimsonisle/ReputationHelperConfig;", "config", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nDailyKuudraBossHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DailyKuudraBossHelper.kt\nat/hannibal2/skyhanni/features/nether/reputationhelper/kuudra/DailyKuudraBossHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,122:1\n1782#2,4:123\n774#2:127\n865#2,2:128\n1863#2,2:130\n1755#2,3:132\n295#2,2:135\n295#2,2:137\n*S KotlinDebug\n*F\n+ 1 DailyKuudraBossHelper.kt\nat/hannibal2/skyhanni/features/nether/reputationhelper/kuudra/DailyKuudraBossHelper\n*L\n59#1:123,4\n88#1:127\n88#1:128,2\n89#1:130,2\n115#1:132,3\n118#1:135,2\n120#1:137,2\n*E\n"})
public final class DailyKuudraBossHelper {
    @NotNull
    public static final DailyKuudraBossHelper INSTANCE = new DailyKuudraBossHelper();
    @Nullable
    private static LorenzVec kuudraLocation;
    private static boolean allKuudraDone;

    private DailyKuudraBossHelper() {
    }

    @NotNull
    public final EnumEntries<KuudraTier> getKuudraTiers() {
        return KuudraTier.getEntries();
    }

    private final ReputationHelperConfig getConfig() {
        return SkyHanniMod.feature.getCrimsonIsle().getReputationHelper();
    }

    @HandleEvent(onlyOnIsland=IslandType.CRIMSON_ISLE)
    public final void onRenderWorld(@NotNull SkyHanniRenderWorldEvent event) {
        block3: {
            Intrinsics.checkNotNullParameter(event, "event");
            if (!((Boolean)this.getConfig().getEnabled().get()).booleanValue()) {
                return;
            }
            if (!CrimsonIsleReputationHelper.INSTANCE.showLocations()) {
                return;
            }
            if (allKuudraDone) {
                return;
            }
            LorenzVec lorenzVec = kuudraLocation;
            if (lorenzVec == null) break block3;
            LorenzVec it = lorenzVec;
            boolean bl = false;
            WorldRenderUtils.drawWaypointFilled$default(WorldRenderUtils.INSTANCE, event, it, LorenzColor.WHITE.toColor(), false, false, 0.0, 0.0, 0.0, 0.0f, false, 508, null);
            WorldRenderUtils.drawDynamicText$default(WorldRenderUtils.INSTANCE, event, it, "Kuudra", 1.5, 0.0f, 0.0, 0.0, false, false, null, 504, null);
        }
    }

    @HandleEvent
    public final void onKuudraDone(@NotNull KuudraCompleteEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        int tier = event.getKuudraTier();
        KuudraTier kuudraTier = this.getByTier(tier);
        if (kuudraTier == null) {
            return;
        }
        KuudraTier kuudraTier2 = kuudraTier;
        ChatUtils.debug$default(ChatUtils.INSTANCE, "Detected kuudra tier done: " + kuudraTier2.getTieredDisplayName(), false, 2, null);
        DailyQuestHelper.INSTANCE.finishKuudra(kuudraTier2);
        kuudraTier2.setDoneToday(true);
        this.updateAllKuudraDone();
        CrimsonIsleReputationHelper.INSTANCE.update();
    }

    public final void addKuudraBoss(@NotNull List<Renderable> $this$addKuudraBoss) {
        int n;
        Intrinsics.checkNotNullParameter($this$addKuudraBoss, "<this>");
        Iterable $this$count$iv = this.getKuudraTiers();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                KuudraTier it = (KuudraTier)((Object)element$iv);
                boolean bl = false;
                if (!it.getDoneToday() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int done = n;
        RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$addKuudraBoss, "", 0.0, null, null, 14, null);
        RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$addKuudraBoss, "\u00a77Daily Kuudra (\u00a7e" + done + "\u00a78/\u00a7e5 killed\u00a77)", 0.0, null, null, 14, null);
        if (done < 5) {
            for (KuudraTier tier : this.getKuudraTiers()) {
                if (((Boolean)this.getConfig().getHideComplete().get()).booleanValue() && tier.getDoneToday()) continue;
                String result2 = tier.getDoneToday() ? "\u00a7aDone" : "\u00a7bTodo";
                String displayName = tier.getTieredDisplayName();
                NeuInternalName displayItem = tier.getDisplayItem();
                RenderableUtilsKt.addLine($this$addKuudraBoss, arg_0 -> DailyKuudraBossHelper.addKuudraBoss$lambda$2(displayItem, displayName, result2, arg_0));
            }
        }
    }

    public final void reset() {
        for (KuudraTier miniBoss : this.getKuudraTiers()) {
            miniBoss.setDoneToday(false);
        }
        this.updateAllKuudraDone();
    }

    /*
     * WARNING - void declaration
     */
    public final void saveConfig(@NotNull ProfileSpecificStorage.CrimsonIsleStorage storage2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(storage2, "storage");
        storage2.getKuudraTiersDone().clear();
        Iterable $this$filter$iv = this.getKuudraTiers();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KuudraTier it = (KuudraTier)((Object)element$iv$iv);
            boolean bl = false;
            if (!it.getDoneToday()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KuudraTier it = (KuudraTier)((Object)element$iv);
            boolean bl = false;
            storage2.getKuudraTiersDone().add(it.name());
        }
    }

    public final void onRepoReload(@NotNull Map<String, ReputationQuest> data2) {
        Intrinsics.checkNotNullParameter(data2, "data");
        int tier = 1;
        for (Map.Entry<String, ReputationQuest> entry : data2.entrySet()) {
            String displayName = entry.getKey();
            ReputationQuest kuudraTier = entry.getValue();
            NeuInternalName displayItem = kuudraTier.getItem();
            LorenzVec location = CrimsonIsleReputationHelper.INSTANCE.readLocationData(kuudraTier.getLocation());
            if (location != null) {
                kuudraLocation = location;
            }
            KuudraTier.Companion.addRepoData(displayName, displayItem, location, tier);
            ++tier;
        }
    }

    public final void loadData(@NotNull ProfileSpecificStorage.CrimsonIsleStorage storage2) {
        Intrinsics.checkNotNullParameter(storage2, "storage");
        if (this.getKuudraTiers().isEmpty()) {
            return;
        }
        for (String name2 : storage2.getKuudraTiersDone()) {
            KuudraTier kuudraTier = this.getByDisplayName(name2);
            if (kuudraTier == null) continue;
            kuudraTier.setDoneToday(true);
        }
        this.updateAllKuudraDone();
    }

    private final void updateAllKuudraDone() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.getKuudraTiers();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KuudraTier it = (KuudraTier)((Object)element$iv);
                    boolean bl2 = false;
                    if (!(!it.getDoneToday())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        allKuudraDone = !bl;
    }

    private final KuudraTier getByDisplayName(String name2) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.getKuudraTiers();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KuudraTier it = (KuudraTier)((Object)element$iv);
                boolean bl = false;
                if (!Intrinsics.areEqual(it.name(), name2)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final KuudraTier getByTier(int number) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.getKuudraTiers();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KuudraTier it = (KuudraTier)((Object)element$iv);
                boolean bl = false;
                if (!(it.getTierNumber() == number)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final Unit addKuudraBoss$lambda$2(NeuInternalName $displayItem, String $displayName, String $result, List $this$addLine) {
        Intrinsics.checkNotNullParameter($displayItem, "$displayItem");
        Intrinsics.checkNotNullParameter($displayName, "$displayName");
        Intrinsics.checkNotNullParameter($result, "$result");
        Intrinsics.checkNotNullParameter($this$addLine, "$this$addLine");
        RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$addLine, " ", 0.0, null, null, 14, null);
        RenderableCollectionUtils.addItemStack$default(RenderableCollectionUtils.INSTANCE, $this$addLine, NeuItems.INSTANCE.getItemStack($displayItem), false, 0.0, 6, null);
        RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$addLine, $displayName + ": " + $result, 0.0, null, null, 14, null);
        return Unit.INSTANCE;
    }

    static {
        allKuudraDone = true;
    }
}

