/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.bridge;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.commons.Remapper;
import org.spongepowered.asm.mixin.extensibility.IRemapper;
import org.spongepowered.asm.util.ObfuscationUtil;

public abstract class RemapperAdapter
implements IRemapper,
ObfuscationUtil.IClassRemapper {
    protected final Logger logger = LogManager.getLogger((String)"mixin");
    protected final Remapper remapper;

    public RemapperAdapter(Remapper remapper) {
        this.remapper = remapper;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String mapMethodName(String owner, String name2, String desc) {
        this.logger.debug("{} is remapping method {}{} for {}", new Object[]{this, name2, desc, owner});
        String newName = this.remapper.mapMethodName(owner, name2, desc);
        if (!newName.equals(name2)) {
            return newName;
        }
        String obfOwner = this.unmap(owner);
        String obfDesc = this.unmapDesc(desc);
        this.logger.debug("{} is remapping obfuscated method {}{} for {}", new Object[]{this, name2, obfDesc, obfOwner});
        return this.remapper.mapMethodName(obfOwner, name2, obfDesc);
    }

    @Override
    public String mapFieldName(String owner, String name2, String desc) {
        this.logger.debug("{} is remapping field {}{} for {}", new Object[]{this, name2, desc, owner});
        String newName = this.remapper.mapFieldName(owner, name2, desc);
        if (!newName.equals(name2)) {
            return newName;
        }
        String obfOwner = this.unmap(owner);
        String obfDesc = this.unmapDesc(desc);
        this.logger.debug("{} is remapping obfuscated field {}{} for {}", new Object[]{this, name2, obfDesc, obfOwner});
        return this.remapper.mapFieldName(obfOwner, name2, obfDesc);
    }

    @Override
    public String map(String typeName) {
        this.logger.debug("{} is remapping class {}", new Object[]{this, typeName});
        return this.remapper.map(typeName);
    }

    @Override
    public String unmap(String typeName) {
        return typeName;
    }

    @Override
    public String mapDesc(String desc) {
        return this.remapper.mapDesc(desc);
    }

    @Override
    public String unmapDesc(String desc) {
        return ObfuscationUtil.unmapDescriptor(desc, this);
    }
}

