/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.farming;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.garden.cropmilestones.CropMilestonesConfig;
import at.hannibal2.skyhanni.config.features.garden.cropmilestones.NextConfig;
import at.hannibal2.skyhanni.data.GardenCropMilestones;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import at.hannibal2.skyhanni.features.garden.CropType;
import at.hannibal2.skyhanni.features.garden.GardenApi;
import at.hannibal2.skyhanni.features.garden.GardenNextJacobContest;
import at.hannibal2.skyhanni.features.garden.farming.GardenCropSpeed;
import at.hannibal2.skyhanni.utils.ConditionalUtils;
import at.hannibal2.skyhanni.utils.TimeUnit;
import at.hannibal2.skyhanni.utils.TimeUtils;
import at.hannibal2.skyhanni.utils.collection.CollectionUtils;
import at.hannibal2.skyhanni.utils.collection.RenderableCollectionUtils;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import at.hannibal2.skyhanni.utils.renderables.container.HorizontalContainerRenderable;
import at.hannibal2.skyhanni.utils.renderables.container.VerticalContainerRenderable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003J\r\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\u0003J\u0017\u0010\u000b\u001a\u00020\n2\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u000b\u0010\fJ;\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0019H\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001cR$\u0010\u001d\u001a\u0004\u0018\u00010\u00138\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0014\u0010&\u001a\u00020#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R#\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020(0'8\u0006\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,\u00a8\u0006-"}, d2={"Lat/hannibal2/skyhanni/features/garden/farming/GardenBestCropTime;", "", "<init>", "()V", "", "onConfigLoad", "reset", "updateTimeTillNextCrop", "Lat/hannibal2/skyhanni/features/garden/CropType;", "currentCrop", "Lat/hannibal2/skyhanni/utils/renderables/container/VerticalContainerRenderable;", "drawBestDisplay", "(Lat/hannibal2/skyhanni/features/garden/CropType;)Lat/hannibal2/skyhanni/utils/renderables/container/VerticalContainerRenderable;", "crop", "", "index", "", "useOverflow", "gardenExp", "Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "createCropEntry", "(Lat/hannibal2/skyhanni/features/garden/CropType;IZZLat/hannibal2/skyhanni/features/garden/CropType;)Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "gardenLevel", "getGardenExpForTier", "(I)I", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "event", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "display", "Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "getDisplay", "()Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "setDisplay", "(Lat/hannibal2/skyhanni/utils/renderables/Renderable;)V", "Lat/hannibal2/skyhanni/config/features/garden/cropmilestones/CropMilestonesConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/cropmilestones/CropMilestonesConfig;", "config", "", "Lkotlin/time/Duration;", "timeTillNextCrop", "Ljava/util/Map;", "getTimeTillNextCrop", "()Ljava/util/Map;", "1.21.7"})
@SourceDebugExtension(value={"SMAP\nGardenBestCropTime.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GardenBestCropTime.kt\nat/hannibal2/skyhanni/features/garden/farming/GardenBestCropTime\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,165:1\n1869#2:166\n1870#2:168\n1#3:167\n*S KotlinDebug\n*F\n+ 1 GardenBestCropTime.kt\nat/hannibal2/skyhanni/features/garden/farming/GardenBestCropTime\n*L\n119#1:166\n119#1:168\n*E\n"})
public final class GardenBestCropTime {
    @NotNull
    public static final GardenBestCropTime INSTANCE = new GardenBestCropTime();
    @Nullable
    private static Renderable display;
    @NotNull
    private static final Map<CropType, Duration> timeTillNextCrop;

    private GardenBestCropTime() {
    }

    @Nullable
    public final Renderable getDisplay() {
        return display;
    }

    public final void setDisplay(@Nullable Renderable renderable2) {
        display = renderable2;
    }

    private final CropMilestonesConfig getConfig() {
        return GardenApi.INSTANCE.getConfig().getCropMilestones();
    }

    @NotNull
    public final Map<CropType, Duration> getTimeTillNextCrop() {
        return timeTillNextCrop;
    }

    @HandleEvent
    public final void onConfigLoad() {
        Property[] propertyArray = new Property[]{this.getConfig().getNext().getBestType(), this.getConfig().getNext().getShowOnlyBest(), this.getConfig().getNext().getShowCurrent(), this.getConfig().getNext().getBestAlwaysOn(), this.getConfig().getNext().getBestCompact(), this.getConfig().getNext().getBestHideTitle()};
        ConditionalUtils.INSTANCE.onToggle(propertyArray, GardenBestCropTime::onConfigLoad$lambda$0);
    }

    public final void reset() {
        timeTillNextCrop.clear();
        this.updateTimeTillNextCrop();
    }

    public final void updateTimeTillNextCrop() {
        boolean useOverflow = this.getConfig().getOverflow().getBestCropTime();
        for (CropType crop : CropType.getEntries()) {
            Integer n = GardenCropSpeed.INSTANCE.getSpeed(crop);
            if (n == null) {
                continue;
            }
            int speed = n;
            if (GardenCropMilestones.INSTANCE.isMaxed(crop, useOverflow)) continue;
            long counter = GardenCropMilestones.INSTANCE.getCounter(crop);
            int currentTier = GardenCropMilestones.INSTANCE.getTierForCropCount(counter, crop, true);
            long cropsForCurrentTier = GardenCropMilestones.getCropsForTier$default(GardenCropMilestones.INSTANCE, currentTier, crop, false, 4, null);
            int nextTier = (Boolean)this.getConfig().getBestShowMaxedNeeded().get() != false ? 46 : currentTier + 1;
            long cropsForNextTier = GardenCropMilestones.getCropsForTier$default(GardenCropMilestones.INSTANCE, nextTier, crop, false, 4, null);
            long have = counter - cropsForCurrentTier;
            long need = cropsForNextTier - cropsForCurrentTier;
            long missing = need - have;
            long missingTimeSeconds = missing / (long)speed;
            long millis = missingTimeSeconds * (long)1000;
            Map<CropType, Duration> map = timeTillNextCrop;
            Duration duration = Duration.box-impl((long)DurationKt.toDuration((long)millis, (DurationUnit)DurationUnit.MILLISECONDS));
            map.put(crop, duration);
        }
    }

    @NotNull
    public final VerticalContainerRenderable drawBestDisplay(@Nullable CropType currentCrop) {
        return VerticalContainerRenderable.Companion.vertical$default(VerticalContainerRenderable.Companion, Renderable.Companion, 0, null, null, arg_0 -> GardenBestCropTime.drawBestDisplay$lambda$2(currentCrop, arg_0), 7, null);
    }

    private final Renderable createCropEntry(CropType crop, int index, boolean useOverflow, boolean gardenExp, CropType currentCrop) {
        boolean isCurrent;
        if (GardenCropMilestones.INSTANCE.isMaxed(crop, useOverflow)) {
            return null;
        }
        Duration duration = timeTillNextCrop.get((Object)crop);
        if (duration == null) {
            return null;
        }
        long millis = duration.unbox-impl();
        TimeUnit biggestUnit = ((CropMilestonesConfig.TimeFormatEntry)((Object)this.getConfig().getHighestTimeFormat().get())).getTimeUnit();
        String duration2 = TimeUtils.format-ABIMYHs$default(TimeUtils.INSTANCE, millis, biggestUnit, false, false, 2, false, false, 54, null);
        boolean bl = isCurrent = crop == currentCrop;
        if (!(index <= ((Number)this.getConfig().getNext().getShowOnlyBest().get()).intValue() || ((Boolean)this.getConfig().getNext().getShowCurrent().get()).booleanValue() && isCurrent)) {
            return null;
        }
        return HorizontalContainerRenderable.Companion.horizontal$default(HorizontalContainerRenderable.Companion, Renderable.Companion, 0, null, null, arg_0 -> GardenBestCropTime.createCropEntry$lambda$3(index, crop, isCurrent, duration2, gardenExp, arg_0), 7, null);
    }

    private final int getGardenExpForTier(int gardenLevel) {
        return gardenLevel > 30 ? 300 : gardenLevel * 10;
    }

    @HandleEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.cropMilestoneBestType", "garden.cropMilestones.next.bestType", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.cropMilestoneShowOnlyBest", "garden.cropMilestones.next.showOnlyBest", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.cropMilestoneShowCurrent", "garden.cropMilestones.next.showCurrent", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.cropMilestoneBestCompact", "garden.cropMilestones.next.bestCompact", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.cropMilestoneBestHideTitle", "garden.cropMilestones.next.bestHideTitle", null, 8, null);
    }

    private static final void onConfigLoad$lambda$0() {
        CropType cropType = GardenApi.INSTANCE.getCurrentlyFarmedCrop();
        if (cropType == null) {
            return;
        }
        CropType currentCrop = cropType;
        display = INSTANCE.drawBestDisplay(currentCrop);
    }

    private static final Unit drawBestDisplay$lambda$2(CropType $currentCrop, List $this$vertical) {
        Map<CropType, Duration> sorted;
        Intrinsics.checkNotNullParameter((Object)$this$vertical, (String)"$this$vertical");
        if (timeTillNextCrop.size() < CropType.getEntries().size()) {
            INSTANCE.updateTimeTillNextCrop();
        }
        boolean gardenExp = INSTANCE.getConfig().getNext().getBestType().get() == NextConfig.BestTypeEntry.GARDEN_EXP;
        boolean useOverflow = INSTANCE.getConfig().getOverflow().getBestCropTime();
        if (gardenExp) {
            Map helpMap = new LinkedHashMap();
            for (Map.Entry<CropType, Duration> object : timeTillNextCrop.entrySet()) {
                CropType crop = object.getKey();
                long time = object.getValue().unbox-impl();
                if (GardenCropMilestones.INSTANCE.isMaxed(crop, useOverflow)) continue;
                int currentTier = GardenCropMilestones.INSTANCE.getTierForCropCount(GardenCropMilestones.INSTANCE.getCounter(crop), crop, true);
                int gardenExpForTier = INSTANCE.getGardenExpForTier(currentTier + 1);
                long fakeTime = Duration.div-UwyO8pc((long)time, (int)gardenExpForTier);
                helpMap.put(crop, Duration.getInWholeMilliseconds-impl((long)fakeTime));
            }
            v0 = CollectionUtils.INSTANCE.sorted(helpMap);
        } else {
            v0 = sorted = CollectionUtils.INSTANCE.sorted(timeTillNextCrop);
        }
        if (!((Boolean)INSTANCE.getConfig().getNext().getBestHideTitle().get()).booleanValue()) {
            String title;
            String string = title = gardenExp ? "\u00a72Garden Experience" : "\u00a7bSkyBlock Level";
            if (((Boolean)INSTANCE.getConfig().getNext().getBestCompact().get()).booleanValue()) {
                RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$vertical, "\u00a7eBest Crop Time", 0.0, null, null, 14, null);
            } else {
                RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$vertical, "\u00a7eBest Crop Time \u00a77(" + title + "\u00a77)", 0.0, null, null, 14, null);
            }
        }
        if (!INSTANCE.getConfig().getProgress()) {
            RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$vertical, "\u00a7cCrop Milestone Progress Display is disabled!", 0.0, null, null, 14, null);
            return Unit.INSTANCE;
        }
        if (sorted.isEmpty()) {
            RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$vertical, "\u00a7cFarm crops to add them to this list!", 0.0, null, null, 14, null);
            return Unit.INSTANCE;
        }
        Iterable $this$forEach$iv = CollectionsKt.withIndex((Iterable)sorted.keySet());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Renderable p0;
            IndexedValue indexedValue = (IndexedValue)element$iv;
            boolean bl = false;
            int index = indexedValue.component1();
            CropType crop = (CropType)((Object)indexedValue.component2());
            if (INSTANCE.createCropEntry(crop, index + 1, useOverflow, gardenExp, $currentCrop) == null) continue;
            boolean bl2 = false;
            $this$vertical.add(p0);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createCropEntry$lambda$3(int $index, CropType $crop, boolean $isCurrent, String $duration, boolean $gardenExp, List $this$horizontal) {
        Intrinsics.checkNotNullParameter((Object)((Object)$crop), (String)"$crop");
        Intrinsics.checkNotNullParameter((Object)$duration, (String)"$duration");
        Intrinsics.checkNotNullParameter((Object)$this$horizontal, (String)"$this$horizontal");
        if (!((Boolean)INSTANCE.getConfig().getNext().getBestCompact().get()).booleanValue()) {
            RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$horizontal, "\u00a77" + $index + "# ", 0.0, null, null, 14, null);
        }
        RenderableCollectionUtils.addItemStack$default(RenderableCollectionUtils.INSTANCE, $this$horizontal, $crop.getIcon(), false, 0.0, 6, null);
        String color = $isCurrent ? "\u00a7e" : "\u00a77";
        String contestFormat = GardenNextJacobContest.INSTANCE.isNextCrop($crop) ? "\u00a7n" : "";
        int currentTier = GardenCropMilestones.INSTANCE.getTierForCropCount(GardenCropMilestones.INSTANCE.getCounter($crop), $crop, true);
        int nextTier = (Boolean)INSTANCE.getConfig().getBestShowMaxedNeeded().get() != false ? 46 : currentTier + 1;
        String cropName = (Boolean)INSTANCE.getConfig().getNext().getBestCompact().get() == false ? $crop.getCropName() + " " : "";
        String tier = (Boolean)INSTANCE.getConfig().getNext().getBestCompact().get() == false ? currentTier + "\u279c" + nextTier + "\u00a7r " : "";
        RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$horizontal, color + contestFormat + cropName + tier + "\u00a7b" + $duration, 0.0, null, null, 14, null);
        if ($gardenExp && !((Boolean)INSTANCE.getConfig().getNext().getBestCompact().get()).booleanValue()) {
            int gardenExpForTier = INSTANCE.getGardenExpForTier(nextTier);
            RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$horizontal, " \u00a77(\u00a72" + gardenExpForTier + " \u00a77Exp)", 0.0, null, null, 14, null);
        }
        return Unit.INSTANCE;
    }

    static {
        timeTillNextCrop = new LinkedHashMap();
    }
}

