/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.farming;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.commands.CommandBuilder;
import at.hannibal2.skyhanni.config.commands.CommandCategory;
import at.hannibal2.skyhanni.config.commands.CommandRegistrationEvent;
import at.hannibal2.skyhanni.config.features.garden.CropStartLocationConfig;
import at.hannibal2.skyhanni.config.features.garden.GardenConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.ClickType;
import at.hannibal2.skyhanni.events.garden.farming.CropClickEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniRenderWorldEvent;
import at.hannibal2.skyhanni.features.garden.CropType;
import at.hannibal2.skyhanni.features.garden.GardenApi;
import at.hannibal2.skyhanni.features.garden.farming.GardenCropSpeed;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.render.WorldRenderUtils;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.reflect.KProperty0;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0012J\r\u0010\u0015\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0015\u0010\u0012R\u0014\u0010\u0019\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u001a\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lat/hannibal2/skyhanni/features/garden/farming/GardenStartLocation;", "", "<init>", "()V", "", "setLocationCommand", "Lat/hannibal2/skyhanni/events/garden/farming/CropClickEvent;", "event", "onCropClick", "(Lat/hannibal2/skyhanni/events/garden/farming/CropClickEvent;)V", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;)V", "Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;", "onCommandRegistration", "(Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;)V", "", "shouldShowBoth", "()Z", "showStartWaypoint", "showLastFarmedWaypoint", "isEnabled", "Lat/hannibal2/skyhanni/config/features/garden/CropStartLocationConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/CropStartLocationConfig;", "config", "shouldShowLastFarmedWaypoint", "Z", "1.21.7"})
public final class GardenStartLocation {
    @NotNull
    public static final GardenStartLocation INSTANCE = new GardenStartLocation();
    private static boolean shouldShowLastFarmedWaypoint;

    private GardenStartLocation() {
    }

    private final CropStartLocationConfig getConfig() {
        return GardenApi.INSTANCE.getConfig().getCropStartLocation();
    }

    private final void setLocationCommand() {
        Map<CropType, LorenzVec> startLocations;
        if (!GardenApi.INSTANCE.inGarden()) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, "This Command only works in the garden!", false, 2, null);
            return;
        }
        if (!this.getConfig().getEnabled()) {
            ChatUtils.INSTANCE.chatAndOpenConfig("This feature is disabled. Enable it in the config: \u00a7e/sh crop start location", (KProperty0)new PropertyReference0Impl(GardenApi.INSTANCE.getConfig()){

                public Object get() {
                    return ((GardenConfig)this.receiver).getCropStartLocation();
                }
            });
            return;
        }
        ProfileSpecificStorage.GardenStorage gardenStorage = GardenApi.INSTANCE.getStorage();
        Map<CropType, LorenzVec> map = startLocations = gardenStorage != null ? gardenStorage.getCropStartLocations() : null;
        if (startLocations == null) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, "The config is not yet loaded, retry in a second.", false, 2, null);
            return;
        }
        CropType crop = GardenApi.INSTANCE.getCurrentlyFarmedCrop();
        if (crop == null) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, "Hold a crop specific farming tool in the hand!", false, 2, null);
            return;
        }
        startLocations.put(crop, LocationUtils.INSTANCE.playerLocation());
        ChatUtils.chat$default(ChatUtils.INSTANCE, "You changed your Crop Start Location for " + crop.getCropName() + "!", false, null, false, false, null, 62, null);
    }

    @HandleEvent
    public final void onCropClick(@NotNull CropClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        if (event.getClickType() != ClickType.LEFT_CLICK || !GardenApi.INSTANCE.hasFarmingToolInHand()) {
            return;
        }
        Object object = GardenApi.INSTANCE.getStorage();
        if (object == null || (object = ((ProfileSpecificStorage.GardenStorage)object).getCropStartLocations()) == null) {
            return;
        }
        Object startLocations = object;
        Object object2 = GardenApi.INSTANCE.getStorage();
        if (object2 == null || (object2 = ((ProfileSpecificStorage.GardenStorage)object2).getCropLastFarmedLocations()) == null) {
            return;
        }
        Object lastFarmedLocations = object2;
        CropType cropType = GardenApi.INSTANCE.getCurrentlyFarmedCrop();
        if (cropType == null) {
            return;
        }
        CropType crop = cropType;
        if (crop != GardenCropSpeed.INSTANCE.getLastBrokenCrop()) {
            return;
        }
        if (!startLocations.containsKey((Object)crop)) {
            startLocations.put(crop, LocationUtils.INSTANCE.playerLocation());
            ChatUtils.chat$default(ChatUtils.INSTANCE, "Auto updated your Crop Start Location for " + crop.getCropName(), false, null, false, false, null, 62, null);
        }
        lastFarmedLocations.put(crop, LocationUtils.INSTANCE.playerLocation().roundToBlock());
        shouldShowLastFarmedWaypoint = false;
    }

    @HandleEvent
    public final void onRenderWorld(@NotNull SkyHanniRenderWorldEvent event) {
        LorenzVec lorenzVec;
        LorenzVec lorenzVec2;
        Map<CropType, LorenzVec> map;
        ProfileSpecificStorage.GardenStorage gardenStorage;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        CropType cropType = GardenApi.INSTANCE.getCropInHand();
        if (cropType == null) {
            return;
        }
        CropType crop = cropType;
        if (this.showStartWaypoint() && (gardenStorage = GardenApi.INSTANCE.getStorage()) != null && (map = gardenStorage.getCropStartLocations()) != null && (lorenzVec2 = map.get((Object)crop)) != null && (lorenzVec = lorenzVec2.roundToBlock()) != null) {
            LorenzVec lorenzVec3;
            LorenzVec it = lorenzVec3 = lorenzVec;
            boolean bl = false;
            WorldRenderUtils.drawWaypointFilled$default(WorldRenderUtils.INSTANCE, event, it, LorenzColor.WHITE.toColor(), false, false, 0.0, 0.0, 0.0, 0.0f, false, 508, null);
            WorldRenderUtils.drawDynamicText$default(WorldRenderUtils.INSTANCE, event, it, "\u00a7b" + crop.getCropName(), 1.5, 0.0f, 0.0, 0.0, false, false, null, 504, null);
            if (INSTANCE.shouldShowBoth()) {
                WorldRenderUtils.drawDynamicText$default(WorldRenderUtils.INSTANCE, event, it, "\u00a7aStart Location", 1.1, 12.0f, 0.0, 0.0, false, false, null, 496, null);
            }
        }
        if (this.showLastFarmedWaypoint()) {
            LorenzVec location;
            Object object = GardenApi.INSTANCE.getStorage();
            LorenzVec lorenzVec4 = object != null && (object = ((ProfileSpecificStorage.GardenStorage)object).getCropLastFarmedLocations()) != null ? (LorenzVec)object.get((Object)crop) : (location = null);
            if (location != null) {
                if (LocationUtils.INSTANCE.distanceSqToPlayer(location) >= 100.0) {
                    shouldShowLastFarmedWaypoint = true;
                }
                if (shouldShowLastFarmedWaypoint) {
                    WorldRenderUtils.drawWaypointFilled$default(WorldRenderUtils.INSTANCE, event, location, LorenzColor.LIGHT_PURPLE.toColor(), true, true, 0.0, 0.0, 0.0, 0.0f, false, 496, null);
                    WorldRenderUtils.drawDynamicText$default(WorldRenderUtils.INSTANCE, event, location, "\u00a7b" + crop.getCropName(), 1.5, 0.0f, 0.0, 0.0, false, false, null, 504, null);
                    if (this.shouldShowBoth()) {
                        WorldRenderUtils.drawDynamicText$default(WorldRenderUtils.INSTANCE, event, location, "\u00a7eLast Farmed", 1.1, 12.0f, 0.0, 0.0, false, false, null, 496, null);
                    }
                }
            }
        }
    }

    @HandleEvent
    public final void onCommandRegistration(@NotNull CommandRegistrationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.register("shcropstartlocation", (Function1<? super CommandBuilder, Unit>)((Function1)GardenStartLocation::onCommandRegistration$lambda$2));
    }

    private final boolean shouldShowBoth() {
        return this.getConfig().getMode() == CropStartLocationConfig.CropLocationMode.BOTH;
    }

    private final boolean showStartWaypoint() {
        return this.getConfig().getMode() != CropStartLocationConfig.CropLocationMode.LAST_FARMED;
    }

    private final boolean showLastFarmedWaypoint() {
        return this.getConfig().getMode() != CropStartLocationConfig.CropLocationMode.START;
    }

    public final boolean isEnabled() {
        return GardenApi.INSTANCE.inGarden() && this.getConfig().getEnabled();
    }

    private static final Unit onCommandRegistration$lambda$2$lambda$1(String[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        INSTANCE.setLocationCommand();
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$2(CommandBuilder $this$register) {
        Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
        $this$register.setDescription("Manually sets the crop start location");
        $this$register.setCategory(CommandCategory.USERS_ACTIVE);
        $this$register.callback((Function1<? super String[], Unit>)((Function1)GardenStartLocation::onCommandRegistration$lambda$2$lambda$1));
        return Unit.INSTANCE;
    }
}

