/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.commons.net.ftp.parser;

import at.hannibal2.skyhanni.deps.commons.net.ftp.FTPClientConfig;
import at.hannibal2.skyhanni.deps.commons.net.ftp.FTPFile;
import at.hannibal2.skyhanni.deps.commons.net.ftp.parser.ConfigurableFTPFileEntryParserImpl;
import at.hannibal2.skyhanni.deps.commons.net.ftp.parser.UnixFTPEntryParser;
import java.text.ParseException;
import java.util.List;

public class MVSFTPEntryParser
extends ConfigurableFTPFileEntryParserImpl {
    static final int UNKNOWN_LIST_TYPE = -1;
    static final int FILE_LIST_TYPE = 0;
    static final int MEMBER_LIST_TYPE = 1;
    static final int UNIX_LIST_TYPE = 2;
    static final int JES_LEVEL_1_LIST_TYPE = 3;
    static final int JES_LEVEL_2_LIST_TYPE = 4;
    static final String DEFAULT_DATE_FORMAT = "yyyy/MM/dd HH:mm";
    static final String FILE_LIST_REGEX = "\\S+\\s+\\S+\\s+\\S+\\s+\\S+\\s+(?:\\S+\\s+)?\\S+\\s+\\S+\\s+\\S+\\s+(PS|PO|PO-E)\\s+(\\S+)\\s*";
    static final String MEMBER_LIST_REGEX = "(\\S+)\\s+\\S+\\s+\\S+\\s+(\\S+)\\s+(\\S+)\\s+\\S+\\s+\\S+\\s+\\S+\\s+\\S+\\s*";
    static final String JES_LEVEL_1_LIST_REGEX = "(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s*";
    static final String JES_LEVEL_2_LIST_REGEX = "(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+).*";
    private int isType = -1;
    private UnixFTPEntryParser unixFTPEntryParser;

    public MVSFTPEntryParser() {
        super("");
        super.configure(null);
    }

    @Override
    protected FTPClientConfig getDefaultConfiguration() {
        return new FTPClientConfig("MVS", DEFAULT_DATE_FORMAT, null);
    }

    private FTPFile parseFileList(String entry) {
        if (this.matches(entry)) {
            FTPFile file = new FTPFile();
            file.setRawListing(entry);
            String name2 = this.group(2);
            String dsorg = this.group(1);
            file.setName(name2);
            if ("PS".equals(dsorg)) {
                file.setType(0);
            } else if ("PO".equals(dsorg) || "PO-E".equals(dsorg)) {
                file.setType(1);
            } else {
                return null;
            }
            return file;
        }
        boolean migrated = entry.startsWith("Migrated");
        if (migrated || entry.startsWith("ARCIVE")) {
            FTPFile file = new FTPFile();
            file.setRawListing(entry);
            file.setType(3);
            file.setName(entry.split("\\s+")[migrated ? 1 : 5]);
            return file;
        }
        return null;
    }

    @Override
    public FTPFile parseFTPEntry(String entry) {
        switch (this.isType) {
            case 0: {
                return this.parseFileList(entry);
            }
            case 1: {
                return this.parseMemberList(entry);
            }
            case 2: {
                return this.unixFTPEntryParser.parseFTPEntry(entry);
            }
            case 3: {
                return this.parseJeslevel1List(entry);
            }
            case 4: {
                return this.parseJeslevel2List(entry);
            }
        }
        return null;
    }

    private FTPFile parseJeslevel1List(String entry) {
        return this.parseJeslevelList(entry, 3);
    }

    private FTPFile parseJeslevel2List(String entry) {
        return this.parseJeslevelList(entry, 4);
    }

    private FTPFile parseJeslevelList(String entry, int matchNum) {
        if (this.matches(entry)) {
            FTPFile file = new FTPFile();
            if (this.group(matchNum).equalsIgnoreCase("OUTPUT")) {
                file.setRawListing(entry);
                String name2 = this.group(2);
                file.setName(name2);
                file.setType(0);
                return file;
            }
        }
        return null;
    }

    private FTPFile parseMemberList(String entry) {
        FTPFile file = new FTPFile();
        if (this.matches(entry)) {
            file.setRawListing(entry);
            String name2 = this.group(1);
            String datestr = this.group(2) + " " + this.group(3);
            file.setName(name2);
            file.setType(0);
            try {
                file.setTimestamp(super.parseTimestamp(datestr));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return file;
        }
        if (entry != null && !entry.trim().isEmpty()) {
            file.setRawListing(entry);
            String name3 = entry.split(" ")[0];
            file.setName(name3);
            file.setType(0);
            return file;
        }
        return null;
    }

    @Override
    public List<String> preParse(List<String> orig) {
        if (orig != null && !orig.isEmpty()) {
            String header = orig.get(0);
            if (header.contains("Volume") && header.contains("Dsname")) {
                this.setType(0);
                super.setRegex(FILE_LIST_REGEX);
            } else if (header.contains("Name") && header.contains("Id")) {
                this.setType(1);
                super.setRegex(MEMBER_LIST_REGEX);
            } else if (header.startsWith("total")) {
                this.setType(2);
                this.unixFTPEntryParser = new UnixFTPEntryParser();
            } else if (header.indexOf("Spool Files") >= 30) {
                this.setType(3);
                super.setRegex(JES_LEVEL_1_LIST_REGEX);
            } else if (header.startsWith("JOBNAME") && header.indexOf("JOBID") > 8) {
                this.setType(4);
                super.setRegex(JES_LEVEL_2_LIST_REGEX);
            } else {
                this.setType(-1);
            }
            if (this.isType != 3) {
                orig.remove(0);
            }
        }
        return orig;
    }

    void setType(int type2) {
        this.isType = type2;
    }
}

