/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.moulconfig.gui.editors;

import at.hannibal2.skyhanni.deps.moulconfig.ChromaColour;
import at.hannibal2.skyhanni.deps.moulconfig.GuiTextures;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiComponent;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiImmediateContext;
import at.hannibal2.skyhanni.deps.moulconfig.gui.MouseEvent;
import at.hannibal2.skyhanni.deps.moulconfig.gui.component.ColorSelectComponent;
import at.hannibal2.skyhanni.deps.moulconfig.gui.editors.ComponentEditor;
import at.hannibal2.skyhanni.deps.moulconfig.internal.ColourUtil;
import at.hannibal2.skyhanni.deps.moulconfig.processor.ProcessedOption;
import java.lang.reflect.Type;
import org.jetbrains.annotations.NotNull;

public class GuiOptionEditorColour
extends ComponentEditor {
    private final boolean usesString;
    GuiComponent component;

    public GuiOptionEditorColour(ProcessedOption option) {
        super(option);
        Type type2 = option.getType();
        if (type2.equals(String.class)) {
            this.usesString = true;
        } else if (type2.equals(ChromaColour.class)) {
            this.usesString = false;
        } else {
            throw new IllegalArgumentException("ConfigEditorColour may only be used on a String or ChromaColour field, but is used on " + option.getDebugDeclarationLocation());
        }
        this.component = this.wrapComponent(new GuiComponent(){

            @Override
            public int getWidth() {
                return 48;
            }

            @Override
            public int getHeight() {
                return 16;
            }

            @Override
            public void render(@NotNull GuiImmediateContext context2) {
                int argb = GuiOptionEditorColour.this.get().getEffectiveColour().getRGB();
                context2.getRenderContext().drawComplexTexture(GuiTextures.BUTTON_WHITE, 0.0f, 0.0f, context2.getWidth(), context2.getHeight(), it -> it.color(ColourUtil.makeOpaque(argb)));
            }

            @Override
            public boolean mouseEvent(@NotNull MouseEvent mouseEvent, @NotNull GuiImmediateContext context2) {
                MouseEvent.Click click;
                if (mouseEvent instanceof MouseEvent.Click && (click = (MouseEvent.Click)mouseEvent).getMouseState() && click.getMouseButton() == 0 && context2.isHovered()) {
                    ColorSelectComponent colorSelectComponent = new ColorSelectComponent(0, 0, GuiOptionEditorColour.this.get().toLegacyString(), newString -> GuiOptionEditorColour.this.set((String)newString), () -> GuiOptionEditorColour.this.closeOverlay());
                    int scaledHeight = context2.getRenderContext().getMinecraft().getScaledHeight();
                    int clampedY = context2.getAbsoluteMouseY() + colorSelectComponent.getHeight() > scaledHeight ? scaledHeight - colorSelectComponent.getHeight() : context2.getAbsoluteMouseY();
                    GuiOptionEditorColour.this.openOverlay(colorSelectComponent, context2.getAbsoluteMouseX(), clampedY);
                    return true;
                }
                return false;
            }
        });
    }

    ChromaColour get() {
        Object value = this.option.get();
        if (this.usesString) {
            return ChromaColour.forLegacyString((String)value);
        }
        return (ChromaColour)value;
    }

    void set(String newString) {
        if (this.usesString) {
            this.option.set(newString);
        } else {
            this.option.set(ChromaColour.forLegacyString(newString));
        }
    }

    @Override
    @NotNull
    public GuiComponent getDelegate() {
        return this.component;
    }
}

