/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.composter;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.garden.composter.ComposterConfig;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.events.GuiContainerEvent;
import at.hannibal2.skyhanni.events.minecraft.ToolTipEvent;
import at.hannibal2.skyhanni.features.garden.GardenApi;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemPriceUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.NeuInternalName;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RenderUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_476;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eR\u0014\u0010\u0012\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lat/hannibal2/skyhanni/features/garden/composter/GardenComposterInventoryFeatures;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/minecraft/ToolTipEvent;", "event", "", "onToolTip", "(Lat/hannibal2/skyhanni/events/minecraft/ToolTipEvent;)V", "Lat/hannibal2/skyhanni/events/GuiContainerEvent$BackgroundDrawnEvent;", "onBackgroundDrawn", "(Lat/hannibal2/skyhanni/events/GuiContainerEvent$BackgroundDrawnEvent;)V", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/config/features/garden/composter/ComposterConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/composter/ComposterConfig;", "config", "1.21.7"})
@SourceDebugExtension(value={"SMAP\nGardenComposterInventoryFeatures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GardenComposterInventoryFeatures.kt\nat/hannibal2/skyhanni/features/garden/composter/GardenComposterInventoryFeatures\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n1761#2,3:98\n*S KotlinDebug\n*F\n+ 1 GardenComposterInventoryFeatures.kt\nat/hannibal2/skyhanni/features/garden/composter/GardenComposterInventoryFeatures\n*L\n84#1:98,3\n*E\n"})
public final class GardenComposterInventoryFeatures {
    @NotNull
    public static final GardenComposterInventoryFeatures INSTANCE = new GardenComposterInventoryFeatures();

    private GardenComposterInventoryFeatures() {
    }

    private final ComposterConfig getConfig() {
        return GardenApi.INSTANCE.getConfig().getComposters();
    }

    @HandleEvent(onlyOnIsland=IslandType.GARDEN)
    public final void onToolTip(@NotNull ToolTipEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.getConfig().getUpgradePrice()) {
            return;
        }
        if (!Intrinsics.areEqual((Object)InventoryUtils.INSTANCE.openInventoryName(), (Object)"Composter Upgrades")) {
            return;
        }
        boolean next = false;
        List<String> list = event.getToolTip();
        int i2 = -1;
        int indexFullCost = 0;
        double fullPrice = 0.0;
        int amountItems = 0;
        for (String line : event.toolTipRemovedPrefix()) {
            Pair<String, Integer> pair;
            ++i2;
            if (Intrinsics.areEqual((Object)line, (Object)"\u00a77Upgrade Cost:")) {
                next = true;
                indexFullCost = i2;
                continue;
            }
            if (!next || StringsKt.endsWith$default((String)line, (String)" Copper", (boolean)false, (int)2, null)) continue;
            if (Intrinsics.areEqual((Object)line, (Object)"")) break;
            if (ItemUtils.INSTANCE.readItemAmount(line) == null) {
                GardenComposterInventoryFeatures $this$onToolTip_u24lambda_u240 = this;
                boolean bl = false;
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"line", (Object)line)};
                ErrorManager.logErrorStateWithData$default(ErrorManager.INSTANCE, "Error reading item line", "could not read item line", pairArray, false, false, false, null, 120, null);
                continue;
            }
            String itemName2 = (String)pair.component1();
            int amount = ((Number)pair.component2()).intValue();
            NeuInternalName internalName2 = NeuInternalName.Companion.fromItemName(itemName2);
            double lowestBin = ItemPriceUtils.getPrice$default(ItemPriceUtils.INSTANCE, internalName2, null, null, 3, null);
            double price = lowestBin * (double)amount;
            fullPrice += price;
            String format = NumberUtil.shortFormat$default(NumberUtil.INSTANCE, price, false, 1, null);
            list.set(i2, list.get(i2) + " \u00a77(\u00a76" + format + "\u00a77)");
            ++amountItems;
        }
        if (amountItems > 1) {
            String format = NumberUtil.shortFormat$default(NumberUtil.INSTANCE, fullPrice, false, 1, null);
            list.set(indexFullCost, list.get(indexFullCost) + " \u00a77(\u00a76" + format + "\u00a77)");
        }
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onBackgroundDrawn(@NotNull GuiContainerEvent.BackgroundDrawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.getConfig().getHighlightUpgrade()) {
            return;
        }
        if (Intrinsics.areEqual((Object)InventoryUtils.INSTANCE.openInventoryName(), (Object)"Composter Upgrades")) {
            if (!(event.getGui() instanceof class_476)) {
                return;
            }
            class_1703 class_17032 = event.getContainer();
            Intrinsics.checkNotNull((Object)class_17032, (String)"null cannot be cast to non-null type net.minecraft.screen.GenericContainerScreenHandler");
            class_1707 chest = (class_1707)class_17032;
            for (Map.Entry<class_1735, class_1799> entry : InventoryUtils.INSTANCE.getUpperItems(chest).entrySet()) {
                boolean bl;
                class_1735 slot;
                block7: {
                    slot = entry.getKey();
                    class_1799 stack = entry.getValue();
                    Iterable $this$any$iv = ItemUtils.INSTANCE.getLore(stack);
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it, (Object)"\u00a7eClick to upgrade!")) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                RenderUtils.INSTANCE.highlight(slot, LorenzColor.GOLD);
            }
        }
    }

    @HandleEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.composterUpgradePrice", "garden.composters.upgradePrice", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.composterHighLightUpgrade", "garden.composters.highlightUpgrade", null, 8, null);
    }
}

