/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.slayer;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.commands.CommandBuilder;
import at.hannibal2.skyhanni.config.commands.CommandCategory;
import at.hannibal2.skyhanni.config.commands.CommandRegistrationEvent;
import at.hannibal2.skyhanni.config.features.slayer.SlayerProfitTrackerConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.ItemAddManager;
import at.hannibal2.skyhanni.data.SlayerApi;
import at.hannibal2.skyhanni.data.jsonobjects.repo.SlayerProfitTrackerItemsJson;
import at.hannibal2.skyhanni.data.repo.AbstractRepoManager;
import at.hannibal2.skyhanni.data.repo.AbstractRepoReloadEvent;
import at.hannibal2.skyhanni.events.ItemAddEvent;
import at.hannibal2.skyhanni.events.PurseChangeCause;
import at.hannibal2.skyhanni.events.PurseChangeEvent;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.events.SlayerQuestCompleteEvent;
import at.hannibal2.skyhanni.events.chat.SkyHanniChatEvent;
import at.hannibal2.skyhanni.events.slayer.SlayerChangeEvent;
import at.hannibal2.skyhanni.features.misc.ReplaceRomanNumerals;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.NeuInternalName;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.RenderDisplayHelper;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.collection.RenderableCollectionUtils;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import at.hannibal2.skyhanni.utils.renderables.Searchable;
import at.hannibal2.skyhanni.utils.renderables.SearchableKt;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.tracker.ItemTrackerData;
import at.hannibal2.skyhanni.utils.tracker.SkyHanniItemTracker;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import kotlin.reflect.KType;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001VB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u001aH\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001e\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u001dH\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001fJ'\u0010&\u001a\u00020\u00062\u0006\u0010!\u001a\u00020 2\u0006\u0010#\u001a\u00020\"2\u0006\u0010%\u001a\u00020$H\u0002\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010(\u001a\u00020$2\u0006\u0010!\u001a\u00020 H\u0002\u00a2\u0006\u0004\b(\u0010)J\u001d\u0010-\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010*\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b-\u0010.J\u000f\u0010/\u001a\u00020$H\u0002\u00a2\u0006\u0004\b/\u00100J\u0017\u00102\u001a\u00020\u00062\u0006\u0010\n\u001a\u000201H\u0007\u00a2\u0006\u0004\b2\u00103J\r\u00104\u001a\u00020$\u00a2\u0006\u0004\b4\u00100J\r\u00105\u001a\u00020\u0006\u00a2\u0006\u0004\b5\u0010\u0003J\u0017\u00107\u001a\u00020\u00062\u0006\u0010\n\u001a\u000206H\u0007\u00a2\u0006\u0004\b7\u00108R\u0014\u0010<\u001a\u0002098BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u0016\u0010>\u001a\u00020=8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b>\u0010?R\u0014\u0010B\u001a\u00020=8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010AR\u0016\u0010C\u001a\u00020=8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bC\u0010?R&\u0010E\u001a\u0014\u0012\u0004\u0012\u00020=\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160D8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bE\u0010FR\u001b\u0010L\u001a\u00020G8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bH\u0010I\u001a\u0004\bJ\u0010KR(\u0010N\u001a\u0014\u0012\u0004\u0012\u00020=\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0+0M8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bN\u0010FR5\u0010R\u001a \u0012\u0004\u0012\u00020P\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020=\u0012\n\u0012\b\u0012\u0004\u0012\u00020=0+0Q0O8\u0006\u00a2\u0006\f\n\u0004\bR\u0010S\u001a\u0004\bT\u0010U\u00a8\u0006W"}, d2={"Lat/hannibal2/skyhanni/features/slayer/SlayerProfitTracker;", "", "<init>", "()V", "", "price", "", "addSlayerCosts", "(D)V", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "event", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "Lat/hannibal2/skyhanni/events/PurseChangeEvent;", "onPurseChange", "(Lat/hannibal2/skyhanni/events/PurseChangeEvent;)V", "Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;)V", "Lat/hannibal2/skyhanni/events/slayer/SlayerChangeEvent;", "onSlayerChange", "(Lat/hannibal2/skyhanni/events/slayer/SlayerChangeEvent;)V", "Lat/hannibal2/skyhanni/utils/tracker/SkyHanniItemTracker;", "Lat/hannibal2/skyhanni/features/slayer/SlayerProfitTracker$Data;", "getTracker", "()Lat/hannibal2/skyhanni/utils/tracker/SkyHanniItemTracker;", "Lat/hannibal2/skyhanni/events/SlayerQuestCompleteEvent;", "onQuestComplete", "(Lat/hannibal2/skyhanni/events/SlayerQuestCompleteEvent;)V", "Lat/hannibal2/skyhanni/events/ItemAddEvent;", "onItemAdd", "(Lat/hannibal2/skyhanni/events/ItemAddEvent;)V", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "internalName", "", "amount", "", "command", "tryAddItem", "(Lat/hannibal2/skyhanni/utils/NeuInternalName;IZ)V", "isAllowedItem", "(Lat/hannibal2/skyhanni/utils/NeuInternalName;)Z", "data", "", "Lat/hannibal2/skyhanni/utils/renderables/Searchable;", "drawDisplay", "(Lat/hannibal2/skyhanni/features/slayer/SlayerProfitTracker$Data;)Ljava/util/List;", "shouldShowDisplay", "()Z", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "isEnabled", "resetCommand", "Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;", "onCommandRegistration", "(Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;)V", "Lat/hannibal2/skyhanni/config/features/slayer/SlayerProfitTrackerConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/slayer/SlayerProfitTrackerConfig;", "config", "", "category", "Ljava/lang/String;", "getCategoryName", "()Ljava/lang/String;", "categoryName", "baseSlayerType", "", "trackers", "Ljava/util/Map;", "Ljava/util/regex/Pattern;", "autoSlayerBankPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getAutoSlayerBankPattern", "()Ljava/util/regex/Pattern;", "autoSlayerBankPattern", "", "allowedItems", "Lkotlin/Function1;", "Lat/hannibal2/skyhanni/utils/tracker/ItemTrackerData$TrackedItem;", "Lkotlin/Pair;", "coinFormat", "Lkotlin/jvm/functions/Function1;", "getCoinFormat", "()Lkotlin/jvm/functions/Function1;", "Data", "1.21.7"})
@SourceDebugExtension(value={"SMAP\nSlayerProfitTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlayerProfitTracker.kt\nat/hannibal2/skyhanni/features/slayer/SlayerProfitTracker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 AbstractRepoReloadEvent.kt\nat/hannibal2/skyhanni/data/repo/AbstractRepoReloadEvent\n+ 4 AbstractRepoManager.kt\nat/hannibal2/skyhanni/data/repo/AbstractRepoManager\n+ 5 JsonUtils.kt\nat/hannibal2/skyhanni/utils/json/JsonUtilsKt\n+ 6 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 7 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 8 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,285:1\n1#2:286\n1#2:311\n13#3,7:287\n21#3,6:304\n168#4,5:294\n173#4,4:300\n24#5:299\n8#6:310\n384#7,7:312\n384#7,7:319\n1563#8:326\n1634#8,3:327\n1563#8:330\n1634#8,3:331\n*S KotlinDebug\n*F\n+ 1 SlayerProfitTracker.kt\nat/hannibal2/skyhanni/features/slayer/SlayerProfitTracker\n*L\n121#1:311\n94#1:287,7\n94#1:304,6\n94#1:294,5\n94#1:300,4\n94#1:299\n121#1:310\n137#1:312,7\n139#1:319,7\n243#1:326\n243#1:327,3\n245#1:330\n245#1:331,3\n*E\n"})
public final class SlayerProfitTracker {
    @NotNull
    public static final SlayerProfitTracker INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static String category;
    @NotNull
    private static String baseSlayerType;
    @NotNull
    private static final Map<String, SkyHanniItemTracker<Data>> trackers;
    @NotNull
    private static final RepoPattern autoSlayerBankPattern$delegate;
    @NotNull
    private static Map<String, ? extends List<NeuInternalName>> allowedItems;
    @NotNull
    private static final Function1<ItemTrackerData.TrackedItem, Pair<String, List<String>>> coinFormat;

    private SlayerProfitTracker() {
    }

    private final SlayerProfitTrackerConfig getConfig() {
        return SlayerApi.INSTANCE.getConfig().getItemProfitTracker();
    }

    private final String getCategoryName() {
        return ReplaceRomanNumerals.INSTANCE.replaceLine(category);
    }

    private final Pattern getAutoSlayerBankPattern() {
        return (Pattern)autoSlayerBankPattern$delegate.getValue(this, $$delegatedProperties[0]);
    }

    private final void addSlayerCosts(double price) {
        block1: {
            if (!(price < 0.0)) {
                boolean bl = false;
                String string = "slayer costs can not be positive";
                throw new IllegalArgumentException(string.toString());
            }
            SkyHanniItemTracker<Data> skyHanniItemTracker = this.getTracker();
            if (skyHanniItemTracker == null) break block1;
            skyHanniItemTracker.modify((Function1<Data, Unit>)((Function1)arg_0 -> SlayerProfitTracker.addSlayerCosts$lambda$1(price, arg_0)));
        }
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent
    public final void onRepoReload(@NotNull RepositoryReloadEvent event) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String constant$iv = "SlayerProfitTrackerItems";
        Object type$iv = null;
        Gson gson$iv = ((AbstractRepoReloadEvent)event).getGson();
        boolean $i$f$getConstant = false;
        Object object2 = event;
        try {
            Object $this$getRepoData_u24lambda_u2414$iv$iv;
            void this_$iv$iv;
            AbstractRepoReloadEvent $this$getConstant_u24lambda_u242$iv = object2;
            boolean bl = false;
            AbstractRepoManager<?> abstractRepoManager = $this$getConstant_u24lambda_u242$iv.getManager();
            String directory$iv$iv = "constants";
            boolean $i$f$getRepoData = false;
            Object object3 = this_$iv$iv;
            try {
                $this$getRepoData_u24lambda_u2414$iv$iv = object3;
                boolean bl2 = false;
                String path$iv$iv = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).resolvePath(directory$iv$iv, constant$iv);
                JsonElement jsonElement = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).readJsonElement(path$iv$iv);
                if (jsonElement == null) {
                    ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).getLogger().throwError("Repo file '" + constant$iv + "' not found.");
                    throw new KotlinNothingValueException();
                }
                JsonElement json$iv$iv = jsonElement;
                Gson $this$fromJson$iv$iv$iv = gson$iv;
                boolean $i$f$fromJson = false;
                Object object4 = $this$fromJson$iv$iv$iv.fromJson(json$iv$iv, ReflectJvmMapping.getJavaType((KType)Reflection.typeOf(SlayerProfitTrackerItemsJson.class)));
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"fromJson(...)");
                $this$getRepoData_u24lambda_u2414$iv$iv = Result.constructor-impl((Object)object4);
            }
            catch (Throwable bl2) {
                $this$getRepoData_u24lambda_u2414$iv$iv = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object3 = $this$getRepoData_u24lambda_u2414$iv$iv;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
            if (throwable != null) {
                Throwable e$iv$iv = throwable;
                boolean bl3 = false;
                this_$iv$iv.getLogger().throwErrorWithCause("Repo parsing error while trying to read constant '" + constant$iv + "'", e$iv$iv);
                throw new KotlinNothingValueException();
            }
            Object constantData$iv = object3;
            $this$getConstant_u24lambda_u242$iv.getManager().addSuccessfulConstant(constant$iv);
            object = constantData$iv;
        }
        catch (Throwable bl) {
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Throwable it$iv = throwable;
                boolean bl4 = false;
                ((AbstractRepoReloadEvent)event).getManager().addUnsuccessfulConstant(constant$iv);
                ((AbstractRepoReloadEvent)event).getManager().getLogger().throwErrorWithCause("Could not load constant '" + constant$iv + "'", it$iv);
                throw new KotlinNothingValueException();
            }
            throw new KotlinNothingValueException();
        }
        allowedItems = ((SlayerProfitTrackerItemsJson)object).getSlayers();
    }

    @HandleEvent
    public final void onPurseChange(@NotNull PurseChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        double coins = event.getCoins();
        if (event.getReason() == PurseChangeCause.GAIN_MOB_KILL && SlayerApi.INSTANCE.isInCorrectArea()) {
            if (coins >= 100000.0) {
                ChatUtils.debug$default(ChatUtils.INSTANCE, "Mob kill coin gain too high! Ignoring!", false, 2, null);
                return;
            }
            this.tryAddItem(NeuInternalName.Companion.getSKYBLOCK_COIN(), (int)coins, false);
        }
        if (event.getReason() == PurseChangeCause.LOSE_SLAYER_QUEST_STARTED) {
            if (coins < -150000.0 || coins > 0.0) {
                ChatUtils.debug$default(ChatUtils.INSTANCE, "Wrong Slayer Spawn Cost! Ignoring!", false, 2, null);
                return;
            }
            this.addSlayerCosts(coins);
        }
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent
    public final void onChat(@NotNull SkyHanniChatEvent event) {
        void $this$matchMatcher$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern pattern = this.getAutoSlayerBankPattern();
        String text$iv = event.getMessage();
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(text$iv);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull((Object)it$iv);
            Matcher $this$onChat_u24lambda_u242 = it$iv;
            boolean bl2 = false;
            String string = $this$onChat_u24lambda_u242.group("coins");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            INSTANCE.addSlayerCosts(-NumberUtil.INSTANCE.formatDouble(string));
        }
    }

    @HandleEvent
    public final void onSlayerChange(@NotNull SlayerChangeEvent event) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            String newSlayer = event.getNewSlayer();
            category = StringUtils.removeColor$default(StringUtils.INSTANCE, newSlayer, false, 1, null);
            baseSlayerType = StringsKt.substringBeforeLast$default((String)category, (String)" ", null, (int)2, null);
            SkyHanniItemTracker<Data> skyHanniItemTracker = this.getTracker();
            if (skyHanniItemTracker == null) break block0;
            skyHanniItemTracker.update();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final SkyHanniItemTracker<Data> getTracker() {
        Object object;
        void $this$getOrPut$iv;
        if (Intrinsics.areEqual((Object)category, (Object)"")) {
            return null;
        }
        Map<String, SkyHanniItemTracker<Data>> map = trackers;
        String key$iv = category;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Function1 getStorage = SlayerProfitTracker::getTracker$lambda$7$lambda$4;
            SkyHanniItemTracker answer$iv = new SkyHanniItemTracker(INSTANCE.getCategoryName() + " Profit Tracker", SlayerProfitTracker::getTracker$lambda$7$lambda$5, getStorage, null, SlayerProfitTracker::getTracker$lambda$7$lambda$6, 8, null);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (SkyHanniItemTracker)object;
    }

    @HandleEvent
    public final void onQuestComplete(@NotNull SlayerQuestCompleteEvent event) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            SkyHanniItemTracker<Data> skyHanniItemTracker = this.getTracker();
            if (skyHanniItemTracker == null) break block0;
            skyHanniItemTracker.modify((Function1<Data, Unit>)((Function1)SlayerProfitTracker::onQuestComplete$lambda$8));
        }
    }

    @HandleEvent
    public final void onItemAdd(@NotNull ItemAddEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        if (!SlayerApi.INSTANCE.isInCorrectArea()) {
            return;
        }
        if (!SlayerApi.INSTANCE.hasActiveSlayerQuest()) {
            return;
        }
        this.tryAddItem(event.getInternalName(), event.getAmount(), event.getSource() == ItemAddManager.Source.COMMAND);
    }

    private final void tryAddItem(NeuInternalName internalName2, int amount, boolean command2) {
        block1: {
            if (!this.isAllowedItem(internalName2) && !Intrinsics.areEqual((Object)internalName2, (Object)NeuInternalName.Companion.getSKYBLOCK_COIN())) {
                ChatUtils.debug$default(ChatUtils.INSTANCE, "Ignored non-slayer item pickup: '" + internalName2 + "' '" + category + "'", false, 2, null);
                return;
            }
            SkyHanniItemTracker<Data> skyHanniItemTracker = this.getTracker();
            if (skyHanniItemTracker == null) break block1;
            SkyHanniItemTracker.addItem$default(skyHanniItemTracker, internalName2, amount, command2, false, 8, null);
        }
    }

    private final boolean isAllowedItem(NeuInternalName internalName2) {
        List<NeuInternalName> list = allowedItems.get(baseSlayerType);
        if (list == null) {
            return false;
        }
        List<NeuInternalName> allowedList = list;
        return allowedList.contains(internalName2);
    }

    private final List<Searchable> drawDisplay(Data data) {
        List list;
        List $this$drawDisplay_u24lambda_u2410 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        SkyHanniItemTracker<Data> skyHanniItemTracker = INSTANCE.getTracker();
        if (skyHanniItemTracker != null) {
            SkyHanniItemTracker<Data> tracker = skyHanniItemTracker;
            RenderableCollectionUtils.addSearchString$default(RenderableCollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u2410, "\u00a7e\u00a7l" + INSTANCE.getCategoryName() + " Profit Tracker", null, null, null, 14, null);
            double profit = SkyHanniItemTracker.drawItems$default(tracker, data, SlayerProfitTracker::drawDisplay$lambda$10$lambda$9, $this$drawDisplay_u24lambda_u2410, null, null, null, null, null, 248, null);
            long slayerSpawnCost = data.getSlayerSpawnCost();
            String slayerSpawnCostFormat = NumberUtil.shortFormat$default(NumberUtil.INSTANCE, slayerSpawnCost, false, 1, null);
            Object[] objectArray = new String[]{"\u00a77You paid \u00a7c" + slayerSpawnCostFormat + " \u00a77in total", "\u00a77for starting the slayer quests."};
            $this$drawDisplay_u24lambda_u2410.add(SearchableKt.toSearchable$default(Renderable.Companion.hoverTips$default(Renderable.Companion, " \u00a77Slayer Spawn Costs: \u00a7c" + slayerSpawnCostFormat, CollectionsKt.listOf((Object[])objectArray), null, null, null, false, false, false, null, null, 1020, null), null, 1, null));
            String slayerCompletedCount = NumberUtil.INSTANCE.addSeparators(data.getSlayerCompletedCount());
            Object[] objectArray2 = new String[]{"\u00a77You killed the " + INSTANCE.getCategoryName() + " boss", "\u00a7e" + slayerCompletedCount + " \u00a77times."};
            $this$drawDisplay_u24lambda_u2410.add(SearchableKt.toSearchable$default(Renderable.Companion.hoverTips$default(Renderable.Companion, "\u00a77Bosses killed: \u00a7e" + slayerCompletedCount, CollectionsKt.listOf((Object[])objectArray2), null, null, null, false, false, false, null, null, 1020, null), null, 1, null));
            $this$drawDisplay_u24lambda_u2410.add(tracker.addTotalProfit(profit += (double)slayerSpawnCost, data.getSlayerCompletedCount(), "boss"));
            tracker.addPriceFromButton($this$drawDisplay_u24lambda_u2410);
        }
        return CollectionsKt.build((List)list);
    }

    @NotNull
    public final Function1<ItemTrackerData.TrackedItem, Pair<String, List<String>>> getCoinFormat() {
        return coinFormat;
    }

    private final boolean shouldShowDisplay() {
        if (!this.isEnabled()) {
            return false;
        }
        return SlayerApi.INSTANCE.isInCorrectArea();
    }

    @HandleEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.transform(10, "#profile.slayerProfitData", (Function1<? super JsonElement, ? extends JsonElement>)((Function1)SlayerProfitTracker::onConfigFix$lambda$16));
    }

    public final boolean isEnabled() {
        return SkyBlockUtils.INSTANCE.getInSkyBlock() && this.getConfig().getEnabled();
    }

    public final void resetCommand() {
        block1: {
            if (Intrinsics.areEqual((Object)category, (Object)"")) {
                ChatUtils.userError$default(ChatUtils.INSTANCE, "No current slayer data found! \u00a7eGo to a slayer area and start the specific slayer type you want to reset the data of.", false, 2, null);
                return;
            }
            SkyHanniItemTracker<Data> skyHanniItemTracker = this.getTracker();
            if (skyHanniItemTracker == null) break block1;
            skyHanniItemTracker.resetCommand();
        }
    }

    @HandleEvent
    public final void onCommandRegistration(@NotNull CommandRegistrationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.register("shresetslayerprofits", (Function1<? super CommandBuilder, Unit>)((Function1)SlayerProfitTracker::onCommandRegistration$lambda$18));
    }

    private static final Unit addSlayerCosts$lambda$1(double $price, Data it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setSlayerSpawnCost(it.getSlayerSpawnCost() + (long)((int)$price));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Data getTracker$lambda$7$lambda$4(ProfileSpecificStorage it) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Map<String, Data> map = it.getSlayerProfitData();
        String key$iv = category;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Data answer$iv = new Data(0L, 0L, 3, null);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Data)object;
    }

    private static final Data getTracker$lambda$7$lambda$5() {
        return new Data(0L, 0L, 3, null);
    }

    private static final List getTracker$lambda$7$lambda$6(Data it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.drawDisplay(it);
    }

    private static final Unit onQuestComplete$lambda$8(Data it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        long l = it.getSlayerCompletedCount();
        it.setSlayerCompletedCount(l + 1L);
        return Unit.INSTANCE;
    }

    private static final boolean drawDisplay$lambda$10$lambda$9(NeuInternalName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final Pair coinFormat$lambda$11(ItemTrackerData.TrackedItem item2) {
        Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
        String mobKillCoinsFormat = NumberUtil.shortFormat$default(NumberUtil.INSTANCE, item2.getTotalAmount(), false, 1, null);
        String text = " \u00a76Mob kill coins\u00a77: \u00a76" + mobKillCoinsFormat;
        Object[] objectArray = new String[]{"\u00a77Killing mobs gives you coins (more with scavenger)", "\u00a77You got \u00a7e" + mobKillCoinsFormat + " \u00a77coins in total this way"};
        List lore = CollectionsKt.listOf((Object[])objectArray);
        return TuplesKt.to((Object)text, (Object)lore);
    }

    private static final boolean _init_$lambda$12() {
        return INSTANCE.shouldShowDisplay();
    }

    private static final Unit _init_$lambda$13() {
        block0: {
            SkyHanniItemTracker<Data> skyHanniItemTracker = INSTANCE.getTracker();
            if (skyHanniItemTracker == null) break block0;
            skyHanniItemTracker.renderDisplay(INSTANCE.getConfig().getPos());
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final JsonElement onConfigFix$lambda$16(JsonElement old) {
        Collection collection;
        Iterator $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)old, (String)"old");
        Set set = old.getAsJsonObject().entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"entrySet(...)");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Object object = $this$mapTo$iv$iv.iterator();
        while (object.hasNext()) {
            void it;
            Object item$iv$iv = object.next();
            Map.Entry entry = (Map.Entry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((JsonElement)it.getValue()).getAsJsonObject());
        }
        for (JsonObject data : (List)destination$iv$iv) {
            void $this$mapTo$iv$iv2;
            JsonObject items = data.get("items").getAsJsonObject();
            Set set2 = items.entrySet();
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"entrySet(...)");
            Iterable $this$map$iv2 = set2;
            boolean $i$f$map2 = false;
            object = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                Map.Entry entry = (Map.Entry)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(((JsonElement)it.getValue()).getAsJsonObject());
            }
            for (JsonObject item2 : (List)destination$iv$iv2) {
                JsonElement oldValue = item2.get("timesDropped");
                item2.add("timesGained", oldValue);
            }
            JsonElement coinAmount = data.get("mobKillCoins");
            JsonObject coins = new JsonObject();
            coins.add("internalName", (JsonElement)new JsonPrimitive("SKYBLOCK_COIN"));
            coins.add("timesDropped", (JsonElement)new JsonPrimitive((Number)1));
            coins.add("totalAmount", coinAmount);
            items.add("SKYBLOCK_COIN", (JsonElement)coins);
        }
        return old;
    }

    private static final Unit onCommandRegistration$lambda$18$lambda$17(String[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        INSTANCE.resetCommand();
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$18(CommandBuilder $this$register) {
        Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
        $this$register.setDescription("Resets the total slayer profit for the current slayer type");
        $this$register.setCategory(CommandCategory.USERS_RESET);
        $this$register.callback((Function1<? super String[], Unit>)((Function1)SlayerProfitTracker::onCommandRegistration$lambda$18$lambda$17));
        return Unit.INSTANCE;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(SlayerProfitTracker.class, "autoSlayerBankPattern", "getAutoSlayerBankPattern()Ljava/util/regex/Pattern;", 0)))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new SlayerProfitTracker();
        category = "";
        baseSlayerType = "";
        trackers = new LinkedHashMap();
        autoSlayerBankPattern$delegate = RepoPattern.Companion.pattern("slayer.autoslayer.bank.chat", "\u00a77Took (?<coins>.+) coins from your bank for auto-slayer\\.\\.\\.");
        allowedItems = MapsKt.emptyMap();
        coinFormat = SlayerProfitTracker::coinFormat$lambda$11;
        new RenderDisplayHelper(null, true, true, SlayerProfitTracker::_init_$lambda$12, null, SlayerProfitTracker::_init_$lambda$13, 17, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001d\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0013J$\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001a\u0010\u001a\u001a\u00020\u00192\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0010\u0010\u001d\u001a\u00020\u001cH\u00d6\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\tH\u00d6\u0001\u00a2\u0006\u0004\b\u001f\u0010 R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010!\u001a\u0004\b\"\u0010\u0013\"\u0004\b#\u0010$R\"\u0010\u0004\u001a\u00020\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0004\u0010!\u001a\u0004\b%\u0010\u0013\"\u0004\b&\u0010$\u00a8\u0006'"}, d2={"Lat/hannibal2/skyhanni/features/slayer/SlayerProfitTracker$Data;", "Lat/hannibal2/skyhanni/utils/tracker/ItemTrackerData;", "", "slayerSpawnCost", "slayerCompletedCount", "<init>", "(JJ)V", "timesGained", "", "", "getDescription", "(J)Ljava/util/List;", "Lat/hannibal2/skyhanni/utils/tracker/ItemTrackerData$TrackedItem;", "item", "getCoinName", "(Lat/hannibal2/skyhanni/utils/tracker/ItemTrackerData$TrackedItem;)Ljava/lang/String;", "getCoinDescription", "(Lat/hannibal2/skyhanni/utils/tracker/ItemTrackerData$TrackedItem;)Ljava/util/List;", "component1", "()J", "component2", "copy", "(JJ)Lat/hannibal2/skyhanni/features/slayer/SlayerProfitTracker$Data;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "()Ljava/lang/String;", "J", "getSlayerSpawnCost", "setSlayerSpawnCost", "(J)V", "getSlayerCompletedCount", "setSlayerCompletedCount", "1.21.7"})
    public static final class Data
    extends ItemTrackerData {
        @Expose
        private long slayerSpawnCost;
        @Expose
        private long slayerCompletedCount;

        public Data(long slayerSpawnCost, long slayerCompletedCount) {
            this.slayerSpawnCost = slayerSpawnCost;
            this.slayerCompletedCount = slayerCompletedCount;
        }

        public /* synthetic */ Data(long l, long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                l = 0L;
            }
            if ((n & 2) != 0) {
                l2 = 0L;
            }
            this(l, l2);
        }

        public final long getSlayerSpawnCost() {
            return this.slayerSpawnCost;
        }

        public final void setSlayerSpawnCost(long l) {
            this.slayerSpawnCost = l;
        }

        public final long getSlayerCompletedCount() {
            return this.slayerCompletedCount;
        }

        public final void setSlayerCompletedCount(long l) {
            this.slayerCompletedCount = l;
        }

        @Override
        @NotNull
        public List<String> getDescription(long timesGained) {
            double percentage = (double)timesGained / (double)this.slayerCompletedCount;
            String perBoss = NumberUtil.INSTANCE.formatPercentage(RangesKt.coerceAtMost((double)percentage, (double)1.0));
            Object[] objectArray = new String[]{"\u00a77Dropped \u00a7e" + NumberUtil.INSTANCE.addSeparators(timesGained) + " \u00a77times.", "\u00a77Your drop rate: \u00a7c" + perBoss};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @Override
        @NotNull
        public String getCoinName(@NotNull ItemTrackerData.TrackedItem item2) {
            Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
            return "\u00a76Mob Kill Coins";
        }

        @Override
        @NotNull
        public List<String> getCoinDescription(@NotNull ItemTrackerData.TrackedItem item2) {
            Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
            String mobKillCoinsFormat = NumberUtil.shortFormat$default(NumberUtil.INSTANCE, item2.getTotalAmount(), false, 1, null);
            Object[] objectArray = new String[]{"\u00a77Killing mobs gives you coins (more with scavenger).", "\u00a77You got \u00a76" + mobKillCoinsFormat + " coins \u00a77that way."};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        public final long component1() {
            return this.slayerSpawnCost;
        }

        public final long component2() {
            return this.slayerCompletedCount;
        }

        @NotNull
        public final Data copy(long slayerSpawnCost, long slayerCompletedCount) {
            return new Data(slayerSpawnCost, slayerCompletedCount);
        }

        public static /* synthetic */ Data copy$default(Data data, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                l = data.slayerSpawnCost;
            }
            if ((n & 2) != 0) {
                l2 = data.slayerCompletedCount;
            }
            return data.copy(l, l2);
        }

        @NotNull
        public String toString() {
            return "Data(slayerSpawnCost=" + this.slayerSpawnCost + ", slayerCompletedCount=" + this.slayerCompletedCount + ")";
        }

        public int hashCode() {
            int result2 = Long.hashCode(this.slayerSpawnCost);
            result2 = result2 * 31 + Long.hashCode(this.slayerCompletedCount);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Data)) {
                return false;
            }
            Data data = (Data)other;
            if (this.slayerSpawnCost != data.slayerSpawnCost) {
                return false;
            }
            return this.slayerCompletedCount == data.slayerCompletedCount;
        }

        public Data() {
            this(0L, 0L, 3, null);
        }
    }
}

