/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.slayer;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.slayer.SlayerConfig;
import at.hannibal2.skyhanni.data.ClickType;
import at.hannibal2.skyhanni.data.SlayerApi;
import at.hannibal2.skyhanni.data.title.TitleManager;
import at.hannibal2.skyhanni.events.ItemClickEvent;
import at.hannibal2.skyhanni.events.ScoreboardUpdateEvent;
import at.hannibal2.skyhanni.events.entity.EntityHealthUpdateEvent;
import at.hannibal2.skyhanni.features.event.diana.DianaApi;
import at.hannibal2.skyhanni.features.rift.RiftApi;
import at.hannibal2.skyhanni.features.slayer.SlayerType;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzVecKt;
import at.hannibal2.skyhanni.utils.NeuInternalName;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.collection.CollectionUtils;
import at.hannibal2.skyhanni.utils.compat.TextCompatKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001;B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0013\u0010\u000e\u001a\u00020\r*\u00020\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\r*\u00020\fH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u0015\u0010\u0011\u001a\u00020\r*\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u000fJ\u0013\u0010\u0012\u001a\u00020\r*\u00020\fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u000fJ\u001f\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0003J\u001f\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u0016J\u0017\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001eH\u0007\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010#\u001a\u00020\r2\u0006\u0010\"\u001a\u00020!H\u0002\u00a2\u0006\u0004\b#\u0010$J\u0017\u0010&\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020%H\u0007\u00a2\u0006\u0004\b&\u0010'R\u0014\u0010+\u001a\u00020(8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0016\u0010-\u001a\u00020,8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u0014\u00100\u001a\u00020/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101R\u0014\u00102\u001a\u00020/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u00101R\u0014\u00103\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00104R\u0014\u00105\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b5\u00104R\u0016\u00106\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b6\u00107R\u0016\u00108\u001a\u00020,8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b8\u0010.R\u0016\u00109\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b9\u0010:\u00a8\u0006<"}, d2={"Lat/hannibal2/skyhanni/features/slayer/SlayerQuestWarning;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/ScoreboardUpdateEvent;", "event", "", "onScoreboardChange", "(Lat/hannibal2/skyhanni/events/ScoreboardUpdateEvent;)V", "Lat/hannibal2/skyhanni/features/slayer/SlayerQuestWarning$SlayerData;", "getSlayerData", "()Lat/hannibal2/skyhanni/features/slayer/SlayerQuestWarning$SlayerData;", "", "", "inCombat", "(Ljava/lang/String;)Z", "inBoss", "bossSlain", "noSlayer", "old", "new", "change", "(Ljava/lang/String;Ljava/lang/String;)V", "reason", "needNewQuest", "(Ljava/lang/String;)V", "tryWarn", "titleMessage", "chatMessage", "warn", "Lat/hannibal2/skyhanni/events/entity/EntityHealthUpdateEvent;", "onEntityHealthUpdate", "(Lat/hannibal2/skyhanni/events/entity/EntityHealthUpdateEvent;)V", "Lnet/minecraft/class_1309;", "entity", "isSlayerMob", "(Lnet/minecraft/class_1309;)Z", "Lat/hannibal2/skyhanni/events/ItemClickEvent;", "onItemClick", "(Lat/hannibal2/skyhanni/events/ItemClickEvent;)V", "Lat/hannibal2/skyhanni/config/features/slayer/SlayerConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/slayer/SlayerConfig;", "config", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastWeaponUse", "J", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "voidItem", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "endItem", "outsideRiftData", "Lat/hannibal2/skyhanni/features/slayer/SlayerQuestWarning$SlayerData;", "insideRiftData", "needSlayerQuest", "Z", "lastWarning", "currentReason", "Ljava/lang/String;", "SlayerData", "1.21.7"})
public final class SlayerQuestWarning {
    @NotNull
    public static final SlayerQuestWarning INSTANCE = new SlayerQuestWarning();
    private static long lastWeaponUse = SimpleTimeMark.Companion.farPast();
    @NotNull
    private static final NeuInternalName voidItem = NeuInternalName.Companion.toInternalName("ASPECT_OF_THE_VOID");
    @NotNull
    private static final NeuInternalName endItem = NeuInternalName.Companion.toInternalName("ASPECT_OF_THE_END");
    @NotNull
    private static final SlayerData outsideRiftData = new SlayerData();
    @NotNull
    private static final SlayerData insideRiftData = new SlayerData();
    private static boolean needSlayerQuest;
    private static long lastWarning;
    @NotNull
    private static String currentReason;

    private SlayerQuestWarning() {
    }

    private final SlayerConfig getConfig() {
        return SlayerApi.INSTANCE.getConfig();
    }

    @HandleEvent
    public final void onScoreboardChange(@NotNull ScoreboardUpdateEvent event) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            String slayerType = CollectionUtils.nextAfter$default(CollectionUtils.INSTANCE, event.getNew(), "Slayer Quest", 0, 2, null);
            String string = CollectionUtils.INSTANCE.nextAfter(event.getNew(), "Slayer Quest", 2);
            if (string == null) {
                string = "no slayer";
            }
            String slayerProgress = string;
            String string2 = StringUtils.removeColor$default(StringUtils.INSTANCE, slayerProgress, false, 1, null);
            SlayerData slayerData = this.getSlayerData();
            if (Intrinsics.areEqual((Object)slayerData.getCurrentSlayerState(), (Object)string2)) {
                return;
            }
            String string3 = slayerData.getCurrentSlayerState();
            if (string3 != null) {
                String it = string3;
                boolean bl = false;
                INSTANCE.change(it, string2);
            }
            slayerData.setCurrentSlayerState(string2);
            String string4 = slayerType;
            if (string4 == null) break block3;
            String it = string4;
            boolean bl = false;
            slayerData.setLastSlayerType(SlayerType.Companion.getByName(it));
        }
    }

    private final SlayerData getSlayerData() {
        return RiftApi.INSTANCE.inRift() ? outsideRiftData : insideRiftData;
    }

    private final boolean inCombat(String $this$inCombat) {
        return StringsKt.contains$default((CharSequence)$this$inCombat, (CharSequence)"Combat", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)$this$inCombat, (CharSequence)"Kills", (boolean)false, (int)2, null);
    }

    private final boolean inBoss(String $this$inBoss) {
        return Intrinsics.areEqual((Object)$this$inBoss, (Object)"Slay the boss!");
    }

    private final boolean bossSlain(String $this$bossSlain) {
        return Intrinsics.areEqual((Object)$this$bossSlain, (Object)"Boss slain!");
    }

    private final boolean noSlayer(String $this$noSlayer) {
        return Intrinsics.areEqual((Object)$this$noSlayer, (Object)"no slayer");
    }

    private final void change(String old, String string) {
        if (!this.inCombat(old) && this.inCombat(string)) {
            needSlayerQuest = false;
        }
        if (this.inBoss(old) && this.noSlayer(string)) {
            this.needNewQuest("The old slayer quest has failed!");
        }
        if (this.bossSlain(string)) {
            DelayedRun.INSTANCE.runDelayed-bouF650(DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.SECONDS), (Function0<Unit>)((Function0)SlayerQuestWarning::change$lambda$2));
        }
    }

    private final void needNewQuest(String reason) {
        currentReason = reason;
        needSlayerQuest = true;
    }

    private final void tryWarn() {
        if (!needSlayerQuest) {
            return;
        }
        this.warn("New Slayer Quest!", "Start a new slayer quest! " + currentReason);
    }

    private final void warn(String titleMessage, String chatMessage) {
        if (!this.getConfig().getQuestWarning()) {
            return;
        }
        if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(lastWarning), (long)DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS)) < 0) {
            return;
        }
        if (DianaApi.INSTANCE.isDoingDiana()) {
            return;
        }
        if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(lastWeaponUse), (long)DurationKt.toDuration((int)500, (DurationUnit)DurationUnit.MILLISECONDS)) > 0) {
            return;
        }
        lastWarning = SimpleTimeMark.Companion.now-uFjCsEo();
        ChatUtils.chat$default(ChatUtils.INSTANCE, chatMessage, false, null, false, false, null, 62, null);
        if (this.getConfig().getQuestWarningTitle()) {
            TitleManager.sendTitle-pX6VMpQ$default(TitleManager.INSTANCE, "\u00a7e" + titleMessage, null, DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.SECONDS), null, null, null, 0.0, false, false, null, 0L, null, null, 0L, 16378, null);
        }
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onEntityHealthUpdate(@NotNull EntityHealthUpdateEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        class_1309 entity = event.getEntity();
        if (LocationUtils.INSTANCE.distanceToPlayer(LorenzVecKt.getLorenzVec((class_1297)entity)) < 6.0 && this.isSlayerMob(entity)) {
            this.tryWarn();
        }
    }

    private final boolean isSlayerMob(class_1309 entity) {
        SlayerType slayerType;
        block5: {
            SlayerType slayerType2 = SlayerApi.INSTANCE.getCurrentAreaType();
            if (slayerType2 == null) {
                return false;
            }
            slayerType = slayerType2;
            if (Intrinsics.areEqual((Object)TextCompatKt.formattedTextCompatLessResets(entity.method_5477()), (Object)"Oubliette Guard")) {
                return false;
            }
            if (Intrinsics.areEqual((Object)SkyBlockUtils.INSTANCE.getScoreboardArea(), (Object)"Stronghold") && Intrinsics.areEqual((Object)TextCompatKt.formattedTextCompatLessResets(entity.method_5477()), (Object)"Skeleton")) {
                return false;
            }
            boolean isSlayer = slayerType.getClazz().isInstance(entity);
            if (!isSlayer) {
                return false;
            }
            SlayerType slayerType3 = SlayerApi.INSTANCE.getActiveSlayer();
            if (slayerType3 == null) break block5;
            SlayerType it = slayerType3;
            boolean bl = false;
            if (slayerType != it) {
                String activeSlayerName = it.getDisplayName();
                String slayerName = slayerType.getDisplayName();
                SlayerApi.INSTANCE.setLatestWrongAreaWarning-gJLAdNM(SimpleTimeMark.Companion.now-uFjCsEo());
                INSTANCE.warn("Wrong Slayer!", "Wrong slayer selected! You have " + activeSlayerName + " selected and you are in an " + slayerName + " area!");
            }
        }
        return this.getSlayerData().getLastSlayerType() == slayerType;
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onItemClick(@NotNull ItemClickEvent event) {
        NeuInternalName internalName2;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        class_1799 class_17992 = event.getItemInHand();
        NeuInternalName neuInternalName = internalName2 = class_17992 != null ? ItemUtils.INSTANCE.getInternalNameOrNull(class_17992) : null;
        if (event.getClickType() == ClickType.RIGHT_CLICK) {
            if (Intrinsics.areEqual((Object)internalName2, (Object)voidItem) || Intrinsics.areEqual((Object)internalName2, (Object)endItem)) {
                return;
            }
            if (internalName2 == null) {
                return;
            }
        }
        lastWeaponUse = SimpleTimeMark.Companion.now-uFjCsEo();
    }

    private static final Unit change$lambda$2() {
        if (INSTANCE.bossSlain(INSTANCE.getSlayerData().getCurrentSlayerState())) {
            INSTANCE.needNewQuest("You have no Auto-Slayer active!");
        }
        return Unit.INSTANCE;
    }

    static {
        lastWarning = SimpleTimeMark.Companion.farPast();
        currentReason = "";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R$\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR$\u0010\f\u001a\u0004\u0018\u00010\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lat/hannibal2/skyhanni/features/slayer/SlayerQuestWarning$SlayerData;", "", "<init>", "()V", "", "currentSlayerState", "Ljava/lang/String;", "getCurrentSlayerState", "()Ljava/lang/String;", "setCurrentSlayerState", "(Ljava/lang/String;)V", "Lat/hannibal2/skyhanni/features/slayer/SlayerType;", "lastSlayerType", "Lat/hannibal2/skyhanni/features/slayer/SlayerType;", "getLastSlayerType", "()Lat/hannibal2/skyhanni/features/slayer/SlayerType;", "setLastSlayerType", "(Lat/hannibal2/skyhanni/features/slayer/SlayerType;)V", "1.21.7"})
    public static final class SlayerData {
        @Nullable
        private String currentSlayerState;
        @Nullable
        private SlayerType lastSlayerType;

        @Nullable
        public final String getCurrentSlayerState() {
            return this.currentSlayerState;
        }

        public final void setCurrentSlayerState(@Nullable String string) {
            this.currentSlayerState = string;
        }

        @Nullable
        public final SlayerType getLastSlayerType() {
            return this.lastSlayerType;
        }

        public final void setLastSlayerType(@Nullable SlayerType slayerType) {
            this.lastSlayerType = slayerType;
        }
    }
}

