/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils.repopatterns;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigManager;
import at.hannibal2.skyhanni.config.features.dev.RepoPatternConfig;
import at.hannibal2.skyhanni.data.repo.AbstractRepoManager;
import at.hannibal2.skyhanni.data.repo.AbstractRepoReloadEvent;
import at.hannibal2.skyhanni.data.repo.SkyHanniRepoManager;
import at.hannibal2.skyhanni.events.ConfigLoadEvent;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.events.utils.PreInitFinishedEvent;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.ConditionalUtils;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.repopatterns.CommonPatternInfo;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternDump;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternImpl;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternKeyOwner;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternList;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternListImpl;
import at.hannibal2.skyhanni.utils.system.PlatformUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u000e\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000e\u0010\rJ\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0017H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0003J+\u0010\u001f\u001a\u00020\u00062\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001b2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J+\u0010#\u001a\u00020\u00062\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001b2\u0006\u0010\"\u001a\u00020!H\u0002\u00a2\u0006\u0004\b#\u0010$J\u0015\u0010%\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\u0004\b%\u0010\bJ\u001d\u0010\u0014\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00042\u0006\u0010(\u001a\u00020'\u00a2\u0006\u0004\b\u0014\u0010)J\u0017\u0010+\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020*H\u0007\u00a2\u0006\u0004\b+\u0010,J)\u00100\u001a\u00020/2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u00042\n\b\u0002\u0010.\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b0\u00101J1\u00105\u001a\u0002042\u0006\u0010\u000b\u001a\u00020\u00042\u000e\u00103\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u0004022\n\b\u0002\u0010.\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b5\u00106J\u001d\u0010<\u001a\b\u0012\u0004\u0012\u000209082\u0006\u00107\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b:\u0010;R\u001f\u0010A\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030>0=8F\u00a2\u0006\u0006\u001a\u0004\b?\u0010@R\u0018\u0010B\u001a\u0004\u0018\u00010\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bB\u0010CR \u0010F\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bD\u0010ER \u0010H\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0G8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bH\u0010IR*\u0010J\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030>0\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bJ\u0010KR\u0016\u0010M\u001a\u00020L8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bM\u0010NR\u0014\u0010O\u001a\u00020L8\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\bO\u0010NR\"\u0010P\u001a\u00020L8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bP\u0010N\u001a\u0004\bQ\u0010R\"\u0004\bS\u0010TR\u0014\u0010X\u001a\u00020U8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bV\u0010WR\u0014\u0010Z\u001a\u00020L8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bY\u0010RR\u001c\u0010]\u001a\n \\*\u0004\u0018\u00010[0[8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b]\u0010^R\u001c\u0010_\u001a\n \\*\u0004\u0018\u000109098\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b_\u0010`\u00a8\u0006a"}, d2={"Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternManager;", "", "<init>", "()V", "", "reason", "", "crash", "(Ljava/lang/String;)V", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternKeyOwner;", "owner", "key", "checkExclusivity", "(Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternKeyOwner;Ljava/lang/String;)V", "checkNameSpaceExclusivity", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "event", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternDump;", "dump", "loadPatternsFromDump", "(Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternDump;)V", "Lat/hannibal2/skyhanni/events/ConfigLoadEvent;", "onConfigLoad", "(Lat/hannibal2/skyhanni/events/ConfigLoadEvent;)V", "reloadPatterns", "Ljava/util/NavigableMap;", "remotePatterns", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternImpl;", "it", "loadStandalonePattern", "(Ljava/util/NavigableMap;Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternImpl;)V", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternListImpl;", "arrayPattern", "loadArrayPatterns", "(Ljava/util/NavigableMap;Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternListImpl;)V", "verifyKeyShape", "sourceLabel", "Ljava/io/File;", "file", "(Ljava/lang/String;Ljava/io/File;)V", "Lat/hannibal2/skyhanni/events/utils/PreInitFinishedEvent;", "onPreInitFinished", "(Lat/hannibal2/skyhanni/events/utils/PreInitFinishedEvent;)V", "fallback", "parentKeyHolder", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "of", "(Ljava/lang/String;Ljava/lang/String;Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternKeyOwner;)Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "", "fallbacks", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternList;", "ofList", "(Ljava/lang/String;[Ljava/lang/String;Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternKeyOwner;)Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternList;", "prefix", "", "Ljava/util/regex/Pattern;", "getUnusedPatterns$1_21_7", "(Ljava/lang/String;)Ljava/util/List;", "getUnusedPatterns", "", "Lat/hannibal2/skyhanni/utils/repopatterns/CommonPatternInfo;", "getAllPatterns", "()Ljava/util/Collection;", "allPatterns", "regexes", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternDump;", "getRemotePattern", "()Ljava/util/NavigableMap;", "remotePattern", "", "exclusivity", "Ljava/util/Map;", "usedKeys", "Ljava/util/NavigableMap;", "", "wasPreInitialized", "Z", "insideTest", "inTestDuplicateUsage", "getInTestDuplicateUsage", "()Z", "setInTestDuplicateUsage", "(Z)V", "Lat/hannibal2/skyhanni/config/features/dev/RepoPatternConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/dev/RepoPatternConfig;", "config", "getLocalLoading", "localLoading", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/apache/logging/log4j/Logger;", "keyShape", "Ljava/util/regex/Pattern;", "1.21.7"})
@SourceDebugExtension(value={"SMAP\nRepoPatternManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepoPatternManager.kt\nat/hannibal2/skyhanni/utils/repopatterns/RepoPatternManager\n+ 2 AbstractRepoReloadEvent.kt\nat/hannibal2/skyhanni/data/repo/AbstractRepoReloadEvent\n+ 3 AbstractRepoManager.kt\nat/hannibal2/skyhanni/data/repo/AbstractRepoManager\n+ 4 JsonUtils.kt\nat/hannibal2/skyhanni/utils/json/JsonUtilsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 8 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 9 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,351:1\n13#2,7:352\n21#2,6:369\n168#3,5:359\n173#3,4:365\n24#4:364\n136#5,9:375\n216#5:384\n217#5:386\n145#5:387\n216#5,2:407\n126#5:416\n153#5,3:417\n77#5:464\n97#5,5:465\n126#5:474\n153#5,3:475\n1#6:385\n1#6:406\n1634#7,3:388\n1056#7:391\n1563#7:392\n1634#7,3:393\n1563#7:396\n1634#7,3:397\n1374#7:400\n1460#7,5:401\n1491#7:420\n1516#7,2:421\n1518#7:426\n1519#7,3:434\n1563#7:478\n1634#7,3:479\n538#8:409\n523#8,6:410\n384#8,7:427\n538#8:437\n523#8,16:438\n538#8:457\n523#8,6:458\n525#8,4:470\n1104#9,3:423\n1104#9,3:454\n*S KotlinDebug\n*F\n+ 1 RepoPatternManager.kt\nat/hannibal2/skyhanni/utils/repopatterns/RepoPatternManager\n*L\n163#1:352,7\n163#1:369,6\n163#1:359,5\n163#1:365,4\n163#1:364\n211#1:375,9\n211#1:384\n211#1:386\n211#1:387\n310#1:407,2\n335#1:416\n335#1:417,3\n340#1:464\n340#1:465,5\n347#1:474\n347#1:475,3\n211#1:385\n228#1:388,3\n233#1:391\n233#1:392\n233#1:393,3\n235#1:396\n235#1:397,3\n264#1:400\n264#1:401,5\n336#1:420\n336#1:421,2\n336#1:426\n336#1:434,3\n218#1:478\n218#1:479,3\n335#1:409\n335#1:410,6\n336#1:427,7\n338#1:437\n338#1:438,16\n340#1:457\n340#1:458,6\n338#1:470,4\n336#1:423,3\n339#1:454,3\n*E\n"})
public final class RepoPatternManager {
    @NotNull
    public static final RepoPatternManager INSTANCE = new RepoPatternManager();
    @Nullable
    private static RepoPatternDump regexes;
    @NotNull
    private static final Map<String, RepoPatternKeyOwner> exclusivity;
    @NotNull
    private static NavigableMap<String, CommonPatternInfo<?, ?>> usedKeys;
    private static boolean wasPreInitialized;
    private static final boolean insideTest;
    private static boolean inTestDuplicateUsage;
    private static final Logger logger;
    private static final Pattern keyShape;

    private RepoPatternManager() {
    }

    @NotNull
    public final Collection<CommonPatternInfo<?, ?>> getAllPatterns() {
        Collection<CommonPatternInfo<?, ?>> collection = usedKeys.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return collection;
    }

    private final NavigableMap<String, String> getRemotePattern() {
        Map map;
        if (this.getLocalLoading()) {
            map = MapsKt.emptyMap();
        } else {
            RepoPatternDump repoPatternDump = regexes;
            map = repoPatternDump != null ? repoPatternDump.getRegexes() : null;
            if (map == null) {
                map = MapsKt.emptyMap();
            }
        }
        return new TreeMap(map);
    }

    public final boolean getInTestDuplicateUsage() {
        return inTestDuplicateUsage;
    }

    public final void setInTestDuplicateUsage(boolean bl) {
        inTestDuplicateUsage = bl;
    }

    private final RepoPatternConfig getConfig() {
        RepoPatternConfig repoPatternConfig;
        if (!insideTest) {
            repoPatternConfig = SkyHanniMod.feature.getDev().getRepoPattern();
        } else {
            RepoPatternConfig repoPatternConfig2;
            RepoPatternConfig $this$_get_config__u24lambda_u240 = repoPatternConfig2 = new RepoPatternConfig();
            boolean bl = false;
            $this$_get_config__u24lambda_u240.setTolerateDuplicateUsage(inTestDuplicateUsage);
            repoPatternConfig = repoPatternConfig2;
        }
        return repoPatternConfig;
    }

    private final boolean getLocalLoading() {
        return (Boolean)this.getConfig().getForceLocal().get() != false || !insideTest && PlatformUtils.INSTANCE.isDevEnvironment() || SkyHanniRepoManager.INSTANCE.isUsingBackup();
    }

    private final void crash(String reason) {
        if (PlatformUtils.INSTANCE.isDevEnvironment()) {
            throw new RuntimeException(reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void checkExclusivity(@NotNull RepoPatternKeyOwner owner, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        RepoPatternKeyOwner parentKeyHolder = owner.getParent();
        Map<String, RepoPatternKeyOwner> map = exclusivity;
        synchronized (map) {
            boolean bl = false;
            RepoPatternManager $this$checkExclusivity_u24lambda_u244_u24lambda_u241 = INSTANCE;
            boolean bl2 = false;
            RepoPatternKeyOwner previousOwner = exclusivity.get(key);
            if (!Intrinsics.areEqual((Object)previousOwner, (Object)owner) && previousOwner != null && !previousOwner.getTransient()) {
                if (!$this$checkExclusivity_u24lambda_u244_u24lambda_u241.getConfig().getTolerateDuplicateUsage()) {
                    $this$checkExclusivity_u24lambda_u244_u24lambda_u241.crash("Non unique access to regex at \"" + key + "\". First obtained by " + previousOwner.getOwnerClass() + " / " + previousOwner.getProperty() + ", tried to use at " + owner.getOwnerClass() + " / " + owner.getProperty());
                }
            } else {
                exclusivity.put(key, owner);
            }
            RepoPatternManager $this$checkExclusivity_u24lambda_u244_u24lambda_u243 = INSTANCE;
            boolean bl3 = false;
            RepoPatternKeyOwner repoPatternKeyOwner = RepoPatternKeyOwner.copy$default(owner, null, null, true, null, true, 11, null);
            Ref.ObjectRef parent = new Ref.ObjectRef();
            parent.element = key;
            RepoPatternKeyOwner previousParentOwnerMutable = null;
            while (previousParentOwnerMutable == null && ((CharSequence)parent.element).length() > 0) {
                if (StringUtils.INSTANCE.substringBeforeLastOrNull((String)parent.element, ".") == null) {
                    Object cfr_ignored_0 = parent.element;
                    return;
                }
                parent.element = parent.element;
                previousParentOwnerMutable = exclusivity.get(parent.element);
                RepoPatternKeyOwner repoPatternKeyOwner2 = previousParentOwnerMutable;
                if (repoPatternKeyOwner2 != null) continue;
                RepoPatternManager $this$checkExclusivity_u24lambda_u244_u24lambda_u243_u24lambda_u242 = $this$checkExclusivity_u24lambda_u244_u24lambda_u243;
                boolean bl4 = false;
                exclusivity.put((String)parent.element, repoPatternKeyOwner);
                repoPatternKeyOwner2 = Unit.INSTANCE;
            }
            RepoPatternKeyOwner previousParentOwner = previousParentOwnerMutable;
            if (!(previousParentOwner == null || Intrinsics.areEqual(previousParentOwner, (Object)parentKeyHolder) || previousParentOwner.getShares() && Intrinsics.areEqual((Object)previousParentOwner.getParent(), (Object)parentKeyHolder) || $this$checkExclusivity_u24lambda_u244_u24lambda_u243.getConfig().getTolerateDuplicateUsage())) {
                RepoPatternKeyOwner repoPatternKeyOwner3 = parentKeyHolder;
                $this$checkExclusivity_u24lambda_u244_u24lambda_u243.crash("Non unique access to array regex at \"" + parent.element + "\". First obtained by " + previousParentOwner.getOwnerClass() + " / " + previousParentOwner.getProperty() + ", tried to use at " + owner.getOwnerClass() + " / " + owner.getProperty() + (String)(repoPatternKeyOwner3 != null ? "with parentKeyHolder " + repoPatternKeyOwner3.getOwnerClass() + " / " + parentKeyHolder.getProperty() : ""));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void checkNameSpaceExclusivity(@NotNull RepoPatternKeyOwner owner, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Map<String, RepoPatternKeyOwner> map = exclusivity;
        synchronized (map) {
            boolean bl = false;
            RepoPatternKeyOwner preRegistered = exclusivity.get(key);
            if (preRegistered != null && !INSTANCE.getConfig().getTolerateDuplicateUsage()) {
                INSTANCE.crash("Non unique access to array regex at \"" + key + "\". First obtained by " + preRegistered.getOwnerClass() + " / " + preRegistered.getProperty() + ", tried to use at " + owner.getOwnerClass() + " / " + owner.getProperty());
            }
            Unit unit = Unit.INSTANCE;
        }
        this.checkExclusivity(owner, key);
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent
    public final void onRepoReload(@NotNull RepositoryReloadEvent event) {
        Object object;
        void constant$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String string = "regexes";
        RepoPatternManager repoPatternManager = this;
        Object type$iv = null;
        Gson gson$iv = ((AbstractRepoReloadEvent)event).getGson();
        boolean $i$f$getConstant = false;
        Object object2 = event;
        try {
            Object $this$getRepoData_u24lambda_u2414$iv$iv;
            void this_$iv$iv;
            AbstractRepoReloadEvent $this$getConstant_u24lambda_u242$iv = object2;
            boolean bl = false;
            AbstractRepoManager<?> abstractRepoManager = $this$getConstant_u24lambda_u242$iv.getManager();
            String directory$iv$iv = "constants";
            boolean $i$f$getRepoData = false;
            Object object3 = this_$iv$iv;
            try {
                $this$getRepoData_u24lambda_u2414$iv$iv = object3;
                boolean bl2 = false;
                String path$iv$iv = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).resolvePath(directory$iv$iv, (String)constant$iv);
                JsonElement jsonElement = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).readJsonElement(path$iv$iv);
                if (jsonElement == null) {
                    ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).getLogger().throwError("Repo file '" + (String)constant$iv + "' not found.");
                    throw new KotlinNothingValueException();
                }
                JsonElement json$iv$iv = jsonElement;
                Gson $this$fromJson$iv$iv$iv = gson$iv;
                boolean $i$f$fromJson = false;
                Object object4 = $this$fromJson$iv$iv$iv.fromJson(json$iv$iv, ReflectJvmMapping.getJavaType((KType)Reflection.typeOf(RepoPatternDump.class)));
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"fromJson(...)");
                $this$getRepoData_u24lambda_u2414$iv$iv = Result.constructor-impl((Object)object4);
            }
            catch (Throwable bl2) {
                $this$getRepoData_u24lambda_u2414$iv$iv = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object3 = $this$getRepoData_u24lambda_u2414$iv$iv;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
            if (throwable != null) {
                Throwable e$iv$iv = throwable;
                boolean bl3 = false;
                this_$iv$iv.getLogger().throwErrorWithCause("Repo parsing error while trying to read constant '" + (String)constant$iv + "'", e$iv$iv);
                throw new KotlinNothingValueException();
            }
            Object constantData$iv = object3;
            $this$getConstant_u24lambda_u242$iv.getManager().addSuccessfulConstant((String)constant$iv);
            object = constantData$iv;
        }
        catch (Throwable bl) {
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Throwable it$iv = throwable;
                boolean bl4 = false;
                ((AbstractRepoReloadEvent)event).getManager().addUnsuccessfulConstant((String)constant$iv);
                ((AbstractRepoReloadEvent)event).getManager().getLogger().throwErrorWithCause("Could not load constant '" + (String)constant$iv + "'", it$iv);
                throw new KotlinNothingValueException();
            }
            throw new KotlinNothingValueException();
        }
        repoPatternManager.loadPatternsFromDump((RepoPatternDump)object);
    }

    public final void loadPatternsFromDump(@NotNull RepoPatternDump dump) {
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        regexes = null;
        regexes = dump;
        this.reloadPatterns();
    }

    @HandleEvent
    public final void onConfigLoad(@NotNull ConfigLoadEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ConditionalUtils.INSTANCE.afterChange(this.getConfig().getForceLocal(), RepoPatternManager::onConfigLoad$lambda$6);
    }

    private final void reloadPatterns() {
        NavigableMap<String, String> remotePatterns = this.getRemotePattern();
        for (CommonPatternInfo it : usedKeys.values()) {
            CommonPatternInfo commonPatternInfo = it;
            if (commonPatternInfo instanceof RepoPatternListImpl) {
                this.loadArrayPatterns(remotePatterns, (RepoPatternListImpl)it);
                continue;
            }
            if (commonPatternInfo instanceof RepoPatternImpl) {
                this.loadStandalonePattern(remotePatterns, (RepoPatternImpl)it);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void loadStandalonePattern(NavigableMap<String, String> remotePatterns, RepoPatternImpl it) {
        String remotePattern = (String)remotePatterns.get(it.getKey());
        try {
            if (remotePattern != null) {
                it.setValue(Pattern.compile(remotePattern));
                it.setLoadedRemotely(true);
                it.setWasOverridden(!Intrinsics.areEqual((Object)remotePattern, (Object)it.getDefaultPattern()));
                return;
            }
        }
        catch (PatternSyntaxException e) {
            logger.error("Error while loading pattern from repo", (Throwable)e);
        }
        it.setValue(Pattern.compile(it.getDefaultPattern()));
        it.setLoadedRemotely(false);
        it.setWasOverridden(false);
    }

    /*
     * WARNING - void declaration
     */
    private final void loadArrayPatterns(NavigableMap<String, String> remotePatterns, RepoPatternListImpl arrayPattern) {
        String it;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object object;
        void $this$mapTo$iv;
        Pair element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        String prefix = arrayPattern.getKey() + ".";
        NavigableMap<String, String> remotePatternList = StringUtils.INSTANCE.subMapOfStringsStartingWith(prefix, remotePatterns);
        Object $this$mapNotNull$iv = remotePatternList;
        boolean $i$f$mapNotNull = false;
        Map map = $this$mapNotNull$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Pair $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Pair it$iv$iv;
            Pair element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Pair it2 = element$iv$iv;
            boolean bl2 = false;
            Object k = it2.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
            Integer index = StringsKt.toIntOrNull((String)StringsKt.removePrefix((String)((String)k), (CharSequence)prefix));
            if ((index == null ? null : TuplesKt.to((Object)index, it2.getValue())) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List patternMap = (List)destination$iv$iv;
        if (this.getLocalLoading()) {
            RepoPatternManager.loadArrayPatterns$setDefaultPatterns(arrayPattern);
            return;
        }
        $this$mapNotNull$iv = patternMap;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it3;
            $this$forEach$iv$iv$iv = (Pair)item$iv;
            object = destination$iv;
            boolean bl = false;
            object.add(((Number)it3.getFirst()).intValue());
        }
        if (!Intrinsics.areEqual((Object)destination$iv, (Object)CollectionsKt.toSet((Iterable)((Iterable)CollectionsKt.getIndices((Collection)patternMap))))) {
            logger.error("Incorrect index set for " + arrayPattern);
            RepoPatternManager.loadArrayPatterns$setDefaultPatterns(arrayPattern);
        }
        Iterable $this$sortedBy$iv = patternMap;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Integer)it.getFirst();
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getFirst()));
            }
        });
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            element$iv$iv$iv = (Pair)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            object.add((String)it.getSecond());
        }
        List patternStrings = (List)destination$iv$iv2;
        try {
            $this$map$iv = patternStrings;
            object = arrayPattern;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                it = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(Pattern.compile((String)p0));
            }
            ((RepoPatternListImpl)object).setValue((List)destination$iv$iv2);
            arrayPattern.setLoadedRemotely(true);
            arrayPattern.setWasOverridden(!Intrinsics.areEqual((Object)patternStrings, (Object)arrayPattern.getDefaultPattern()));
            return;
        }
        catch (PatternSyntaxException e) {
            logger.error("Error while loading pattern from repo", (Throwable)e);
            RepoPatternManager.loadArrayPatterns$setDefaultPatterns(arrayPattern);
            return;
        }
    }

    public final void verifyKeyShape(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Pattern pattern = keyShape;
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"keyShape");
        if (!RegexUtils.INSTANCE.matches(pattern, key)) {
            boolean bl = false;
            String string = "pattern key: \"" + key + "\" failed shape requirements. Make sure your key only includes lowercase letters, numbers, dots and dashes.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void dump(@NotNull String sourceLabel, @NotNull File file) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)sourceLabel, (String)"sourceLabel");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Gson gson = ConfigManager.Companion.getGson();
        Collection collection = usedKeys.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable iterable = collection;
        String string = sourceLabel;
        Gson gson2 = gson;
        boolean $i$f$flatMap = false;
        void var6_7 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            CommonPatternInfo it = (CommonPatternInfo)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = MapsKt.toList(it.dump());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        Map map = MapsKt.toMap((Iterable)list);
        String string2 = string;
        String data = gson2.toJson((Object)new RepoPatternDump(string2, map));
        file.getParentFile().mkdirs();
        Intrinsics.checkNotNull((Object)data);
        FilesKt.writeText$default((File)file, (String)data, null, (int)2, null);
    }

    @HandleEvent
    public final void onPreInitFinished(@NotNull PreInitFinishedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        wasPreInitialized = true;
    }

    @NotNull
    public final RepoPattern of(@NotNull String key, @NotNull String fallback, @Nullable RepoPatternKeyOwner parentKeyHolder) {
        RepoPatternImpl repoPatternImpl;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)fallback, (String)"fallback");
        this.verifyKeyShape(key);
        if (wasPreInitialized && !this.getConfig().getTolerateLateRegistration()) {
            this.crash("Illegal late initialization of repo pattern. Repo pattern needs to be created during pre-initialization.");
        }
        if (((Map)usedKeys).containsKey(key)) {
            CommonPatternInfo commonPatternInfo = (CommonPatternInfo)usedKeys.get(key);
            if (commonPatternInfo != null) {
                commonPatternInfo.setHasObtainedLock$1_21_7(false);
            }
        }
        RepoPatternImpl it = repoPatternImpl = new RepoPatternImpl(fallback, key, parentKeyHolder);
        boolean bl = false;
        ((Map)usedKeys).put(key, it);
        return repoPatternImpl;
    }

    public static /* synthetic */ RepoPattern of$default(RepoPatternManager repoPatternManager, String string, String string2, RepoPatternKeyOwner repoPatternKeyOwner, int n, Object object) {
        if ((n & 4) != 0) {
            repoPatternKeyOwner = null;
        }
        return repoPatternManager.of(string, string2, repoPatternKeyOwner);
    }

    @NotNull
    public final RepoPatternList ofList(@NotNull String key, @NotNull String[] fallbacks, @Nullable RepoPatternKeyOwner parentKeyHolder) {
        RepoPatternListImpl repoPatternListImpl;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)fallbacks, (String)"fallbacks");
        this.verifyKeyShape(key);
        if (wasPreInitialized && !this.getConfig().getTolerateLateRegistration()) {
            this.crash("Illegal late initialization of repo pattern. Repo pattern needs to be created during pre-initialization.");
        }
        if (((Map)usedKeys).containsKey(key)) {
            CommonPatternInfo commonPatternInfo = (CommonPatternInfo)usedKeys.get(key);
            if (commonPatternInfo != null) {
                commonPatternInfo.setHasObtainedLock$1_21_7(false);
            }
        }
        Map $this$forEach$iv = StringUtils.INSTANCE.subMapOfStringsStartingWith(key, usedKeys);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            boolean bl = false;
            ((CommonPatternInfo)it.getValue()).setHasObtainedLock$1_21_7(false);
        }
        RepoPatternListImpl it = repoPatternListImpl = new RepoPatternListImpl(ArraysKt.toList((Object[])fallbacks), key, parentKeyHolder);
        boolean bl = false;
        ((Map)usedKeys).put(key, it);
        return repoPatternListImpl;
    }

    public static /* synthetic */ RepoPatternList ofList$default(RepoPatternManager repoPatternManager, String string, String[] stringArray, RepoPatternKeyOwner repoPatternKeyOwner, int n, Object object) {
        if ((n & 4) != 0) {
            repoPatternKeyOwner = null;
        }
        return repoPatternManager.ofList(string, stringArray, repoPatternKeyOwner);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pattern> getUnusedPatterns$1_21_7(@NotNull String prefix) {
        Map.Entry unused;
        char it;
        int count$iv;
        CharSequence $this$count$iv;
        Map $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Map.Entry it2;
        Map.Entry element$iv$iv;
        Object $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        if (this.getLocalLoading()) {
            return CollectionsKt.emptyList();
        }
        try {
            this.verifyKeyShape(prefix);
        }
        catch (IllegalArgumentException e) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"prefix", (Object)prefix)};
            ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, e, "getUnusedPatterns failed do to invalid key shape", pairArray, false, false, false, 56, null);
            return CollectionsKt.emptyList();
        }
        String prefixWithDot = prefix + ".";
        NavigableMap<String, String> patterns = StringUtils.INSTANCE.subMapOfStringsStartingWith(prefixWithDot, this.getRemotePattern());
        NavigableMap<String, CommonPatternInfo<?, ?>> holders = StringUtils.INSTANCE.subMapOfStringsStartingWith(prefixWithDot, usedKeys);
        Object $this$filter$iv = holders;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            it2 = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!(!((CommonPatternInfo)it2.getValue()).getShares())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            it2 = item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Object k = it2.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
            object.add(StringsKt.removePrefix((String)((String)k), (CharSequence)prefixWithDot));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$mapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object2;
            element$iv$iv = iterator2.next();
            it2 = (String)((Object)element$iv$iv);
            boolean bl = false;
            $this$count$iv = (CharSequence)((Object)it2);
            boolean $i$f$count = false;
            count$iv = 0;
            for (int j = 0; j < $this$count$iv.length(); ++j) {
                char element$iv;
                it = element$iv = $this$count$iv.charAt(j);
                boolean bl2 = false;
                if (!(it == '.')) continue;
                ++count$iv;
            }
            Integer key$iv$iv = count$iv;
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Object noShareHolder = destination$iv$iv;
        $this$filter$iv = patterns;
        $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        $i$f$filterTo = false;
        iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            it2 = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!(!holders.keySet().contains(it2.getKey()))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        $i$f$filterTo = false;
        iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            boolean bl;
            block17: {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                Map.Entry it3;
                Map.Entry element$iv$iv2;
                void $this$filterTo$iv$iv2;
                unused = element$iv$iv = iterator2.next();
                boolean bl4 = false;
                Object k = unused.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
                $this$count$iv = (CharSequence)k;
                boolean $i$f$count = false;
                count$iv = 0;
                for (int j = 0; j < $this$count$iv.length(); ++j) {
                    char element$iv;
                    it = element$iv = $this$count$iv.charAt(j);
                    boolean bl5 = false;
                    if (!(it == '.')) continue;
                    ++count$iv;
                }
                int dot = count$iv;
                Object $this$filter$iv2 = noShareHolder;
                boolean $i$f$filter2 = false;
                Object object3 = $this$filter$iv2;
                Object destination$iv$iv2 = new LinkedHashMap();
                boolean $i$f$filterTo2 = false;
                Iterator iterator3 = $this$filterTo$iv$iv2.entrySet().iterator();
                while (iterator3.hasNext()) {
                    it3 = element$iv$iv2 = iterator3.next();
                    boolean bl6 = false;
                    if (!(((Number)it3.getKey()).intValue() < dot)) continue;
                    destination$iv$iv2.put(element$iv$iv2.getKey(), element$iv$iv2.getValue());
                }
                $this$filter$iv2 = destination$iv$iv2;
                boolean $i$f$flatMap = false;
                $this$filterTo$iv$iv2 = $this$flatMap$iv;
                destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                iterator3 = $this$flatMapTo$iv$iv.entrySet().iterator();
                while (iterator3.hasNext()) {
                    it3 = element$iv$iv2 = iterator3.next();
                    boolean bl7 = false;
                    Iterable list$iv$iv = (Iterable)it3.getValue();
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                Set possibleConflicts = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
                Object k2 = unused.getKey();
                Intrinsics.checkNotNullExpressionValue(k2, (String)"<get-key>(...)");
                String key = StringsKt.removePrefix((String)((String)k2), (CharSequence)prefixWithDot);
                while (((CharSequence)key).length() > 0) {
                    if (possibleConflicts.contains(key)) {
                        bl = false;
                        break block17;
                    }
                    if (StringUtils.INSTANCE.substringBeforeLastOrNull(key, ".") != null) continue;
                    bl = true;
                    break block17;
                }
                bl = true;
            }
            if (!bl) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            unused = item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Object v = it2.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
            String string = (String)v;
            int n = 0;
            Pattern pattern = Pattern.compile(string, n);
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
            object.add(pattern);
        }
        return (List)destination$iv$iv;
    }

    private static final Unit onConfigLoad$lambda$6(boolean $this$afterChange) {
        INSTANCE.reloadPatterns();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final void loadArrayPatterns$setDefaultPatterns(RepoPatternListImpl $arrayPattern) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = (Iterable)$arrayPattern.getDefaultPattern();
        RepoPatternListImpl repoPatternListImpl = $arrayPattern;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Pattern.compile((String)p0));
        }
        repoPatternListImpl.setValue((List)destination$iv$iv);
        $arrayPattern.setLoadedRemotely(false);
        $arrayPattern.setWasOverridden(false);
    }

    static {
        exclusivity = new LinkedHashMap();
        usedKeys = new TreeMap();
        inTestDuplicateUsage = true;
        logger = LogManager.getLogger((String)"SkyHanni");
        keyShape = Pattern.compile("^(?:[a-z0-9]+[.-])*[a-z0-9]+$");
    }
}

