/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils.shader;

import at.hannibal2.skyhanni.utils.shader.Shader;
import at.hannibal2.skyhanni.utils.shader.ShaderHelper;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001aB3\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0010R\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0018\u001a\u0004\u0018\u00018\u00008\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001b"}, d2={"Lat/hannibal2/skyhanni/utils/shader/Uniform;", "T", "", "Lat/hannibal2/skyhanni/utils/shader/Shader;", "shader", "Lat/hannibal2/skyhanni/utils/shader/Uniform$UniformType;", "uniformType", "", "name", "Lkotlin/Function0;", "uniformValuesSupplier", "<init>", "(Lat/hannibal2/skyhanni/utils/shader/Shader;Lat/hannibal2/skyhanni/utils/shader/Uniform$UniformType;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "", "update", "()V", "Lat/hannibal2/skyhanni/utils/shader/Uniform$UniformType;", "Ljava/lang/String;", "getName", "()Ljava/lang/String;", "Lkotlin/jvm/functions/Function0;", "", "uniformID", "I", "previousUniformValue", "Ljava/lang/Object;", "UniformType", "1.21.5"})
public final class Uniform<T> {
    @NotNull
    private final UniformType<T> uniformType;
    @NotNull
    private final String name;
    @NotNull
    private final Function0<T> uniformValuesSupplier;
    private final int uniformID;
    @Nullable
    private T previousUniformValue;

    public Uniform(@NotNull Shader shader, @NotNull UniformType<T> uniformType, @NotNull String name2, @NotNull Function0<? extends T> uniformValuesSupplier) {
        Intrinsics.checkNotNullParameter((Object)shader, (String)"shader");
        Intrinsics.checkNotNullParameter(uniformType, (String)"uniformType");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(uniformValuesSupplier, (String)"uniformValuesSupplier");
        this.uniformType = uniformType;
        this.name = name2;
        this.uniformValuesSupplier = uniformValuesSupplier;
        this.uniformID = ShaderHelper.INSTANCE.glGetUniformLocation(shader.getShaderProgram(), this.name);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void update() {
        Object newUniformValue = this.uniformValuesSupplier.invoke();
        if (!Objects.deepEquals(this.previousUniformValue, newUniformValue)) {
            UniformType<T> uniformType = this.uniformType;
            if (Intrinsics.areEqual(uniformType, UniformType.Companion.getFLOAT())) {
                Intrinsics.checkNotNull((Object)newUniformValue, (String)"null cannot be cast to non-null type kotlin.Float");
                ShaderHelper.INSTANCE.glUniform1f(this.uniformID, ((Float)newUniformValue).floatValue());
            } else if (Intrinsics.areEqual(uniformType, UniformType.Companion.getVEC2())) {
                Intrinsics.checkNotNull((Object)newUniformValue, (String)"null cannot be cast to non-null type kotlin.FloatArray");
                float[] values = (float[])newUniformValue;
                ShaderHelper.INSTANCE.glUniform2f(this.uniformID, values[0], values[1]);
            } else if (Intrinsics.areEqual(uniformType, UniformType.Companion.getVEC3())) {
                Intrinsics.checkNotNull((Object)newUniformValue, (String)"null cannot be cast to non-null type kotlin.FloatArray");
                float[] values = (float[])newUniformValue;
                ShaderHelper.INSTANCE.glUniform3f(this.uniformID, values[0], values[1], values[2]);
            } else if (Intrinsics.areEqual(uniformType, UniformType.Companion.getVEC4())) {
                Intrinsics.checkNotNull((Object)newUniformValue, (String)"null cannot be cast to non-null type kotlin.FloatArray");
                float[] values = (float[])newUniformValue;
                ShaderHelper.INSTANCE.glUniform4f(this.uniformID, values[0], values[1], values[2], values[3]);
            } else if (Intrinsics.areEqual(uniformType, UniformType.Companion.getMAT4())) {
                Intrinsics.checkNotNull((Object)newUniformValue, (String)"null cannot be cast to non-null type org.joml.Matrix4f");
                Matrix4f matrix = (Matrix4f)newUniformValue;
                ShaderHelper.INSTANCE.glUniformMatrix4f(this.uniformID, false, matrix);
            } else if (Intrinsics.areEqual(uniformType, UniformType.Companion.getBOOL())) {
                Intrinsics.checkNotNull((Object)newUniformValue, (String)"null cannot be cast to non-null type kotlin.Boolean");
                ShaderHelper.INSTANCE.glUniform1f(this.uniformID, (Boolean)newUniformValue != false ? 1.0f : 0.0f);
            } else if (Intrinsics.areEqual(uniformType, UniformType.Companion.getINT())) {
                Intrinsics.checkNotNull((Object)newUniformValue, (String)"null cannot be cast to non-null type kotlin.Int");
                ShaderHelper.INSTANCE.glUniform1i(this.uniformID, (Integer)newUniformValue);
            }
            this.previousUniformValue = newUniformValue;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u0005*\u0004\b\u0001\u0010\u00012\u00020\u0002:\u0001\u0005B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0006"}, d2={"Lat/hannibal2/skyhanni/utils/shader/Uniform$UniformType;", "T", "", "<init>", "()V", "Companion", "1.21.5"})
    public static final class UniformType<T> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final UniformType<Float> FLOAT = new UniformType();
        @NotNull
        private static final UniformType<float[]> VEC2 = new UniformType();
        @NotNull
        private static final UniformType<float[]> VEC3 = new UniformType();
        @NotNull
        private static final UniformType<float[]> VEC4 = new UniformType();
        @NotNull
        private static final UniformType<Boolean> BOOL = new UniformType();
        @NotNull
        private static final UniformType<Integer> INT = new UniformType();
        @NotNull
        private static final UniformType<Matrix4f> MAT4 = new UniformType();

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\tR\u001d\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u00048\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\u0007\u001a\u0004\b\f\u0010\tR\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u00048\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u0007\u001a\u0004\b\u000e\u0010\tR\u001d\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00048\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0007\u001a\u0004\b\u0010\u0010\tR\u001d\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0007\u001a\u0004\b\u0013\u0010\tR\u001d\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0007\u001a\u0004\b\u0016\u0010\tR\u001d\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0007\u001a\u0004\b\u0019\u0010\t\u00a8\u0006\u001a"}, d2={"Lat/hannibal2/skyhanni/utils/shader/Uniform$UniformType$Companion;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/utils/shader/Uniform$UniformType;", "", "FLOAT", "Lat/hannibal2/skyhanni/utils/shader/Uniform$UniformType;", "getFLOAT", "()Lat/hannibal2/skyhanni/utils/shader/Uniform$UniformType;", "", "VEC2", "getVEC2", "VEC3", "getVEC3", "VEC4", "getVEC4", "", "BOOL", "getBOOL", "", "INT", "getINT", "Lorg/joml/Matrix4f;", "MAT4", "getMAT4", "1.21.5"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final UniformType<Float> getFLOAT() {
                return FLOAT;
            }

            @NotNull
            public final UniformType<float[]> getVEC2() {
                return VEC2;
            }

            @NotNull
            public final UniformType<float[]> getVEC3() {
                return VEC3;
            }

            @NotNull
            public final UniformType<float[]> getVEC4() {
                return VEC4;
            }

            @NotNull
            public final UniformType<Boolean> getBOOL() {
                return BOOL;
            }

            @NotNull
            public final UniformType<Integer> getINT() {
                return INT;
            }

            @NotNull
            public final UniformType<Matrix4f> getMAT4() {
                return MAT4;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

