/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.api.minecraftevents;

import at.hannibal2.skyhanni.data.mob.Mob;
import at.hannibal2.skyhanni.data.mob.MobData;
import at.hannibal2.skyhanni.data.mob.MobDetection;
import at.hannibal2.skyhanni.events.SkyHanniRenderEntityEvent;
import at.hannibal2.skyhanni.events.entity.EndermanTeleportEvent;
import at.hannibal2.skyhanni.events.entity.EntityDeathEvent;
import at.hannibal2.skyhanni.events.entity.EntityEnterWorldEvent;
import at.hannibal2.skyhanni.events.entity.EntityHurtEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001b\u0010\u0013\u001a\u00020\u00062\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001b\u0010\u0016\u001a\u00020\u00062\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001b\u0010\u0019\u001a\u00020\u00062\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001b\u0010\u001c\u001a\u00020\u00062\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lat/hannibal2/skyhanni/api/minecraftevents/EntityEvents;", "", "<init>", "()V", "Lnet/minecraftforge/event/entity/EntityJoinWorldEvent;", "event", "", "onEntityJoinWorld", "(Lnet/minecraftforge/event/entity/EntityJoinWorldEvent;)V", "Lnet/minecraftforge/event/entity/living/LivingAttackEvent;", "onEntityHurt", "(Lnet/minecraftforge/event/entity/living/LivingAttackEvent;)V", "Lnet/minecraftforge/event/entity/living/EnderTeleportEvent;", "onEnderTeleport", "(Lnet/minecraftforge/event/entity/living/EnderTeleportEvent;)V", "Lnet/minecraftforge/event/entity/living/LivingDeathEvent;", "onLivingDeath", "(Lnet/minecraftforge/event/entity/living/LivingDeathEvent;)V", "Lnet/minecraftforge/client/event/RenderLivingEvent$Pre;", "onEntityRenderPre", "(Lnet/minecraftforge/client/event/RenderLivingEvent$Pre;)V", "Lnet/minecraftforge/client/event/RenderLivingEvent$Post;", "onEntityRenderPost", "(Lnet/minecraftforge/client/event/RenderLivingEvent$Post;)V", "Lnet/minecraftforge/client/event/RenderLivingEvent$Specials$Pre;", "onEntityRenderSpecialsPre", "(Lnet/minecraftforge/client/event/RenderLivingEvent$Specials$Pre;)V", "Lnet/minecraftforge/client/event/RenderLivingEvent$Specials$Post;", "onEntityRenderSpecialsPost", "(Lnet/minecraftforge/client/event/RenderLivingEvent$Specials$Post;)V", "1.8.9"})
public final class EntityEvents {
    @NotNull
    public static final EntityEvents INSTANCE = new EntityEvents();

    private EntityEvents() {
    }

    @SubscribeEvent
    public final void onEntityJoinWorld(@NotNull EntityJoinWorldEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Entity entity = event.entity;
        Intrinsics.checkNotNullExpressionValue(entity, "entity");
        new EntityEnterWorldEvent<Entity>(entity).post();
    }

    @SubscribeEvent
    public final void onEntityHurt(@NotNull LivingAttackEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Entity entity = event.entity;
        DamageSource source = event.source;
        float amount = event.ammount;
        Intrinsics.checkNotNull(entity);
        Intrinsics.checkNotNull(source);
        new EntityHurtEvent<Entity>(entity, source, amount).post();
        Mob mob = MobData.INSTANCE.getEntityToMob().get(entity);
        if (mob == null) {
            return;
        }
        Mob skyblockMob = mob;
        MobDetection.INSTANCE.postMobHurtEvent(skyblockMob, source, amount);
    }

    @SubscribeEvent
    public final void onEnderTeleport(@NotNull EnderTeleportEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (new EndermanTeleportEvent().post()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public final void onLivingDeath(@NotNull LivingDeathEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Entity entity = event.entity;
        Intrinsics.checkNotNullExpressionValue(entity, "entity");
        new EntityDeathEvent<Entity>(entity).post();
    }

    @SubscribeEvent
    public final void onEntityRenderPre(@NotNull RenderLivingEvent.Pre<?> event) {
        Intrinsics.checkNotNullParameter(event, "event");
        EntityLivingBase entityLivingBase = event.entity;
        Intrinsics.checkNotNullExpressionValue(entityLivingBase, "entity");
        if (new SkyHanniRenderEntityEvent.Pre<EntityLivingBase>(entityLivingBase, event.x, event.y, event.z).post()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public final void onEntityRenderPost(@NotNull RenderLivingEvent.Post<?> event) {
        Intrinsics.checkNotNullParameter(event, "event");
        EntityLivingBase entityLivingBase = event.entity;
        Intrinsics.checkNotNullExpressionValue(entityLivingBase, "entity");
        new SkyHanniRenderEntityEvent.Post<EntityLivingBase>(entityLivingBase, event.x, event.y, event.z).post();
    }

    @SubscribeEvent
    public final void onEntityRenderSpecialsPre(@NotNull RenderLivingEvent.Specials.Pre<?> event) {
        Intrinsics.checkNotNullParameter(event, "event");
        EntityLivingBase entityLivingBase = event.entity;
        Intrinsics.checkNotNullExpressionValue(entityLivingBase, "entity");
        if (new SkyHanniRenderEntityEvent.Specials.Pre<EntityLivingBase>(entityLivingBase, event.x, event.y, event.z).post()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public final void onEntityRenderSpecialsPost(@NotNull RenderLivingEvent.Specials.Post<?> event) {
        Intrinsics.checkNotNullParameter(event, "event");
        EntityLivingBase entityLivingBase = event.entity;
        Intrinsics.checkNotNullExpressionValue(entityLivingBase, "entity");
        new SkyHanniRenderEntityEvent.Specials.Post<EntityLivingBase>(entityLivingBase, event.x, event.y, event.z).post();
    }
}

