/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.data.mob;

import at.hannibal2.skyhanni.data.ElectionApi;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.mob.IslandExceptions;
import at.hannibal2.skyhanni.data.mob.Mob;
import at.hannibal2.skyhanni.data.mob.MobData;
import at.hannibal2.skyhanni.data.mob.MobFactories;
import at.hannibal2.skyhanni.events.MobEvent;
import at.hannibal2.skyhanni.features.dungeon.DungeonApi;
import at.hannibal2.skyhanni.utils.EntityUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.MobUtils;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.SkullTextureHolder;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.collection.CollectionUtils;
import at.hannibal2.skyhanni.utils.compat.EntityCompatKt;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.reflect.KProperty;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGiantZombie;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b?\n\u0002\u0010\"\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001~B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0011\u0010\n\u001a\u00020\u0006*\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0011\u0010\r\u001a\u00020\u0006*\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0011\u0010\u0010\u001a\u00020\u0006*\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0013\u0010\u0011J\u0017\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u000fH\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0017J/\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u00192\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001bH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0019\u0010 \u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0014\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b \u0010\u0017J#\u0010\"\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0014\u001a\u00020\u000f2\b\u0010!\u001a\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0004\b\"\u0010#J'\u0010$\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0014\u001a\u00020\u000f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001bH\u0002\u00a2\u0006\u0004\b$\u0010%J!\u0010&\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b&\u0010'J\u0011\u0010(\u001a\u00020\u0006*\u00020\u000f\u00a2\u0006\u0004\b(\u0010\u0011J\u0019\u0010)\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b)\u0010*J\u0019\u0010+\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0014\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b+\u0010\u0017J+\u00100\u001a\u00020\u0015*\u0004\u0018\u00010\u00192\u0014\u0010-\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001d0,H\u0000\u00a2\u0006\u0004\b.\u0010/R\u0014\u00102\u001a\u0002018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u00103R\u0014\u00104\u001a\u00020\u00048\u0002X\u0083D\u00a2\u0006\u0006\n\u0004\b4\u00105R\u0014\u00106\u001a\u00020\u00048\u0002X\u0083D\u00a2\u0006\u0006\n\u0004\b6\u00105R\u001b\u0010<\u001a\u0002078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b8\u00109\u001a\u0004\b:\u0010;R\u001b\u0010?\u001a\u0002078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b=\u00109\u001a\u0004\b>\u0010;R\u001b\u0010B\u001a\u0002078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b@\u00109\u001a\u0004\bA\u0010;R!\u0010F\u001a\u0002078FX\u0086\u0084\u0002\u00a2\u0006\u0012\n\u0004\bC\u00109\u0012\u0004\bE\u0010\u0003\u001a\u0004\bD\u0010;R\u001b\u0010I\u001a\u0002078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bG\u00109\u001a\u0004\bH\u0010;R\u001b\u0010L\u001a\u0002078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bJ\u00109\u001a\u0004\bK\u0010;R\u001b\u0010O\u001a\u0002078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bM\u00109\u001a\u0004\bN\u0010;R\u001b\u0010R\u001a\u0002078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bP\u00109\u001a\u0004\bQ\u0010;R\u001b\u0010U\u001a\u0002078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bS\u00109\u001a\u0004\bT\u0010;R\u001b\u0010X\u001a\u0002078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bV\u00109\u001a\u0004\bW\u0010;R\u001b\u0010[\u001a\u0002078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bY\u00109\u001a\u0004\bZ\u0010;R\u001b\u0010^\u001a\u0002078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\\\u00109\u001a\u0004\b]\u0010;R\u001b\u0010a\u001a\u0002078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b_\u00109\u001a\u0004\b`\u0010;R\u001b\u0010d\u001a\u0002078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bb\u00109\u001a\u0004\bc\u0010;R\u001b\u0010i\u001a\u00020\u00048@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\be\u0010f\u001a\u0004\bg\u0010hR\u001b\u0010l\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bj\u0010f\u001a\u0004\bk\u0010hR\u001b\u0010o\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bm\u0010f\u001a\u0004\bn\u0010hR\u001b\u0010r\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bp\u0010f\u001a\u0004\bq\u0010hR\u001b\u0010u\u001a\u00020\u00048@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\bs\u0010f\u001a\u0004\bt\u0010hR\u0014\u0010v\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bv\u00105R\u001a\u0010x\u001a\b\u0012\u0004\u0012\u00020\u00040w8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bx\u0010yR\u001b\u0010|\u001a\u0002078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bz\u00109\u001a\u0004\b{\u0010;R\u001a\u0010}\u001a\b\u0012\u0004\u0012\u00020\u00040w8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b}\u0010y\u00a8\u0006\u007f"}, d2={"Lat/hannibal2/skyhanni/data/mob/MobFilter;", "", "<init>", "()V", "", "name", "", "displayNpcNameCheck", "(Ljava/lang/String;)Z", "Lnet/minecraft/entity/Entity;", "isSkyBlockMob", "(Lnet/minecraft/entity/Entity;)Z", "Lnet/minecraft/entity/player/EntityPlayer;", "isRealPlayer", "(Lnet/minecraft/entity/player/EntityPlayer;)Z", "Lnet/minecraft/entity/EntityLivingBase;", "isDisplayNpc", "(Lnet/minecraft/entity/EntityLivingBase;)Z", "entity", "createDisplayNpc", "baseEntity", "Lat/hannibal2/skyhanni/data/mob/MobData$MobResult;", "createSkyblockEntity$1_8_9", "(Lnet/minecraft/entity/EntityLivingBase;)Lat/hannibal2/skyhanni/data/mob/MobData$MobResult;", "createSkyblockEntity", "Lnet/minecraft/entity/item/EntityArmorStand;", "armorStand", "", "extraEntityList", "Lat/hannibal2/skyhanni/data/mob/Mob;", "createSkyblockMob", "(Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/entity/item/EntityArmorStand;Ljava/util/List;)Lat/hannibal2/skyhanni/data/mob/Mob;", "noArmorStandMobs", "nextEntity", "exceptions", "(Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/entity/EntityLivingBase;)Lat/hannibal2/skyhanni/data/mob/MobData$MobResult;", "stackedMobsException", "(Lnet/minecraft/entity/EntityLivingBase;Ljava/util/List;)Lat/hannibal2/skyhanni/data/mob/MobData$MobResult;", "armorStandOnlyMobs", "(Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/entity/item/EntityArmorStand;)Lat/hannibal2/skyhanni/data/mob/MobData$MobResult;", "isFarmMob", "createFarmMobs", "(Lnet/minecraft/entity/EntityLivingBase;)Lat/hannibal2/skyhanni/data/mob/Mob;", "createBat", "Lkotlin/Function1;", "mob", "makeMobResult$1_8_9", "(Lnet/minecraft/entity/item/EntityArmorStand;Lkotlin/jvm/functions/Function1;)Lat/hannibal2/skyhanni/data/mob/MobData$MobResult;", "makeMobResult", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "mobType", "Ljava/lang/String;", "level", "Ljava/util/regex/Pattern;", "mobNameFilter$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getMobNameFilter", "()Ljava/util/regex/Pattern;", "mobNameFilter", "slayerNameFilter$delegate", "getSlayerNameFilter", "slayerNameFilter", "bossMobNameFilter$delegate", "getBossMobNameFilter", "bossMobNameFilter", "dungeonNameFilter$delegate", "getDungeonNameFilter", "getDungeonNameFilter$annotations", "dungeonNameFilter", "summonFilter$delegate", "getSummonFilter", "summonFilter", "dojoFilter$delegate", "getDojoFilter", "dojoFilter", "jerryPattern$delegate", "getJerryPattern", "jerryPattern", "petCareNamePattern$delegate", "getPetCareNamePattern", "petCareNamePattern", "wokeSleepingGolemPattern$delegate", "getWokeSleepingGolemPattern", "wokeSleepingGolemPattern", "jerryMagmaCubePattern$delegate", "getJerryMagmaCubePattern", "jerryMagmaCubePattern", "summonOwnerPattern$delegate", "getSummonOwnerPattern", "summonOwnerPattern", "heavyPearlPattern$delegate", "getHeavyPearlPattern", "heavyPearlPattern", "shinyPig$delegate", "getShinyPig", "shinyPig", "illegalEntitiesPattern$delegate", "getIllegalEntitiesPattern", "illegalEntitiesPattern", "RAT_SKULL_TEXTURE$delegate", "Lkotlin/Lazy;", "getRAT_SKULL_TEXTURE$1_8_9", "()Ljava/lang/String;", "RAT_SKULL_TEXTURE", "HELLWISP_TENTACLE_SKULL_TEXTURE$delegate", "getHELLWISP_TENTACLE_SKULL_TEXTURE", "HELLWISP_TENTACLE_SKULL_TEXTURE", "RIFT_EYE_SKULL1_TEXTURE$delegate", "getRIFT_EYE_SKULL1_TEXTURE", "RIFT_EYE_SKULL1_TEXTURE", "RIFT_EYE_SKULL2_TEXTURE$delegate", "getRIFT_EYE_SKULL2_TEXTURE", "RIFT_EYE_SKULL2_TEXTURE", "NPC_TURD_SKULL$delegate", "getNPC_TURD_SKULL$1_8_9", "NPC_TURD_SKULL", "MINION_MOB_PREFIX", "", "extraDisplayNpcByName", "Ljava/util/Set;", "displayNpcCompressedNamePattern$delegate", "getDisplayNpcCompressedNamePattern", "displayNpcCompressedNamePattern", "listOfClickArmorStand", "DungeonAttribute", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nMobFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MobFilter.kt\nat/hannibal2/skyhanni/data/mob/MobFilter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n*L\n1#1,433:1\n1#2:434\n1#2:442\n295#3,2:435\n1557#3:437\n1628#3,3:438\n8#4:441\n*S KotlinDebug\n*F\n+ 1 MobFilter.kt\nat/hannibal2/skyhanni/data/mob/MobFilter\n*L\n337#1:442\n231#1:435,2\n293#1:437\n293#1:438,3\n337#1:441\n*E\n"})
public final class MobFilter {
    @NotNull
    public static final MobFilter INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @Language(value="RegExp")
    @NotNull
    private static final String mobType;
    @Language(value="RegExp")
    @NotNull
    private static final String level;
    @NotNull
    private static final RepoPattern mobNameFilter$delegate;
    @NotNull
    private static final RepoPattern slayerNameFilter$delegate;
    @NotNull
    private static final RepoPattern bossMobNameFilter$delegate;
    @NotNull
    private static final RepoPattern dungeonNameFilter$delegate;
    @NotNull
    private static final RepoPattern summonFilter$delegate;
    @NotNull
    private static final RepoPattern dojoFilter$delegate;
    @NotNull
    private static final RepoPattern jerryPattern$delegate;
    @NotNull
    private static final RepoPattern petCareNamePattern$delegate;
    @NotNull
    private static final RepoPattern wokeSleepingGolemPattern$delegate;
    @NotNull
    private static final RepoPattern jerryMagmaCubePattern$delegate;
    @NotNull
    private static final RepoPattern summonOwnerPattern$delegate;
    @NotNull
    private static final RepoPattern heavyPearlPattern$delegate;
    @NotNull
    private static final RepoPattern shinyPig$delegate;
    @NotNull
    private static final RepoPattern illegalEntitiesPattern$delegate;
    @NotNull
    private static final Lazy RAT_SKULL_TEXTURE$delegate;
    @NotNull
    private static final Lazy HELLWISP_TENTACLE_SKULL_TEXTURE$delegate;
    @NotNull
    private static final Lazy RIFT_EYE_SKULL1_TEXTURE$delegate;
    @NotNull
    private static final Lazy RIFT_EYE_SKULL2_TEXTURE$delegate;
    @NotNull
    private static final Lazy NPC_TURD_SKULL$delegate;
    @NotNull
    public static final String MINION_MOB_PREFIX = "Minion Mob ";
    @NotNull
    private static final Set<String> extraDisplayNpcByName;
    @NotNull
    private static final RepoPattern displayNpcCompressedNamePattern$delegate;
    @NotNull
    private static final Set<String> listOfClickArmorStand;

    private MobFilter() {
    }

    @NotNull
    public final Pattern getMobNameFilter() {
        return (Pattern)mobNameFilter$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    @NotNull
    public final Pattern getSlayerNameFilter() {
        return (Pattern)slayerNameFilter$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[1]);
    }

    @NotNull
    public final Pattern getBossMobNameFilter() {
        return (Pattern)bossMobNameFilter$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[2]);
    }

    @NotNull
    public final Pattern getDungeonNameFilter() {
        return (Pattern)dungeonNameFilter$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[3]);
    }

    public static /* synthetic */ void getDungeonNameFilter$annotations() {
    }

    @NotNull
    public final Pattern getSummonFilter() {
        return (Pattern)summonFilter$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[4]);
    }

    @NotNull
    public final Pattern getDojoFilter() {
        return (Pattern)dojoFilter$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[5]);
    }

    @NotNull
    public final Pattern getJerryPattern() {
        return (Pattern)jerryPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[6]);
    }

    @NotNull
    public final Pattern getPetCareNamePattern() {
        return (Pattern)petCareNamePattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[7]);
    }

    @NotNull
    public final Pattern getWokeSleepingGolemPattern() {
        return (Pattern)wokeSleepingGolemPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[8]);
    }

    @NotNull
    public final Pattern getJerryMagmaCubePattern() {
        return (Pattern)jerryMagmaCubePattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[9]);
    }

    @NotNull
    public final Pattern getSummonOwnerPattern() {
        return (Pattern)summonOwnerPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[10]);
    }

    @NotNull
    public final Pattern getHeavyPearlPattern() {
        return (Pattern)heavyPearlPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[11]);
    }

    @NotNull
    public final Pattern getShinyPig() {
        return (Pattern)shinyPig$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[12]);
    }

    @NotNull
    public final Pattern getIllegalEntitiesPattern() {
        return (Pattern)illegalEntitiesPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[13]);
    }

    @NotNull
    public final String getRAT_SKULL_TEXTURE$1_8_9() {
        Lazy lazy = RAT_SKULL_TEXTURE$delegate;
        return (String)lazy.getValue();
    }

    private final String getHELLWISP_TENTACLE_SKULL_TEXTURE() {
        Lazy lazy = HELLWISP_TENTACLE_SKULL_TEXTURE$delegate;
        return (String)lazy.getValue();
    }

    private final String getRIFT_EYE_SKULL1_TEXTURE() {
        Lazy lazy = RIFT_EYE_SKULL1_TEXTURE$delegate;
        return (String)lazy.getValue();
    }

    private final String getRIFT_EYE_SKULL2_TEXTURE() {
        Lazy lazy = RIFT_EYE_SKULL2_TEXTURE$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getNPC_TURD_SKULL$1_8_9() {
        Lazy lazy = NPC_TURD_SKULL$delegate;
        return (String)lazy.getValue();
    }

    private final Pattern getDisplayNpcCompressedNamePattern() {
        return (Pattern)displayNpcCompressedNamePattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[14]);
    }

    private final boolean displayNpcNameCheck(String name2) {
        return StringsKt.startsWith$default((CharSequence)name2, '\u00a7', false, 2, null) || RegexUtils.INSTANCE.matches(this.getDisplayNpcCompressedNamePattern(), name2) || extraDisplayNpcByName.contains(name2);
    }

    public final boolean isSkyBlockMob(@NotNull Entity $this$isSkyBlockMob) {
        Intrinsics.checkNotNullParameter($this$isSkyBlockMob, "<this>");
        return !($this$isSkyBlockMob instanceof EntityLivingBase) ? false : ($this$isSkyBlockMob instanceof EntityArmorStand ? false : ($this$isSkyBlockMob instanceof EntityPlayer && this.isRealPlayer((EntityPlayer)$this$isSkyBlockMob) ? false : (this.isDisplayNpc((EntityLivingBase)$this$isSkyBlockMob) ? false : !($this$isSkyBlockMob instanceof EntityWither) || ((EntityWither)$this$isSkyBlockMob).func_145782_y() >= 0)));
    }

    public final boolean isRealPlayer(@NotNull EntityPlayer $this$isRealPlayer) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isRealPlayer, "<this>");
        UUID uUID = $this$isRealPlayer.func_110124_au();
        if (uUID != null) {
            UUID it = uUID;
            boolean bl2 = false;
            bl = it.version() == 4;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isDisplayNpc(@NotNull EntityLivingBase $this$isDisplayNpc) {
        Intrinsics.checkNotNullParameter($this$isDisplayNpc, "<this>");
        if ($this$isDisplayNpc instanceof EntityPlayer && EntityUtils.INSTANCE.isNpc((EntityPlayer)$this$isDisplayNpc)) {
            String string = ((EntityPlayer)$this$isDisplayNpc).func_70005_c_();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            if (this.displayNpcNameCheck(string)) return true;
        }
        if ($this$isDisplayNpc instanceof EntityVillager) {
            if (((EntityVillager)$this$isDisplayNpc).func_110138_aP() == 20.0f) {
                return true;
            }
            boolean bl = false;
            if (bl) return true;
        }
        if ($this$isDisplayNpc instanceof EntityWitch) {
            if (((EntityWitch)$this$isDisplayNpc).func_145782_y() <= 500) return true;
        }
        if ($this$isDisplayNpc instanceof EntityCow) {
            if (((EntityCow)$this$isDisplayNpc).func_145782_y() <= 500) return true;
        }
        if ($this$isDisplayNpc instanceof EntityPig) {
            if (((EntityPig)$this$isDisplayNpc).func_145782_y() <= 600) return true;
        }
        if (!($this$isDisplayNpc instanceof EntitySnowman)) return false;
        if (((EntitySnowman)$this$isDisplayNpc).func_145782_y() > 500) return false;
        return true;
    }

    public final boolean createDisplayNpc(@NotNull EntityLivingBase entity) {
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter(entity, "entity");
            Iterable $this$firstOrNull$iv = MobUtils.INSTANCE.getArmorStandByRangeAll((Entity)entity, 1.5);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                EntityArmorStand armorStand = (EntityArmorStand)element$iv;
                boolean bl = false;
                if (!listOfClickArmorStand.contains(armorStand.func_70005_c_())) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        EntityArmorStand entityArmorStand = v0;
        if (entityArmorStand == null) {
            return false;
        }
        EntityArmorStand clickArmorStand = entityArmorStand;
        EntityArmorStand entityArmorStand2 = MobUtils.INSTANCE.getArmorStand((Entity)clickArmorStand, -1);
        if (entityArmorStand2 == null) {
            return false;
        }
        EntityArmorStand armorStand = entityArmorStand2;
        new MobEvent.Spawn.DisplayNpc(MobFactories.INSTANCE.displayNpc(entity, armorStand, clickArmorStand)).post();
        return true;
    }

    @NotNull
    public final MobData.MobResult createSkyblockEntity$1_8_9(@NotNull EntityLivingBase baseEntity) {
        Object object;
        block12: {
            block11: {
                Object object2;
                Object it;
                Intrinsics.checkNotNullParameter(baseEntity, "baseEntity");
                Object object3 = MobUtils.INSTANCE.getNextEntity((Entity)baseEntity, 1);
                EntityLivingBase nextEntity = object3 instanceof EntityLivingBase ? (EntityLivingBase)object3 : null;
                object3 = this.exceptions(baseEntity, nextEntity);
                if (object3 != null) {
                    Object it2 = object3;
                    boolean bl = false;
                    return it2;
                }
                EntityLivingBase entityLivingBase = nextEntity;
                if (entityLivingBase != null) {
                    EntityLivingBase it3 = entityLivingBase;
                    boolean bl = false;
                    Mob mob = MobData.INSTANCE.getEntityToMob().get(it3);
                    if (mob != null) {
                        Mob mob2;
                        Mob $this$createSkyblockEntity_u24lambda_u2410_u24lambda_u248 = mob2 = mob;
                        boolean bl2 = false;
                        $this$createSkyblockEntity_u24lambda_u2410_u24lambda_u248.internalAddEntity$1_8_9(baseEntity);
                        mob = mob2;
                        if (mob != null) {
                            it = mob;
                            boolean bl3 = false;
                            return MobData.MobResult.Companion.getIllegal();
                        }
                    }
                }
                Ref.ObjectRef caughtSkyblockMob = new Ref.ObjectRef();
                List<EntityLivingBase> extraEntityList = SequencesKt.toList(CollectionUtils.INSTANCE.takeWhileInclusive(SequencesKt.generateSequence(nextEntity, MobFilter::createSkyblockEntity$lambda$11), arg_0 -> MobFilter.createSkyblockEntity$lambda$14(caughtSkyblockMob, arg_0)));
                Object bl = this.stackedMobsException(baseEntity, extraEntityList);
                if (bl != null) {
                    it = bl;
                    boolean bl4 = false;
                    return it;
                }
                bl = (Mob)caughtSkyblockMob.element;
                if (bl != null) {
                    Object $this$createSkyblockEntity_u24lambda_u2416 = object2 = bl;
                    boolean bl5 = false;
                    ((Mob)$this$createSkyblockEntity_u24lambda_u2416).internalAddEntity$1_8_9((Collection<? extends EntityLivingBase>)CollectionsKt.dropLast(extraEntityList, 1));
                    Object it4 = object2;
                    boolean bl6 = false;
                    return MobData.MobResult.Companion.getIllegal();
                }
                object2 = CollectionsKt.lastOrNull(extraEntityList);
                EntityArmorStand entityArmorStand = object2 instanceof EntityArmorStand ? (EntityArmorStand)object2 : null;
                if (entityArmorStand == null) {
                    return MobData.MobResult.Companion.getNotYetFound();
                }
                EntityArmorStand armorStand = entityArmorStand;
                if (MobUtils.INSTANCE.isDefaultValue(armorStand)) {
                    return MobData.MobResult.Companion.getNotYetFound();
                }
                object = this.createSkyblockMob(baseEntity, armorStand, CollectionsKt.dropLast(extraEntityList, 1));
                if (object == null) break block11;
                Mob it5 = object;
                boolean bl7 = false;
                MobData.MobResult mobResult = MobData.MobResult.Companion.found(it5);
                object = mobResult;
                if (mobResult != null) break block12;
            }
            object = MobData.MobResult.Companion.getNotYetFound();
        }
        return object;
    }

    private final Mob createSkyblockMob(EntityLivingBase baseEntity, EntityArmorStand armorStand, List<? extends EntityLivingBase> extraEntityList) {
        Mob mob = MobFactories.INSTANCE.summon(baseEntity, armorStand, extraEntityList);
        if (mob == null && (mob = MobFactories.INSTANCE.slayer(baseEntity, armorStand, extraEntityList)) == null && (mob = MobFactories.boss$default(MobFactories.INSTANCE, baseEntity, armorStand, extraEntityList, null, 8, null)) == null) {
            if (DungeonApi.INSTANCE.inDungeon()) {
                mob = MobFactories.INSTANCE.dungeon(baseEntity, armorStand, extraEntityList);
            } else {
                mob = MobFactories.INSTANCE.basic(baseEntity, armorStand, extraEntityList);
                if (mob == null) {
                    mob = MobFactories.INSTANCE.dojo(baseEntity, armorStand);
                }
            }
        }
        return mob;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final MobData.MobResult noArmorStandMobs(EntityLivingBase baseEntity) {
        MobData.MobResult mobResult;
        if (baseEntity instanceof EntityBat) {
            mobResult = this.createBat(baseEntity);
            return mobResult;
        } else if (this.isFarmMob(baseEntity)) {
            Mob mob = this.createFarmMobs(baseEntity);
            if (mob == null) return null;
            Mob it = mob;
            boolean bl = false;
            mobResult = MobData.MobResult.Companion.found(it);
            return mobResult;
        } else if (baseEntity instanceof EntityDragon) {
            if (WhenMappings.$EnumSwitchMapping$0[SkyBlockUtils.INSTANCE.getCurrentIsland().ordinal()] == 1) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable it = new IntRange(8, 16);
                MobData.MobResult.Companion companion = MobData.MobResult.Companion;
                boolean $i$f$map = false;
                void var6_9 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void it2;
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(MobUtils.INSTANCE.getArmorStand((Entity)baseEntity, (int)it2));
                }
                mobResult = companion.makeMobResult((List)destination$iv$iv, arg_0 -> MobFilter.noArmorStandMobs$lambda$21(baseEntity, arg_0));
                return mobResult;
            } else {
                mobResult = MobData.MobResult.Companion.found(MobFactories.INSTANCE.basic(baseEntity, EntityUtils.INSTANCE.cleanName((Entity)baseEntity)));
            }
            return mobResult;
        } else if (baseEntity instanceof EntityGiantZombie && Intrinsics.areEqual(((EntityGiantZombie)baseEntity).func_70005_c_(), "Dinnerbone")) {
            mobResult = MobData.MobResult.Companion.found(MobFactories.INSTANCE.projectile(baseEntity, "Giant Sword"));
            return mobResult;
        } else if (baseEntity instanceof EntityCaveSpider) {
            EntityArmorStand entityArmorStand;
            EntityArmorStand entityArmorStand2 = MobUtils.INSTANCE.getArmorStand((Entity)baseEntity, -1);
            if (entityArmorStand2 == null) return null;
            EntityArmorStand it = entityArmorStand = entityArmorStand2;
            boolean bl = false;
            if (!RegexUtils.INSTANCE.matches(INSTANCE.getSummonOwnerPattern(), EntityUtils.INSTANCE.cleanName((Entity)it))) return null;
            EntityArmorStand entityArmorStand3 = entityArmorStand;
            EntityArmorStand entityArmorStand4 = entityArmorStand3;
            if (entityArmorStand4 == null) return null;
            it = entityArmorStand4;
            boolean bl2 = false;
            Mob mob = MobData.INSTANCE.getEntityToMob().get(MobUtils.INSTANCE.getNextEntity((Entity)baseEntity, -4));
            if (mob == null) return null;
            mob.internalAddEntity$1_8_9(baseEntity);
            Unit it3 = Unit.INSTANCE;
            boolean bl3 = false;
            mobResult = MobData.MobResult.Companion.getIllegal();
            return mobResult;
        } else if (baseEntity instanceof EntityWither && ((EntityWither)baseEntity).func_82212_n() == 800) {
            mobResult = MobData.MobResult.Companion.found(MobFactories.special$default(MobFactories.INSTANCE, baseEntity, "Mini Wither", null, 4, null));
            return mobResult;
        } else {
            if (!(baseEntity instanceof EntityOtherPlayerMP)) return null;
            if (!Intrinsics.areEqual(((EntityOtherPlayerMP)baseEntity).func_70005_c_(), "Decoy ")) return null;
            mobResult = MobData.MobResult.Companion.found(MobFactories.special$default(MobFactories.INSTANCE, baseEntity, "Decoy", null, 4, null));
        }
        return mobResult;
    }

    /*
     * WARNING - void declaration
     */
    private final MobData.MobResult exceptions(EntityLivingBase baseEntity, EntityLivingBase nextEntity) {
        void $this$matchMatcher$iv;
        MobData.MobResult mobResult = this.noArmorStandMobs(baseEntity);
        if (mobResult != null) {
            MobData.MobResult it = mobResult;
            boolean bl = false;
            return it;
        }
        EntityArmorStand armorStand = nextEntity instanceof EntityArmorStand ? (EntityArmorStand)nextEntity : null;
        Object object = IslandExceptions.INSTANCE.islandSpecificExceptions$1_8_9(baseEntity, armorStand, nextEntity);
        if (object != null) {
            MobData.MobResult it = object;
            boolean bl = false;
            return it;
        }
        if (armorStand == null) {
            return null;
        }
        object = this.armorStandOnlyMobs(baseEntity, armorStand);
        if (object != null) {
            MobData.MobResult it = object;
            boolean bl = false;
            return it;
        }
        object = RegexUtils.INSTANCE;
        Pattern it = this.getJerryPattern();
        String text$iv = EntityUtils.INSTANCE.cleanName((Entity)armorStand);
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(text$iv);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$exceptions_u24lambda_u2428 = it$iv;
            boolean bl2 = false;
            String string = $this$exceptions_u24lambda_u2428.group("level");
            int level = string != null ? Integer.parseInt(string) : -1;
            String string2 = $this$exceptions_u24lambda_u2428.group("owner");
            if (string2 != null) {
                String owner = string2;
                String string3 = $this$exceptions_u24lambda_u2428.group("name");
                if (string3 != null) {
                    String name2 = string3;
                    return MobData.MobResult.Companion.found(new Mob(baseEntity, Mob.Type.BASIC, armorStand, name2, null, owner, false, null, level, null, 720, null));
                }
            }
        }
        return (baseEntity instanceof EntityPig || baseEntity instanceof EntityHorse) && RegexUtils.INSTANCE.matches(this.getIllegalEntitiesPattern(), armorStand.func_70005_c_()) ? MobData.MobResult.Companion.getIllegal() : (baseEntity instanceof EntityGuardian && new Regex("^\\d+").matches((CharSequence)(object = (CharSequence)EntityUtils.INSTANCE.cleanName((Entity)armorStand))) ? MobData.MobResult.Companion.getIllegal() : null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final MobData.MobResult stackedMobsException(EntityLivingBase baseEntity, List<? extends EntityLivingBase> extraEntityList) {
        if (DungeonApi.INSTANCE.inDungeon()) {
            if (!(baseEntity instanceof EntityEnderman)) {
                if (!(baseEntity instanceof EntityGiantZombie)) return null;
            }
        } else {
            if (WhenMappings.$EnumSwitchMapping$0[SkyBlockUtils.INSTANCE.getCurrentIsland().ordinal()] != 2) return null;
            return null;
        }
        EntityLivingBase entityLivingBase = CollectionsKt.lastOrNull(extraEntityList);
        if (!Intrinsics.areEqual(entityLivingBase != null ? entityLivingBase.func_70005_c_() : null, "\u00a7e\ufd3e \u00a7c\u00a7lLivid\u00a7r\u00a7r \u00a7a7M\u00a7c\u2764 \u00a7e\ufd3f")) return null;
        MobData.MobResult mobResult = MobData.MobResult.Companion.getIllegal();
        return mobResult;
    }

    private final MobData.MobResult armorStandOnlyMobs(EntityLivingBase baseEntity, EntityArmorStand armorStand) {
        Object object;
        if (!(baseEntity instanceof EntityZombie)) {
            return null;
        }
        if (RegexUtils.INSTANCE.matches(this.getIllegalEntitiesPattern(), armorStand.func_70005_c_())) {
            return MobData.MobResult.Companion.getIllegal();
        }
        if (EntityCompatKt.getFirstPassenger((Entity)baseEntity) instanceof EntityPlayer && ((object = MobUtils.INSTANCE.getArmorStand((Entity)baseEntity, 2)) != null ? EntityUtils.INSTANCE.wearingSkullTexture((EntityArmorStand)object, this.getRAT_SKULL_TEXTURE$1_8_9()) : false)) {
            return MobData.MobResult.Companion.getIllegal();
        }
        ItemStack itemStack = EntityCompatKt.getStandHelmet(armorStand);
        String string = object = itemStack != null ? ItemUtils.INSTANCE.getSkullTexture(itemStack) : null;
        if (Intrinsics.areEqual(object, this.getHELLWISP_TENTACLE_SKULL_TEXTURE())) {
            return MobData.MobResult.Companion.getIllegal();
        }
        if (Intrinsics.areEqual(object, this.getRIFT_EYE_SKULL1_TEXTURE())) {
            return MobData.MobResult.Companion.found(MobFactories.INSTANCE.special(baseEntity, "Rift Teleport Eye", armorStand));
        }
        if (Intrinsics.areEqual(object, this.getRIFT_EYE_SKULL2_TEXTURE())) {
            return MobData.MobResult.Companion.found(MobFactories.INSTANCE.special(baseEntity, "Rift Teleport Eye", armorStand));
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isFarmMob(@NotNull EntityLivingBase $this$isFarmMob) {
        Intrinsics.checkNotNullParameter($this$isFarmMob, "<this>");
        if (!($this$isFarmMob instanceof EntityAnimal)) return false;
        int it = ElectionApi.INSTANCE.derpy(EntityUtils.INSTANCE.getBaseMaxHealth($this$isFarmMob));
        boolean bl = false;
        if (it != 50 && it != 20) {
            if (it != 130) return false;
        }
        boolean bl2 = true;
        if (!bl2) return false;
        if (SkyBlockUtils.INSTANCE.getCurrentIsland() == IslandType.PRIVATE_ISLAND) return false;
        return true;
    }

    private final Mob createFarmMobs(EntityLivingBase baseEntity) {
        EntityLivingBase entityLivingBase = baseEntity;
        return entityLivingBase instanceof EntityMooshroom ? MobFactories.INSTANCE.basic(baseEntity, "Farm Mooshroom") : (entityLivingBase instanceof EntityCow ? MobFactories.INSTANCE.basic(baseEntity, "Farm Cow") : (entityLivingBase instanceof EntityPig ? MobFactories.INSTANCE.basic(baseEntity, "Farm Pig") : (entityLivingBase instanceof EntityChicken ? MobFactories.INSTANCE.basic(baseEntity, "Farm Chicken") : (entityLivingBase instanceof EntityRabbit ? MobFactories.INSTANCE.basic(baseEntity, "Farm Rabbit") : (entityLivingBase instanceof EntitySheep ? MobFactories.INSTANCE.basic(baseEntity, "Farm Sheep") : null)))));
    }

    private final MobData.MobResult createBat(EntityLivingBase baseEntity) {
        MobData.MobResult mobResult;
        switch (ElectionApi.INSTANCE.derpy(EntityUtils.INSTANCE.getBaseMaxHealth(baseEntity))) {
            case 5000000: {
                mobResult = MobData.MobResult.Companion.found(MobFactories.INSTANCE.basic(baseEntity, "Cinderbat"));
                break;
            }
            case 75000: {
                mobResult = MobData.MobResult.Companion.found(MobFactories.INSTANCE.basic(baseEntity, "Thorn Bat"));
                break;
            }
            case 600: {
                if (IslandType.GARDEN.isCurrent()) {
                    mobResult = null;
                    break;
                }
                mobResult = MobData.MobResult.Companion.getNotYetFound();
                break;
            }
            case 100: {
                mobResult = MobData.MobResult.Companion.found(MobFactories.INSTANCE.basic(baseEntity, DungeonApi.INSTANCE.inDungeon() ? "Dungeon Secret Bat" : (IslandType.PRIVATE_ISLAND.isCurrent() ? "Private Island Bat" : "Mega Bat")));
                break;
            }
            case 20: {
                mobResult = MobData.MobResult.Companion.found(MobFactories.INSTANCE.projectile(baseEntity, "Vampire Mask Bat"));
                break;
            }
            case 5: {
                mobResult = MobData.MobResult.Companion.found(MobFactories.special$default(MobFactories.INSTANCE, baseEntity, "Bat Pinata", null, 4, null));
                break;
            }
            default: {
                mobResult = MobData.MobResult.Companion.getNotYetFound();
            }
        }
        return mobResult;
    }

    @NotNull
    public final MobData.MobResult makeMobResult$1_8_9(@Nullable EntityArmorStand $this$makeMobResult, @NotNull Function1<? super EntityArmorStand, Mob> mob) {
        Object object;
        block7: {
            block4: {
                Object object2;
                block6: {
                    block5: {
                        Intrinsics.checkNotNullParameter(mob, "mob");
                        object = $this$makeMobResult;
                        if (object == null) break block4;
                        EntityArmorStand armor = object;
                        boolean bl = false;
                        object2 = mob.invoke((EntityArmorStand)armor);
                        if (object2 == null) break block5;
                        Mob it = object2;
                        boolean bl2 = false;
                        MobData.MobResult mobResult = MobData.MobResult.Companion.found(it);
                        object2 = mobResult;
                        if (mobResult != null) break block6;
                    }
                    object2 = MobData.MobResult.Companion.getSomethingWentWrong();
                }
                object = object2;
                if (object2 != null) break block7;
            }
            object = MobData.MobResult.Companion.getNotYetFound();
        }
        return object;
    }

    private static final String RAT_SKULL_TEXTURE_delegate$lambda$0() {
        return SkullTextureHolder.INSTANCE.getTexture("MOB_RAT");
    }

    private static final String HELLWISP_TENTACLE_SKULL_TEXTURE_delegate$lambda$1() {
        return SkullTextureHolder.INSTANCE.getTexture("HELLWISP_TENTACLE");
    }

    private static final String RIFT_EYE_SKULL1_TEXTURE_delegate$lambda$2() {
        return SkullTextureHolder.INSTANCE.getTexture("RIFT_EYE_1");
    }

    private static final String RIFT_EYE_SKULL2_TEXTURE_delegate$lambda$3() {
        return SkullTextureHolder.INSTANCE.getTexture("RIFT_EYE_2");
    }

    private static final String NPC_TURD_SKULL_delegate$lambda$4() {
        return SkullTextureHolder.INSTANCE.getTexture("NPC_TURD");
    }

    private static final EntityLivingBase createSkyblockEntity$lambda$11(EntityLivingBase it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Entity entity = MobUtils.INSTANCE.getNextEntity((Entity)it, 1);
        return entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean createSkyblockEntity$lambda$14(Ref.ObjectRef $caughtSkyblockMob, EntityLivingBase entity) {
        Mob mob;
        Intrinsics.checkNotNullParameter($caughtSkyblockMob, "$caughtSkyblockMob");
        Intrinsics.checkNotNullParameter(entity, "entity");
        if (entity instanceof EntityArmorStand) {
            if (!MobUtils.INSTANCE.isDefaultValue((EntityArmorStand)entity)) return false;
        }
        Mob mob2 = MobData.INSTANCE.getEntityToMob().get(entity);
        if (mob2 == null) return true;
        Mob it = mob = mob2;
        boolean bl = false;
        $caughtSkyblockMob.element = it;
        Mob $this$createSkyblockEntity_u24lambda_u2414_u24lambda_u2413 = mob;
        return false;
    }

    private static final Mob noArmorStandMobs$lambda$21(EntityLivingBase $baseEntity, List it) {
        Intrinsics.checkNotNullParameter($baseEntity, "$baseEntity");
        Intrinsics.checkNotNullParameter(it, "it");
        return MobFactories.boss$default(MobFactories.INSTANCE, $baseEntity, (EntityArmorStand)CollectionsKt.first(it), CollectionsKt.drop(it, 1), null, 8, null);
    }

    static {
        Object[] objectArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(MobFilter.class, "mobNameFilter", "getMobNameFilter()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(MobFilter.class, "slayerNameFilter", "getSlayerNameFilter()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(MobFilter.class, "bossMobNameFilter", "getBossMobNameFilter()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(MobFilter.class, "dungeonNameFilter", "getDungeonNameFilter()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(MobFilter.class, "summonFilter", "getSummonFilter()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(MobFilter.class, "dojoFilter", "getDojoFilter()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(MobFilter.class, "jerryPattern", "getJerryPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(MobFilter.class, "petCareNamePattern", "getPetCareNamePattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(MobFilter.class, "wokeSleepingGolemPattern", "getWokeSleepingGolemPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(MobFilter.class, "jerryMagmaCubePattern", "getJerryMagmaCubePattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(MobFilter.class, "summonOwnerPattern", "getSummonOwnerPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(MobFilter.class, "heavyPearlPattern", "getHeavyPearlPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(MobFilter.class, "shinyPig", "getShinyPig()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(MobFilter.class, "illegalEntitiesPattern", "getIllegalEntitiesPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(MobFilter.class, "displayNpcCompressedNamePattern", "getDisplayNpcCompressedNamePattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = objectArray;
        INSTANCE = new MobFilter();
        patternGroup = RepoPattern.Companion.group("mob.detection");
        mobType = "(?<mobType>[^\\w\\s\u272f\\-]+ )?";
        level = "(?:\\[Lv(?<level>\\d+)\\] )?";
        mobNameFilter$delegate = patternGroup.pattern("filter.basic", level + mobType + "(?<corrupted>.Corrupted )?(?<name>[^\u16e4]*)(?: \u16e4)? [\\dBMk.,\u2764]+");
        slayerNameFilter$delegate = patternGroup.pattern("filter.slayer", '^' + mobType + ". (?<name>.*)(?: (?<tier>[IV]+)|(?<=Atoned Horror|Conjoined Brood)) \\d+.*");
        bossMobNameFilter$delegate = patternGroup.pattern("filter.boss", "^. " + level + mobType + "(?<name>[^\u16e4\n]*?)(?: \u16e4)?(?: [\\d\\/BMk.,\u2764]+| \u2588+)? .$");
        dungeonNameFilter$delegate = patternGroup.pattern("filter.dungeon", '^' + level + mobType + "(?:(?<star>\u272f)\\s)?(?:(?<attribute>" + DungeonAttribute.Companion.getToRegexLine() + ")\\s)?(?:\\[[\\w\\d]+\\]\\s)?(?<name>[^\u16e4]+)(?: \u16e4)?\\s[^\\s]+$");
        summonFilter$delegate = patternGroup.pattern("filter.summon", "^(?<owner>\\w+)'s (?<name>.*) \\d+.*");
        dojoFilter$delegate = patternGroup.pattern("filter.dojo", "^(?:(?<points>\\d+) pts|(?<empty>\\w+))$");
        jerryPattern$delegate = patternGroup.pattern("jerry", "(?:\\[\\w+(?<level>\\d+)] )?\u2730\u26e8 (?:(?:a(?=a ))?(?<owner>\\w+)'s (?<name>\\w+ Jerrya?)) \\d+ Hits");
        petCareNamePattern$delegate = patternGroup.pattern("pattern.petcare", "^\\[\\w+ (?<level>\\d+)\\] (?<name>.*)");
        wokeSleepingGolemPattern$delegate = patternGroup.pattern("pattern.dungeon.woke.golem", "(?:\u00a7c\u00a7lWoke|\u00a75\u00a7lSleeping) Golem\u00a7r");
        jerryMagmaCubePattern$delegate = patternGroup.pattern("pattern.jerry.magma.cube", "\u00a7c(?:Cubie|Maggie|Cubert|C\u00fcbe|Cubette|Magmalene|Lucky 7|8ball|Mega Cube|Super Cube)(?: \u16e4)? \u00a7a\\d+\u00a78\\/\u00a7a\\d+\u00a7c\u2764");
        summonOwnerPattern$delegate = patternGroup.pattern("pattern.summon.owner", ".*Spawned by: (?<name>.*).*");
        heavyPearlPattern$delegate = patternGroup.pattern("pattern.heavypearl.collect", "\u00a7.\u00a7lCOLLECT!");
        shinyPig$delegate = patternGroup.pattern("pattern.shiny", "SHINY PIG");
        illegalEntitiesPattern$delegate = patternGroup.pattern("pattern.pet.entities", "^\u00a78\\[\u00a77Lv\\d+\u00a78] \u00a7.(?<name>Horse|Armadillo|Skeleton Horse|Pig|Rat)$");
        RAT_SKULL_TEXTURE$delegate = LazyKt.lazy(MobFilter::RAT_SKULL_TEXTURE_delegate$lambda$0);
        HELLWISP_TENTACLE_SKULL_TEXTURE$delegate = LazyKt.lazy(MobFilter::HELLWISP_TENTACLE_SKULL_TEXTURE_delegate$lambda$1);
        RIFT_EYE_SKULL1_TEXTURE$delegate = LazyKt.lazy(MobFilter::RIFT_EYE_SKULL1_TEXTURE_delegate$lambda$2);
        RIFT_EYE_SKULL2_TEXTURE$delegate = LazyKt.lazy(MobFilter::RIFT_EYE_SKULL2_TEXTURE_delegate$lambda$3);
        NPC_TURD_SKULL$delegate = LazyKt.lazy(MobFilter::NPC_TURD_SKULL_delegate$lambda$4);
        objectArray = new String[]{"Guy ", "vswiblxdxg", "anrrtqytsl"};
        extraDisplayNpcByName = SetsKt.setOf(objectArray);
        displayNpcCompressedNamePattern$delegate = patternGroup.pattern("displaynpc.name", "[a-z0-9]{10}");
        objectArray = new String[]{"\u00a7e\u00a7lCLICK", "\u00a76\u00a7lSEASONAL SKINS", "\u00a7e\u00a7lGATE KEEPER", "\u00a7e\u00a7lBLACKSMITH", "\u00a7e\u00a7lSHOP", "\u00a7e\u00a7lTREASURES", "\u00a7c\u00a7lQUEST", "\u00a7e\u00a7lQUEST"};
        listOfClickArmorStand = SetsKt.setOf(objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\r\b\u0086\u0081\u0002\u0018\u0000 \u00042\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lat/hannibal2/skyhanni/data/mob/MobFilter$DungeonAttribute;", "", "<init>", "(Ljava/lang/String;I)V", "Companion", "Flaming", "Stormy", "Speedy", "Fortified", "Healthy", "Healing", "Boomer", "Golden", "Stealth", "1.8.9"})
    public static final class DungeonAttribute
    extends Enum<DungeonAttribute> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private static final String toRegexLine;
        public static final /* enum */ DungeonAttribute Flaming;
        public static final /* enum */ DungeonAttribute Stormy;
        public static final /* enum */ DungeonAttribute Speedy;
        public static final /* enum */ DungeonAttribute Fortified;
        public static final /* enum */ DungeonAttribute Healthy;
        public static final /* enum */ DungeonAttribute Healing;
        public static final /* enum */ DungeonAttribute Boomer;
        public static final /* enum */ DungeonAttribute Golden;
        public static final /* enum */ DungeonAttribute Stealth;
        private static final /* synthetic */ DungeonAttribute[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static DungeonAttribute[] values() {
            return (DungeonAttribute[])$VALUES.clone();
        }

        public static DungeonAttribute valueOf(String value) {
            return Enum.valueOf(DungeonAttribute.class, value);
        }

        @NotNull
        public static EnumEntries<DungeonAttribute> getEntries() {
            return $ENTRIES;
        }

        private static final CharSequence toRegexLine$lambda$0(DungeonAttribute it) {
            Intrinsics.checkNotNullParameter((Object)it, "it");
            return it.name();
        }

        static {
            Flaming = new DungeonAttribute();
            Stormy = new DungeonAttribute();
            Speedy = new DungeonAttribute();
            Fortified = new DungeonAttribute();
            Healthy = new DungeonAttribute();
            Healing = new DungeonAttribute();
            Boomer = new DungeonAttribute();
            Golden = new DungeonAttribute();
            Stealth = new DungeonAttribute();
            $VALUES = dungeonAttributeArray = new DungeonAttribute[]{DungeonAttribute.Flaming, DungeonAttribute.Stormy, DungeonAttribute.Speedy, DungeonAttribute.Fortified, DungeonAttribute.Healthy, DungeonAttribute.Healing, DungeonAttribute.Boomer, DungeonAttribute.Golden, DungeonAttribute.Stealth};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            toRegexLine = CollectionsKt.joinToString$default(DungeonAttribute.getEntries(), "|", null, null, 0, null, DungeonAttribute::toRegexLine$lambda$0, 30, null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lat/hannibal2/skyhanni/data/mob/MobFilter$DungeonAttribute$Companion;", "", "<init>", "()V", "", "toRegexLine", "Ljava/lang/String;", "getToRegexLine", "()Ljava/lang/String;", "1.8.9"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final String getToRegexLine() {
                return toRegexLine;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IslandType.values().length];
            try {
                nArray[IslandType.CATACOMBS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IslandType.CRIMSON_ISLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

