/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.commons.net.ftp;

import at.hannibal2.skyhanni.deps.commons.net.ftp.DurationUtils;
import at.hannibal2.skyhanni.deps.commons.net.ftp.FTPClient;
import at.hannibal2.skyhanni.deps.commons.net.ftp.FTPCommand;
import at.hannibal2.skyhanni.deps.commons.net.ftp.FTPReply;
import at.hannibal2.skyhanni.deps.commons.net.ftp.FTPSServerSocketFactory;
import at.hannibal2.skyhanni.deps.commons.net.ftp.FTPSSocketFactory;
import at.hannibal2.skyhanni.deps.commons.net.util.SSLContextUtils;
import at.hannibal2.skyhanni.deps.commons.net.util.SSLSocketUtils;
import at.hannibal2.skyhanni.deps.commons.net.util.TrustManagerUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Base64;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class FTPSClient
extends FTPClient {
    public static final int DEFAULT_FTPS_DATA_PORT = 989;
    public static final int DEFAULT_FTPS_PORT = 990;
    private static final String[] PROT_COMMAND_VALUE = new String[]{"C", "E", "S", "P"};
    private static final String DEFAULT_PROT = "C";
    private static final String DEFAULT_PROTOCOL = "TLS";
    private static final String CMD_AUTH = "AUTH";
    private static final String CMD_ADAT = "ADAT";
    private static final String CMD_PROT = "PROT";
    private static final String CMD_PBSZ = "PBSZ";
    private static final String CMD_MIC = "MIC";
    private static final String CMD_CONF = "CONF";
    private static final String CMD_ENC = "ENC";
    private static final String CMD_CCC = "CCC";
    @Deprecated
    public static String KEYSTORE_ALGORITHM;
    @Deprecated
    public static String TRUSTSTORE_ALGORITHM;
    @Deprecated
    public static String PROVIDER;
    @Deprecated
    public static String STORE_TYPE;
    private final boolean isImplicit;
    private final String protocol;
    private String auth = "TLS";
    private SSLContext context;
    private Socket plainSocket;
    private boolean isCreation = true;
    private boolean isClientMode = true;
    private boolean isNeedClientAuth;
    private boolean isWantClientAuth;
    private String[] suites;
    private String[] protocols;
    private TrustManager trustManager = TrustManagerUtils.getValidateServerCertificateTrustManager();
    private KeyManager keyManager;
    private HostnameVerifier hostnameVerifier;
    private boolean tlsEndpointChecking;

    public FTPSClient() {
        this(DEFAULT_PROTOCOL, false);
    }

    public FTPSClient(boolean isImplicit) {
        this(DEFAULT_PROTOCOL, isImplicit);
    }

    public FTPSClient(boolean isImplicit, SSLContext context2) {
        this(DEFAULT_PROTOCOL, isImplicit);
        this.context = context2;
    }

    public FTPSClient(SSLContext context2) {
        this(false, context2);
    }

    public FTPSClient(String protocol) {
        this(protocol, false);
    }

    public FTPSClient(String protocol, boolean isImplicit) {
        this.protocol = protocol;
        this.isImplicit = isImplicit;
        if (isImplicit) {
            this.setDefaultPort(990);
        }
    }

    @Override
    protected void _connectAction_() throws IOException {
        if (this.isImplicit) {
            this.applySocketAttributes();
            this.sslNegotiation();
        }
        super._connectAction_();
        if (!this.isImplicit) {
            this.execAUTH();
            this.sslNegotiation();
        }
    }

    @Override
    @Deprecated
    protected Socket _openDataConnection_(int command2, String arg2) throws IOException {
        return this._openDataConnection_(FTPCommand.getCommand(command2), arg2);
    }

    @Override
    protected Socket _openDataConnection_(String command2, String arg2) throws IOException {
        Socket socket = this.openDataSecureConnection(command2, arg2);
        this._prepareDataSocket_(socket);
        if (socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            sslSocket.setUseClientMode(this.isClientMode);
            sslSocket.setEnableSessionCreation(this.isCreation);
            if (!this.isClientMode) {
                sslSocket.setNeedClientAuth(this.isNeedClientAuth);
                sslSocket.setWantClientAuth(this.isWantClientAuth);
            }
            if (this.suites != null) {
                sslSocket.setEnabledCipherSuites(this.suites);
            }
            if (this.protocols != null) {
                sslSocket.setEnabledProtocols(this.protocols);
            }
            sslSocket.startHandshake();
        }
        return socket;
    }

    protected void _prepareDataSocket_(Socket socket) throws IOException {
    }

    private boolean checkPROTValue(String prot) {
        for (String element : PROT_COMMAND_VALUE) {
            if (!element.equals(prot)) continue;
            return true;
        }
        return false;
    }

    private void closeSockets(Socket socket, Socket sslSocket) throws IOException {
        if (socket != null) {
            socket.close();
        }
        if (sslSocket != null) {
            sslSocket.close();
        }
    }

    private SSLSocket createSSLSocket(Socket socket) throws IOException {
        if (socket != null) {
            SSLSocketFactory f = this.context.getSocketFactory();
            return (SSLSocket)f.createSocket(socket, this._hostname_, socket.getPort(), false);
        }
        return null;
    }

    @Override
    public void disconnect() throws IOException {
        super.disconnect();
        if (this.plainSocket != null) {
            this.plainSocket.close();
        }
        this.setSocketFactory(null);
        this.setServerSocketFactory(null);
    }

    public int execADAT(byte[] data2) throws IOException {
        if (data2 != null) {
            return this.sendCommand(CMD_ADAT, Base64.getEncoder().encodeToString(data2));
        }
        return this.sendCommand(CMD_ADAT);
    }

    protected void execAUTH() throws SSLException, IOException {
        int replyCode = this.sendCommand(CMD_AUTH, this.auth);
        if (334 != replyCode && 234 != replyCode) {
            throw new SSLException(this.getReplyString());
        }
    }

    public int execAUTH(String mechanism) throws IOException {
        return this.sendCommand(CMD_AUTH, mechanism);
    }

    public int execCCC() throws IOException {
        return this.sendCommand(CMD_CCC);
    }

    public int execCONF(byte[] data2) throws IOException {
        if (data2 != null) {
            return this.sendCommand(CMD_CONF, Base64.getEncoder().encodeToString(data2));
        }
        return this.sendCommand(CMD_CONF, "");
    }

    public int execENC(byte[] data2) throws IOException {
        if (data2 != null) {
            return this.sendCommand(CMD_ENC, Base64.getEncoder().encodeToString(data2));
        }
        return this.sendCommand(CMD_ENC, "");
    }

    public int execMIC(byte[] data2) throws IOException {
        if (data2 != null) {
            return this.sendCommand(CMD_MIC, Base64.getEncoder().encodeToString(data2));
        }
        return this.sendCommand(CMD_MIC, "");
    }

    public void execPBSZ(long pbsz) throws SSLException, IOException {
        if (pbsz < 0L || 0xFFFFFFFFL < pbsz) {
            throw new IllegalArgumentException();
        }
        int status = this.sendCommand(CMD_PBSZ, String.valueOf(pbsz));
        if (200 != status) {
            throw new SSLException(this.getReplyString());
        }
    }

    public void execPROT(String prot) throws SSLException, IOException {
        if (prot == null) {
            prot = DEFAULT_PROT;
        }
        if (!this.checkPROTValue(prot)) {
            throw new IllegalArgumentException();
        }
        if (200 != this.sendCommand(CMD_PROT, prot)) {
            throw new SSLException(this.getReplyString());
        }
        if (DEFAULT_PROT.equals(prot)) {
            this.setSocketFactory(null);
            this.setServerSocketFactory(null);
        } else {
            this.setSocketFactory(new FTPSSocketFactory(this.context));
            this.setServerSocketFactory(new FTPSServerSocketFactory(this.context));
            this.initSslContext();
        }
    }

    private String extractPrefixedData(String prefix, String reply) {
        int idx = reply.indexOf(prefix);
        if (idx == -1) {
            return null;
        }
        return reply.substring(idx + prefix.length()).trim();
    }

    public String getAuthValue() {
        return this.auth;
    }

    public String[] getEnabledCipherSuites() {
        if (this._socket_ instanceof SSLSocket) {
            return ((SSLSocket)this._socket_).getEnabledCipherSuites();
        }
        return null;
    }

    public String[] getEnabledProtocols() {
        if (this._socket_ instanceof SSLSocket) {
            return ((SSLSocket)this._socket_).getEnabledProtocols();
        }
        return null;
    }

    public boolean getEnableSessionCreation() {
        if (this._socket_ instanceof SSLSocket) {
            return ((SSLSocket)this._socket_).getEnableSessionCreation();
        }
        return false;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    private KeyManager getKeyManager() {
        return this.keyManager;
    }

    public boolean getNeedClientAuth() {
        if (this._socket_ instanceof SSLSocket) {
            return ((SSLSocket)this._socket_).getNeedClientAuth();
        }
        return false;
    }

    protected String getProtocol() {
        return this.protocol;
    }

    protected String[] getProtocols() {
        return this.protocols == null ? null : (String[])this.protocols.clone();
    }

    protected String[] getSuites() {
        return this.suites == null ? null : (String[])this.suites.clone();
    }

    public TrustManager getTrustManager() {
        return this.trustManager;
    }

    public boolean getUseClientMode() {
        if (this._socket_ instanceof SSLSocket) {
            return ((SSLSocket)this._socket_).getUseClientMode();
        }
        return false;
    }

    public boolean getWantClientAuth() {
        if (this._socket_ instanceof SSLSocket) {
            return ((SSLSocket)this._socket_).getWantClientAuth();
        }
        return false;
    }

    private void initSslContext() throws IOException {
        if (this.context == null) {
            this.context = SSLContextUtils.createSSLContext(this.protocol, this.getKeyManager(), this.getTrustManager());
        }
    }

    protected boolean isClientMode() {
        return this.isClientMode;
    }

    protected boolean isCreation() {
        return this.isCreation;
    }

    public boolean isEndpointCheckingEnabled() {
        return this.tlsEndpointChecking;
    }

    protected boolean isImplicit() {
        return this.isImplicit;
    }

    protected boolean isNeedClientAuth() {
        return this.isNeedClientAuth;
    }

    protected boolean isWantClientAuth() {
        return this.isWantClientAuth;
    }

    /*
     * Unable to fully structure code
     */
    private Socket openDataSecureConnection(String command, String arg) throws IOException {
        if (this.getDataConnectionMode() != 0 && this.getDataConnectionMode() != 2) {
            return null;
        }
        isInet6Address = this.getRemoteAddress() instanceof Inet6Address;
        sslSocket = null;
        soTimeoutMillis = DurationUtils.toMillisInt(this.getDataTimeout());
        if (this.getDataConnectionMode() == 0) {
            server = this._serverSocketFactory_.createServerSocket(this.getActivePort(), 1, this.getHostAddress());
            try {
                if (isInet6Address) {
                    if (!FTPReply.isPositiveCompletion(this.eprt(this.getReportHostAddress(), server.getLocalPort()))) {
                        var8_9 = null;
                        return var8_9;
                    }
                } else if (!FTPReply.isPositiveCompletion(this.port(this.getReportHostAddress(), server.getLocalPort()))) {
                    var8_10 = null;
                    return var8_10;
                }
                if (this.getRestartOffset() > 0L && !this.restart(this.getRestartOffset())) {
                    var8_11 = null;
                    return var8_11;
                }
                if (!FTPReply.isPositivePreliminary(this.sendCommand(command, arg))) {
                    var8_12 = null;
                    return var8_12;
                }
                if (soTimeoutMillis >= 0) {
                    server.setSoTimeout(soTimeoutMillis);
                }
                socket = server.accept();
                if (soTimeoutMillis >= 0) {
                    socket.setSoTimeout(soTimeoutMillis);
                }
                if (this.getReceiveDataSocketBufferSize() > 0) {
                    socket.setReceiveBufferSize(this.getReceiveDataSocketBufferSize());
                }
                if (this.getSendDataSocketBufferSize() <= 0) ** GOTO lbl64
                socket.setSendBufferSize(this.getSendDataSocketBufferSize());
            }
            finally {
                if (server != null) {
                    server.close();
                }
            }
        } else {
            v0 = attemptEPSV = this.isUseEPSVwithIPv4() != false || isInet6Address != false;
            if (attemptEPSV && this.epsv() == 229) {
                this._parseExtendedPassiveModeReply((String)this._replyLines.get(0));
            } else {
                if (isInet6Address) {
                    return null;
                }
                if (this.pasv() != 227) {
                    return null;
                }
                this._parsePassiveModeReply((String)this._replyLines.get(0));
            }
            socket = this.getProxy() != null ? new Socket(this.getProxy()) : this._socketFactory_.createSocket();
            if (this.getReceiveDataSocketBufferSize() > 0) {
                socket.setReceiveBufferSize(this.getReceiveDataSocketBufferSize());
            }
            if (this.getSendDataSocketBufferSize() > 0) {
                socket.setSendBufferSize(this.getSendDataSocketBufferSize());
            }
            if (this.getPassiveLocalIPAddress() != null) {
                socket.bind(new InetSocketAddress(this.getPassiveLocalIPAddress(), 0));
            }
            if (soTimeoutMillis >= 0) {
                socket.setSoTimeout(soTimeoutMillis);
            }
            socket.connect(new InetSocketAddress(this.getPassiveHost(), this.getPassivePort()), this.connectTimeout);
            if (this.getProxy() != null) {
                sslSocket = this.context.getSocketFactory().createSocket(socket, this.getPassiveHost(), this.getPassivePort(), true);
            }
            if (this.getRestartOffset() > 0L && !this.restart(this.getRestartOffset())) {
                this.closeSockets(socket, sslSocket);
                return null;
            }
            if (!FTPReply.isPositivePreliminary(this.sendCommand(command, arg))) {
                this.closeSockets(socket, sslSocket);
                return null;
            }
        }
lbl64:
        // 4 sources

        if (this.isRemoteVerificationEnabled() && !this.verifyRemote(socket)) {
            socketHost = socket.getInetAddress();
            this.closeSockets(socket, sslSocket);
            throw new IOException("Host attempting data connection " + socketHost.getHostAddress() + " is not same as server " + this.getRemoteAddress().getHostAddress());
        }
        return this.getProxy() != null ? sslSocket : socket;
    }

    public byte[] parseADATReply(String reply) {
        if (reply == null) {
            return null;
        }
        return Base64.getDecoder().decode(this.extractPrefixedData("ADAT=", reply));
    }

    public long parsePBSZ(long pbsz) throws SSLException, IOException {
        long replysz;
        this.execPBSZ(pbsz);
        long minvalue = pbsz;
        String remainder = this.extractPrefixedData("PBSZ=", this.getReplyString());
        if (remainder != null && (replysz = Long.parseLong(remainder)) < minvalue) {
            minvalue = replysz;
        }
        return minvalue;
    }

    @Override
    public int sendCommand(String command2, String args2) throws IOException {
        int repCode = super.sendCommand(command2, args2);
        if (CMD_CCC.equals(command2)) {
            if (200 != repCode) {
                throw new SSLException(this.getReplyString());
            }
            this._socket_.close();
            this._socket_ = this.plainSocket;
            this._controlInput_ = new BufferedReader(new InputStreamReader(this._socket_.getInputStream(), this.getControlEncoding()));
            this._controlOutput_ = new BufferedWriter(new OutputStreamWriter(this._socket_.getOutputStream(), this.getControlEncoding()));
        }
        return repCode;
    }

    public void setAuthValue(String auth) {
        this.auth = auth;
    }

    public void setEnabledCipherSuites(String[] cipherSuites) {
        this.suites = (String[])cipherSuites.clone();
    }

    public void setEnabledProtocols(String[] protocolVersions) {
        this.protocols = (String[])protocolVersions.clone();
    }

    public void setEnabledSessionCreation(boolean isCreation) {
        this.isCreation = isCreation;
    }

    public void setEndpointCheckingEnabled(boolean enable) {
        this.tlsEndpointChecking = enable;
    }

    public void setHostnameVerifier(HostnameVerifier newHostnameVerifier) {
        this.hostnameVerifier = newHostnameVerifier;
    }

    public void setKeyManager(KeyManager keyManager) {
        this.keyManager = keyManager;
    }

    public void setNeedClientAuth(boolean isNeedClientAuth) {
        this.isNeedClientAuth = isNeedClientAuth;
    }

    public void setTrustManager(TrustManager trustManager) {
        this.trustManager = trustManager;
    }

    public void setUseClientMode(boolean isClientMode) {
        this.isClientMode = isClientMode;
    }

    public void setWantClientAuth(boolean isWantClientAuth) {
        this.isWantClientAuth = isWantClientAuth;
    }

    protected void sslNegotiation() throws IOException {
        this.plainSocket = this._socket_;
        this.initSslContext();
        SSLSocket socket = this.createSSLSocket(this._socket_);
        socket.setEnableSessionCreation(this.isCreation);
        socket.setUseClientMode(this.isClientMode);
        if (this.isClientMode) {
            if (this.tlsEndpointChecking) {
                SSLSocketUtils.enableEndpointNameVerification(socket);
            }
        } else {
            socket.setNeedClientAuth(this.isNeedClientAuth);
            socket.setWantClientAuth(this.isWantClientAuth);
        }
        if (this.protocols != null) {
            socket.setEnabledProtocols(this.protocols);
        }
        if (this.suites != null) {
            socket.setEnabledCipherSuites(this.suites);
        }
        socket.startHandshake();
        this._socket_ = socket;
        this._controlInput_ = new BufferedReader(new InputStreamReader(socket.getInputStream(), this.getControlEncoding()));
        this._controlOutput_ = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), this.getControlEncoding()));
        if (this.isClientMode && this.hostnameVerifier != null && !this.hostnameVerifier.verify(this._hostname_, socket.getSession())) {
            throw new SSLHandshakeException("Hostname doesn't match certificate");
        }
    }
}

