/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.dungeon;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.dungeon.ObjectHiderConfig;
import at.hannibal2.skyhanni.data.EntityMovementData;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.events.CheckRenderEntityEvent;
import at.hannibal2.skyhanni.events.ReceiveParticleEvent;
import at.hannibal2.skyhanni.events.entity.EntityMoveEvent;
import at.hannibal2.skyhanni.mixins.hooks.RenderLivingEntityHelper;
import at.hannibal2.skyhanni.utils.ColorUtils;
import at.hannibal2.skyhanni.utils.EntityUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.LorenzVecKt;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SkullTextureHolder;
import at.hannibal2.skyhanni.utils.compat.EntityCompatKt;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u001b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\r\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001d\u0010\u0013\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0003J\u0017\u0010\u0019\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0018H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001e\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR \u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020 0\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R \u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020 0\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010\"R\u001b\u0010)\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(R\u001b\u0010,\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010&\u001a\u0004\b+\u0010(R\u001b\u0010/\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010&\u001a\u0004\b.\u0010(R\u001b\u00102\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u0010&\u001a\u0004\b1\u0010(R\u001b\u00105\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b3\u0010&\u001a\u0004\b4\u0010(R\u001b\u00108\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b6\u0010&\u001a\u0004\b7\u0010(R\u001b\u0010;\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b9\u0010&\u001a\u0004\b:\u0010(R\u001b\u0010>\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b<\u0010&\u001a\u0004\b=\u0010(\u00a8\u0006?"}, d2={"Lat/hannibal2/skyhanni/features/dungeon/DungeonHideItems;", "", "<init>", "()V", "Lnet/minecraft/entity/item/EntityArmorStand;", "entity", "", "isSkeletonSkull", "(Lnet/minecraft/entity/item/EntityArmorStand;)Z", "Lat/hannibal2/skyhanni/events/CheckRenderEntityEvent;", "Lnet/minecraft/entity/Entity;", "event", "", "onCheckRender", "(Lat/hannibal2/skyhanni/events/CheckRenderEntityEvent;)V", "Lat/hannibal2/skyhanni/events/ReceiveParticleEvent;", "onReceiveParticle", "(Lat/hannibal2/skyhanni/events/ReceiveParticleEvent;)V", "Lat/hannibal2/skyhanni/events/entity/EntityMoveEvent;", "onArmoStandMove", "(Lat/hannibal2/skyhanni/events/entity/EntityMoveEvent;)V", "shouldColorMovingSkull", "(Lnet/minecraft/entity/Entity;)Z", "onWorldChange", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/config/features/dungeon/ObjectHiderConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/dungeon/ObjectHiderConfig;", "config", "", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "hideParticles", "Ljava/util/Map;", "movingSkeletonSkulls", "", "SOUL_WEAVER_HIDER$delegate", "Lkotlin/Lazy;", "getSOUL_WEAVER_HIDER", "()Ljava/lang/String;", "SOUL_WEAVER_HIDER", "BLESSING_TEXTURE$delegate", "getBLESSING_TEXTURE", "BLESSING_TEXTURE", "REVIVE_STONE_TEXTURE$delegate", "getREVIVE_STONE_TEXTURE", "REVIVE_STONE_TEXTURE", "PREMIUM_FLESH_TEXTURE$delegate", "getPREMIUM_FLESH_TEXTURE", "PREMIUM_FLESH_TEXTURE", "ABILITY_ORB_TEXTURE$delegate", "getABILITY_ORB_TEXTURE", "ABILITY_ORB_TEXTURE", "SUPPORT_ORB_TEXTURE$delegate", "getSUPPORT_ORB_TEXTURE", "SUPPORT_ORB_TEXTURE", "DAMAGE_ORB_TEXTURE$delegate", "getDAMAGE_ORB_TEXTURE", "DAMAGE_ORB_TEXTURE", "HEALER_FAIRY_TEXTURE$delegate", "getHEALER_FAIRY_TEXTURE", "HEALER_FAIRY_TEXTURE", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nDungeonHideItems.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DungeonHideItems.kt\nat/hannibal2/skyhanni/features/dungeon/DungeonHideItems\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,207:1\n503#2,7:208\n*S KotlinDebug\n*F\n+ 1 DungeonHideItems.kt\nat/hannibal2/skyhanni/features/dungeon/DungeonHideItems\n*L\n157#1:208,7\n*E\n"})
public final class DungeonHideItems {
    @NotNull
    public static final DungeonHideItems INSTANCE = new DungeonHideItems();
    @NotNull
    private static final Map<EntityArmorStand, SimpleTimeMark> hideParticles = new LinkedHashMap();
    @NotNull
    private static final Map<EntityArmorStand, SimpleTimeMark> movingSkeletonSkulls = new LinkedHashMap();
    @NotNull
    private static final Lazy SOUL_WEAVER_HIDER$delegate = LazyKt.lazy(DungeonHideItems::SOUL_WEAVER_HIDER_delegate$lambda$0);
    @NotNull
    private static final Lazy BLESSING_TEXTURE$delegate = LazyKt.lazy(DungeonHideItems::BLESSING_TEXTURE_delegate$lambda$1);
    @NotNull
    private static final Lazy REVIVE_STONE_TEXTURE$delegate = LazyKt.lazy(DungeonHideItems::REVIVE_STONE_TEXTURE_delegate$lambda$2);
    @NotNull
    private static final Lazy PREMIUM_FLESH_TEXTURE$delegate = LazyKt.lazy(DungeonHideItems::PREMIUM_FLESH_TEXTURE_delegate$lambda$3);
    @NotNull
    private static final Lazy ABILITY_ORB_TEXTURE$delegate = LazyKt.lazy(DungeonHideItems::ABILITY_ORB_TEXTURE_delegate$lambda$4);
    @NotNull
    private static final Lazy SUPPORT_ORB_TEXTURE$delegate = LazyKt.lazy(DungeonHideItems::SUPPORT_ORB_TEXTURE_delegate$lambda$5);
    @NotNull
    private static final Lazy DAMAGE_ORB_TEXTURE$delegate = LazyKt.lazy(DungeonHideItems::DAMAGE_ORB_TEXTURE_delegate$lambda$6);
    @NotNull
    private static final Lazy HEALER_FAIRY_TEXTURE$delegate = LazyKt.lazy(DungeonHideItems::HEALER_FAIRY_TEXTURE_delegate$lambda$7);

    private DungeonHideItems() {
    }

    private final ObjectHiderConfig getConfig() {
        return SkyHanniMod.feature.getDungeon().getObjectHider();
    }

    private final String getSOUL_WEAVER_HIDER() {
        Lazy lazy = SOUL_WEAVER_HIDER$delegate;
        return (String)lazy.getValue();
    }

    private final String getBLESSING_TEXTURE() {
        Lazy lazy = BLESSING_TEXTURE$delegate;
        return (String)lazy.getValue();
    }

    private final String getREVIVE_STONE_TEXTURE() {
        Lazy lazy = REVIVE_STONE_TEXTURE$delegate;
        return (String)lazy.getValue();
    }

    private final String getPREMIUM_FLESH_TEXTURE() {
        Lazy lazy = PREMIUM_FLESH_TEXTURE$delegate;
        return (String)lazy.getValue();
    }

    private final String getABILITY_ORB_TEXTURE() {
        Lazy lazy = ABILITY_ORB_TEXTURE$delegate;
        return (String)lazy.getValue();
    }

    private final String getSUPPORT_ORB_TEXTURE() {
        Lazy lazy = SUPPORT_ORB_TEXTURE$delegate;
        return (String)lazy.getValue();
    }

    private final String getDAMAGE_ORB_TEXTURE() {
        Lazy lazy = DAMAGE_ORB_TEXTURE$delegate;
        return (String)lazy.getValue();
    }

    private final String getHEALER_FAIRY_TEXTURE() {
        Lazy lazy = HEALER_FAIRY_TEXTURE$delegate;
        return (String)lazy.getValue();
    }

    private final boolean isSkeletonSkull(EntityArmorStand entity) {
        ItemStack itemStack = EntityCompatKt.getStandHelmet(entity);
        return Intrinsics.areEqual(itemStack != null ? ItemUtils.INSTANCE.cleanName(itemStack) : null, "Skeleton Skull");
    }

    @HandleEvent(onlyOnIsland=IslandType.CATACOMBS)
    public final void onCheckRender(@NotNull CheckRenderEntityEvent<Entity> event) {
        String skullTexture;
        ItemStack head;
        Intrinsics.checkNotNullParameter(event, "event");
        Entity entity = event.getEntity();
        if (entity instanceof EntityItem) {
            ItemStack stack = ((EntityItem)entity).func_92059_d();
            if (this.getConfig().getHideReviveStone()) {
                Intrinsics.checkNotNull(stack);
                if (Intrinsics.areEqual(ItemUtils.INSTANCE.cleanName(stack), "Revive Stone")) {
                    event.cancel();
                }
            }
            if (this.getConfig().getHideJournalEntry()) {
                Intrinsics.checkNotNull(stack);
                if (Intrinsics.areEqual(ItemUtils.INSTANCE.cleanName(stack), "Journal Entry")) {
                    event.cancel();
                }
            }
        }
        if (!(entity instanceof EntityArmorStand)) {
            return;
        }
        ItemStack itemStack = head = EntityCompatKt.getStandHelmet((EntityArmorStand)entity);
        String string = skullTexture = itemStack != null ? ItemUtils.INSTANCE.getSkullTexture(itemStack) : null;
        if (this.getConfig().getHideSuperboomTNT()) {
            String string2 = ((EntityArmorStand)entity).func_70005_c_();
            Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
            if (StringsKt.startsWith$default(string2, "\u00a79Superboom TNT", false, 2, null)) {
                event.cancel();
            }
            if (head != null && Intrinsics.areEqual(ItemUtils.INSTANCE.cleanName(head), "Superboom TNT")) {
                event.cancel();
                hideParticles.put((EntityArmorStand)entity, SimpleTimeMark.box-impl(SimpleTimeMark.Companion.now-uFjCsEo()));
            }
        }
        if (this.getConfig().getHideBlessing()) {
            String string3 = ((EntityArmorStand)entity).func_70005_c_();
            Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
            if (StringsKt.startsWith$default(string3, "\u00a7dBlessing of ", false, 2, null)) {
                event.cancel();
            }
            if (Intrinsics.areEqual(skullTexture, this.getBLESSING_TEXTURE())) {
                event.cancel();
            }
        }
        if (this.getConfig().getHideReviveStone()) {
            if (Intrinsics.areEqual(((EntityArmorStand)entity).func_70005_c_(), "\u00a76Revive Stone")) {
                event.cancel();
            }
            if (Intrinsics.areEqual(skullTexture, this.getREVIVE_STONE_TEXTURE())) {
                event.cancel();
                hideParticles.put((EntityArmorStand)entity, SimpleTimeMark.box-impl(SimpleTimeMark.Companion.now-uFjCsEo()));
            }
        }
        if (this.getConfig().getHidePremiumFlesh()) {
            if (Intrinsics.areEqual(((EntityArmorStand)entity).func_70005_c_(), "\u00a79Premium Flesh")) {
                event.cancel();
                hideParticles.put((EntityArmorStand)entity, SimpleTimeMark.box-impl(SimpleTimeMark.Companion.now-uFjCsEo()));
            }
            if (Intrinsics.areEqual(skullTexture, this.getPREMIUM_FLESH_TEXTURE())) {
                event.cancel();
            }
        }
        if (this.isSkeletonSkull((EntityArmorStand)entity)) {
            EntityMovementData.INSTANCE.addToTrack((EntityLivingBase)entity);
            if (this.getConfig().getHideSkeletonSkull()) {
                SimpleTimeMark simpleTimeMark = movingSkeletonSkulls.get(entity);
                long lastMove = simpleTimeMark != null ? simpleTimeMark.unbox-impl() : SimpleTimeMark.Companion.farPast();
                if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastMove), DurationKt.toDuration(100, DurationUnit.MILLISECONDS)) < 0) {
                    return;
                }
                event.cancel();
            }
        }
        if (this.getConfig().getHideHealerOrbs()) {
            String string4 = ((EntityArmorStand)entity).func_70005_c_();
            Intrinsics.checkNotNullExpressionValue(string4, "getName(...)");
            if (StringsKt.startsWith$default(string4, "\u00a7c\u00a7lDAMAGE \u00a7e", false, 2, null)) {
                event.cancel();
            } else {
                String string5 = ((EntityArmorStand)entity).func_70005_c_();
                Intrinsics.checkNotNullExpressionValue(string5, "getName(...)");
                if (StringsKt.startsWith$default(string5, "\u00a7c\u00a7lABILITY DAMAGE \u00a7e", false, 2, null)) {
                    event.cancel();
                } else {
                    String string6 = ((EntityArmorStand)entity).func_70005_c_();
                    Intrinsics.checkNotNullExpressionValue(string6, "getName(...)");
                    if (StringsKt.startsWith$default(string6, "\u00a7a\u00a7lDEFENSE \u00a7e", false, 2, null)) {
                        event.cancel();
                    }
                }
            }
            String string7 = skullTexture;
            if (Intrinsics.areEqual(string7, this.getABILITY_ORB_TEXTURE()) || Intrinsics.areEqual(string7, this.getSUPPORT_ORB_TEXTURE()) || Intrinsics.areEqual(string7, this.getDAMAGE_ORB_TEXTURE())) {
                event.cancel();
                hideParticles.put((EntityArmorStand)entity, SimpleTimeMark.box-impl(SimpleTimeMark.Companion.now-uFjCsEo()));
                return;
            }
        }
        if (this.getConfig().getHideHealerFairy() && EntityUtils.INSTANCE.holdingSkullTexture((EntityArmorStand)entity, this.getHEALER_FAIRY_TEXTURE())) {
            event.cancel();
            return;
        }
        if (this.getConfig().getHideSoulweaverSkulls() && Intrinsics.areEqual(skullTexture, this.getSOUL_WEAVER_HIDER())) {
            event.cancel();
            return;
        }
    }

    @HandleEvent(onlyOnIsland=IslandType.CATACOMBS)
    public final void onReceiveParticle(@NotNull ReceiveParticleEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.getConfig().getHideSuperboomTNT() && !this.getConfig().getHideReviveStone()) {
            return;
        }
        LorenzVec packetLocation = event.getLocation();
        Map<EntityArmorStand, SimpleTimeMark> $this$filterValues$iv = hideParticles;
        boolean $i$f$filterValues = false;
        LinkedHashMap<EntityArmorStand, SimpleTimeMark> result$iv = new LinkedHashMap<EntityArmorStand, SimpleTimeMark>();
        for (Map.Entry<EntityArmorStand, SimpleTimeMark> entry$iv : $this$filterValues$iv.entrySet()) {
            long it = entry$iv.getValue().unbox-impl();
            boolean bl = false;
            if (!(Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(it), DurationKt.toDuration(100, DurationUnit.MILLISECONDS)) < 0)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        for (EntityArmorStand armorStand : ((Map)result$iv).keySet()) {
            double distance = packetLocation.distance(LorenzVecKt.getLorenzVec((Entity)armorStand));
            if (!(distance < 2.0)) continue;
            if (event.getType() == EnumParticleTypes.FIREWORKS_SPARK) {
                event.cancel();
            }
            if (event.getType() != EnumParticleTypes.REDSTONE) continue;
            event.cancel();
        }
    }

    @HandleEvent(onlyOnIsland=IslandType.CATACOMBS)
    public final void onArmoStandMove(@NotNull EntityMoveEvent<EntityArmorStand> event) {
        Intrinsics.checkNotNullParameter(event, "event");
        EntityArmorStand entity = event.getEntity();
        if (this.isSkeletonSkull(entity)) {
            movingSkeletonSkulls.put(entity, SimpleTimeMark.box-impl(SimpleTimeMark.Companion.now-uFjCsEo()));
            RenderLivingEntityHelper.INSTANCE.setEntityColorWithNoHurtTime((EntityLivingBase)entity, ColorUtils.INSTANCE.addAlpha(LorenzColor.GOLD.toColor(), 60), () -> DungeonHideItems.onArmoStandMove$lambda$9(entity));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldColorMovingSkull(Entity entity) {
        if (!SkyHanniMod.feature.getDungeon().getHighlightSkeletonSkull()) return false;
        SimpleTimeMark simpleTimeMark = movingSkeletonSkulls.get(entity);
        if (simpleTimeMark == null) return false;
        long it = simpleTimeMark.unbox-impl();
        boolean bl = false;
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(it), DurationKt.toDuration(200, DurationUnit.MILLISECONDS)) >= 0) return false;
        return true;
    }

    @HandleEvent
    public final void onWorldChange() {
        hideParticles.clear();
        movingSkeletonSkulls.clear();
    }

    @HandleEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "dungeon.hideSuperboomTNT", "dungeon.objectHider.hideSuperboomTNT", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "dungeon.hideBlessing", "dungeon.objectHider.hideBlessing", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "dungeon.hideReviveStone", "dungeon.objectHider.hideReviveStone", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "dungeon.hidePremiumFlesh", "dungeon.objectHider.hidePremiumFlesh", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "dungeon.hideJournalEntry", "dungeon.objectHider.hideJournalEntry", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "dungeon.hideSkeletonSkull", "dungeon.objectHider.hideSkeletonSkull", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "dungeon.hideHealerOrbs", "dungeon.objectHider.hideHealerOrbs", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "dungeon.hideHealerFairy", "dungeon.objectHider.hideHealerFairy", null, 8, null);
    }

    private static final String SOUL_WEAVER_HIDER_delegate$lambda$0() {
        return SkullTextureHolder.INSTANCE.getTexture("DUNGEONS_SOUL_WEAVER");
    }

    private static final String BLESSING_TEXTURE_delegate$lambda$1() {
        return SkullTextureHolder.INSTANCE.getTexture("DUNGEONS_BLESSING");
    }

    private static final String REVIVE_STONE_TEXTURE_delegate$lambda$2() {
        return SkullTextureHolder.INSTANCE.getTexture("DUNGEONS_REVIVE_STONE");
    }

    private static final String PREMIUM_FLESH_TEXTURE_delegate$lambda$3() {
        return SkullTextureHolder.INSTANCE.getTexture("DUNGEONS_PREMIUM_FLESH");
    }

    private static final String ABILITY_ORB_TEXTURE_delegate$lambda$4() {
        return SkullTextureHolder.INSTANCE.getTexture("DUNGEONS_ABILITY_ORB");
    }

    private static final String SUPPORT_ORB_TEXTURE_delegate$lambda$5() {
        return SkullTextureHolder.INSTANCE.getTexture("DUNGEONS_SUPPORT_ORB");
    }

    private static final String DAMAGE_ORB_TEXTURE_delegate$lambda$6() {
        return SkullTextureHolder.INSTANCE.getTexture("DUNGEONS_DAMAGE_ORB");
    }

    private static final String HEALER_FAIRY_TEXTURE_delegate$lambda$7() {
        return SkullTextureHolder.INSTANCE.getTexture("DUNGEONS_HEALER_FAIRY");
    }

    private static final boolean onArmoStandMove$lambda$9(EntityArmorStand $entity) {
        Intrinsics.checkNotNullParameter($entity, "$entity");
        return INSTANCE.shouldColorMovingSkull((Entity)$entity);
    }
}

