/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.dungeon;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.dungeon.LividFinderConfig;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.deps.moulconfig.ChromaColour;
import at.hannibal2.skyhanni.events.CheckRenderEntityEvent;
import at.hannibal2.skyhanni.events.ConfigLoadEvent;
import at.hannibal2.skyhanni.events.DebugDataCollectEvent;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.events.ServerBlockChangeEvent;
import at.hannibal2.skyhanni.events.dungeon.DungeonBossRoomEnterEvent;
import at.hannibal2.skyhanni.events.dungeon.DungeonCompleteEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniRenderWorldEvent;
import at.hannibal2.skyhanni.features.dungeon.DungeonApi;
import at.hannibal2.skyhanni.features.dungeon.DungeonFloor;
import at.hannibal2.skyhanni.features.dungeon.DungeonLividFinder$special$;
import at.hannibal2.skyhanni.mixins.hooks.RenderLivingEntityHelper;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.BlockUtils;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.ConditionalUtils;
import at.hannibal2.skyhanni.utils.EntityUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.RecalculatingValue;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.TimeUtils;
import at.hannibal2.skyhanni.utils.compat.ColoredBlockCompat;
import at.hannibal2.skyhanni.utils.compat.EffectsCompat;
import at.hannibal2.skyhanni.utils.compat.MinecraftCompat;
import at.hannibal2.skyhanni.utils.render.WorldRenderUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001JB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\n\u0010\u0003J\u000f\u0010\u000b\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u000b\u0010\u0003J\u000f\u0010\f\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\f\u0010\u0003J\u001d\u0010\u000f\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001b\u0010\u0017\u001a\u00020\u0011*\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u0019\u001a\u0004\u0018\u00010\u0015*\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u001bH\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001e\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u0013J\u001d\u0010\u001f\u001a\u00020\u0004*\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010!\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b!\u0010\u0003J\u000f\u0010\"\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\"\u0010\u0003J\u0017\u0010$\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020#H\u0007\u00a2\u0006\u0004\b$\u0010%R\u0014\u0010)\u001a\u00020&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0014\u0010+\u001a\u00020*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u001b\u0010/\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010.\u001a\u0004\b/\u0010\u0013R(\u00101\u001a\u0004\u0018\u00010\u00142\b\u00100\u001a\u0004\u0018\u00010\u00148\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b1\u00102\u001a\u0004\b3\u00104R\u001c\u00106\u001a\b\u0012\u0004\u0012\u00020\u0014058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b6\u00107R\u001a\u0010;\u001a\b\u0012\u0004\u0012\u00020\u0014088BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0016\u0010<R \u0010?\u001a\u000e\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u00020\u00150=8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b?\u0010@R\u001b\u0010F\u001a\u00020A8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bB\u0010C\u001a\u0004\bD\u0010ER\u001b\u0010I\u001a\u00020A8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bG\u0010C\u001a\u0004\bH\u0010E\u00a8\u0006K"}, d2={"Lat/hannibal2/skyhanni/features/dungeon/DungeonLividFinder;", "", "<init>", "()V", "", "onSecondPassed", "Lat/hannibal2/skyhanni/events/ServerBlockChangeEvent;", "event", "onBlockChange", "(Lat/hannibal2/skyhanni/events/ServerBlockChangeEvent;)V", "onBossStart", "onBossEnd", "onWorldChange", "Lat/hannibal2/skyhanni/events/CheckRenderEntityEvent;", "Lnet/minecraft/entity/Entity;", "onCheckRender", "(Lat/hannibal2/skyhanni/events/CheckRenderEntityEvent;)V", "", "isCurrentlyBlind", "()Z", "Lnet/minecraft/client/entity/EntityOtherPlayerMP;", "Lat/hannibal2/skyhanni/utils/LorenzColor;", "color", "isLividColor", "(Lnet/minecraft/client/entity/EntityOtherPlayerMP;Lat/hannibal2/skyhanni/utils/LorenzColor;)Z", "getLividColor", "(Lnet/minecraft/client/entity/EntityOtherPlayerMP;)Lat/hannibal2/skyhanni/utils/LorenzColor;", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;)V", "inLividBossRoom", "highlight", "(Lnet/minecraft/client/entity/EntityOtherPlayerMP;Lat/hannibal2/skyhanni/utils/LorenzColor;)V", "onConfigLoad", "reloadHighlight", "Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;", "onDebug", "(Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;)V", "Lat/hannibal2/skyhanni/config/features/dungeon/LividFinderConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/dungeon/LividFinderConfig;", "config", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "blockLocation", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "isBlind$delegate", "Lat/hannibal2/skyhanni/utils/RecalculatingValue;", "isBlind", "value", "livid", "Lnet/minecraft/client/entity/EntityOtherPlayerMP;", "getLivid", "()Lnet/minecraft/client/entity/EntityOtherPlayerMP;", "", "fakeLivids", "Ljava/util/Set;", "", "getLividEntities", "()Ljava/util/List;", "lividEntities", "Lat/hannibal2/skyhanni/utils/LorenzColor;", "", "", "lividNameColor", "Ljava/util/Map;", "Ljava/util/regex/Pattern;", "lividNamePattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getLividNamePattern", "()Ljava/util/regex/Pattern;", "lividNamePattern", "lividArmorStandNamePattern$delegate", "getLividArmorStandNamePattern", "lividArmorStandNamePattern", "LividColorHighlight", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nDungeonLividFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DungeonLividFinder.kt\nat/hannibal2/skyhanni/features/dungeon/DungeonLividFinder\n+ 2 EntityUtils.kt\nat/hannibal2/skyhanni/utils/EntityUtils\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,308:1\n189#2:309\n477#3:310\n8#4:311\n8#4:313\n1#5:312\n1#5:314\n1#5:315\n*S KotlinDebug\n*F\n+ 1 DungeonLividFinder.kt\nat/hannibal2/skyhanni/features/dungeon/DungeonLividFinder\n*L\n60#1:309\n60#1:310\n174#1:311\n190#1:313\n174#1:312\n190#1:314\n*E\n"})
public final class DungeonLividFinder {
    @NotNull
    public static final DungeonLividFinder INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final LorenzVec blockLocation;
    @NotNull
    private static final RecalculatingValue isBlind$delegate;
    @Nullable
    private static EntityOtherPlayerMP livid;
    @NotNull
    private static Set<EntityOtherPlayerMP> fakeLivids;
    @Nullable
    private static LorenzColor color;
    @NotNull
    private static final Map<String, LorenzColor> lividNameColor;
    @NotNull
    private static final RepoPattern lividNamePattern$delegate;
    @NotNull
    private static final RepoPattern lividArmorStandNamePattern$delegate;

    private DungeonLividFinder() {
    }

    private final LividFinderConfig getConfig() {
        return SkyHanniMod.feature.getDungeon().getLividFinder();
    }

    private final boolean isBlind() {
        return (Boolean)isBlind$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    @Nullable
    public final EntityOtherPlayerMP getLivid() {
        return livid;
    }

    private final List<EntityOtherPlayerMP> getLividEntities() {
        EntityUtils this_$iv = EntityUtils.INSTANCE;
        boolean $i$f$getEntities = false;
        Sequence<Entity> $this$filterIsInstance$iv$iv = this_$iv.getAllEntities();
        boolean $i$f$filterIsInstance = false;
        Sequence<Entity> sequence2 = SequencesKt.filter($this$filterIsInstance$iv$iv, special$$inlined$getEntities$1.INSTANCE);
        Intrinsics.checkNotNull(sequence2, "null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        return SequencesKt.toList(SequencesKt.filter(sequence2, DungeonLividFinder::_get_lividEntities_$lambda$0));
    }

    private final Pattern getLividNamePattern() {
        return (Pattern)lividNamePattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[1]);
    }

    private final Pattern getLividArmorStandNamePattern() {
        return (Pattern)lividArmorStandNamePattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[2]);
    }

    @HandleEvent(eventType=SecondPassedEvent.class)
    public final void onSecondPassed() {
        if (!((Boolean)this.getConfig().getEnabled().get()).booleanValue()) {
            return;
        }
        if (!this.inLividBossRoom()) {
            return;
        }
        if (color == null) {
            return;
        }
        for (EntityOtherPlayerMP entity : this.getLividEntities()) {
            LorenzColor lividColor;
            if (this.getLividColor(entity) == null) {
                DungeonLividFinder $this$onSecondPassed_u24lambda_u241 = this;
                boolean bl = false;
                Pair[] pairArray = new Pair[]{TuplesKt.to("Livid Name", entity.func_70005_c_())};
                ErrorManager.logErrorStateWithData$default(ErrorManager.INSTANCE, "Unknown Livid found", "No color matches for name", pairArray, false, false, false, null, 120, null);
                continue;
            }
            if (lividColor == color) {
                livid = entity;
                this.highlight(entity, color);
                continue;
            }
            if (fakeLivids.contains(entity)) continue;
            ((Collection)fakeLivids).add(entity);
        }
    }

    @HandleEvent
    public final void onBlockChange(@NotNull ServerBlockChangeEvent event) {
        LorenzColor newColor;
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.inLividBossRoom()) {
            return;
        }
        if (!Intrinsics.areEqual(event.getLocation(), blockLocation)) {
            return;
        }
        if (!ColoredBlockCompat.Companion.isWool$default(ColoredBlockCompat.Companion, event.getNewState(), null, 1, null)) {
            return;
        }
        color = newColor = ColoredBlockCompat.Companion.getBlockColor(event.getNewState());
        ChatUtils.debug$default(ChatUtils.INSTANCE, "newColor! " + (Object)((Object)newColor), false, 2, null);
        livid = null;
        fakeLivids.clear();
        for (EntityOtherPlayerMP mob : this.getLividEntities()) {
            if (this.isLividColor(mob, LorenzColor.RED) && newColor != LorenzColor.RED) {
                if (Intrinsics.areEqual(mob, livid)) {
                    livid = null;
                }
                this.highlight(mob, null);
                ((Collection)fakeLivids).add(mob);
                continue;
            }
            if (!this.isLividColor(mob, newColor)) continue;
            livid = mob;
            ChatUtils.debug$default(ChatUtils.INSTANCE, "Livid found: " + (Object)((Object)newColor) + "\u00a77", false, 2, null);
            if (((Boolean)this.getConfig().getEnabled().get()).booleanValue()) {
                this.highlight(mob, newColor);
            }
            ((Collection)fakeLivids).remove(mob);
        }
    }

    @HandleEvent(eventType=DungeonBossRoomEnterEvent.class)
    public final void onBossStart() {
        if (DungeonApi.INSTANCE.getCurrentBoss() != DungeonFloor.F5) {
            return;
        }
        color = LorenzColor.RED;
    }

    @HandleEvent(eventType=DungeonCompleteEvent.class)
    public final void onBossEnd() {
        color = null;
        livid = null;
        fakeLivids.clear();
    }

    @HandleEvent
    public final void onWorldChange() {
        color = null;
        livid = null;
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent(onlyOnIsland=IslandType.CATACOMBS)
    public final void onCheckRender(@NotNull CheckRenderEntityEvent<Entity> event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.inLividBossRoom() || !this.getConfig().getHideWrong()) {
            return;
        }
        if (livid == null) {
            return;
        }
        if (event.getEntity() instanceof EntityOtherPlayerMP && fakeLivids.contains(event.getEntity())) {
            event.cancel();
        }
        if (event.getEntity() instanceof EntityArmorStand) {
            void $this$matchMatcher$iv;
            RegexUtils regexUtils = RegexUtils.INSTANCE;
            Pattern pattern = this.getLividArmorStandNamePattern();
            String string = ((EntityArmorStand)event.getEntity()).func_70005_c_();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            String text$iv = string;
            boolean $i$f$matchMatcher = false;
            Matcher it$iv = $this$matchMatcher$iv.matcher(text$iv);
            boolean bl = false;
            if (it$iv.matches()) {
                Intrinsics.checkNotNull(it$iv);
                Matcher $this$onCheckRender_u24lambda_u242 = it$iv;
                boolean bl2 = false;
                char colorChar = $this$onCheckRender_u24lambda_u242.group("colorCode").charAt(0);
                if (LorenzColor.Companion.toLorenzColor(colorChar) != color) {
                    event.cancel();
                }
            }
        }
    }

    private final boolean isCurrentlyBlind() {
        EntityPlayerSP entityPlayerSP = MinecraftCompat.INSTANCE.getLocalPlayerOrNull();
        return (entityPlayerSP != null && (entityPlayerSP = EffectsCompat.Companion.activePotionEffect((EntityLivingBase)entityPlayerSP, EffectsCompat.BLINDNESS)) != null ? entityPlayerSP.func_76459_b() : 0) > 10;
    }

    private final boolean isLividColor(EntityOtherPlayerMP $this$isLividColor, LorenzColor color) {
        String chatColor = color.getChatColor();
        String string = $this$isLividColor.func_70005_c_();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        return StringsKt.startsWith$default(string, chatColor + "\ufd3e " + chatColor + "\u00a7lLivid", false, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final LorenzColor getLividColor(EntityOtherPlayerMP $this$getLividColor) {
        void $this$matchMatcher$iv;
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern pattern = this.getLividNamePattern();
        String string = $this$getLividColor.func_70005_c_();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        String text$iv = string;
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(text$iv);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$getLividColor_u24lambda_u244 = it$iv;
            boolean bl2 = false;
            String string2 = RegexUtils.INSTANCE.groupOrNull($this$getLividColor_u24lambda_u244, "type");
            if (string2 == null) {
                return null;
            }
            String type2 = string2;
            LorenzColor lorenzColor = lividNameColor.get(type2);
            if (lorenzColor == null) {
                boolean bl3 = false;
                lorenzColor = null;
            }
            return lorenzColor;
        }
        return null;
    }

    @HandleEvent
    public final void onRenderWorld(@NotNull SkyHanniRenderWorldEvent event) {
        LorenzColor lorenzColor;
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.inLividBossRoom() || !((Boolean)this.getConfig().getEnabled().get()).booleanValue()) {
            return;
        }
        if (this.isBlind()) {
            return;
        }
        EntityOtherPlayerMP entityOtherPlayerMP = livid;
        if (entityOtherPlayerMP == null) {
            return;
        }
        EntityOtherPlayerMP entity = entityOtherPlayerMP;
        if (this.getConfig().getColorOverride() != LividColorHighlight.DEFAULT) {
            LorenzColor lorenzColor2 = this.getConfig().getColorOverride().getColor();
            lorenzColor = lorenzColor2;
            Intrinsics.checkNotNull((Object)lorenzColor2, "null cannot be cast to non-null type at.hannibal2.skyhanni.utils.LorenzColor");
        } else {
            lorenzColor = color;
            if (lorenzColor == null) {
                return;
            }
        }
        LorenzColor lorenzColor3 = lorenzColor;
        if (!EntityUtils.canBeSeen$default(EntityUtils.INSTANCE, (Entity)entity, null, 0.0, false, 7, null)) {
            return;
        }
        LorenzVec location = WorldRenderUtils.INSTANCE.exactLocation(event, (Entity)entity);
        AxisAlignedBB boundingBox = WorldRenderUtils.INSTANCE.exactBoundingBox(event, (Entity)entity);
        WorldRenderUtils.drawDynamicText$default(WorldRenderUtils.INSTANCE, event, location, lorenzColor3.getChatColor() + "Livid", 1.5, 0.0f, 0.0, 0.0, false, false, null, 504, null);
        ChromaColour color = LorenzColor.toChromaColor$default(lorenzColor3, 0, 0, 3, null);
        WorldRenderUtils.drawFilledBoundingBox$default(WorldRenderUtils.INSTANCE, event, boundingBox, color, 0.5f, false, false, 24, null);
        WorldRenderUtils.INSTANCE.drawLineToEye(event, LorenzVec.add$default(location, 0.5, 0.0, 0.5, 2, null), color, 3, true);
    }

    private final boolean inLividBossRoom() {
        return DungeonApi.INSTANCE.getInBossRoom() && DungeonApi.INSTANCE.getCurrentBoss() == DungeonFloor.F5;
    }

    private final void highlight(EntityOtherPlayerMP $this$highlight, LorenzColor color) {
        LorenzColor lorenzColor;
        if (color == null) {
            RenderLivingEntityHelper.INSTANCE.removeEntityColor((EntityLivingBase)$this$highlight);
            RenderLivingEntityHelper.INSTANCE.removeNoHurtTime((EntityLivingBase)$this$highlight);
            return;
        }
        if (this.getConfig().getColorOverride() != LividColorHighlight.DEFAULT) {
            LorenzColor lorenzColor2 = this.getConfig().getColorOverride().getColor();
            lorenzColor = lorenzColor2;
            Intrinsics.checkNotNull((Object)lorenzColor2, "null cannot be cast to non-null type at.hannibal2.skyhanni.utils.LorenzColor");
        } else {
            lorenzColor = color;
        }
        LorenzColor newColor = lorenzColor;
        RenderLivingEntityHelper.INSTANCE.setEntityColorWithNoHurtTime((EntityLivingBase)$this$highlight, newColor.toColor(), () -> DungeonLividFinder.highlight$lambda$5($this$highlight, newColor));
    }

    @HandleEvent(eventType=ConfigLoadEvent.class)
    public final void onConfigLoad() {
        ConditionalUtils.INSTANCE.onToggle(this.getConfig().getEnabled(), DungeonLividFinder::onConfigLoad$lambda$6);
    }

    private final void reloadHighlight() {
        Boolean enabled = (Boolean)this.getConfig().getEnabled().get();
        if (enabled.booleanValue()) {
            EntityOtherPlayerMP entityOtherPlayerMP = livid;
            if (entityOtherPlayerMP == null) {
                return;
            }
            EntityOtherPlayerMP newLivid = entityOtherPlayerMP;
            LorenzColor lorenzColor = color;
            if (lorenzColor == null) {
                return;
            }
            LorenzColor newColor = lorenzColor;
            RenderLivingEntityHelper.INSTANCE.setEntityColorWithNoHurtTime((EntityLivingBase)newLivid, newColor.toColor(), () -> DungeonLividFinder.reloadHighlight$lambda$7(newLivid, newColor));
        } else {
            EntityOtherPlayerMP entityOtherPlayerMP = livid;
            if (entityOtherPlayerMP == null) {
                return;
            }
            RenderLivingEntityHelper.INSTANCE.removeEntityColor((EntityLivingBase)entityOtherPlayerMP);
            EntityOtherPlayerMP entityOtherPlayerMP2 = livid;
            if (entityOtherPlayerMP2 == null) {
                return;
            }
            RenderLivingEntityHelper.INSTANCE.removeNoHurtTime((EntityLivingBase)entityOtherPlayerMP2);
        }
    }

    @HandleEvent
    public final void onDebug(@NotNull DebugDataCollectEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        event.title("Livid Finder");
        if (!this.inLividBossRoom()) {
            event.addIrrelevant(DungeonLividFinder::onDebug$lambda$8);
            return;
        }
        event.addData(DungeonLividFinder::onDebug$lambda$9);
    }

    private static final boolean _get_lividEntities_$lambda$0(EntityOtherPlayerMP it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return EntityUtils.INSTANCE.isNpc((EntityPlayer)it) && RegexUtils.INSTANCE.matches(INSTANCE.getLividNamePattern(), it.func_70005_c_());
    }

    private static final boolean highlight$lambda$5(EntityOtherPlayerMP $this_highlight, LorenzColor $newColor) {
        Intrinsics.checkNotNullParameter($this_highlight, "$this_highlight");
        Intrinsics.checkNotNullParameter((Object)$newColor, "$newColor");
        return INSTANCE.isLividColor($this_highlight, $newColor);
    }

    private static final void onConfigLoad$lambda$6() {
        INSTANCE.reloadHighlight();
    }

    private static final boolean reloadHighlight$lambda$7(EntityOtherPlayerMP $newLivid, LorenzColor $newColor) {
        Intrinsics.checkNotNullParameter($newLivid, "$newLivid");
        Intrinsics.checkNotNullParameter((Object)$newColor, "$newColor");
        return INSTANCE.isLividColor($newLivid, $newColor);
    }

    private static final Unit onDebug$lambda$8(List $this$addIrrelevant) {
        Intrinsics.checkNotNullParameter($this$addIrrelevant, "$this$addIrrelevant");
        $this$addIrrelevant.add("Not in Livid Boss");
        $this$addIrrelevant.add("currentBoss: " + (Object)((Object)DungeonApi.INSTANCE.getCurrentBoss()));
        $this$addIrrelevant.add("inBossRoom: " + DungeonApi.INSTANCE.getInBossRoom());
        return Unit.INSTANCE;
    }

    private static final Unit onDebug$lambda$9(List $this$addData) {
        Intrinsics.checkNotNullParameter($this$addData, "$this$addData");
        $this$addData.add("isEnabled: " + INSTANCE.getConfig().getEnabled().get());
        $this$addData.add("inBoss: " + INSTANCE.inLividBossRoom());
        $this$addData.add("isBlind: " + INSTANCE.isBlind());
        $this$addData.add("blockColor: " + BlockUtils.INSTANCE.getBlockStateAt(blockLocation));
        EntityOtherPlayerMP entityOtherPlayerMP = livid;
        $this$addData.add("livid: '" + (entityOtherPlayerMP != null ? entityOtherPlayerMP.func_70005_c_() : null) + '\'');
        LorenzColor lorenzColor = color;
        $this$addData.add("color: " + (lorenzColor != null ? lorenzColor.name() : null));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ boolean access$isCurrentlyBlind(DungeonLividFinder $this) {
        return $this.isCurrentlyBlind();
    }

    static {
        Object[] objectArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(DungeonLividFinder.class, "isBlind", "isBlind()Z", 0)), Reflection.property1(new PropertyReference1Impl(DungeonLividFinder.class, "lividNamePattern", "getLividNamePattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(DungeonLividFinder.class, "lividArmorStandNamePattern", "getLividArmorStandNamePattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = objectArray;
        INSTANCE = new DungeonLividFinder();
        blockLocation = new LorenzVec(6, 109, 43);
        isBlind$delegate = new RecalculatingValue(TimeUtils.INSTANCE.getTicks-5sfh64U(2), new Function0<Boolean>((Object)INSTANCE){

            public final Boolean invoke() {
                return DungeonLividFinder.access$isCurrentlyBlind((DungeonLividFinder)this.receiver);
            }
        }, null);
        fakeLivids = new LinkedHashSet();
        objectArray = new Pair[]{TuplesKt.to("Vendetta", LorenzColor.WHITE), TuplesKt.to("Doctor", LorenzColor.GRAY), TuplesKt.to("Crossed", LorenzColor.LIGHT_PURPLE), TuplesKt.to("Purple", LorenzColor.DARK_PURPLE), TuplesKt.to("Scream", LorenzColor.BLUE), TuplesKt.to("Hockey", LorenzColor.RED), TuplesKt.to("Arcade", LorenzColor.YELLOW), TuplesKt.to("Smile", LorenzColor.GREEN), TuplesKt.to("Frog", LorenzColor.DARK_GREEN)};
        lividNameColor = MapsKt.mapOf(objectArray);
        lividNamePattern$delegate = RepoPattern.Companion.pattern("dungeon.f5.livid.name", "^(?<type>\\w+) Livid$");
        lividArmorStandNamePattern$delegate = RepoPattern.Companion.pattern("dungeon.f5.livid.armorstand", "^\u00a7(?<colorCode>.)\ufd3e \u00a7.\u00a7lLivid.*$");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u001b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001d\b\u0002\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\b\u0010\tR\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001e\u00a8\u0006\u001f"}, d2={"Lat/hannibal2/skyhanni/features/dungeon/DungeonLividFinder$LividColorHighlight;", "", "Lat/hannibal2/skyhanni/utils/LorenzColor;", "color", "", "prettyName", "<init>", "(Ljava/lang/String;ILat/hannibal2/skyhanni/utils/LorenzColor;Ljava/lang/String;)V", "toString", "()Ljava/lang/String;", "Lat/hannibal2/skyhanni/utils/LorenzColor;", "getColor", "()Lat/hannibal2/skyhanni/utils/LorenzColor;", "Ljava/lang/String;", "DEFAULT", "BLACK", "DARK_BLUE", "DARK_GREEN", "DARK_AQUA", "DARK_RED", "DARK_PURPLE", "GOLD", "GRAY", "DARK_GRAY", "BLUE", "GREEN", "AQUA", "RED", "LIGHT_PURPLE", "YELLOW", "WHITE", "1.8.9"})
    public static final class LividColorHighlight
    extends Enum<LividColorHighlight> {
        @Nullable
        private final LorenzColor color;
        @NotNull
        private final String prettyName;
        public static final /* enum */ LividColorHighlight DEFAULT = new LividColorHighlight("DEFAULT", 0, null, null, 2, null);
        public static final /* enum */ LividColorHighlight BLACK = new LividColorHighlight("BLACK", 1, LorenzColor.BLACK, null, 2, null);
        public static final /* enum */ LividColorHighlight DARK_BLUE = new LividColorHighlight("DARK_BLUE", 2, LorenzColor.DARK_BLUE, null, 2, null);
        public static final /* enum */ LividColorHighlight DARK_GREEN = new LividColorHighlight("DARK_GREEN", 3, LorenzColor.DARK_GREEN, null, 2, null);
        public static final /* enum */ LividColorHighlight DARK_AQUA = new LividColorHighlight("DARK_AQUA", 4, LorenzColor.DARK_AQUA, null, 2, null);
        public static final /* enum */ LividColorHighlight DARK_RED = new LividColorHighlight("DARK_RED", 5, LorenzColor.DARK_RED, null, 2, null);
        public static final /* enum */ LividColorHighlight DARK_PURPLE = new LividColorHighlight("DARK_PURPLE", 6, LorenzColor.DARK_PURPLE, null, 2, null);
        public static final /* enum */ LividColorHighlight GOLD = new LividColorHighlight("GOLD", 7, LorenzColor.GOLD, null, 2, null);
        public static final /* enum */ LividColorHighlight GRAY = new LividColorHighlight("GRAY", 8, LorenzColor.GRAY, null, 2, null);
        public static final /* enum */ LividColorHighlight DARK_GRAY = new LividColorHighlight("DARK_GRAY", 9, LorenzColor.DARK_GRAY, null, 2, null);
        public static final /* enum */ LividColorHighlight BLUE = new LividColorHighlight("BLUE", 10, LorenzColor.BLUE, null, 2, null);
        public static final /* enum */ LividColorHighlight GREEN = new LividColorHighlight("GREEN", 11, LorenzColor.GREEN, null, 2, null);
        public static final /* enum */ LividColorHighlight AQUA = new LividColorHighlight("AQUA", 12, LorenzColor.AQUA, null, 2, null);
        public static final /* enum */ LividColorHighlight RED = new LividColorHighlight("RED", 13, LorenzColor.RED, null, 2, null);
        public static final /* enum */ LividColorHighlight LIGHT_PURPLE = new LividColorHighlight("LIGHT_PURPLE", 14, LorenzColor.LIGHT_PURPLE, null, 2, null);
        public static final /* enum */ LividColorHighlight YELLOW = new LividColorHighlight("YELLOW", 15, LorenzColor.YELLOW, null, 2, null);
        public static final /* enum */ LividColorHighlight WHITE = new LividColorHighlight("WHITE", 16, LorenzColor.WHITE, null, 2, null);
        private static final /* synthetic */ LividColorHighlight[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private LividColorHighlight(LorenzColor color, String prettyName) {
            this.color = color;
            this.prettyName = prettyName;
        }

        /* synthetic */ LividColorHighlight(String string, int n, LorenzColor lorenzColor, String object, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                Object object2 = lorenzColor;
                if (object2 == null || (object2 = object2.toString()) == null) {
                    object2 = "Disabled";
                }
                object = object2;
            }
            this(lorenzColor, (String)object);
        }

        @Nullable
        public final LorenzColor getColor() {
            return this.color;
        }

        @NotNull
        public String toString() {
            return this.prettyName;
        }

        public static LividColorHighlight[] values() {
            return (LividColorHighlight[])$VALUES.clone();
        }

        public static LividColorHighlight valueOf(String value) {
            return Enum.valueOf(LividColorHighlight.class, value);
        }

        @NotNull
        public static EnumEntries<LividColorHighlight> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = lividColorHighlightArray = new LividColorHighlight[]{LividColorHighlight.DEFAULT, LividColorHighlight.BLACK, LividColorHighlight.DARK_BLUE, LividColorHighlight.DARK_GREEN, LividColorHighlight.DARK_AQUA, LividColorHighlight.DARK_RED, LividColorHighlight.DARK_PURPLE, LividColorHighlight.GOLD, LividColorHighlight.GRAY, LividColorHighlight.DARK_GRAY, LividColorHighlight.BLUE, LividColorHighlight.GREEN, LividColorHighlight.AQUA, LividColorHighlight.RED, LividColorHighlight.LIGHT_PURPLE, LividColorHighlight.YELLOW, LividColorHighlight.WHITE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

