/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.fishing;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.events.fishing.FishingBobberInLiquidEvent;
import at.hannibal2.skyhanni.features.fishing.FishingApi;
import at.hannibal2.skyhanni.utils.EntityUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.compat.MinecraftCompat;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.util.AxisAlignedBB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\u0003J\u000f\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\r\u0010\fJ\u000f\u0010\u000e\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000e\u0010\fR\"\u0010\u000f\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0017\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0018R\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0015R\u0016\u0010\u001b\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u0018\u00a8\u0006\u001c"}, d2={"Lat/hannibal2/skyhanni/features/fishing/IsFishingDetection;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/fishing/FishingBobberInLiquidEvent;", "event", "", "onBobber", "(Lat/hannibal2/skyhanni/events/fishing/FishingBobberInLiquidEvent;)V", "onTick", "", "testIsFishing", "()Z", "inRodCastArea", "inKillArea", "isFishing", "Z", "setFishing", "(Z)V", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "lastRodCastLocation", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastRodCastTime", "J", "lastInAreaTime", "lastSeaCreatureKillArea", "lastSeaCreatureKillAreaTime", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nIsFishingDetection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IsFishingDetection.kt\nat/hannibal2/skyhanni/features/fishing/IsFishingDetection\n+ 2 EntityUtils.kt\nat/hannibal2/skyhanni/utils/EntityUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n144#2:86\n46#2:87\n145#2,9:88\n192#2,9:97\n774#3:106\n865#3,2:107\n*S KotlinDebug\n*F\n+ 1 IsFishingDetection.kt\nat/hannibal2/skyhanni/features/fishing/IsFishingDetection\n*L\n39#1:86\n39#1:87\n39#1:88,9\n39#1:97,9\n40#1:106\n40#1:107,2\n*E\n"})
public final class IsFishingDetection {
    @NotNull
    public static final IsFishingDetection INSTANCE = new IsFishingDetection();
    private static boolean isFishing;
    @Nullable
    private static LorenzVec lastRodCastLocation;
    private static long lastRodCastTime;
    private static long lastInAreaTime;
    @Nullable
    private static LorenzVec lastSeaCreatureKillArea;
    private static long lastSeaCreatureKillAreaTime;

    private IsFishingDetection() {
    }

    public final boolean isFishing() {
        return isFishing;
    }

    public final void setFishing(boolean bl) {
        isFishing = bl;
    }

    @HandleEvent
    public final void onBobber(@NotNull FishingBobberInLiquidEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        lastRodCastLocation = LocationUtils.INSTANCE.playerLocation();
        lastRodCastTime = SimpleTimeMark.Companion.now-uFjCsEo();
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent(onlyOnSkyblock=true)
    public final void onTick() {
        if (this.inRodCastArea()) {
            lastInAreaTime = SimpleTimeMark.Companion.now-uFjCsEo();
        }
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastInAreaTime), DurationKt.toDuration(5, DurationUnit.SECONDS)) < 0) {
            void $this$filterTo$iv$iv;
            List list;
            void this_$iv$iv$iv;
            void this_$iv$iv;
            void $this$iv;
            EntityUtils entityUtils = EntityUtils.INSTANCE;
            double radius$iv = 5.0;
            void this_$iv$iv2 = $this$iv;
            boolean $i$f$getALWAYS = false;
            Function1 predicate$iv = EntityUtils.ALWAYS.1.INSTANCE;
            boolean $i$f$getEntitiesNextToPlayer = false;
            void var8_11 = $this$iv;
            LorenzVec location$iv$iv = LocationUtils.INSTANCE.playerLocation();
            boolean $i$f$getEntitiesNearby = false;
            void var9_12 = this_$iv$iv;
            Function1 predicate$iv$iv$iv = new Function1<EntityArmorStand, Boolean>(location$iv$iv, radius$iv, predicate$iv){
                final /* synthetic */ LorenzVec $location;
                final /* synthetic */ double $radius;
                final /* synthetic */ Function1 $predicate;
                {
                    this.$location = $location;
                    this.$radius = $radius;
                    this.$predicate = $predicate;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final Boolean invoke(Entity it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return LocationUtils.INSTANCE.distanceTo(it, this.$location) < this.$radius && (Boolean)this.$predicate.invoke(it) != false;
                }
            };
            boolean $i$f$getEntitiesInBox = false;
            void var12_16 = this_$iv$iv$iv;
            AxisAlignedBB aabb$iv$iv$iv$iv = location$iv$iv.boundingCenter(radius$iv);
            boolean $i$f$getEntitiesInBoundingBox = false;
            WorldClient worldClient = MinecraftCompat.INSTANCE.getLocalWorldOrNull();
            if (worldClient == null) {
                list = CollectionsKt.emptyList();
            } else {
                WorldClient world$iv$iv$iv$iv = worldClient;
                Function1 function1 = new Function1<EntityArmorStand, Boolean>(predicate$iv$iv$iv){
                    final /* synthetic */ Function1 $predicate;
                    {
                        this.$predicate = $predicate;
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public final Boolean invoke(Entity it) {
                        return it != null && (Boolean)this.$predicate.invoke(it) != false;
                    }
                };
                List list2 = world$iv$iv$iv$iv.func_175647_a(EntityArmorStand.class, aabb$iv$iv$iv$iv, new Predicate(function1){
                    private final /* synthetic */ Function1 function;
                    {
                        Intrinsics.checkNotNullParameter(function, "function");
                        this.function = function;
                    }

                    public final /* synthetic */ boolean apply(@javax.annotation.Nullable Object p0) {
                        return (Boolean)this.function.invoke(p0);
                    }
                });
                list = list2;
                Intrinsics.checkNotNullExpressionValue(list2, "getEntitiesWithinAABB(...)");
            }
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                EntityArmorStand it = (EntityArmorStand)element$iv$iv;
                boolean bl = false;
                if (!(FishingApi.INSTANCE.seaCreatureCount(it) > 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            if (CollectionsKt.any((List)destination$iv$iv)) {
                lastSeaCreatureKillArea = LocationUtils.INSTANCE.playerLocation();
                lastSeaCreatureKillAreaTime = SimpleTimeMark.Companion.now-uFjCsEo();
            }
        }
        isFishing = this.testIsFishing();
    }

    private final boolean testIsFishing() {
        if (this.inRodCastArea()) {
            return true;
        }
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastRodCastTime), DurationKt.toDuration(5, DurationUnit.SECONDS)) < 0) {
            return true;
        }
        return this.inKillArea();
    }

    private final boolean inRodCastArea() {
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastRodCastTime), DurationKt.toDuration(2, DurationUnit.MINUTES)) < 0) {
            LorenzVec lorenzVec = lastRodCastLocation;
            if (lorenzVec != null) {
                LorenzVec it = lorenzVec;
                boolean bl = false;
                if (LocationUtils.INSTANCE.distanceToPlayer(it) < 10.0) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean inKillArea() {
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastSeaCreatureKillAreaTime), DurationKt.toDuration(2, DurationUnit.MINUTES)) < 0) {
            LorenzVec lorenzVec = lastSeaCreatureKillArea;
            if (lorenzVec != null) {
                LorenzVec it = lorenzVec;
                boolean bl = false;
                if (LocationUtils.INSTANCE.distanceToPlayer(it) < 10.0) {
                    return true;
                }
            }
        }
        return false;
    }

    static {
        lastRodCastTime = SimpleTimeMark.Companion.farPast();
        lastInAreaTime = SimpleTimeMark.Companion.farPast();
        lastSeaCreatureKillAreaTime = SimpleTimeMark.Companion.farPast();
    }
}

