/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.contest;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.garden.contest.JacobContestConfig;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.InventoryCloseEvent;
import at.hannibal2.skyhanni.events.RenderItemTooltipEvent;
import at.hannibal2.skyhanni.features.garden.CropType;
import at.hannibal2.skyhanni.features.garden.FarmingFortuneDisplay;
import at.hannibal2.skyhanni.features.garden.GardenApi;
import at.hannibal2.skyhanni.features.garden.contest.ContestBracket;
import at.hannibal2.skyhanni.features.garden.contest.FarmingContest;
import at.hannibal2.skyhanni.features.garden.contest.FarmingContestApi;
import at.hannibal2.skyhanni.features.garden.contest.JacobContestFFNeededDisplayKt;
import at.hannibal2.skyhanni.features.garden.farming.GardenCropSpeed;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.collection.RenderableCollectionUtils;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import at.hannibal2.skyhanni.utils.renderables.RenderableUtilsKt;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J3\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00172\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001d\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010!\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020 H\u0007\u00a2\u0006\u0004\b!\u0010\"R\u0014\u0010&\u001a\u00020#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u001c\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u0016\u0010*\u001a\u00020)8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010+R&\u0010.\u001a\u0014\u0012\u0004\u0012\u00020-\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0,8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010/\u00a8\u00060"}, d2={"Lat/hannibal2/skyhanni/features/garden/contest/JacobContestFFNeededDisplay;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/RenderItemTooltipEvent;", "event", "", "onRenderItemTooltip", "(Lat/hannibal2/skyhanni/events/RenderItemTooltipEvent;)V", "Lat/hannibal2/skyhanni/events/InventoryCloseEvent;", "onInventoryClose", "(Lat/hannibal2/skyhanni/events/InventoryCloseEvent;)V", "Lat/hannibal2/skyhanni/features/garden/contest/FarmingContest;", "contest", "", "Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "drawDisplay", "(Lat/hannibal2/skyhanni/features/garden/contest/FarmingContest;)Ljava/util/List;", "", "farmingFortune", "", "formatFarmingFortune", "(D)Ljava/lang/String;", "Lat/hannibal2/skyhanni/features/garden/contest/ContestBracket;", "bracket", "", "", "map", "Lat/hannibal2/skyhanni/features/garden/CropType;", "crop", "getLine", "(Lat/hannibal2/skyhanni/features/garden/contest/ContestBracket;Ljava/util/Map;Lat/hannibal2/skyhanni/features/garden/CropType;)Ljava/lang/String;", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$ChestGuiOverlayRenderEvent;", "onBackgroundDraw", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$ChestGuiOverlayRenderEvent;)V", "Lat/hannibal2/skyhanni/config/features/garden/contest/JacobContestConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/contest/JacobContestConfig;", "config", "display", "Ljava/util/List;", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastToolTipTime", "J", "", "Lnet/minecraft/item/ItemStack;", "cache", "Ljava/util/Map;", "1.8.9"})
public final class JacobContestFFNeededDisplay {
    @NotNull
    public static final JacobContestFFNeededDisplay INSTANCE = new JacobContestFFNeededDisplay();
    @NotNull
    private static List<? extends Renderable> display = CollectionsKt.emptyList();
    private static long lastToolTipTime = SimpleTimeMark.Companion.farPast();
    @NotNull
    private static final Map<ItemStack, List<Renderable>> cache = new LinkedHashMap();

    private JacobContestFFNeededDisplay() {
    }

    private final JacobContestConfig getConfig() {
        return GardenApi.INSTANCE.getConfig().getJacobContest();
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onRenderItemTooltip(@NotNull RenderItemTooltipEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.getConfig().getFfForContest()) {
            return;
        }
        if (!FarmingContestApi.INSTANCE.getInInventory()) {
            return;
        }
        ItemStack stack = event.getStack();
        List<Renderable> oldData = cache.get(stack);
        if (oldData != null) {
            display = oldData;
            lastToolTipTime = SimpleTimeMark.Companion.now-uFjCsEo();
            return;
        }
        String string = stack.func_82833_r();
        Intrinsics.checkNotNullExpressionValue(string, "getDisplayName(...)");
        Long l = FarmingContestApi.INSTANCE.getSBTimeFor(string);
        if (l == null) {
            return;
        }
        long time = l;
        FarmingContest farmingContest = FarmingContestApi.INSTANCE.getContestAtTime(time);
        if (farmingContest == null) {
            return;
        }
        FarmingContest contest = farmingContest;
        List<Renderable> newDisplay = this.drawDisplay(contest);
        display = newDisplay;
        cache.put(stack, newDisplay);
        lastToolTipTime = SimpleTimeMark.Companion.now-uFjCsEo();
    }

    @HandleEvent
    public final void onInventoryClose(@NotNull InventoryCloseEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        cache.clear();
    }

    private final List<Renderable> drawDisplay(FarmingContest contest) {
        List<Renderable> list;
        List<Renderable> $this$drawDisplay_u24lambda_u246 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u246, "\u00a76Minimum Farming Fortune needed", 0.0, null, null, 14, null);
        RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u246, "", 0.0, null, null, 14, null);
        CropType crop = contest.getCrop();
        RenderableUtilsKt.addLine($this$drawDisplay_u24lambda_u246, arg_0 -> JacobContestFFNeededDisplay.drawDisplay$lambda$6$lambda$0(crop, arg_0));
        for (ContestBracket bracket : ContestBracket.getEntries()) {
            RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u246, INSTANCE.getLine(bracket, contest.getBrackets(), crop), 0.0, null, null, 14, null);
        }
        RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u246, "", 0.0, null, null, 14, null);
        Pair<Integer, Map<ContestBracket, Integer>> pair = FarmingContestApi.INSTANCE.calculateAverages(crop);
        int size = ((Number)pair.component1()).intValue();
        Map averages = (Map)pair.component2();
        RenderableUtilsKt.addLine($this$drawDisplay_u24lambda_u246, arg_0 -> JacobContestFFNeededDisplay.drawDisplay$lambda$6$lambda$1(size, crop, arg_0));
        for (ContestBracket bracket : ContestBracket.getEntries()) {
            RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u246, INSTANCE.getLine(bracket, averages, crop), 0.0, null, null, 14, null);
        }
        RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u246, "", 0.0, null, null, 14, null);
        Double blocksPerSecond = GardenCropSpeed.INSTANCE.getLatestBlocksPerSecond(crop);
        if (blocksPerSecond == null) {
            RenderableUtilsKt.addLine($this$drawDisplay_u24lambda_u246, arg_0 -> JacobContestFFNeededDisplay.drawDisplay$lambda$6$lambda$2(crop, arg_0));
            RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u246, "\u00a7cassuming 19.9 instead.", 0.0, null, null, 14, null);
        } else if (blocksPerSecond < 15.0) {
            double formatted = NumberUtil.INSTANCE.roundTo(blocksPerSecond, 2);
            RenderableUtilsKt.addLine($this$drawDisplay_u24lambda_u246, arg_0 -> JacobContestFFNeededDisplay.drawDisplay$lambda$6$lambda$3(crop, formatted, arg_0));
            RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u246, "\u00a7cThis is too low, showing 19.9 Blocks/second instead!", 0.0, null, null, 14, null);
            blocksPerSecond = 19.9;
        }
        RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u246, "", 0.0, null, null, 14, null);
        Double trueFF = FarmingFortuneDisplay.INSTANCE.getLatestTrueFarmingFortune(crop);
        if (trueFF == null) {
            RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u246, "\u00a7cNo latest true FF saved!", 0.0, null, null, 14, null);
        } else {
            String farmingFortune = INSTANCE.formatFarmingFortune(trueFF);
            RenderableUtilsKt.addLine($this$drawDisplay_u24lambda_u246, arg_0 -> JacobContestFFNeededDisplay.drawDisplay$lambda$6$lambda$4(crop, farmingFortune, arg_0));
        }
        RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u246, "", 0.0, null, null, 14, null);
        if (blocksPerSecond == null || trueFF == null) {
            RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u246, "\u00a7cMissing data from above!", 0.0, null, null, 14, null);
        } else {
            String predictedScore = NumberUtil.INSTANCE.addSeparators((int)((100.0 + trueFF) * blocksPerSecond * crop.getBaseDrops() * (double)20 * (double)60 / (double)100));
            RenderableUtilsKt.addLine($this$drawDisplay_u24lambda_u246, arg_0 -> JacobContestFFNeededDisplay.drawDisplay$lambda$6$lambda$5(crop, predictedScore, arg_0));
        }
        return CollectionsKt.build(list);
    }

    private final String formatFarmingFortune(double farmingFortune) {
        return NumberUtil.INSTANCE.addSeparators(Math.ceil(farmingFortune));
    }

    private final String getLine(ContestBracket bracket, Map<ContestBracket, Integer> map2, CropType crop) {
        Integer n = map2.get((Object)bracket);
        if (n == null) {
            return ' ' + bracket.getDisplayName() + "\u00a7f: \u00a78Not found!";
        }
        int counter = n;
        double blocksPerSecond = JacobContestFFNeededDisplayKt.access$getRealBlocksPerSecond(crop);
        double cropsPerSecond = (double)counter / blocksPerSecond / (double)60;
        double farmingFortune = cropsPerSecond * (double)100 / (double)20 / crop.getBaseDrops() - (double)100;
        String format = this.formatFarmingFortune(RangesKt.coerceAtLeast(farmingFortune, 0.0));
        return ' ' + bracket.getDisplayName() + "\u00a7f: \u00a76" + format + " FF \u00a77(" + NumberUtil.INSTANCE.addSeparators(counter) + " crops)";
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onBackgroundDraw(@NotNull GuiRenderEvent.ChestGuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.getConfig().getFfForContest()) {
            return;
        }
        if (!FarmingContestApi.INSTANCE.getInInventory()) {
            return;
        }
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastToolTipTime), DurationKt.toDuration(200, DurationUnit.MILLISECONDS)) > 0) {
            return;
        }
        RenderUtils.renderRenderables$default(RenderUtils.INSTANCE, this.getConfig().getFfForContestPosition(), display, 0, "Jacob Contest Crop Data", false, 10, null);
    }

    private static final Unit drawDisplay$lambda$6$lambda$0(CropType $crop, List $this$addLine) {
        Intrinsics.checkNotNullParameter((Object)$crop, "$crop");
        Intrinsics.checkNotNullParameter($this$addLine, "$this$addLine");
        RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$addLine, "\u00a77For this ", 0.0, null, null, 14, null);
        RenderableCollectionUtils.addItemStack$default(RenderableCollectionUtils.INSTANCE, $this$addLine, $crop.getIcon(), false, 0.0, 6, null);
        RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$addLine, "\u00a77" + $crop.getCropName() + " contest:", 0.0, null, null, 14, null);
        return Unit.INSTANCE;
    }

    private static final Unit drawDisplay$lambda$6$lambda$1(int $size, CropType $crop, List $this$addLine) {
        Intrinsics.checkNotNullParameter((Object)$crop, "$crop");
        Intrinsics.checkNotNullParameter($this$addLine, "$this$addLine");
        RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$addLine, "\u00a77For the last \u00a7e" + $size + ' ', 0.0, null, null, 14, null);
        RenderableCollectionUtils.addItemStack$default(RenderableCollectionUtils.INSTANCE, $this$addLine, $crop.getIcon(), false, 0.0, 6, null);
        RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$addLine, "\u00a77" + $crop.getCropName() + " contests:", 0.0, null, null, 14, null);
        return Unit.INSTANCE;
    }

    private static final Unit drawDisplay$lambda$6$lambda$2(CropType $crop, List $this$addLine) {
        Intrinsics.checkNotNullParameter((Object)$crop, "$crop");
        Intrinsics.checkNotNullParameter($this$addLine, "$this$addLine");
        RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$addLine, "\u00a7cNo ", 0.0, null, null, 14, null);
        RenderableCollectionUtils.addItemStack$default(RenderableCollectionUtils.INSTANCE, $this$addLine, $crop.getIcon(), false, 0.0, 6, null);
        RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$addLine, "\u00a7cblocks/second data,", 0.0, null, null, 14, null);
        return Unit.INSTANCE;
    }

    private static final Unit drawDisplay$lambda$6$lambda$3(CropType $crop, double $formatted, List $this$addLine) {
        Intrinsics.checkNotNullParameter((Object)$crop, "$crop");
        Intrinsics.checkNotNullParameter($this$addLine, "$this$addLine");
        RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$addLine, "\u00a7cYour latest ", 0.0, null, null, 14, null);
        RenderableCollectionUtils.addItemStack$default(RenderableCollectionUtils.INSTANCE, $this$addLine, $crop.getIcon(), false, 0.0, 6, null);
        RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$addLine, "\u00a7cblocks/second: \u00a7e" + $formatted, 0.0, null, null, 14, null);
        return Unit.INSTANCE;
    }

    private static final Unit drawDisplay$lambda$6$lambda$4(CropType $crop, String $farmingFortune, List $this$addLine) {
        Intrinsics.checkNotNullParameter((Object)$crop, "$crop");
        Intrinsics.checkNotNullParameter($farmingFortune, "$farmingFortune");
        Intrinsics.checkNotNullParameter($this$addLine, "$this$addLine");
        RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$addLine, "\u00a76Your latest ", 0.0, null, null, 14, null);
        RenderableCollectionUtils.addItemStack$default(RenderableCollectionUtils.INSTANCE, $this$addLine, $crop.getIcon(), false, 0.0, 6, null);
        RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$addLine, "\u00a76FF: " + $farmingFortune, 0.0, null, null, 14, null);
        return Unit.INSTANCE;
    }

    private static final Unit drawDisplay$lambda$6$lambda$5(CropType $crop, String $predictedScore, List $this$addLine) {
        Intrinsics.checkNotNullParameter((Object)$crop, "$crop");
        Intrinsics.checkNotNullParameter($predictedScore, "$predictedScore");
        Intrinsics.checkNotNullParameter($this$addLine, "$this$addLine");
        RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$addLine, "\u00a76Predicted ", 0.0, null, null, 14, null);
        RenderableCollectionUtils.addItemStack$default(RenderableCollectionUtils.INSTANCE, $this$addLine, $crop.getIcon(), false, 0.0, 6, null);
        RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$addLine, "\u00a76crops: " + $predictedScore, 0.0, null, null, 14, null);
        return Unit.INSTANCE;
    }
}

