/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.misc.discordrpc;

import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.features.dungeon.DungeonApi;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\u0007R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000bR \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lat/hannibal2/skyhanni/features/misc/discordrpc/DiscordLocationKey;", "", "<init>", "()V", "", "location", "getAmbiguousKey", "(Ljava/lang/String;)Ljava/lang/String;", "getDiscordIconKey", "", "normalRPC", "Ljava/util/Set;", "", "specialRPC", "Ljava/util/Map;", "", "specialNetherRPC", "[Ljava/lang/String;", "specialRiftRPC", "1.8.9"})
public final class DiscordLocationKey {
    @NotNull
    public static final DiscordLocationKey INSTANCE = new DiscordLocationKey();
    @NotNull
    private static final Set<String> normalRPC;
    @NotNull
    private static final Map<String, String> specialRPC;
    @NotNull
    private static final String[] specialNetherRPC;
    @NotNull
    private static final Map<String, String> specialRiftRPC;

    private DiscordLocationKey() {
    }

    private final String getAmbiguousKey(String location) {
        String string;
        IslandType island = SkyBlockUtils.INSTANCE.getCurrentIsland();
        String string2 = DungeonApi.INSTANCE.getDungeonFloor();
        if (string2 != null) {
            String string3 = string2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
            string2 = string3;
            if (string3 != null) {
                String it = string2;
                boolean bl = false;
                if (StringsKt.startsWith$default(it, "m", false, 2, null)) {
                    return "master-mode";
                }
                if (StringsKt.startsWith$default(it, "f", false, 2, null)) {
                    return "dungeon";
                }
            }
        }
        block6 : switch (location) {
            case "Wizard Tower": {
                switch (WhenMappings.$EnumSwitchMapping$0[island.ordinal()]) {
                    case 1: {
                        string = "rift-tower";
                        break block6;
                    }
                    case 2: {
                        string = "wizard-tower";
                        break block6;
                    }
                }
                string = "skyblock-logo";
                break;
            }
            case "The Bastion": {
                switch (WhenMappings.$EnumSwitchMapping$0[island.ordinal()]) {
                    case 1: {
                        string = "wyld-woods";
                        break block6;
                    }
                    case 3: {
                        string = "crimson-isle";
                        break block6;
                    }
                }
                string = "skyblock-logo";
                break;
            }
            case "Community Center": {
                switch (WhenMappings.$EnumSwitchMapping$0[island.ordinal()]) {
                    case 2: {
                        string = "village";
                        break block6;
                    }
                    case 3: {
                        string = "crimson-isle";
                        break block6;
                    }
                }
                string = "skyblock-logo";
                break;
            }
            case "Colosseum": {
                switch (WhenMappings.$EnumSwitchMapping$0[island.ordinal()]) {
                    case 2: {
                        string = "colosseum";
                        break block6;
                    }
                    case 1: {
                        string = "around-colosseum";
                        break block6;
                    }
                }
                string = "skyblock-logo";
                break;
            }
            default: {
                string = "skyblock-logo";
            }
        }
        return string;
    }

    @NotNull
    public final String getDiscordIconKey(@NotNull String location) {
        String string;
        Intrinsics.checkNotNullParameter(location, "location");
        String string2 = location.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        String keyIfNormal = StringsKt.replace$default(string2, ' ', '-', false, 4, null);
        if (normalRPC.contains(keyIfNormal)) {
            string = keyIfNormal;
        } else if (specialRPC.containsKey(location)) {
            string = specialRPC.get(location);
            if (string == null) {
                string = this.getAmbiguousKey(location);
            }
        } else if (ArraysKt.contains(specialNetherRPC, location)) {
            string = "crimson-isle";
        } else if (specialRiftRPC.containsKey(location)) {
            string = specialRiftRPC.get(location);
            if (string == null) {
                string = this.getAmbiguousKey(location);
            }
        } else {
            string = this.getAmbiguousKey(location);
        }
        return string;
    }

    static {
        Object[] objectArray = new String[]{"auction-house", "bank", "canvas-room", "coal-mine", "crimson-isle", "farm", "fashion-shop", "flower-house", "forest", "graveyard", "library", "mountain", "ruins", "tavern", "unincorporated", "village", "wilderness", "birch-park", "spruce-woods", "savanna-woodland", "dark-thicket", "jungle-island", "gold-mine", "slimehill", "the-barn", "mushroom-desert", "the-end", "around-colosseum", "barrier-street", "dreadfarm", "empty-bank", "lagoon-hut", "living-cave", "rift-gallery", "the-rift", "village-plaza", "wyld-woods", "glacite-tunnels", "jungle", "mithril-deposits", "precursor-remnants", "goblin-holdout", "magma-fields", "crystal-nucleus", "dungeon-hub"};
        normalRPC = SetsKt.setOf(objectArray);
        objectArray = new Pair[]{TuplesKt.to("Fisherman's Hut", "fishermans-hut"), TuplesKt.to("Farmhouse", "farm"), TuplesKt.to("Dragon's Nest", "dragons-nest"), TuplesKt.to("Windmill", "the-barn"), TuplesKt.to("Dark Auction", "wilderness"), TuplesKt.to("Catacombs Entrance", "coal-mine"), TuplesKt.to("Colosseum Arena", "colosseum"), TuplesKt.to("Museum", "unincorporated"), TuplesKt.to("Personal Garden", "garden"), TuplesKt.to("Jerry's Workshop", "winter-island"), TuplesKt.to("Jerry Pond", "winter-island"), TuplesKt.to("Mount Jerry", "winter-island"), TuplesKt.to("Gary's Shack", "winter-island"), TuplesKt.to("Glacial Cave", "winter-island"), TuplesKt.to("Terry's Shack", "winter-island"), TuplesKt.to("Hot Springs", "winter-island"), TuplesKt.to("Jerry Pond", "winter-island"), TuplesKt.to("Reflective Pond", "winter-island"), TuplesKt.to("Sunken Jerry Pond", "winter-island"), TuplesKt.to("Sherry's Showroom", "winter-island"), TuplesKt.to("Einary's Emporium", "winter-island"), TuplesKt.to("Archery Range", "village"), TuplesKt.to("Bazaar Alley", "village"), TuplesKt.to("Blacksmith", "village"), TuplesKt.to("Builder's House", "village"), TuplesKt.to("Election Room", "village"), TuplesKt.to("Hexatorum", "village"), TuplesKt.to("Thaumaturgist", "village"), TuplesKt.to("Weaponsmith", "village"), TuplesKt.to("Void Sepulture", "the-end"), TuplesKt.to("Void Slate", "the-end"), TuplesKt.to("Zealot Bruiser Hideout", "dragons-nest"), TuplesKt.to("Desert Settlement", "mushroom-desert"), TuplesKt.to("Oasis", "mushroom-desert"), TuplesKt.to("Desert Mountain", "mushroom-desert"), TuplesKt.to("Jake's House", "mushroom-desert"), TuplesKt.to("Trapper's Den", "mushroom-desert"), TuplesKt.to("Mushroom Gorge", "mushroom-desert"), TuplesKt.to("Glowing Mushroom Cave", "mushroom-desert"), TuplesKt.to("Overgrown Mushroom Cave", "mushroom-desert"), TuplesKt.to("Shepherd's Keep", "mushroom-desert"), TuplesKt.to("Treasure Hunter Camp", "mushroom-desert"), TuplesKt.to("Spider's Den", "spiders-den"), TuplesKt.to("Arachne's Burrow", "spiders-den"), TuplesKt.to("Arachne's Sanctuary", "spiders-den"), TuplesKt.to("Archaeologist's Camp", "spiders-den"), TuplesKt.to("Grandma's House", "spiders-den"), TuplesKt.to("Gravel Mines", "spiders-den"), TuplesKt.to("Spider Mound", "spiders-den"), TuplesKt.to("Melody's Plateau", "savanna-woodland"), TuplesKt.to("Viking Longhouse", "spruce-woods"), TuplesKt.to("Lonely Island", "spruce-woods"), TuplesKt.to("Howling Cave", "birch-park"), TuplesKt.to("Aristocrat Passage", "dwarven-mines"), TuplesKt.to("Barracks of Heroes", "dwarven-mines"), TuplesKt.to("C&C Minecarts Co.", "dwarven-mines"), TuplesKt.to("Cliffside Veins", "dwarven-mines"), TuplesKt.to("Divan's Gateway", "dwarven-mines"), TuplesKt.to("Dwarven Tavern", "dwarven-mines"), TuplesKt.to("Dwarven Village", "dwarven-mines"), TuplesKt.to("Far Reserve", "dwarven-mines"), TuplesKt.to("Forge Basin", "dwarven-mines"), TuplesKt.to("Gates to the Mines", "dwarven-mines"), TuplesKt.to("Goblin Burrows", "dwarven-mines"), TuplesKt.to("Grand Library", "dwarven-mines"), TuplesKt.to("Great Ice Wall", "dwarven-mines"), TuplesKt.to("Hanging Court", "dwarven-mines"), TuplesKt.to("Lava Springs", "dwarven-mines"), TuplesKt.to("Miner's Guild", "dwarven-mines"), TuplesKt.to("Palace Bridge", "dwarven-mines"), TuplesKt.to("Rampart's Quarry", "dwarven-mines"), TuplesKt.to("Royal Mines", "dwarven-mines"), TuplesKt.to("Royal Palace", "dwarven-mines"), TuplesKt.to("Royal Quarters", "dwarven-mines"), TuplesKt.to("The Forge", "dwarven-mines"), TuplesKt.to("The Lift", "dwarven-mines"), TuplesKt.to("The Mist", "dwarven-mines"), TuplesKt.to("Upper Mines", "dwarven-mines"), TuplesKt.to("Dragon's Lair", "mithril-deposits"), TuplesKt.to("Fairy Grotto", "crystal-nucleus"), TuplesKt.to("Goblin Queen's Den", "goblin-holdout"), TuplesKt.to("Jungle Temple", "jungle"), TuplesKt.to("Khazad-d\u00fbm", "magma-fields"), TuplesKt.to("Lost Precursor City", "precursor-remnants"), TuplesKt.to("Mines of Divan", "mithril-deposits"), TuplesKt.to("Diamond Reserve", "coal-mine"), TuplesKt.to("Gunpowder Mines", "coal-mine"), TuplesKt.to("Lapis Quarry", "coal-mine"), TuplesKt.to("Obsidian Sanctuary", "coal-mine"), TuplesKt.to("Pigmen's Den", "coal-mine"), TuplesKt.to("Dwarven Base Camp", "glacite-tunnels"), TuplesKt.to("Fossil Research Center", "glacite-tunnels"), TuplesKt.to("Great Glacite Lake", "glacite-tunnels"), TuplesKt.to("Glacite Mineshafts", "glacite-tunnels")};
        specialRPC = MapsKt.mapOf(objectArray);
        objectArray = new String[]{"Aura's Lab", "Barbarian Outpost", "Belly of the Beast", "Blazing Volcano", "Burning Desert", "Cathedral", "Chief's Hut", "Courtyard", "Crimson Fields", "Dojo", "Dragontail Auction House", "Dragontail Bank", "Dragontail Bazaar", "Dragontail Blacksmith", "Dragontail Townsquare", "Dragontail", "Forgotten Skull", "Igrupan's Chicken Coop", "Igrupan's House", "Kuudra's Hollow", "Mage Council", "Mage Outpost", "Magma Chamber", "Matriarch's Lair", "Minion Shop", "Mystic Marsh", "Odger's Hut", "Plhlegblast Pool", "Ruins of Ashfang", "Scarleton Auction House", "Scarleton Bank", "Scarleton Bazaar", "Scarleton Blacksmith", "Scarleton Minion Shop", "Scarleton Plaza", "Scarleton", "Smoldering Tomb", "Stronghold", "The Dukedom", "The Wasteland", "Throne Room"};
        specialNetherRPC = objectArray;
        objectArray = new Pair[]{TuplesKt.to("Enigma's Crib", "wyld-woods"), TuplesKt.to("Broken Cage", "wyld-woods"), TuplesKt.to("Shifted Tavern", "wyld-woods"), TuplesKt.to("Pumpgrotto", "wyld-woods"), TuplesKt.to("Otherside", "wyld-woods"), TuplesKt.to("Black Lagoon", "the-rift"), TuplesKt.to("Lagoon Cave", "the-rift"), TuplesKt.to("Leeches Lair", "the-rift"), TuplesKt.to("Dolphin Trainer", "the-rift"), TuplesKt.to("Mirrorverse", "the-rift"), TuplesKt.to("Book In A Book", "the-rift"), TuplesKt.to("\"Your\" Island", "the-rift"), TuplesKt.to("Lagoon Hut", "lagoon-hut"), TuplesKt.to("Around Colosseum", "around-colosseum"), TuplesKt.to("Rift Gallery Entrance", "rift-gallery"), TuplesKt.to("Great Beanstalk", "dreadfarm"), TuplesKt.to("Taylor's", "taylors"), TuplesKt.to("Lonely Terrace", "taylors"), TuplesKt.to("Half-Eaten Cave", "half-cave"), TuplesKt.to("D\u00e9j\u00e0 Vu Alley", "living-cave"), TuplesKt.to("Living Stillness", "living-cave"), TuplesKt.to("West Village", "village-plaza"), TuplesKt.to("Cake House", "village-plaza"), TuplesKt.to("Infested House", "village-plaza"), TuplesKt.to("Murder House", "village-plaza"), TuplesKt.to("Barry Center", "village-plaza"), TuplesKt.to("Barry HQ", "village-plaza"), TuplesKt.to("Photon Pathway", "stillgore-chateau"), TuplesKt.to("Stillgore Ch\u00e2teau", "stillgore-chateau"), TuplesKt.to("Oubliette", "stillgore-chateau"), TuplesKt.to("Fairylosopher Tower", "stillgore-chateau")};
        specialRiftRPC = MapsKt.mapOf(objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IslandType.values().length];
            try {
                nArray[IslandType.THE_RIFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IslandType.HUB.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IslandType.CRIMSON_ISLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

