/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils;

import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.LorenzVecKt;
import at.hannibal2.skyhanni.utils.compat.MinecraftCompat;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.util.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u001c\u001dB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001d\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\u000e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0011\u0010\u0012JC\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00100\u0014\"\u0004\b\u0000\u0010\u00132\u0006\u0010\u0007\u001a\u00020\u00042\u0014\b\u0004\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0014H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0017J?\u0010\u001a\u001a\u0004\u0018\u00018\u0000\"\b\b\u0000\u0010\u0013*\u00020\u0001*\b\u0012\u0004\u0012\u00028\u00000\u00182\u0006\u0010\u0007\u001a\u00020\u00042\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0014\u00a2\u0006\u0004\b\u001a\u0010\u001b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001e"}, d2={"Lat/hannibal2/skyhanni/utils/RaycastUtils;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/utils/RaycastUtils$Ray;", "createPlayerLookDirectionRay", "()Lat/hannibal2/skyhanni/utils/RaycastUtils$Ray;", "ray", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "point", "Lat/hannibal2/skyhanni/utils/RaycastUtils$Plane;", "createOrthogonalPlaneToRayAtPoint", "(Lat/hannibal2/skyhanni/utils/RaycastUtils$Ray;Lat/hannibal2/skyhanni/utils/LorenzVec;)Lat/hannibal2/skyhanni/utils/RaycastUtils$Plane;", "plane", "intersectPlaneWithRay", "(Lat/hannibal2/skyhanni/utils/RaycastUtils$Plane;Lat/hannibal2/skyhanni/utils/RaycastUtils$Ray;)Lat/hannibal2/skyhanni/utils/LorenzVec;", "", "findDistanceToRay", "(Lat/hannibal2/skyhanni/utils/RaycastUtils$Ray;Lat/hannibal2/skyhanni/utils/LorenzVec;)D", "T", "Lkotlin/Function1;", "position", "createDistanceToRayEstimator", "(Lat/hannibal2/skyhanni/utils/RaycastUtils$Ray;Lkotlin/jvm/functions/Function1;)Lkotlin/jvm/functions/Function1;", "", "positionExtractor", "findClosestPointToRay", "(Ljava/util/List;Lat/hannibal2/skyhanni/utils/RaycastUtils$Ray;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Ray", "Plane", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nRaycastUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RaycastUtils.kt\nat/hannibal2/skyhanni/utils/RaycastUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n64#1:76\n2341#2,14:77\n*S KotlinDebug\n*F\n+ 1 RaycastUtils.kt\nat/hannibal2/skyhanni/utils/RaycastUtils\n*L\n71#1:76\n71#1:77,14\n*E\n"})
public final class RaycastUtils {
    @NotNull
    public static final RaycastUtils INSTANCE = new RaycastUtils();

    private RaycastUtils() {
    }

    @NotNull
    public final Ray createPlayerLookDirectionRay() {
        LorenzVec lorenzVec = LocationUtils.INSTANCE.playerEyeLocation();
        Vec3 vec3 = MinecraftCompat.INSTANCE.getLocalPlayer().func_70040_Z();
        Intrinsics.checkNotNullExpressionValue(vec3, "getLookVec(...)");
        return new Ray(lorenzVec, LorenzVecKt.toLorenzVec(vec3));
    }

    @NotNull
    public final Plane createOrthogonalPlaneToRayAtPoint(@NotNull Ray ray, @NotNull LorenzVec point) {
        Intrinsics.checkNotNullParameter(ray, "ray");
        Intrinsics.checkNotNullParameter(point, "point");
        return new Plane(point, ray.getDirection());
    }

    @NotNull
    public final LorenzVec intersectPlaneWithRay(@NotNull Plane plane, @NotNull Ray ray) {
        Intrinsics.checkNotNullParameter(plane, "plane");
        Intrinsics.checkNotNullParameter(ray, "ray");
        double intersectionPointDistanceAlongRay = (plane.getNormal().dotProduct(plane.getOrigin()) - plane.getNormal().dotProduct(ray.getOrigin())) / plane.getNormal().dotProduct(ray.getDirection());
        return ray.getOrigin().plus(ray.getDirection().scale(intersectionPointDistanceAlongRay));
    }

    public final double findDistanceToRay(@NotNull Ray ray, @NotNull LorenzVec point) {
        Intrinsics.checkNotNullParameter(ray, "ray");
        Intrinsics.checkNotNullParameter(point, "point");
        Plane plane = this.createOrthogonalPlaneToRayAtPoint(ray, point);
        LorenzVec intersectionPoint = this.intersectPlaneWithRay(plane, ray);
        if (intersectionPoint.minus(ray.getOrigin()).dotProduct(ray.getDirection()) < 0.0) {
            return Double.MAX_VALUE;
        }
        return intersectionPoint.distance(point);
    }

    @NotNull
    public final <T> Function1<T, Double> createDistanceToRayEstimator(@NotNull Ray ray, @NotNull Function1<? super T, LorenzVec> position) {
        Intrinsics.checkNotNullParameter(ray, "ray");
        Intrinsics.checkNotNullParameter(position, "position");
        boolean $i$f$createDistanceToRayEstimator = false;
        return new Function1<T, Double>(ray, position){
            final /* synthetic */ Ray $ray;
            final /* synthetic */ Function1<T, LorenzVec> $position;
            {
                this.$ray = $ray;
                this.$position = $position;
            }

            public final Double invoke(T it) {
                return RaycastUtils.INSTANCE.findDistanceToRay(this.$ray, this.$position.invoke(it));
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final <T> T findClosestPointToRay(@NotNull List<? extends T> $this$findClosestPointToRay, @NotNull Ray ray, @NotNull Function1<? super T, LorenzVec> positionExtractor) {
        T t;
        void $this$minByOrNull$iv;
        Intrinsics.checkNotNullParameter($this$findClosestPointToRay, "<this>");
        Intrinsics.checkNotNullParameter(ray, "ray");
        Intrinsics.checkNotNullParameter(positionExtractor, "positionExtractor");
        Iterable iterable = $this$findClosestPointToRay;
        Object this_$iv = this;
        boolean $i$f$createDistanceToRayEstimator = false;
        this_$iv = new /* invalid duplicate definition of identical inner class */;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            t = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                t = minElem$iv;
            } else {
                void selector$iv;
                Comparable minValue$iv = (Comparable)selector$iv.invoke(minElem$iv);
                do {
                    Object e$iv;
                    Comparable v$iv;
                    if (minValue$iv.compareTo(v$iv = (Comparable)selector$iv.invoke(e$iv = iterator$iv.next())) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                t = minElem$iv;
            }
        }
        return t;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\bJ$\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u000e\u001a\u00020\r2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0011\u001a\u00020\u0010H\u00d6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0014\u001a\u00020\u0013H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\bR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0016\u001a\u0004\b\u0018\u0010\b\u00a8\u0006\u0019"}, d2={"Lat/hannibal2/skyhanni/utils/RaycastUtils$Plane;", "", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "origin", "normal", "<init>", "(Lat/hannibal2/skyhanni/utils/LorenzVec;Lat/hannibal2/skyhanni/utils/LorenzVec;)V", "component1", "()Lat/hannibal2/skyhanni/utils/LorenzVec;", "component2", "copy", "(Lat/hannibal2/skyhanni/utils/LorenzVec;Lat/hannibal2/skyhanni/utils/LorenzVec;)Lat/hannibal2/skyhanni/utils/RaycastUtils$Plane;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "getOrigin", "getNormal", "1.8.9"})
    public static final class Plane {
        @NotNull
        private final LorenzVec origin;
        @NotNull
        private final LorenzVec normal;

        public Plane(@NotNull LorenzVec origin, @NotNull LorenzVec normal) {
            Intrinsics.checkNotNullParameter(origin, "origin");
            Intrinsics.checkNotNullParameter(normal, "normal");
            this.origin = origin;
            this.normal = normal;
            if (!LorenzVec.isNormalized$default(this.normal, 0.0, 1, null)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final LorenzVec getOrigin() {
            return this.origin;
        }

        @NotNull
        public final LorenzVec getNormal() {
            return this.normal;
        }

        @NotNull
        public final LorenzVec component1() {
            return this.origin;
        }

        @NotNull
        public final LorenzVec component2() {
            return this.normal;
        }

        @NotNull
        public final Plane copy(@NotNull LorenzVec origin, @NotNull LorenzVec normal) {
            Intrinsics.checkNotNullParameter(origin, "origin");
            Intrinsics.checkNotNullParameter(normal, "normal");
            return new Plane(origin, normal);
        }

        public static /* synthetic */ Plane copy$default(Plane plane, LorenzVec lorenzVec, LorenzVec lorenzVec2, int n, Object object) {
            if ((n & 1) != 0) {
                lorenzVec = plane.origin;
            }
            if ((n & 2) != 0) {
                lorenzVec2 = plane.normal;
            }
            return plane.copy(lorenzVec, lorenzVec2);
        }

        @NotNull
        public String toString() {
            return "Plane(origin=" + this.origin + ", normal=" + this.normal + ')';
        }

        public int hashCode() {
            int result2 = this.origin.hashCode();
            result2 = result2 * 31 + this.normal.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Plane)) {
                return false;
            }
            Plane plane = (Plane)other;
            if (!Intrinsics.areEqual(this.origin, plane.origin)) {
                return false;
            }
            return Intrinsics.areEqual(this.normal, plane.normal);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\bJ$\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u000e\u001a\u00020\r2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0011\u001a\u00020\u0010H\u00d6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0014\u001a\u00020\u0013H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\bR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0016\u001a\u0004\b\u0018\u0010\b\u00a8\u0006\u0019"}, d2={"Lat/hannibal2/skyhanni/utils/RaycastUtils$Ray;", "", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "origin", "direction", "<init>", "(Lat/hannibal2/skyhanni/utils/LorenzVec;Lat/hannibal2/skyhanni/utils/LorenzVec;)V", "component1", "()Lat/hannibal2/skyhanni/utils/LorenzVec;", "component2", "copy", "(Lat/hannibal2/skyhanni/utils/LorenzVec;Lat/hannibal2/skyhanni/utils/LorenzVec;)Lat/hannibal2/skyhanni/utils/RaycastUtils$Ray;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "getOrigin", "getDirection", "1.8.9"})
    public static final class Ray {
        @NotNull
        private final LorenzVec origin;
        @NotNull
        private final LorenzVec direction;

        public Ray(@NotNull LorenzVec origin, @NotNull LorenzVec direction) {
            Intrinsics.checkNotNullParameter(origin, "origin");
            Intrinsics.checkNotNullParameter(direction, "direction");
            this.origin = origin;
            this.direction = direction;
            if (!LorenzVec.isNormalized$default(this.direction, 0.0, 1, null)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final LorenzVec getOrigin() {
            return this.origin;
        }

        @NotNull
        public final LorenzVec getDirection() {
            return this.direction;
        }

        @NotNull
        public final LorenzVec component1() {
            return this.origin;
        }

        @NotNull
        public final LorenzVec component2() {
            return this.direction;
        }

        @NotNull
        public final Ray copy(@NotNull LorenzVec origin, @NotNull LorenzVec direction) {
            Intrinsics.checkNotNullParameter(origin, "origin");
            Intrinsics.checkNotNullParameter(direction, "direction");
            return new Ray(origin, direction);
        }

        public static /* synthetic */ Ray copy$default(Ray ray, LorenzVec lorenzVec, LorenzVec lorenzVec2, int n, Object object) {
            if ((n & 1) != 0) {
                lorenzVec = ray.origin;
            }
            if ((n & 2) != 0) {
                lorenzVec2 = ray.direction;
            }
            return ray.copy(lorenzVec, lorenzVec2);
        }

        @NotNull
        public String toString() {
            return "Ray(origin=" + this.origin + ", direction=" + this.direction + ')';
        }

        public int hashCode() {
            int result2 = this.origin.hashCode();
            result2 = result2 * 31 + this.direction.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Ray)) {
                return false;
            }
            Ray ray = (Ray)other;
            if (!Intrinsics.areEqual(this.origin, ray.origin)) {
                return false;
            }
            return Intrinsics.areEqual(this.direction, ray.direction);
        }
    }
}

