/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.SocketException;
import org.eclipse.jdt.annotation.NonNull;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.AFSocketFactory;
import org.newsclub.net.unix.AFSocketImpl;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketChannel;
import org.newsclub.net.unix.AFUNIXSocketCredentials;
import org.newsclub.net.unix.AFUNIXSocketExtensions;
import org.newsclub.net.unix.AFUNIXSocketFactory;
import org.newsclub.net.unix.AFUNIXSocketImpl;

public final class AFUNIXSocket
extends AFSocket<AFUNIXSocketAddress>
implements AFUNIXSocketExtensions {
    private static final AFSocket.Constructor<AFUNIXSocketAddress> CONSTRUCTOR_STRICT = new AFSocket.Constructor<AFUNIXSocketAddress>(){

        @Override
        public @NonNull AFSocket<AFUNIXSocketAddress> newInstance(FileDescriptor fdObj, AFSocketFactory<AFUNIXSocketAddress> factory) throws SocketException {
            return new AFUNIXSocket(new AFUNIXSocketImpl(fdObj), factory);
        }
    };

    private AFUNIXSocket(AFSocketImpl<AFUNIXSocketAddress> impl, AFSocketFactory<AFUNIXSocketAddress> factory) throws SocketException {
        super(impl, factory);
    }

    AFUNIXSocket(FileDescriptor fd, AFSocketFactory<AFUNIXSocketAddress> factory) throws SocketException {
        this(new AFUNIXSocketImpl.Lenient(fd), factory);
    }

    protected AFUNIXSocketChannel newChannel() {
        return new AFUNIXSocketChannel(this);
    }

    public static AFUNIXSocket newInstance() throws IOException {
        return (AFUNIXSocket)AFSocket.newInstance(AFUNIXSocket::new, null);
    }

    static AFUNIXSocket newLenientInstance() throws IOException {
        return AFUNIXSocket.newInstance();
    }

    static AFUNIXSocket newInstance(FileDescriptor fdObj, int localPort, int remotePort) throws IOException {
        return (AFUNIXSocket)AFSocket.newInstance(AFUNIXSocket::new, null, fdObj, localPort, remotePort);
    }

    static AFUNIXSocket newInstance(AFUNIXSocketFactory factory) throws SocketException {
        return (AFUNIXSocket)AFSocket.newInstance(AFUNIXSocket::new, factory);
    }

    public static AFUNIXSocket newStrictInstance() throws IOException {
        return (AFUNIXSocket)AFSocket.newInstance(CONSTRUCTOR_STRICT, null);
    }

    public static AFUNIXSocket connectTo(AFUNIXSocketAddress addr) throws IOException {
        return (AFUNIXSocket)AFSocket.connectTo(AFUNIXSocket::new, addr);
    }

    @Override
    public AFUNIXSocketChannel getChannel() {
        return (AFUNIXSocketChannel)super.getChannel();
    }

    @Override
    public AFUNIXSocketCredentials getPeerCredentials() throws IOException {
        if (this.isClosed() || !this.isConnected()) {
            throw new SocketException("Not connected");
        }
        return ((AFUNIXSocketImpl)this.getAFImpl()).getPeerCredentials();
    }

    @Override
    public FileDescriptor[] getReceivedFileDescriptors() throws IOException {
        return ((AFUNIXSocketImpl)this.getAFImpl()).getReceivedFileDescriptors();
    }

    @Override
    public void clearReceivedFileDescriptors() {
        ((AFUNIXSocketImpl)this.getAFImpl()).clearReceivedFileDescriptors();
    }

    @Override
    public void setOutboundFileDescriptors(FileDescriptor ... fdescs) throws IOException {
        if (fdescs != null && fdescs.length > 0 && !this.isConnected()) {
            throw new SocketException("Not connected");
        }
        ((AFUNIXSocketImpl)this.getAFImpl()).setOutboundFileDescriptors(fdescs);
    }

    @Override
    public boolean hasOutboundFileDescriptors() {
        return ((AFUNIXSocketImpl)this.getAFImpl()).hasOutboundFileDescriptors();
    }

    public static boolean isSupported() {
        return AFSocket.isSupported() && AFSocket.supports(AFSocketCapability.CAPABILITY_UNIX_DOMAIN);
    }

    public static void main(String[] args2) {
        System.out.print(AFUNIXSocket.class.getName() + ".isSupported(): ");
        System.out.flush();
        System.out.println(AFUNIXSocket.isSupported());
        for (AFSocketCapability cap : AFSocketCapability.values()) {
            System.out.print((Object)((Object)cap) + ": ");
            System.out.flush();
            System.out.println(AFSocket.supports(cap));
        }
    }
}

