/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.commons.net.ftp.parser;

import at.hannibal2.skyhanni.deps.commons.net.ftp.Configurable;
import at.hannibal2.skyhanni.deps.commons.net.ftp.FTPClientConfig;
import at.hannibal2.skyhanni.deps.commons.net.ftp.FTPFile;
import at.hannibal2.skyhanni.deps.commons.net.ftp.parser.ConfigurableFTPFileEntryParserImpl;
import at.hannibal2.skyhanni.deps.commons.net.ftp.parser.FTPTimestampParser;
import at.hannibal2.skyhanni.deps.commons.net.ftp.parser.FTPTimestampParserImpl;
import java.text.ParseException;

public class NTFTPEntryParser
extends ConfigurableFTPFileEntryParserImpl {
    private static final String DEFAULT_DATE_FORMAT = "MM-dd-yy hh:mma";
    private static final String DEFAULT_DATE_FORMAT2 = "MM-dd-yy kk:mm";
    private static final String REGEX = "(\\S+)\\s+(\\S+)\\s+(?:(<DIR>)|([0-9]+))\\s+(\\S.*)";
    private final FTPTimestampParser timestampParser;

    public NTFTPEntryParser() {
        this((FTPClientConfig)null);
    }

    public NTFTPEntryParser(FTPClientConfig config) {
        super(REGEX, 32);
        this.configure(config);
        FTPClientConfig config2 = new FTPClientConfig("WINDOWS", DEFAULT_DATE_FORMAT2, null);
        config2.setDefaultDateFormatStr(DEFAULT_DATE_FORMAT2);
        this.timestampParser = new FTPTimestampParserImpl();
        ((Configurable)((Object)this.timestampParser)).configure(config2);
    }

    @Override
    public FTPClientConfig getDefaultConfiguration() {
        return new FTPClientConfig("WINDOWS", DEFAULT_DATE_FORMAT, null);
    }

    @Override
    public FTPFile parseFTPEntry(String entry) {
        FTPFile f = new FTPFile();
        f.setRawListing(entry);
        if (this.matches(entry)) {
            String datestr = this.group(1) + " " + this.group(2);
            String dirString = this.group(3);
            String size = this.group(4);
            String name2 = this.group(5);
            try {
                f.setTimestamp(super.parseTimestamp(datestr));
            }
            catch (ParseException e) {
                try {
                    f.setTimestamp(this.timestampParser.parseTimestamp(datestr));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (null == name2 || name2.equals(".") || name2.equals("..")) {
                return null;
            }
            f.setName(name2);
            if ("<DIR>".equals(dirString)) {
                f.setType(1);
                f.setSize(0L);
            } else {
                f.setType(0);
                if (null != size) {
                    f.setSize(Long.parseLong(size));
                }
            }
            return f;
        }
        return null;
    }
}

