/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.test.command;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.commands.CommandCategory;
import at.hannibal2.skyhanni.config.commands.CommandRegistrationEvent;
import at.hannibal2.skyhanni.config.commands.brigadier.ArgContext;
import at.hannibal2.skyhanni.config.commands.brigadier.BaseBrigadierBuilder;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.OSUtils;
import at.hannibal2.skyhanni.utils.SkyBlockItemModifierUtils;
import at.hannibal2.skyhanni.utils.compat.TextCompatKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0015\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lat/hannibal2/skyhanni/test/command/CopyItemCommand;", "", "<init>", "()V", "", "command", "Lnet/minecraft/class_1799;", "itemStack", "copyItemToClipboard", "(Lnet/minecraft/class_1799;)V", "Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;", "event", "onCommandRegistration", "(Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;)V", "1.21.10"})
public final class CopyItemCommand {
    @NotNull
    public static final CopyItemCommand INSTANCE = new CopyItemCommand();

    private CopyItemCommand() {
    }

    private final void command() {
        class_1799 itemStack = InventoryUtils.INSTANCE.getItemInHand();
        if (itemStack == null) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, "No item in hand!", false, 2, null);
            return;
        }
        this.copyItemToClipboard(itemStack);
    }

    public final void copyItemToClipboard(@NotNull class_1799 itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        List resultList = new ArrayList();
        resultList.add("internal name: " + ItemUtils.INSTANCE.getInternalName(itemStack).asString());
        resultList.add("display name: '" + TextCompatKt.formattedTextCompatLeadingWhiteLessResets(itemStack.method_7964()) + "'");
        resultList.add("minecraft id: '" + SkyBlockItemModifierUtils.INSTANCE.getMinecraftId(itemStack) + "'");
        resultList.add("lore:");
        for (String line : ItemUtils.INSTANCE.getLore(itemStack)) {
            resultList.add(" '" + line + "'");
        }
        resultList.add("");
        List attributes = ItemUtils.getReadableNBTDump$default(ItemUtils.INSTANCE, ItemUtils.INSTANCE.getExtraAttributes(itemStack), null, false, 3, null);
        if (attributes.isEmpty()) {
            v0 = resultList.add("no tag compound");
        } else {
            resultList.add("getTagCompound");
            v0 = resultList.addAll(attributes);
        }
        String string = CollectionsKt.joinToString$default((Iterable)resultList, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        OSUtils.INSTANCE.copyToClipboard(string);
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Item info copied into the clipboard!", false, null, false, false, null, 62, null);
    }

    @HandleEvent
    public final void onCommandRegistration(@NotNull CommandRegistrationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.registerBrigadier("shcopyitem", (Function1<? super BaseBrigadierBuilder, Unit>)((Function1)CopyItemCommand::onCommandRegistration$lambda$1));
    }

    private static final Unit onCommandRegistration$lambda$1$lambda$0(ArgContext $this$callback) {
        Intrinsics.checkNotNullParameter((Object)$this$callback, (String)"$this$callback");
        INSTANCE.command();
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$1(BaseBrigadierBuilder $this$registerBrigadier) {
        Intrinsics.checkNotNullParameter((Object)$this$registerBrigadier, (String)"$this$registerBrigadier");
        $this$registerBrigadier.setDescription("Copies information about the item in hand to the clipboard");
        $this$registerBrigadier.setCategory(CommandCategory.DEVELOPER_DEBUG);
        $this$registerBrigadier.callback((Function1<ArgContext, Unit>)((Function1)CopyItemCommand::onCommandRegistration$lambda$1$lambda$0));
        return Unit.INSTANCE;
    }
}

