/*
 * Decompiled with CFR 0.152.
 */
package dev.cbyrne.kdiscordipc.core.socket.impl;

import dev.cbyrne.kdiscordipc.core.socket.RawPacket;
import dev.cbyrne.kdiscordipc.core.socket.Socket;
import dev.cbyrne.kdiscordipc.core.util.IntegerKt;
import java.io.DataInputStream;
import java.io.File;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0014\u0010\u001a\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001d\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Ldev/cbyrne/kdiscordipc/core/socket/impl/UnixSocket;", "Ldev/cbyrne/kdiscordipc/core/socket/Socket;", "<init>", "()V", "", "close", "Ljava/io/File;", "file", "connect", "(Ljava/io/File;)V", "Ldev/cbyrne/kdiscordipc/core/socket/RawPacket;", "read", "()Ldev/cbyrne/kdiscordipc/core/socket/RawPacket;", "", "length", "", "readBytes", "(I)[B", "readLittleEndianInt", "()I", "bytes", "write", "([B)V", "", "getConnected", "()Z", "connected", "Lorg/newsclub/net/unix/AFUNIXSocket;", "kotlin.jvm.PlatformType", "socket", "Lorg/newsclub/net/unix/AFUNIXSocket;", "KDiscordIPC"})
public final class UnixSocket
implements Socket {
    private final AFUNIXSocket socket = AFUNIXSocket.newInstance();

    @Override
    public boolean getConnected() {
        return this.socket.isConnected();
    }

    @Override
    public void connect(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.socket.connect(AFUNIXSocketAddress.of(file));
    }

    @Override
    @NotNull
    public RawPacket read() {
        int opcode = this.readLittleEndianInt();
        int length = this.readLittleEndianInt();
        DataInputStream stream = new DataInputStream(this.socket.getInputStream());
        byte[] data = new byte[length];
        stream.readFully(data);
        return new RawPacket(opcode, length, data);
    }

    private final int readLittleEndianInt() {
        return IntegerKt.reverse(ByteBuffer.wrap(this.readBytes(4)).getInt());
    }

    private final byte[] readBytes(int length) {
        byte[] array = new byte[length];
        this.socket.getInputStream().read(array, 0, length);
        return array;
    }

    @Override
    public void write(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.socket.getOutputStream().write(bytes);
    }

    @Override
    public void close() {
        this.socket.close();
    }
}

