/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.inventory.chocolatefactory;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.inventory.chocolatefactory.CFConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.events.ProfileJoinEvent;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.features.fame.ReminderUtils;
import at.hannibal2.skyhanni.features.inventory.chocolatefactory.CFApi;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.HypixelCommands;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SoundUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KProperty0;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\f\u0010\u0003J\u0015\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\r\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0016J\r\u0010\u0018\u001a\u00020\r\u00a2\u0006\u0004\b\u0018\u0010\u0019J\r\u0010\u001a\u001a\u00020\r\u00a2\u0006\u0004\b\u001a\u0010\u0019J\u000f\u0010\u001e\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\r\u0010 \u001a\u00020\u001b\u00a2\u0006\u0004\b\u001f\u0010\u001dJ\r\u0010#\u001a\u00020!\u00a2\u0006\u0004\b\"\u0010\u001dJ\u0017\u0010$\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b$\u0010\bR\u0014\u0010(\u001a\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0016\u0010,\u001a\u0004\u0018\u00010)8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0016\u0010-\u001a\u00020\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u0016\u0010/\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b/\u00100R\u0016\u00101\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b1\u00100R\u0014\u00102\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b2\u00103\u00a8\u00064"}, d2={"Lat/hannibal2/skyhanni/features/inventory/chocolatefactory/CFTimeTowerManager;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/ProfileJoinEvent;", "event", "", "onProfileJoin", "(Lat/hannibal2/skyhanni/events/ProfileJoinEvent;)V", "Lat/hannibal2/skyhanni/events/SecondPassedEvent;", "onSecondPassed", "(Lat/hannibal2/skyhanni/events/SecondPassedEvent;)V", "checkTimeTowerExpired", "", "inInventory", "checkTimeTowerWarning", "(Z)V", "", "timeTowerCharges", "()Ljava/lang/String;", "", "currentCharges", "()I", "maxCharges", "timeTowerFull", "()Z", "timeTowerActive", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "timeTowerEnds-uFjCsEo", "()J", "timeTowerEnds", "timeTowerFullTimeMark-uFjCsEo", "timeTowerFullTimeMark", "Lkotlin/time/Duration;", "timeTowerActiveDuration-UwyO8pc", "timeTowerActiveDuration", "onProfileChange", "Lat/hannibal2/skyhanni/config/features/inventory/chocolatefactory/CFConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/inventory/chocolatefactory/CFConfig;", "config", "Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$CFStorage;", "getProfileStorage", "()Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$CFStorage;", "profileStorage", "lastTimeTowerWarning", "J", "warnAboutNewCharge", "Z", "wasTimeTowerRecentlyActive", "HOVER_TEXT", "Ljava/lang/String;", "1.21.10"})
public final class CFTimeTowerManager {
    @NotNull
    public static final CFTimeTowerManager INSTANCE = new CFTimeTowerManager();
    private static long lastTimeTowerWarning = SimpleTimeMark.Companion.farPast();
    private static boolean warnAboutNewCharge;
    private static boolean wasTimeTowerRecentlyActive;
    @NotNull
    private static final String HOVER_TEXT = "\u00a7eClick to run /cf!";

    private CFTimeTowerManager() {
    }

    private final CFConfig getConfig() {
        return CFApi.INSTANCE.getConfig();
    }

    private final ProfileSpecificStorage.CFStorage getProfileStorage() {
        return CFApi.INSTANCE.getProfileStorage();
    }

    @HandleEvent
    public final void onProfileJoin(@NotNull ProfileJoinEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        wasTimeTowerRecentlyActive = false;
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onSecondPassed(@NotNull SecondPassedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ProfileSpecificStorage.CFStorage cFStorage = this.getProfileStorage();
        if (cFStorage == null) {
            return;
        }
        ProfileSpecificStorage.CFStorage profileStorage = cFStorage;
        if (SimpleTimeMark.isInPast-impl(profileStorage.getCurrentTimeTowerEnds-uFjCsEo())) {
            profileStorage.setCurrentTimeTowerEnds-gJLAdNM(SimpleTimeMark.Companion.farPast());
        }
        this.checkTimeTowerExpired();
        if (CFApi.INSTANCE.getInChocolateFactory()) {
            return;
        }
        if (SimpleTimeMark.isInPast-impl(this.timeTowerFullTimeMark-uFjCsEo())) {
            profileStorage.setCurrentTimeTowerUses(this.maxCharges());
        } else {
            long nextCharge = profileStorage.getNextTimeTower-uFjCsEo();
            while (SimpleTimeMark.isInPast-impl(nextCharge) && !SimpleTimeMark.isFarPast-impl(nextCharge)) {
                int n = profileStorage.getCurrentTimeTowerUses();
                profileStorage.setCurrentTimeTowerUses(n + 1);
                nextCharge = SimpleTimeMark.plus-qeHQSLg(nextCharge, CFApi.INSTANCE.timeTowerChargeDuration-UwyO8pc());
                profileStorage.setNextTimeTower-gJLAdNM(nextCharge);
                warnAboutNewCharge = true;
            }
        }
        if (this.currentCharges() > 0 && this.currentCharges() < this.maxCharges()) {
            if (!this.getConfig().getTimeTowerWarning() || this.timeTowerActive()) {
                return;
            }
            if (!warnAboutNewCharge) {
                return;
            }
            ChatUtils.clickableChat-ylHfTWE$default(ChatUtils.INSTANCE, "Your Time Tower has an available charge \u00a77(" + this.timeTowerCharges() + ")\u00a7e. Click here to open the Chocolate Factory menu.", CFTimeTowerManager::onSecondPassed$lambda$0, HOVER_TEXT, 0L, false, null, false, false, 248, null);
            SoundUtils.playBeepSound$default(SoundUtils.INSTANCE, 0.0f, 1, null);
            lastTimeTowerWarning = SimpleTimeMark.Companion.now-uFjCsEo();
            warnAboutNewCharge = false;
        }
        this.checkTimeTowerWarning(false);
    }

    private final void checkTimeTowerExpired() {
        boolean isTimeTowerActive = this.timeTowerActive();
        if (!isTimeTowerActive && wasTimeTowerRecentlyActive && this.getConfig().getTimeTowerReminder() && this.currentCharges() > 0) {
            String charges = StringUtils.INSTANCE.pluralize(this.currentCharges(), "charge", "charges", true);
            ChatUtils.clickableChat-ylHfTWE$default(ChatUtils.INSTANCE, "\u00a7cYour Time Tower just expired and has " + charges + " remaining. Click here to open the Chocolate Factory Menu.", CFTimeTowerManager::checkTimeTowerExpired$lambda$1, HOVER_TEXT, 0L, false, null, false, false, 248, null);
            SoundUtils.playBeepSound$default(SoundUtils.INSTANCE, 0.0f, 1, null);
        }
        wasTimeTowerRecentlyActive = isTimeTowerActive;
    }

    public final void checkTimeTowerWarning(boolean inInventory) {
        long warningSeparation;
        if (!CFApi.INSTANCE.isEnabled()) {
            return;
        }
        if (!this.getConfig().getTimeTowerWarning()) {
            return;
        }
        if (!this.timeTowerFull()) {
            return;
        }
        if (ReminderUtils.isBusy$default(ReminderUtils.INSTANCE, false, 1, null)) {
            return;
        }
        if (this.maxCharges() == 0) {
            return;
        }
        long l = inInventory ? DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS) : (warningSeparation = DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES));
        if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(lastTimeTowerWarning), (long)warningSeparation) < 0) {
            return;
        }
        ChatUtils.clickToActionOrDisable$default(ChatUtils.INSTANCE, "\u00a7cYour Time Tower is full \u00a77(" + this.timeTowerCharges() + ")\u00a7c, Use one to avoid wasting time tower usages! Click here to open the Chocolate Factory menu.", (KProperty0)new MutablePropertyReference0Impl(this.getConfig()){

            public Object get() {
                return ((CFConfig)this.receiver).getTimeTowerWarning();
            }

            public void set(Object value) {
                ((CFConfig)this.receiver).setTimeTowerWarning((Boolean)value);
            }
        }, "open Chocolate Factory", CFTimeTowerManager::checkTimeTowerWarning$lambda$2, false, 16, null);
        SoundUtils.playBeepSound$default(SoundUtils.INSTANCE, 0.0f, 1, null);
        lastTimeTowerWarning = SimpleTimeMark.Companion.now-uFjCsEo();
    }

    @NotNull
    public final String timeTowerCharges() {
        return this.currentCharges() + "/" + this.maxCharges() + " Charges";
    }

    public final int currentCharges() {
        ProfileSpecificStorage.CFStorage cFStorage = this.getProfileStorage();
        return cFStorage != null ? cFStorage.getCurrentTimeTowerUses() : -1;
    }

    private final int maxCharges() {
        ProfileSpecificStorage.CFStorage cFStorage = this.getProfileStorage();
        return cFStorage != null ? cFStorage.getMaxTimeTowerUses() : 3;
    }

    public final boolean timeTowerFull() {
        return this.currentCharges() >= this.maxCharges();
    }

    public final boolean timeTowerActive() {
        ProfileSpecificStorage.CFStorage cFStorage = this.getProfileStorage();
        long currentTime = cFStorage != null ? cFStorage.getLastDataSave-uFjCsEo() : SimpleTimeMark.Companion.farPast();
        long endTime = this.timeTowerEnds-uFjCsEo();
        return SimpleTimeMark.compareTo-gJLAdNM(endTime, currentTime) > 0;
    }

    private final long timeTowerEnds-uFjCsEo() {
        ProfileSpecificStorage.CFStorage cFStorage = this.getProfileStorage();
        return cFStorage != null ? cFStorage.getCurrentTimeTowerEnds-uFjCsEo() : SimpleTimeMark.Companion.farPast();
    }

    public final long timeTowerFullTimeMark-uFjCsEo() {
        ProfileSpecificStorage.CFStorage cFStorage = this.getProfileStorage();
        if (cFStorage == null) {
            return SimpleTimeMark.Companion.farPast();
        }
        ProfileSpecificStorage.CFStorage profileStorage = cFStorage;
        if (this.timeTowerFull()) {
            return SimpleTimeMark.Companion.farPast();
        }
        long nextChargeDuration = profileStorage.getNextTimeTower-uFjCsEo();
        int remainingChargesAfter = profileStorage.getMaxTimeTowerUses() - (profileStorage.getCurrentTimeTowerUses() + 1);
        long endTime = SimpleTimeMark.plus-qeHQSLg(nextChargeDuration, Duration.times-UwyO8pc((long)CFApi.INSTANCE.timeTowerChargeDuration-UwyO8pc(), (int)remainingChargesAfter));
        return endTime;
    }

    public final long timeTowerActiveDuration-UwyO8pc() {
        if (!this.timeTowerActive()) {
            return Duration.Companion.getZERO-UwyO8pc();
        }
        ProfileSpecificStorage.CFStorage cFStorage = this.getProfileStorage();
        long currentTime = cFStorage != null ? cFStorage.getLastDataSave-uFjCsEo() : SimpleTimeMark.Companion.farPast();
        ProfileSpecificStorage.CFStorage cFStorage2 = this.getProfileStorage();
        long endTime = cFStorage2 != null ? cFStorage2.getCurrentTimeTowerEnds-uFjCsEo() : SimpleTimeMark.Companion.farPast();
        return SimpleTimeMark.minus-I5LXd8s(endTime, currentTime);
    }

    @HandleEvent
    public final void onProfileChange(@NotNull ProfileJoinEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        lastTimeTowerWarning = SimpleTimeMark.Companion.farPast();
    }

    private static final Unit onSecondPassed$lambda$0() {
        HypixelCommands.INSTANCE.chocolateFactory();
        return Unit.INSTANCE;
    }

    private static final Unit checkTimeTowerExpired$lambda$1() {
        HypixelCommands.INSTANCE.chocolateFactory();
        return Unit.INSTANCE;
    }

    private static final Unit checkTimeTowerWarning$lambda$2() {
        HypixelCommands.INSTANCE.chocolateFactory();
        return Unit.INSTANCE;
    }
}

