/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.deps.moulconfig.ChromaColour;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.ExtendedChatColor;
import java.awt.Color;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\u0010\f\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0015\n\u0002\b\u0011\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\t\u001a\u00020\b*\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0011\u0010\u000b\u001a\u00020\u0004*\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0011\u0010\r\u001a\u00020\u0005*\u00020\b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0010*\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0016\u0010\u0015J\u0015\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0017\u0010\u0015J\u0015\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0018\u0010\u0015J\u0014\u0010\u001a\u001a\u00020\u0019*\u00020\u0004H\u0086\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0014\u0010\u001c\u001a\u00020\u0019*\u00020\u0004H\u0086\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001bJ\u0014\u0010\u001d\u001a\u00020\u0019*\u00020\u0004H\u0086\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001bJ\u0014\u0010\u001e\u001a\u00020\u0019*\u00020\u0004H\u0086\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001bJ%\u0010#\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00042\u0006\u0010\"\u001a\u00020!\u00a2\u0006\u0004\b#\u0010$J\u001b\u0010'\u001a\u00020\u000f*\u00020\u00042\b\b\u0002\u0010&\u001a\u00020%\u00a2\u0006\u0004\b'\u0010(J\u001b\u0010*\u001a\u00020\u0004*\u00020\u00042\b\b\u0002\u0010)\u001a\u00020!\u00a2\u0006\u0004\b*\u0010+J\u0019\u0010,\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b,\u0010-J\u0015\u0010/\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u000f\u00a2\u0006\u0004\b/\u00100J\u000f\u00102\u001a\u000201H\u0002\u00a2\u0006\u0004\b2\u00103J\u0015\u00104\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0010\u00a2\u0006\u0004\b4\u00105R\u0014\u00108\u001a\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0015\u0010;\u001a\u00020\u0005*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R\u0017\u0010<\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b<\u0010=\u001a\u0004\b>\u0010?R\u0014\u0010@\u001a\u0002018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b@\u0010A\u00a8\u0006B"}, d2={"Lat/hannibal2/skyhanni/utils/ColorUtils;", "", "<init>", "()V", "Ljava/awt/Color;", "", "alpha", "chromaSpeedMillis", "Lat/hannibal2/skyhanni/deps/moulconfig/ChromaColour;", "toChromaColor", "(Ljava/awt/Color;II)Lat/hannibal2/skyhanni/deps/moulconfig/ChromaColour;", "toColor", "(Lat/hannibal2/skyhanni/deps/moulconfig/ChromaColour;)Ljava/awt/Color;", "toInt", "(Lat/hannibal2/skyhanni/deps/moulconfig/ChromaColour;)I", "", "", "getFirstColorCode", "(Ljava/lang/String;)Ljava/lang/Character;", "color", "getAlpha", "(I)I", "getRed", "getGreen", "getBlue", "", "component1", "(Ljava/awt/Color;)F", "component2", "component3", "component4", "start", "end", "", "percent", "blendRGB", "(Ljava/awt/Color;Ljava/awt/Color;D)Ljava/awt/Color;", "", "hasAlpha", "getExtendedColorCode", "(Ljava/awt/Color;Z)Ljava/lang/String;", "factor", "darker", "(Ljava/awt/Color;D)Ljava/awt/Color;", "addAlpha", "(Ljava/awt/Color;I)Ljava/awt/Color;", "hex", "getColorFromHex", "(Ljava/lang/String;)I", "", "makeColorCodeArray", "()[I", "getColorCode", "(C)I", "getTooltipFixBool", "()Z", "tooltipFixBool", "getRgb", "(Lio/github/notenoughupdates/moulconfig/ChromaColour;)I", "rgb", "TRANSPARENT_COLOR", "Ljava/awt/Color;", "getTRANSPARENT_COLOR", "()Ljava/awt/Color;", "colorCodes", "[I", "1.21.10"})
@SourceDebugExtension(value={"SMAP\nColorUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorUtils.kt\nat/hannibal2/skyhanni/utils/ColorUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,99:1\n1#2:100\n*E\n"})
public final class ColorUtils {
    @NotNull
    public static final ColorUtils INSTANCE = new ColorUtils();
    @NotNull
    private static final Color TRANSPARENT_COLOR = new Color(0, 0, 0, 0);
    @NotNull
    private static final int[] colorCodes = INSTANCE.makeColorCodeArray();

    private ColorUtils() {
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ChromaColour toChromaColor(@NotNull Color $this$toChromaColor, int alpha, int chromaSpeedMillis) {
        Intrinsics.checkNotNullParameter((Object)$this$toChromaColor, (String)"<this>");
        return ChromaColour.Companion.fromRGB($this$toChromaColor.getRed(), $this$toChromaColor.getGreen(), $this$toChromaColor.getBlue(), chromaSpeedMillis, alpha);
    }

    public static /* synthetic */ ChromaColour toChromaColor$default(Color color, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = color.getAlpha();
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return ColorUtils.toChromaColor(color, n, n2);
    }

    @NotNull
    public final Color toColor(@NotNull ChromaColour $this$toColor) {
        Intrinsics.checkNotNullParameter((Object)$this$toColor, (String)"<this>");
        return $this$toColor.getEffectiveColour();
    }

    public final int toInt(@NotNull ChromaColour $this$toInt) {
        Intrinsics.checkNotNullParameter((Object)$this$toInt, (String)"<this>");
        return $this$toInt.getEffectiveColour().getRGB();
    }

    @Nullable
    public final Character getFirstColorCode(@NotNull String $this$getFirstColorCode) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$getFirstColorCode, (String)"<this>");
        String it = string = $this$getFirstColorCode;
        boolean bl = false;
        Character c = StringsKt.firstOrNull((CharSequence)it);
        char c2 = '\u00a7';
        String string2 = c != null && c.charValue() == c2 ? string : null;
        return string2 != null ? StringsKt.getOrNull((CharSequence)string2, (int)1) : null;
    }

    public final int getAlpha(int color) {
        return color >> 24 & 0xFF;
    }

    public final int getRed(int color) {
        return color >> 16 & 0xFF;
    }

    public final int getGreen(int color) {
        return color >> 8 & 0xFF;
    }

    public final int getBlue(int color) {
        return color & 0xFF;
    }

    private final boolean getTooltipFixBool() {
        return SkyHanniMod.feature.misc.getTransparentTooltips();
    }

    public final float component1(@NotNull Color $this$component1) {
        Intrinsics.checkNotNullParameter((Object)$this$component1, (String)"<this>");
        return !this.getTooltipFixBool() ? (float)$this$component1.getAlpha() / 255.0f : (float)$this$component1.getRed() / 255.0f;
    }

    public final float component2(@NotNull Color $this$component2) {
        Intrinsics.checkNotNullParameter((Object)$this$component2, (String)"<this>");
        return !this.getTooltipFixBool() ? (float)$this$component2.getRed() / 255.0f : (float)$this$component2.getGreen() / 255.0f;
    }

    public final float component3(@NotNull Color $this$component3) {
        Intrinsics.checkNotNullParameter((Object)$this$component3, (String)"<this>");
        return !this.getTooltipFixBool() ? (float)$this$component3.getGreen() / 255.0f : (float)$this$component3.getBlue() / 255.0f;
    }

    public final float component4(@NotNull Color $this$component4) {
        Intrinsics.checkNotNullParameter((Object)$this$component4, (String)"<this>");
        return !this.getTooltipFixBool() ? (float)$this$component4.getBlue() / 255.0f : (float)$this$component4.getAlpha() / 255.0f;
    }

    @NotNull
    public final Color blendRGB(@NotNull Color start2, @NotNull Color end, double percent) {
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        return new Color((int)((double)start2.getRed() * (1.0 - percent) + (double)end.getRed() * percent), (int)((double)start2.getGreen() * (1.0 - percent) + (double)end.getGreen() * percent), (int)((double)start2.getBlue() * (1.0 - percent) + (double)end.getBlue() * percent));
    }

    public final int getRgb(@NotNull ChromaColour $this$rgb) {
        Intrinsics.checkNotNullParameter((Object)$this$rgb, (String)"<this>");
        return this.toColor($this$rgb).getRGB();
    }

    @NotNull
    public final String getExtendedColorCode(@NotNull Color $this$getExtendedColorCode, boolean hasAlpha) {
        Intrinsics.checkNotNullParameter((Object)$this$getExtendedColorCode, (String)"<this>");
        return new ExtendedChatColor($this$getExtendedColorCode.getRGB(), hasAlpha).toString();
    }

    public static /* synthetic */ String getExtendedColorCode$default(ColorUtils colorUtils, Color color, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return colorUtils.getExtendedColorCode(color, bl);
    }

    @NotNull
    public final Color darker(@NotNull Color $this$darker, double factor) {
        Intrinsics.checkNotNullParameter((Object)$this$darker, (String)"<this>");
        return new Color(RangesKt.coerceIn((int)((int)((double)$this$darker.getRed() * factor)), (int)0, (int)255), RangesKt.coerceIn((int)((int)((double)$this$darker.getGreen() * factor)), (int)0, (int)255), RangesKt.coerceIn((int)((int)((double)$this$darker.getBlue() * factor)), (int)0, (int)255), $this$darker.getAlpha());
    }

    public static /* synthetic */ Color darker$default(ColorUtils colorUtils, Color color, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.7;
        }
        return colorUtils.darker(color, d);
    }

    @NotNull
    public final Color getTRANSPARENT_COLOR() {
        return TRANSPARENT_COLOR;
    }

    @NotNull
    public final Color addAlpha(@NotNull Color $this$addAlpha, int alpha) {
        Intrinsics.checkNotNullParameter((Object)$this$addAlpha, (String)"<this>");
        return new Color($this$addAlpha.getRed(), $this$addAlpha.getGreen(), $this$addAlpha.getBlue(), alpha);
    }

    public final int getColorFromHex(@NotNull String hex) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)hex, (String)"hex");
        Object object2 = this;
        try {
            ColorUtils $this$getColorFromHex_u24lambda_u241 = object2;
            boolean bl = false;
            Integer n = Integer.decode(hex);
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"decode(...)");
            object = Result.constructor-impl((Object)new Color(((Number)n).intValue()));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        Color color = (Color)(Result.isFailure-impl((Object)object2) ? null : object2);
        return color != null ? color.getRGB() : 0;
    }

    private final int[] makeColorCodeArray() {
        int[] colorCode = new int[32];
        for (int i2 = 0; i2 < 32; ++i2) {
            int j = (i2 >> 3 & 1) * 85;
            int k = (i2 >> 2 & 1) * 170 + j;
            int l = (i2 >> 1 & 1) * 170 + j;
            int i1 = (i2 >> 0 & 1) * 170 + j;
            if (i2 == 6) {
                k += 85;
            }
            if (i2 >= 16) {
                k /= 4;
                l /= 4;
                i1 /= 4;
            }
            colorCode[i2] = (k & 0xFF) << 16 | (l & 0xFF) << 8 | i1 & 0xFF;
        }
        return colorCode;
    }

    public final int getColorCode(char color) {
        char newColor = color;
        if (color == 'r') {
            newColor = 'f';
        }
        if (!StringsKt.contains$default((CharSequence)"0123456789abcdef", (char)newColor, (boolean)false, (int)2, null)) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"color", (Object)Character.valueOf(color))};
            ErrorManager.INSTANCE.skyHanniError("invalid color code", pairArray);
            throw new KotlinNothingValueException();
        }
        return colorCodes[StringsKt.indexOf$default((CharSequence)"0123456789abcdef", (char)newColor, (int)0, (boolean)false, (int)6, null)];
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ChromaColour toChromaColor(@NotNull Color $this$toChromaColor, int alpha) {
        Intrinsics.checkNotNullParameter((Object)$this$toChromaColor, (String)"<this>");
        return ColorUtils.toChromaColor$default($this$toChromaColor, alpha, 0, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ChromaColour toChromaColor(@NotNull Color $this$toChromaColor) {
        Intrinsics.checkNotNullParameter((Object)$this$toChromaColor, (String)"<this>");
        return ColorUtils.toChromaColor$default($this$toChromaColor, 0, 0, 3, null);
    }
}

