/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.slayer.spider;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.slayer.spider.SpiderConfig;
import at.hannibal2.skyhanni.data.EntityMovementData;
import at.hannibal2.skyhanni.data.SlayerApi;
import at.hannibal2.skyhanni.data.hypixel.chat.event.SystemMessageEvent;
import at.hannibal2.skyhanni.data.mob.Mob;
import at.hannibal2.skyhanni.events.MobEvent;
import at.hannibal2.skyhanni.events.entity.EntityClickEvent;
import at.hannibal2.skyhanni.events.entity.EntityMoveEvent;
import at.hannibal2.skyhanni.events.minecraft.WorldChangeEvent;
import at.hannibal2.skyhanni.utils.MobUtils;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1309;
import net.minecraft.class_1628;
import net.minecraft.class_2824;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\u000b\u001a\u00020\n*\u00020\tH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001d\u0010\u0015\u001a\u00020\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0003R\u0014\u0010\u001b\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0018\u0010\u001f\u001a\u0004\u0018\u00010\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u001d\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0\u001c8\u0006\u00a2\u0006\f\n\u0004\b!\u0010\u001e\u001a\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lat/hannibal2/skyhanni/features/slayer/spider/SlayerSpiderFeatures;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/MobEvent$Spawn$SkyblockMob;", "event", "", "onMobSpawn", "(Lat/hannibal2/skyhanni/events/MobEvent$Spawn$SkyblockMob;)V", "Lat/hannibal2/skyhanni/data/mob/Mob;", "", "isTier5", "(Lat/hannibal2/skyhanni/data/mob/Mob;)Z", "Lat/hannibal2/skyhanni/events/entity/EntityClickEvent;", "onClickEntity", "(Lat/hannibal2/skyhanni/events/entity/EntityClickEvent;)V", "Lat/hannibal2/skyhanni/data/hypixel/chat/event/SystemMessageEvent;", "onChat", "(Lat/hannibal2/skyhanni/data/hypixel/chat/event/SystemMessageEvent;)V", "Lat/hannibal2/skyhanni/events/entity/EntityMoveEvent;", "Lnet/minecraft/class_1628;", "onPlayerMove", "(Lat/hannibal2/skyhanni/events/entity/EntityMoveEvent;)V", "onWorldChange", "Lat/hannibal2/skyhanni/config/features/slayer/spider/SpiderConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/slayer/spider/SpiderConfig;", "config", "", "allTier5", "Ljava/util/Set;", "lastClickedTier5", "Lat/hannibal2/skyhanni/data/mob/Mob;", "stuckTier5", "getStuckTier5", "()Ljava/util/Set;", "1.21.5"})
public final class SlayerSpiderFeatures {
    @NotNull
    public static final SlayerSpiderFeatures INSTANCE = new SlayerSpiderFeatures();
    @NotNull
    private static final Set<Mob> allTier5 = new LinkedHashSet();
    @Nullable
    private static Mob lastClickedTier5;
    @NotNull
    private static final Set<Mob> stuckTier5;

    private SlayerSpiderFeatures() {
    }

    private final SpiderConfig getConfig() {
        return SlayerApi.INSTANCE.getConfig().getSpider();
    }

    @NotNull
    public final Set<Mob> getStuckTier5() {
        return stuckTier5;
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onMobSpawn(@NotNull MobEvent.Spawn.SkyblockMob event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Mob mob = event.getMob();
        if (this.isTier5(mob)) {
            allTier5.add(mob);
        }
    }

    private final boolean isTier5(Mob $this$isTier5) {
        return $this$isTier5.getMobType() == Mob.Type.SLAYER && $this$isTier5.getLevelOrTier() == 5 && Intrinsics.areEqual((Object)$this$isTier5.getName(), (Object)"Tarantula Broodfather");
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onClickEntity(@NotNull EntityClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getAction() != class_2824.class_5907.field_29172) {
            return;
        }
        Mob mob = MobUtils.INSTANCE.getMob(event.getClickedEntity());
        if (mob == null) {
            return;
        }
        Mob mob2 = mob;
        if (allTier5.contains(mob2)) {
            lastClickedTier5 = mob2;
        }
    }

    @HandleEvent
    public final void onChat(@NotNull SystemMessageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!Intrinsics.areEqual((Object)event.getMessage(), (Object)"\u00a7cYou need to kill the Broodfather's hatchlings before it can be damaged again!")) {
            return;
        }
        Mob mob = lastClickedTier5;
        if (mob == null) {
            return;
        }
        Mob mob2 = mob;
        mob2.highlight(this.getConfig().getHighlightInvincibleColor(), (Function0<Boolean>)((Function0)() -> SlayerSpiderFeatures.onChat$lambda$0(mob2)));
        stuckTier5.add(mob2);
        EntityMovementData.INSTANCE.addToTrack(mob2);
    }

    @HandleEvent
    public final void onPlayerMove(@NotNull EntityMoveEvent<class_1628> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        Mob mob = MobUtils.INSTANCE.getMob((class_1309)event.getEntity());
        if (mob == null) {
            return;
        }
        Mob mob2 = mob;
        if (stuckTier5.contains(mob2)) {
            stuckTier5.remove(mob2);
            mob2.removeHighlight();
        }
    }

    @HandleEvent(eventType=WorldChangeEvent.class)
    public final void onWorldChange() {
        allTier5.clear();
        lastClickedTier5 = null;
        stuckTier5.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean onChat$lambda$0(Mob $mob) {
        Intrinsics.checkNotNullParameter((Object)$mob, (String)"$mob");
        if (!INSTANCE.getConfig().getHighlightInvincible()) return false;
        if (!stuckTier5.contains($mob)) return false;
        return true;
    }

    static {
        stuckTier5 = new LinkedHashSet();
    }
}

