/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.utils.OSUtils;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.TimeUtils;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\bJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0005R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\u00020\u00068\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lat/hannibal2/skyhanni/utils/LorenzLogger;", "", "", "filePath", "<init>", "(Ljava/lang/String;)V", "Ljava/util/logging/Logger;", "getLogger", "()Ljava/util/logging/Logger;", "initLogger", "Ljava/io/File;", "file", "", "createParent", "(Ljava/io/File;)V", "text", "log", "Ljava/text/SimpleDateFormat;", "format", "Ljava/text/SimpleDateFormat;", "fileName", "Ljava/lang/String;", "logger", "Ljava/util/logging/Logger;", "Companion", "1.21.5"})
public final class LorenzLogger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SimpleDateFormat format;
    @NotNull
    private final String fileName;
    private Logger logger;
    @NotNull
    private static final File LOG_DIRECTORY = new File("config/skyhanni/logs");
    @NotNull
    private static String PREFIX_PATH;
    private static boolean hasDone;

    public LorenzLogger(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.format = new SimpleDateFormat("HH:mm:ss");
        this.fileName = PREFIX_PATH + filePath + ".log";
    }

    private final Logger getLogger() {
        Logger initLogger2;
        if (this.logger != null) {
            Logger logger = this.logger;
            if (logger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                logger = null;
            }
            return logger;
        }
        this.logger = initLogger2 = this.initLogger();
        return initLogger2;
    }

    private final Logger initLogger() {
        Logger logger = Logger.getLogger("Lorenz-Logger-" + System.nanoTime());
        try {
            this.createParent(new File(this.fileName));
            FileHandler handler = new FileHandler(this.fileName);
            handler.setEncoding("utf-8");
            logger.addHandler(handler);
            logger.setUseParentHandlers(false);
            handler.setFormatter(new Formatter(this){
                final /* synthetic */ LorenzLogger this$0;
                {
                    this.this$0 = $receiver;
                }

                public String format(LogRecord logRecord) {
                    Intrinsics.checkNotNullParameter((Object)logRecord, (String)"logRecord");
                    String message = logRecord.getMessage();
                    return TimeUtils.INSTANCE.formatCurrentTime(LorenzLogger.access$getFormat$p(this.this$0)) + " " + message + "\n";
                }
            });
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!hasDone && SkyBlockUtils.INSTANCE.getOnHypixel()) {
            hasDone = true;
            OSUtils.INSTANCE.deleteExpiredFiles-HG0u8IE(LOG_DIRECTORY, DurationKt.toDuration((int)SkyHanniMod.feature.getDev().getLogExpiryTime(), (DurationUnit)DurationUnit.DAYS));
        }
        Intrinsics.checkNotNull((Object)logger);
        return logger;
    }

    private final void createParent(File file) {
        File parent = file.getParentFile();
        if (parent != null && !parent.isDirectory()) {
            parent.mkdirs();
        }
    }

    public final void log(@Nullable String text) {
        this.getLogger().info(text);
    }

    public static final /* synthetic */ SimpleDateFormat access$getFormat$p(LorenzLogger $this) {
        return $this.format;
    }

    static {
        String format = TimeUtils.INSTANCE.formatCurrentTime(new SimpleDateFormat("yyyy_MM_dd/HH_mm_ss"));
        PREFIX_PATH = "config/skyhanni/logs/" + format + "/";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0016\u0010\b\u001a\u00020\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR\"\u0010\u000b\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lat/hannibal2/skyhanni/utils/LorenzLogger$Companion;", "", "<init>", "()V", "Ljava/io/File;", "LOG_DIRECTORY", "Ljava/io/File;", "", "PREFIX_PATH", "Ljava/lang/String;", "", "hasDone", "Z", "getHasDone", "()Z", "setHasDone", "(Z)V", "1.21.5"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getHasDone() {
            return hasDone;
        }

        public final void setHasDone(boolean bl) {
            hasDone = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

