/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.libautoupdate;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;

public class UpdateUtils {
    static final Gson gson = new Gson();
    private static Consumer<URLConnection> connectionPatcher = null;

    private UpdateUtils() {
    }

    public static File getJarFileContainingClass(Class<?> clazz) {
        URL location = clazz.getProtectionDomain().getCodeSource().getLocation();
        if (location == null) {
            return null;
        }
        String path = location.toString();
        if ((path = path.split("!", 2)[0]).startsWith("jar:")) {
            path = path.substring(4);
        }
        try {
            return new File(new URI(path));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void connect(InputStream from, OutputStream to) throws IOException {
        int r;
        byte[] buf = new byte[4096];
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
        }
    }

    public static String sha256sum(InputStream stream) throws IOException {
        try {
            int r;
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] buf = new byte[4096];
            while ((r = stream.read(buf)) != -1) {
                digest.update(buf, 0, r);
            }
            return String.format("%64s", new BigInteger(1, digest.digest()).toString(16)).replace(' ', '0').toLowerCase(Locale.ROOT);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static InputStream openUrlConnection(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        if (connectionPatcher != null) {
            connectionPatcher.accept(conn);
        }
        return conn.getInputStream();
    }

    public static void deleteDirectory(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void patchConnection(Consumer<URLConnection> connectionPatcher) {
        UpdateUtils.connectionPatcher = connectionPatcher;
    }

    public static <T> CompletableFuture<T> httpGet(String url, Gson gson, Type clazz) {
        return CompletableFuture.supplyAsync(() -> {
            Object object;
            block8: {
                InputStream is = UpdateUtils.openUrlConnection(new URL(url));
                try {
                    object = gson.fromJson((Reader)new InputStreamReader(is, StandardCharsets.UTF_8), clazz);
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new CompletionException(e);
                    }
                }
                is.close();
            }
            return object;
        });
    }
}

