/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.mixins.init;

import at.hannibal2.skyhanni.mixins.init.BeforeForLoopInjectionPoint;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.injection.InjectionPoint;

public class SkyHanniMixinPlugin
implements IMixinConfigPlugin {
    String mixinBasePackage = "at.hannibal2.skyhanni.mixins.transformers.";
    String mixinBaseDir = this.mixinBasePackage.replace(".", "/");
    List<String> mixins = null;

    public void onLoad(String mixinPackage) {
        InjectionPoint.register(BeforeForLoopInjectionPoint.class);
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return false;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public URL baseUrl(URL classUrl) {
        String string = classUrl.toString();
        if (classUrl.getProtocol().equals("jar")) {
            try {
                return new URL(string.substring(4, string.lastIndexOf(33)));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        if (string.endsWith(".class")) {
            try {
                return new URL(string.replace("\\", "/").replace(this.getClass().getCanonicalName().replace(".", "/") + ".class", ""));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return classUrl;
    }

    public void tryAddMixinClass(String className) {
        String norm = (className.endsWith(".class") ? className.substring(0, className.length() - ".class".length()) : className).replace("\\", "/").replace("/", ".");
        if (norm.startsWith(this.mixinBasePackage) && !norm.endsWith(".")) {
            this.mixins.add(norm.substring(this.mixinBasePackage.length()));
        }
    }

    public void walkDir(Path file) {
        System.out.println("Trying to find mixins from directory");
        try (Stream<Path> classes = Files.walk(file.resolve(this.mixinBaseDir), new FileVisitOption[0]);){
            classes.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(it -> file.relativize((Path)it).toString()).forEach(this::tryAddMixinClass);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getMixins() {
        Path file;
        if (this.mixins != null) {
            return this.mixins;
        }
        System.out.println("Trying to discover mixins");
        this.mixins = new ArrayList<String>();
        URL classUrl = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        System.out.println("Found classes at " + String.valueOf(classUrl));
        try {
            file = Paths.get(this.baseUrl(classUrl).toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        System.out.println("Base directory found at " + String.valueOf(file));
        if (Files.isDirectory(file, new LinkOption[0])) {
            this.walkDir(file);
        } else {
            this.walkJar(file);
        }
        System.out.println("Found mixins: " + String.valueOf(this.mixins));
        return this.mixins;
    }

    private void walkJar(Path file) {
        System.out.println("Trying to find mixins from jar file");
        try (ZipInputStream zis = new ZipInputStream(Files.newInputStream(file, new OpenOption[0]));){
            ZipEntry next;
            while ((next = zis.getNextEntry()) != null) {
                this.tryAddMixinClass(next.getName());
                zis.closeEntry();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

