/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.data;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.commands.CommandBuilder;
import at.hannibal2.skyhanni.config.commands.CommandCategory;
import at.hannibal2.skyhanni.config.commands.CommandRegistrationEvent;
import at.hannibal2.skyhanni.data.SackApi;
import at.hannibal2.skyhanni.events.DebugDataCollectEvent;
import at.hannibal2.skyhanni.events.InventoryCloseEvent;
import at.hannibal2.skyhanni.events.InventoryOpenEvent;
import at.hannibal2.skyhanni.events.ItemAddEvent;
import at.hannibal2.skyhanni.events.SackChangeEvent;
import at.hannibal2.skyhanni.events.chat.SkyHanniChatEvent;
import at.hannibal2.skyhanni.events.entity.ItemAddInInventoryEvent;
import at.hannibal2.skyhanni.events.item.ShardGainEvent;
import at.hannibal2.skyhanni.features.inventory.SuperCraftFeatures;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.NeuInternalName;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.TimeUtils;
import at.hannibal2.skyhanni.utils.collection.CollectionUtils;
import at.hannibal2.skyhanni.utils.collection.TimeLimitedSet;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001AB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J#\u0010\u001a\u001a\u00020\u0006*\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001cH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u001dJ\u0017\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001eH\u0007\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010\"\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020!H\u0007\u00a2\u0006\u0004\b\"\u0010#J\u0015\u0010&\u001a\b\u0012\u0004\u0012\u00020%0$H\u0002\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010)\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020(H\u0007\u00a2\u0006\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010,R\u001b\u00103\u001a\u00020.8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b1\u00102R\u0016\u00105\u001a\u0002048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b5\u00106R\u0016\u00108\u001a\u0002078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b8\u00109R \u0010;\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u0002070:8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b;\u0010<R\u0016\u0010=\u001a\u0002078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b=\u00109R\u001a\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00160>8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b?\u0010@\u00a8\u0006B"}, d2={"Lat/hannibal2/skyhanni/data/ItemAddManager;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/InventoryOpenEvent;", "event", "", "onInventoryOpen", "(Lat/hannibal2/skyhanni/events/InventoryOpenEvent;)V", "Lat/hannibal2/skyhanni/events/InventoryCloseEvent;", "onInventoryClose", "(Lat/hannibal2/skyhanni/events/InventoryCloseEvent;)V", "Lat/hannibal2/skyhanni/events/SackChangeEvent;", "onSackChange", "(Lat/hannibal2/skyhanni/events/SackChangeEvent;)V", "Lat/hannibal2/skyhanni/events/entity/ItemAddInInventoryEvent;", "onItemAdd", "(Lat/hannibal2/skyhanni/events/entity/ItemAddInInventoryEvent;)V", "Lat/hannibal2/skyhanni/events/item/ShardGainEvent;", "onShardGain", "(Lat/hannibal2/skyhanni/events/item/ShardGainEvent;)V", "Lat/hannibal2/skyhanni/data/ItemAddManager$Source;", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "internalName", "", "amount", "addItem", "(Lat/hannibal2/skyhanni/data/ItemAddManager$Source;Lat/hannibal2/skyhanni/utils/NeuInternalName;I)V", "Lat/hannibal2/skyhanni/events/ItemAddEvent;", "(Lat/hannibal2/skyhanni/events/ItemAddEvent;)V", "Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;", "onDebug", "(Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;)V", "Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;", "onCommandRegistration", "(Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;)V", "", "", "formattedList", "()Ljava/util/List;", "Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;)V", "ARCHFIEND_DICE", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "HIGH_CLASS_ARCHFIEND_DICE", "Ljava/util/regex/Pattern;", "diceRollChatPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getDiceRollChatPattern", "()Ljava/util/regex/Pattern;", "diceRollChatPattern", "", "inSackInventory", "Z", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastSackInventoryLeave", "J", "", "recentItems", "Ljava/util/Map;", "lastDiceRoll", "Lat/hannibal2/skyhanni/utils/collection/TimeLimitedSet;", "superCraftedItems", "Lat/hannibal2/skyhanni/utils/collection/TimeLimitedSet;", "Source", "1.21.10"})
@SourceDebugExtension(value={"SMAP\nItemAddManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemAddManager.kt\nat/hannibal2/skyhanni/data/ItemAddManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n1563#2:160\n1634#2,3:161\n126#3:164\n153#3,3:165\n8#4:168\n1#5:169\n*S KotlinDebug\n*F\n+ 1 ItemAddManager.kt\nat/hannibal2/skyhanni/data/ItemAddManager\n*L\n117#1:160\n117#1:161,3\n136#1:164\n136#1:165,3\n152#1:168\n152#1:169\n*E\n"})
public final class ItemAddManager {
    @NotNull
    public static final ItemAddManager INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final NeuInternalName ARCHFIEND_DICE;
    @NotNull
    private static final NeuInternalName HIGH_CLASS_ARCHFIEND_DICE;
    @NotNull
    private static final RepoPattern diceRollChatPattern$delegate;
    private static boolean inSackInventory;
    private static long lastSackInventoryLeave;
    @NotNull
    private static final Map<ItemAddEvent, SimpleTimeMark> recentItems;
    private static long lastDiceRoll;
    @NotNull
    private static final TimeLimitedSet<NeuInternalName> superCraftedItems;

    private ItemAddManager() {
    }

    private final Pattern getDiceRollChatPattern() {
        return (Pattern)diceRollChatPattern$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @HandleEvent
    public final void onInventoryOpen(@NotNull InventoryOpenEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (StringsKt.contains$default((CharSequence)event.getInventoryName(), (CharSequence)"Sack", (boolean)false, (int)2, null)) {
            inSackInventory = true;
        }
    }

    @HandleEvent
    public final void onInventoryClose(@NotNull InventoryCloseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (inSackInventory) {
            inSackInventory = false;
            lastSackInventoryLeave = SimpleTimeMark.Companion.now-uFjCsEo();
        }
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onSackChange(@NotNull SackChangeEvent event) {
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (inSackInventory) break block3;
                if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(lastSackInventoryLeave), (long)DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS)) >= 0) break block4;
            }
            return;
        }
        for (SackApi.SackChange sackChange : event.getSackChanges()) {
            int change = sackChange.getDelta();
            NeuInternalName internalName2 = sackChange.getInternalName();
            if (change <= 0 || superCraftedItems.contains(internalName2)) continue;
            this.addItem(Source.SACKS, internalName2, change);
        }
        superCraftedItems.clear();
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onItemAdd(@NotNull ItemAddInInventoryEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        NeuInternalName internalName2 = event.getInternalName();
        if (Intrinsics.areEqual((Object)internalName2, (Object)ARCHFIEND_DICE) || Intrinsics.areEqual((Object)internalName2, (Object)HIGH_CLASS_ARCHFIEND_DICE)) {
            if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(lastDiceRoll), (long)DurationKt.toDuration((int)500, (DurationUnit)DurationUnit.MILLISECONDS)) < 0) {
                return;
            }
        }
        this.addItem(Source.ITEM_ADD, internalName2, event.getAmount());
    }

    @HandleEvent
    public final void onShardGain(@NotNull ShardGainEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getAmount() < 0) {
            return;
        }
        this.addItem(Source.SHARD, event.getShardInternalName(), event.getAmount());
    }

    private final void addItem(Source $this$addItem, NeuInternalName internalName2, int amount) {
        new ItemAddEvent(internalName2, amount, $this$addItem).post();
    }

    @HandleEvent
    public final void onItemAdd(@NotNull ItemAddEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        recentItems.put(event, SimpleTimeMark.box-impl(SimpleTimeMark.Companion.now-uFjCsEo()));
        CollectionUtils.INSTANCE.evictOldestEntry(recentItems, 15);
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent
    public final void onDebug(@NotNull DebugDataCollectEvent event) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.title("Recent Item Adds");
        if (recentItems.isEmpty()) {
            event.addIrrelevant("no items added");
            return;
        }
        Iterable $this$map$iv = this.formattedList();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringUtils.removeColor$default(StringUtils.INSTANCE, (CharSequence)it, false, 1, null));
        }
        List text = (List)destination$iv$iv;
        if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(((SimpleTimeMark)CollectionsKt.maxOrThrow((Iterable)recentItems.values())).unbox-impl()), (long)DurationKt.toDuration((int)20, (DurationUnit)DurationUnit.SECONDS)) < 0) {
            event.addData(text);
        } else {
            event.addIrrelevant(text);
        }
    }

    @HandleEvent
    public final void onCommandRegistration(@NotNull CommandRegistrationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.register("shdebugrecentitemadds", (Function1<? super CommandBuilder, Unit>)((Function1)ItemAddManager::onCommandRegistration$lambda$2));
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> formattedList() {
        void $this$mapTo$iv$iv;
        Map<ItemAddEvent, SimpleTimeMark> $this$map$iv = recentItems;
        boolean $i$f$map = false;
        Map<ItemAddEvent, SimpleTimeMark> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ItemAddEvent itemAddEvent = (ItemAddEvent)entry.getKey();
            long time = ((SimpleTimeMark)entry.getValue()).unbox-impl();
            String itemName2 = ItemUtils.INSTANCE.getRepoItemName(itemAddEvent.getInternalName());
            int amount = itemAddEvent.getAmount();
            String source = itemAddEvent.getSource().getDisplayName();
            String passedSince = TimeUtils.format-ABIMYHs$default(TimeUtils.INSTANCE, SimpleTimeMark.passedSince-UwyO8pc(time), null, false, false, 0, false, false, 63, null);
            collection.add("\u00a7r" + itemName2 + " \u00a77(\u00a78x" + amount + "\u00a77) \u00a7e" + source + " \u00a7b" + passedSince + " ago \u00a77(\u00a7b" + SimpleTimeMark.toString-impl(time) + "\u00a77)");
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent
    public final void onChat(@NotNull SkyHanniChatEvent event) {
        void $this$matchMatcher$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (RegexUtils.INSTANCE.matches(this.getDiceRollChatPattern(), event.getMessage())) {
            lastDiceRoll = SimpleTimeMark.Companion.now-uFjCsEo();
        }
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern pattern = SuperCraftFeatures.INSTANCE.getCraftedPattern();
        String text$iv = event.getMessage();
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(text$iv);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull((Object)it$iv);
            Matcher $this$onChat_u24lambda_u244 = it$iv;
            boolean bl2 = false;
            String string = $this$onChat_u24lambda_u244.group("item");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            NeuInternalName internalName2 = NeuInternalName.Companion.fromItemName(string);
            if (SackApi.INSTANCE.getSackListInternalNames().contains(internalName2.asString())) {
                superCraftedItems.add(internalName2);
            }
        }
    }

    private static final Unit onCommandRegistration$lambda$2$lambda$1(String[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ChatUtils.INSTANCE.clickToClipboard("Recent Item adds", INSTANCE.formattedList());
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$2(CommandBuilder $this$register) {
        Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
        $this$register.setDescription("Shows recent item addions.");
        $this$register.setCategory(CommandCategory.DEVELOPER_DEBUG);
        $this$register.callback((Function1<? super String[], Unit>)((Function1)ItemAddManager::onCommandRegistration$lambda$2$lambda$1));
        return Unit.INSTANCE;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ItemAddManager.class, "diceRollChatPattern", "getDiceRollChatPattern()Ljava/util/regex/Pattern;", 0)))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new ItemAddManager();
        ARCHFIEND_DICE = NeuInternalName.Companion.toInternalName("ARCHFIEND_DICE");
        HIGH_CLASS_ARCHFIEND_DICE = NeuInternalName.Companion.toInternalName("HIGH_CLASS_ARCHFIEND_DICE");
        diceRollChatPattern$delegate = RepoPattern.Companion.pattern("data.itemmanager.diceroll", "\u00a7eYour \u00a7r\u00a7(?:5|6High Class )Archfiend Dice \u00a7r\u00a7erolled a \u00a7r\u00a7.(?<number>.)\u00a7r\u00a7e! Bonus: \u00a7r\u00a7.(?<hearts>.*)\u2764");
        lastSackInventoryLeave = SimpleTimeMark.Companion.farPast();
        recentItems = new LinkedHashMap();
        lastDiceRoll = SimpleTimeMark.Companion.farPast();
        superCraftedItems = new TimeLimitedSet(DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS), null, 2, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0006\u001a\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lat/hannibal2/skyhanni/data/ItemAddManager$Source;", "", "", "displayName", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "Ljava/lang/String;", "getDisplayName", "()Ljava/lang/String;", "ITEM_ADD", "SACKS", "SHARD", "COMMAND", "1.21.10"})
    public static final class Source
    extends Enum<Source> {
        @NotNull
        private final String displayName;
        public static final /* enum */ Source ITEM_ADD = new Source("Picked up in inventory");
        public static final /* enum */ Source SACKS = new Source("Went into Sacks");
        public static final /* enum */ Source SHARD = new Source("Went into Hunting Box");
        public static final /* enum */ Source COMMAND = new Source("Invented via command");
        private static final /* synthetic */ Source[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Source(String displayName) {
            this.displayName = displayName;
        }

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        public static Source[] values() {
            return (Source[])$VALUES.clone();
        }

        public static Source valueOf(String value) {
            return Enum.valueOf(Source.class, value);
        }

        @NotNull
        public static EnumEntries<Source> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = sourceArray = new Source[]{Source.ITEM_ADD, Source.SACKS, Source.SHARD, Source.COMMAND};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

