/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.inventory;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.garden.GardenConfig;
import at.hannibal2.skyhanni.data.GardenCropMilestones;
import at.hannibal2.skyhanni.events.InventoryCloseEvent;
import at.hannibal2.skyhanni.events.RenderInventoryItemTipEvent;
import at.hannibal2.skyhanni.events.garden.farming.CropMilestoneUpdateEvent;
import at.hannibal2.skyhanni.events.minecraft.ToolTipEvent;
import at.hannibal2.skyhanni.features.garden.CropType;
import at.hannibal2.skyhanni.features.garden.GardenApi;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.collection.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0016\u001a\u00020\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0014\u0010\u001b\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001c"}, d2={"Lat/hannibal2/skyhanni/features/garden/inventory/GardenCropMilestoneInventory;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/garden/farming/CropMilestoneUpdateEvent;", "event", "", "onCropMilestoneUpdate", "(Lat/hannibal2/skyhanni/events/garden/farming/CropMilestoneUpdateEvent;)V", "Lat/hannibal2/skyhanni/events/InventoryCloseEvent;", "onInventoryClose", "(Lat/hannibal2/skyhanni/events/InventoryCloseEvent;)V", "Lat/hannibal2/skyhanni/events/RenderInventoryItemTipEvent;", "onRenderItemTip", "(Lat/hannibal2/skyhanni/events/RenderInventoryItemTipEvent;)V", "Lat/hannibal2/skyhanni/events/minecraft/ToolTipEvent;", "onToolTip", "(Lat/hannibal2/skyhanni/events/minecraft/ToolTipEvent;)V", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "", "average", "D", "Lat/hannibal2/skyhanni/config/features/garden/GardenConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/GardenConfig;", "config", "1.21.10"})
public final class GardenCropMilestoneInventory {
    @NotNull
    public static final GardenCropMilestoneInventory INSTANCE = new GardenCropMilestoneInventory();
    private static double average = -1.0;

    private GardenCropMilestoneInventory() {
    }

    private final GardenConfig getConfig() {
        return GardenApi.INSTANCE.getConfig();
    }

    @HandleEvent
    public final void onCropMilestoneUpdate(@NotNull CropMilestoneUpdateEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.getConfig().getNumber().getAverageCropMilestone()) {
            return;
        }
        List tiers = new ArrayList();
        for (CropType cropType : CropType.getEntries()) {
            long counter = GardenCropMilestones.INSTANCE.getCounter(cropType);
            boolean allowOverflow = this.getConfig().getCropMilestones().getOverflow().getInventoryStackSize();
            int tier = GardenCropMilestones.INSTANCE.getTierForCropCount(counter, cropType, allowOverflow);
            tiers.add(Double.valueOf(tier));
        }
        average = NumberUtil.INSTANCE.roundTo(CollectionsKt.sumOfDouble((Iterable)tiers) / (double)CropType.getEntries().size(), 2);
    }

    @HandleEvent
    public final void onInventoryClose(@NotNull InventoryCloseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        average = -1.0;
    }

    @HandleEvent
    public final void onRenderItemTip(@NotNull RenderInventoryItemTipEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (average == -1.0) {
            return;
        }
        if (event.getSlot().field_7874 == 38) {
            event.setOffsetY(-23);
            event.setOffsetX(-50);
            event.setAlignLeft(false);
            event.setStackTip("\u00a76Average Crop Milestone: \u00a7e" + average);
        }
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onToolTip(@NotNull ToolTipEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.getConfig().getTooltipTweak().getCropMilestoneTotalProgress()) {
            return;
        }
        CropType cropType = GardenCropMilestones.INSTANCE.getCropTypeByLore(event.getItemStack());
        if (cropType == null) {
            return;
        }
        CropType crop = cropType;
        int tier = GardenCropMilestones.getTierForCropCount$default(GardenCropMilestones.INSTANCE, GardenCropMilestones.INSTANCE.getCounter(crop), crop, false, 4, null);
        if (tier >= 20) {
            return;
        }
        int maxTier = GardenCropMilestones.INSTANCE.getMaxTier();
        long maxCounter = GardenCropMilestones.getCropsForTier$default(GardenCropMilestones.INSTANCE, maxTier, crop, false, 4, null);
        String[] stringArray = new String[]{"\u00a77Rewards:"};
        Integer n = CollectionUtils.INSTANCE.indexOfFirst(event.toolTipRemovedPrefix(), stringArray);
        if (n == null) {
            return;
        }
        int index = n;
        double counter = GardenCropMilestones.INSTANCE.getCounter(crop);
        double percentage = counter / (double)maxCounter;
        String percentageFormat = NumberUtil.INSTANCE.formatPercentage(percentage);
        event.getToolTip().add(index, " ");
        Object progressBar2 = StringUtils.INSTANCE.progressBar(percentage, 19);
        event.getToolTip().add(index, progressBar2 + " \u00a7e" + NumberUtil.INSTANCE.addSeparators(counter) + "\u00a76/\u00a7e" + NumberUtil.shortFormat$default(NumberUtil.INSTANCE, maxCounter, false, 1, null));
        event.getToolTip().add(index, "\u00a77Progress to Tier " + maxTier + ": \u00a7e" + percentageFormat);
    }

    @HandleEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.numberAverageCropMilestone", "garden.number.averageCropMilestone", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.cropMilestoneTotalProgress", "garden.tooltipTweak.cropMilestoneTotalProgress", null, 8, null);
    }
}

