/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.mining;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.mining.glacite.ColdOverlayConfig;
import at.hannibal2.skyhanni.data.IslandTypeTags;
import at.hannibal2.skyhanni.events.ColdUpdateEvent;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.GuiRenderUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.compat.DrawContextUtils;
import at.hannibal2.skyhanni.utils.compat.TextCompatKt;
import at.hannibal2.skyhanni.utils.render.ModernGlStateManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0015\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0017\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0018R\u0016\u0010\u001b\u001a\u00020\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001e\u001a\u00020\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lat/hannibal2/skyhanni/features/mining/ColdOverlay;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "event", "", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "", "getColdAlpha", "()F", "Lat/hannibal2/skyhanni/events/ColdUpdateEvent;", "onColdUpdate", "(Lat/hannibal2/skyhanni/events/ColdUpdateEvent;)V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/mining/glacite/ColdOverlayConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/mining/glacite/ColdOverlayConfig;", "config", "", "cold", "I", "lastCold", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastColdUpdate", "J", "Lnet/minecraft/class_2960;", "textureLocation", "Lnet/minecraft/class_2960;", "1.21.10"})
public final class ColdOverlay {
    @NotNull
    public static final ColdOverlay INSTANCE = new ColdOverlay();
    private static int cold;
    private static int lastCold;
    private static long lastColdUpdate;
    @NotNull
    private static final class_2960 textureLocation;

    private ColdOverlay() {
    }

    private final ColdOverlayConfig getConfig() {
        return SkyHanniMod.feature.getMining().getColdOverlay();
    }

    @HandleEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        float alpha = this.getColdAlpha();
        if (alpha == 0.0f) {
            return;
        }
        DrawContextUtils.INSTANCE.pushMatrix();
        ModernGlStateManager.INSTANCE.pushAttrib();
        GL11.glDepthMask((boolean)false);
        DrawContextUtils.INSTANCE.translate(0.0f, 0.0f, -500.0f);
        GuiRenderUtils.INSTANCE.drawTexturedRect(0.0f, 0.0f, textureLocation, alpha);
        GL11.glDepthMask((boolean)true);
        DrawContextUtils.INSTANCE.popMatrix();
        ModernGlStateManager.INSTANCE.popAttrib();
    }

    private final float getColdAlpha() {
        float coldInterp = NumberUtil.INSTANCE.interpolate(cold, lastCold, SimpleTimeMark.toMillis-impl(lastColdUpdate));
        float coldPercentage = (coldInterp - (float)this.getConfig().getColdThreshold()) / (float)(100 - this.getConfig().getColdThreshold());
        return RangesKt.coerceAtLeast((float)coldPercentage, (float)0.0f) * (this.getConfig().getMaxAlpha() / (float)100);
    }

    @HandleEvent
    public final void onColdUpdate(@NotNull ColdUpdateEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        long duration = event.getCold() == 0 ? DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS) : DurationKt.toDuration((int)0, (DurationUnit)DurationUnit.SECONDS);
        DelayedRun.INSTANCE.runDelayed-bouF650(duration, (Function0<Unit>)((Function0)() -> ColdOverlay.onColdUpdate$lambda$0(event)));
    }

    private final boolean isEnabled() {
        return IslandTypeTags.INSTANCE.getIS_COLD().inAny() && this.getConfig().getEnabled();
    }

    private static final Unit onColdUpdate$lambda$0(ColdUpdateEvent $event) {
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        lastCold = cold;
        cold = $event.getCold();
        lastColdUpdate = SimpleTimeMark.Companion.now-uFjCsEo();
        return Unit.INSTANCE;
    }

    static {
        lastColdUpdate = SimpleTimeMark.Companion.farPast();
        textureLocation = TextCompatKt.createResourceLocation("skyhanni", "cold_overlay.png");
    }
}

