/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.combat.mobs;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.combat.MobsConfig;
import at.hannibal2.skyhanni.data.mob.Mob;
import at.hannibal2.skyhanni.events.MobEvent;
import at.hannibal2.skyhanni.events.entity.EntityHealthUpdateEvent;
import at.hannibal2.skyhanni.events.entity.EntityMaxHealthUpdateEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniRenderWorldEvent;
import at.hannibal2.skyhanni.mixins.hooks.RenderLivingEntityHelper;
import at.hannibal2.skyhanni.utils.ColorUtils;
import at.hannibal2.skyhanni.utils.EntityUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.LorenzVecKt;
import at.hannibal2.skyhanni.utils.compat.EntityCompatKt;
import at.hannibal2.skyhanni.utils.compat.TextCompatKt;
import at.hannibal2.skyhanni.utils.render.WorldRenderUtils;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1549;
import net.minecraft.class_1560;
import net.minecraft.class_1628;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_745;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\f\u0010\u0003J\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u000e\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0003J\u0017\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001cR\u0014\u0010!\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0018\u0010\"\u001a\u0004\u0018\u00010\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010#R$\u0010'\u001a\u0012\u0012\u0004\u0012\u00020%0$j\b\u0012\u0004\u0012\u00020%`&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010(\u00a8\u0006)"}, d2={"Lat/hannibal2/skyhanni/features/combat/mobs/MobHighlight;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/MobEvent$Spawn$SkyblockMob;", "event", "", "onMobSpawn", "(Lat/hannibal2/skyhanni/events/MobEvent$Spawn$SkyblockMob;)V", "Lat/hannibal2/skyhanni/events/MobEvent$DeSpawn$SkyblockMob;", "onMobDespawn", "(Lat/hannibal2/skyhanni/events/MobEvent$DeSpawn$SkyblockMob;)V", "onTick", "Lat/hannibal2/skyhanni/events/entity/EntityHealthUpdateEvent;", "onEntityHealthUpdate", "(Lat/hannibal2/skyhanni/events/entity/EntityHealthUpdateEvent;)V", "Lat/hannibal2/skyhanni/events/entity/EntityMaxHealthUpdateEvent;", "(Lat/hannibal2/skyhanni/events/entity/EntityMaxHealthUpdateEvent;)V", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;)V", "onWorldChange", "Lnet/minecraft/class_1628;", "entity", "checkArachne", "(Lnet/minecraft/class_1628;)V", "Lnet/minecraft/class_1309;", "markArachneMinis", "(Lnet/minecraft/class_1309;)V", "markArachne", "Lat/hannibal2/skyhanni/config/features/combat/MobsConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/combat/MobsConfig;", "config", "arachne", "Lnet/minecraft/class_1309;", "Ljava/util/HashSet;", "Lat/hannibal2/skyhanni/data/mob/Mob;", "Lkotlin/collections/HashSet;", "toHighlightRunicMobs", "Ljava/util/HashSet;", "1.21.7"})
@SourceDebugExtension(value={"SMAP\nMobHighlight.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MobHighlight.kt\nat/hannibal2/skyhanni/features/combat/mobs/MobHighlight\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,179:1\n1869#2,2:180\n*S KotlinDebug\n*F\n+ 1 MobHighlight.kt\nat/hannibal2/skyhanni/features/combat/mobs/MobHighlight\n*L\n50#1:180,2\n*E\n"})
public final class MobHighlight {
    @NotNull
    public static final MobHighlight INSTANCE = new MobHighlight();
    @Nullable
    private static class_1309 arachne;
    @NotNull
    private static final HashSet<Mob> toHighlightRunicMobs;

    private MobHighlight() {
    }

    private final MobsConfig getConfig() {
        return SkyHanniMod.feature.getCombat().getMobs();
    }

    @HandleEvent
    public final void onMobSpawn(@NotNull MobEvent.Spawn.SkyblockMob event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Mob mob = event.getMob();
        if (mob.isRunic()) {
            toHighlightRunicMobs.add(mob);
        }
    }

    @HandleEvent
    public final void onMobDespawn(@NotNull MobEvent.DeSpawn.SkyblockMob event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Mob mob = event.getMob();
        if (mob.isRunic()) {
            toHighlightRunicMobs.remove(mob);
        }
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onTick() {
        if (!this.getConfig().getRunicMobHighlight()) {
            return;
        }
        Iterable $this$forEach$iv = toHighlightRunicMobs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Mob it = (Mob)element$iv;
            boolean bl = false;
            it.highlight(LorenzColor.toChromaColor$default(LorenzColor.LIGHT_PURPLE, 0, 0, 3, null), (Function0<Boolean>)((Function0)MobHighlight::onTick$lambda$1$lambda$0));
        }
        toHighlightRunicMobs.clear();
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onEntityHealthUpdate(@NotNull EntityHealthUpdateEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        class_1309 entity = event.getEntity();
        int baseMaxHealth = EntityUtils.INSTANCE.getBaseMaxHealth(entity);
        if (this.getConfig().getCorruptedMobHighlight() && event.getHealth() == baseMaxHealth * 3) {
            RenderLivingEntityHelper.INSTANCE.setEntityColorWithNoHurtTime(entity, ColorUtils.INSTANCE.addAlpha(LorenzColor.DARK_PURPLE.toColor(), 127), (Function0<Boolean>)((Function0)MobHighlight::onEntityHealthUpdate$lambda$2));
        }
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onEntityHealthUpdate(@NotNull EntityMaxHealthUpdateEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        class_1309 entity = event.getEntity();
        int maxHealth = event.getMaxHealth();
        if (this.getConfig().getArachneKeeperHighlight() && (maxHealth == 3000 || maxHealth == 12000) && entity instanceof class_1549) {
            RenderLivingEntityHelper.INSTANCE.setEntityColorWithNoHurtTime(entity, ColorUtils.INSTANCE.addAlpha(LorenzColor.DARK_BLUE.toColor(), 127), (Function0<Boolean>)((Function0)MobHighlight::onEntityHealthUpdate$lambda$3));
        }
        if (this.getConfig().getCorleoneHighlighter() && maxHealth == 1000000 && entity instanceof class_745 && Intrinsics.areEqual((Object)TextCompatKt.formattedTextCompatLessResets(((class_745)entity).method_5477()), (Object)"Team Treasurite")) {
            RenderLivingEntityHelper.INSTANCE.setEntityColorWithNoHurtTime(entity, ColorUtils.INSTANCE.addAlpha(LorenzColor.DARK_PURPLE.toColor(), 127), (Function0<Boolean>)((Function0)MobHighlight::onEntityHealthUpdate$lambda$4));
        }
        if (entity instanceof class_1560) {
            class_2248 heldItem;
            boolean isBruiser;
            boolean isZealot = maxHealth == 13000 || maxHealth == 52000;
            boolean bl = isBruiser = maxHealth == 65000 || maxHealth == 260000;
            if (!isZealot && !isBruiser) {
                return;
            }
            if (this.getConfig().getZealotBruiserHighlighter()) {
                RenderLivingEntityHelper.INSTANCE.setEntityColorWithNoHurtTime(entity, ColorUtils.INSTANCE.addAlpha(LorenzColor.DARK_AQUA.toColor(), 127), (Function0<Boolean>)((Function0)MobHighlight::onEntityHealthUpdate$lambda$5));
            }
            class_2680 class_26802 = EntityUtils.INSTANCE.getBlockInHand((class_1560)entity);
            Object object = heldItem = class_26802 != null ? class_26802.method_26204() : null;
            if (this.getConfig().getChestZealotHighlighter() && Intrinsics.areEqual((Object)heldItem, (Object)class_2246.field_10443)) {
                RenderLivingEntityHelper.INSTANCE.setEntityColorWithNoHurtTime(entity, ColorUtils.INSTANCE.addAlpha(LorenzColor.GREEN.toColor(), 127), (Function0<Boolean>)((Function0)MobHighlight::onEntityHealthUpdate$lambda$6));
            }
            if (this.getConfig().getSpecialZealotHighlighter() && Intrinsics.areEqual((Object)heldItem, (Object)class_2246.field_10398)) {
                RenderLivingEntityHelper.INSTANCE.setEntityColorWithNoHurtTime(entity, ColorUtils.INSTANCE.addAlpha(LorenzColor.DARK_RED.toColor(), 50), (Function0<Boolean>)((Function0)MobHighlight::onEntityHealthUpdate$lambda$7));
            }
        }
        if (entity instanceof class_1628) {
            this.checkArachne((class_1628)entity);
        }
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onRenderWorld(@NotNull SkyHanniRenderWorldEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.getConfig().getLineToArachne()) {
            return;
        }
        class_1309 class_13092 = arachne;
        if (class_13092 == null) {
            return;
        }
        class_1309 arachne = class_13092;
        if (EntityCompatKt.getDeceased((class_1297)arachne) || EntityCompatKt.findHealthReal(arachne) <= 0.0f) {
            MobHighlight.arachne = null;
            return;
        }
        if (!EntityUtils.canBeSeen$default(EntityUtils.INSTANCE, (class_1297)arachne, 10, 0.0, false, 6, null)) {
            return;
        }
        WorldRenderUtils.INSTANCE.drawLineToEye(event, LorenzVec.up$default(LorenzVecKt.getLorenzVec((class_1297)arachne), null, 1, null), LorenzColor.toChromaColor$default(LorenzColor.RED, 0, 0, 3, null), this.getConfig().getLineToArachneWidth(), true);
    }

    @HandleEvent
    public final void onWorldChange() {
        arachne = null;
        toHighlightRunicMobs.clear();
    }

    private final void checkArachne(class_1628 entity) {
        if (!this.getConfig().getArachneBossHighlighter() && !this.getConfig().getLineToArachne()) {
            return;
        }
        if (!(EntityUtils.hasNameTagWith$default(EntityUtils.INSTANCE, (class_1309)entity, 1, "[\u00a77Lv300\u00a78] \u00a7cArachne", false, 0.0, false, 28, null) || EntityUtils.hasNameTagWith$default(EntityUtils.INSTANCE, (class_1309)entity, 1, "[\u00a77Lv300\u00a78] \u00a7lArachne", false, 0.0, false, 28, null) || EntityUtils.hasNameTagWith$default(EntityUtils.INSTANCE, (class_1309)entity, 1, "[\u00a77Lv500\u00a78] \u00a7cArachne", false, 0.0, false, 28, null) || EntityUtils.hasNameTagWith$default(EntityUtils.INSTANCE, (class_1309)entity, 1, "[\u00a77Lv500\u00a78] \u00a7lArachne", false, 0.0, false, 28, null))) {
            return;
        }
        if (entity instanceof class_1549) {
            this.markArachneMinis((class_1309)entity);
        } else if (EntityUtils.INSTANCE.getBaseMaxHealth((class_1309)entity) == 20000 || EntityUtils.INSTANCE.getBaseMaxHealth((class_1309)entity) == 100000) {
            arachne = (class_1309)entity;
            this.markArachne((class_1309)entity);
        }
    }

    private final void markArachneMinis(class_1309 entity) {
        RenderLivingEntityHelper.INSTANCE.setEntityColorWithNoHurtTime(entity, ColorUtils.INSTANCE.addAlpha(LorenzColor.GOLD.toColor(), 50), (Function0<Boolean>)((Function0)MobHighlight::markArachneMinis$lambda$8));
    }

    private final void markArachne(class_1309 entity) {
        RenderLivingEntityHelper.INSTANCE.setEntityColorWithNoHurtTime(entity, ColorUtils.INSTANCE.addAlpha(LorenzColor.RED.toColor(), 50), (Function0<Boolean>)((Function0)MobHighlight::markArachne$lambda$9));
    }

    private static final boolean onTick$lambda$1$lambda$0() {
        return INSTANCE.getConfig().getRunicMobHighlight();
    }

    private static final boolean onEntityHealthUpdate$lambda$2() {
        return INSTANCE.getConfig().getCorruptedMobHighlight();
    }

    private static final boolean onEntityHealthUpdate$lambda$3() {
        return INSTANCE.getConfig().getArachneKeeperHighlight();
    }

    private static final boolean onEntityHealthUpdate$lambda$4() {
        return INSTANCE.getConfig().getCorleoneHighlighter();
    }

    private static final boolean onEntityHealthUpdate$lambda$5() {
        return INSTANCE.getConfig().getZealotBruiserHighlighter();
    }

    private static final boolean onEntityHealthUpdate$lambda$6() {
        return INSTANCE.getConfig().getChestZealotHighlighter();
    }

    private static final boolean onEntityHealthUpdate$lambda$7() {
        return INSTANCE.getConfig().getSpecialZealotHighlighter();
    }

    private static final boolean markArachneMinis$lambda$8() {
        return INSTANCE.getConfig().getArachneBossHighlighter();
    }

    private static final boolean markArachne$lambda$9() {
        return INSTANCE.getConfig().getArachneBossHighlighter();
    }

    static {
        toHighlightRunicMobs = new HashSet();
    }
}

