/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.dungeon;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.dungeon.SecretChimeConfig;
import at.hannibal2.skyhanni.data.ClickedBlockType;
import at.hannibal2.skyhanni.data.jsonobjects.repo.ItemsJson;
import at.hannibal2.skyhanni.data.repo.AbstractRepoManager;
import at.hannibal2.skyhanni.data.repo.AbstractRepoReloadEvent;
import at.hannibal2.skyhanni.events.MobEvent;
import at.hannibal2.skyhanni.events.PlaySoundEvent;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.events.dungeon.DungeonBlockClickEvent;
import at.hannibal2.skyhanni.events.entity.EntityRemovedEvent;
import at.hannibal2.skyhanni.features.dungeon.DungeonApi;
import at.hannibal2.skyhanni.utils.NeuInternalName;
import at.hannibal2.skyhanni.utils.SoundUtils;
import at.hannibal2.skyhanni.utils.compat.TextCompatKt;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.reflect.jvm.ReflectJvmMapping;
import net.minecraft.class_1542;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\u000e\u001a\u00020\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0013\u0010\u0014\u001a\u00020\u0013*\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0013\u0010\u0016\u001a\u00020\u0013*\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0015J\u0017\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0017H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001c\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u001c\u0010\u0003R\u0014\u0010 \u001a\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001c\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lat/hannibal2/skyhanni/features/dungeon/DungeonSecretChime;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/dungeon/DungeonBlockClickEvent;", "event", "", "onDungeonClickedBlock", "(Lat/hannibal2/skyhanni/events/dungeon/DungeonBlockClickEvent;)V", "Lat/hannibal2/skyhanni/events/MobEvent$DeSpawn$SkyblockMob;", "onMobDeSpawn", "(Lat/hannibal2/skyhanni/events/MobEvent$DeSpawn$SkyblockMob;)V", "Lat/hannibal2/skyhanni/events/entity/EntityRemovedEvent;", "Lnet/minecraft/class_1542;", "onItemPickup", "(Lat/hannibal2/skyhanni/events/entity/EntityRemovedEvent;)V", "Lat/hannibal2/skyhanni/events/PlaySoundEvent;", "onPlaySound", "(Lat/hannibal2/skyhanni/events/PlaySoundEvent;)V", "", "isChestSound", "(Lat/hannibal2/skyhanni/events/PlaySoundEvent;)Z", "isLeverSound", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "isEnabled", "()Z", "playSound", "Lat/hannibal2/skyhanni/config/features/dungeon/SecretChimeConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/dungeon/SecretChimeConfig;", "config", "", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "dungeonSecretItems", "Ljava/util/Set;", "1.21.7"})
@SourceDebugExtension(value={"SMAP\nDungeonSecretChime.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DungeonSecretChime.kt\nat/hannibal2/skyhanni/features/dungeon/DungeonSecretChime\n+ 2 AbstractRepoReloadEvent.kt\nat/hannibal2/skyhanni/data/repo/AbstractRepoReloadEvent\n+ 3 AbstractRepoManager.kt\nat/hannibal2/skyhanni/data/repo/AbstractRepoManager\n+ 4 JsonUtils.kt\nat/hannibal2/skyhanni/utils/json/JsonUtilsKt\n*L\n1#1,95:1\n13#2,7:96\n21#2,6:113\n156#3,5:103\n161#3,4:109\n24#4:108\n*S KotlinDebug\n*F\n+ 1 DungeonSecretChime.kt\nat/hannibal2/skyhanni/features/dungeon/DungeonSecretChime\n*L\n82#1:96,7\n82#1:113,6\n82#1:103,5\n82#1:109,4\n82#1:108\n*E\n"})
public final class DungeonSecretChime {
    @NotNull
    public static final DungeonSecretChime INSTANCE = new DungeonSecretChime();
    @NotNull
    private static Set<NeuInternalName> dungeonSecretItems = SetsKt.emptySet();

    private DungeonSecretChime() {
    }

    private final SecretChimeConfig getConfig() {
        return SkyHanniMod.feature.getDungeon().getSecretChime();
    }

    @HandleEvent
    public final void onDungeonClickedBlock(@NotNull DungeonBlockClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        if (DungeonApi.INSTANCE.getInWaterRoom() && event.getBlockType() == ClickedBlockType.LEVER) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[event.getBlockType().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                DungeonSecretChime.playSound();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @HandleEvent
    public final void onMobDeSpawn(@NotNull MobEvent.DeSpawn.SkyblockMob event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.isEnabled() && Intrinsics.areEqual((Object)event.getMob().getName(), (Object)"Dungeon Secret Bat")) {
            DungeonSecretChime.playSound();
        }
    }

    @HandleEvent
    public final void onItemPickup(@NotNull EntityRemovedEvent<class_1542> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        String itemName2 = TextCompatKt.formattedTextCompatLeadingWhiteLessResets(event.getEntity().method_6983().method_7964());
        if (dungeonSecretItems.contains(NeuInternalName.Companion.fromItemName(itemName2))) {
            DungeonSecretChime.playSound();
        }
    }

    @HandleEvent
    public final void onPlaySound(@NotNull PlaySoundEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        SecretChimeConfig.MuteSecretSoundConfig $this$onPlaySound_u24lambda_u240 = this.getConfig().getMuteSecretSound();
        boolean bl = false;
        if (!$this$onPlaySound_u24lambda_u240.getMuteChestSound() && !$this$onPlaySound_u24lambda_u240.getMuteLeverSound()) {
            return;
        }
        if ($this$onPlaySound_u24lambda_u240.getMuteChestSound() && INSTANCE.isChestSound(event)) {
            event.cancel();
        }
        if ($this$onPlaySound_u24lambda_u240.getMuteLeverSound() && INSTANCE.isLeverSound(event)) {
            event.cancel();
        }
    }

    private final boolean isChestSound(PlaySoundEvent $this$isChestSound) {
        Object[] objectArray;
        String string = $this$isChestSound.getSoundName();
        boolean bl = Intrinsics.areEqual((Object)string, (Object)"random.chestopen") ? $this$isChestSound.getVolume() == 0.5f : (Intrinsics.areEqual((Object)string, (Object)"note.harp") ? $this$isChestSound.getVolume() == 1.0f && SetsKt.setOf((Object[])(objectArray = new Float[]{Float.valueOf(0.7936508f), Float.valueOf(0.8888889f), Float.valueOf(1.0f), Float.valueOf(1.0952381f), Float.valueOf(1.1904762f)})).contains(Float.valueOf($this$isChestSound.getPitch())) : false);
        return bl;
    }

    private final boolean isLeverSound(PlaySoundEvent $this$isLeverSound) {
        Object[] objectArray;
        String string = $this$isLeverSound.getSoundName();
        boolean bl = Intrinsics.areEqual((Object)string, (Object)"random.anvil_break") ? $this$isLeverSound.getVolume() == 1.0f && $this$isLeverSound.getPitch() == 1.6984127f : (Intrinsics.areEqual((Object)string, (Object)"random.wood_click") ? SetsKt.setOf((Object[])(objectArray = new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f)})).contains(Float.valueOf($this$isLeverSound.getVolume())) && $this$isLeverSound.getPitch() == 0.4920635f : false);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent
    public final void onRepoReload(@NotNull RepositoryReloadEvent event) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String constant$iv = "Items";
        Object type$iv = null;
        Gson gson$iv = ((AbstractRepoReloadEvent)event).getGson();
        boolean $i$f$getConstant = false;
        Object object2 = event;
        try {
            Object $this$getRepoData_u24lambda_u2414$iv$iv;
            void this_$iv$iv;
            AbstractRepoReloadEvent $this$getConstant_u24lambda_u242$iv = object2;
            boolean bl = false;
            AbstractRepoManager<?> abstractRepoManager = $this$getConstant_u24lambda_u242$iv.getManager();
            String directory$iv$iv = "constants";
            boolean $i$f$getRepoData = false;
            Object object3 = this_$iv$iv;
            try {
                $this$getRepoData_u24lambda_u2414$iv$iv = object3;
                boolean bl2 = false;
                String path$iv$iv = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).resolvePath(directory$iv$iv, constant$iv);
                JsonElement jsonElement = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).readJsonElement(path$iv$iv);
                if (jsonElement == null) {
                    ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).getLogger().throwError("Repo file '" + constant$iv + "' not found.");
                    throw new KotlinNothingValueException();
                }
                JsonElement json$iv$iv = jsonElement;
                Gson $this$fromJson$iv$iv$iv = gson$iv;
                boolean $i$f$fromJson = false;
                Object object4 = $this$fromJson$iv$iv$iv.fromJson(json$iv$iv, ReflectJvmMapping.getJavaType((KType)Reflection.typeOf(ItemsJson.class)));
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"fromJson(...)");
                $this$getRepoData_u24lambda_u2414$iv$iv = Result.constructor-impl((Object)object4);
            }
            catch (Throwable bl2) {
                $this$getRepoData_u24lambda_u2414$iv$iv = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object3 = $this$getRepoData_u24lambda_u2414$iv$iv;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
            if (throwable != null) {
                Throwable e$iv$iv = throwable;
                boolean bl3 = false;
                this_$iv$iv.getLogger().throwErrorWithCause("Repo parsing error while trying to read constant '" + constant$iv + "'", e$iv$iv);
                throw new KotlinNothingValueException();
            }
            Object constantData$iv = object3;
            $this$getConstant_u24lambda_u242$iv.getManager().addSuccessfulConstant(constant$iv);
            object = constantData$iv;
        }
        catch (Throwable bl) {
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Throwable it$iv = throwable;
                boolean bl4 = false;
                ((AbstractRepoReloadEvent)event).getManager().addUnsuccessfulConstant(constant$iv);
                ((AbstractRepoReloadEvent)event).getManager().getLogger().throwErrorWithCause("Could not load constant '" + constant$iv + "'", it$iv);
                throw new KotlinNothingValueException();
            }
            throw new KotlinNothingValueException();
        }
        ItemsJson data = (ItemsJson)object;
        dungeonSecretItems = data.getDungeonSecretItems();
    }

    private final boolean isEnabled() {
        return DungeonApi.INSTANCE.inDungeon() && !DungeonApi.INSTANCE.getInBossRoom() && this.getConfig().getEnabled();
    }

    @JvmStatic
    public static final void playSound() {
        SecretChimeConfig $this$playSound_u24lambda_u241 = INSTANCE.getConfig();
        boolean bl = false;
        SoundUtils.INSTANCE.playSound(SoundUtils.INSTANCE.createSound($this$playSound_u24lambda_u241.getSoundName(), $this$playSound_u24lambda_u241.getSoundPitch(), 100.0f));
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClickedBlockType.values().length];
            try {
                nArray[ClickedBlockType.CHEST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClickedBlockType.TRAPPED_CHEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClickedBlockType.LEVER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClickedBlockType.WITHER_ESSENCE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

