/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.inventory;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.inventory.InventoryConfig;
import at.hannibal2.skyhanni.events.InventoryCloseEvent;
import at.hannibal2.skyhanni.events.InventoryOpenEvent;
import at.hannibal2.skyhanni.events.minecraft.ToolTipEvent;
import at.hannibal2.skyhanni.utils.ConditionalUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.collection.CollectionUtils;
import at.hannibal2.skyhanni.utils.compat.TextCompatKt;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0015\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0017\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u001b\u0010\u001e\u001a\u00020\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u001b\u0010!\u001a\u00020\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u001b\u001a\u0004\b \u0010\u001dR\u001b\u0010$\u001a\u00020\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u001b\u001a\u0004\b#\u0010\u001dR\u001b\u0010'\u001a\u00020\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\u001b\u001a\u0004\b&\u0010\u001dR\"\u0010(\u001a\u00020\u000f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b(\u0010)\u001a\u0004\b*\u0010\u0011\"\u0004\b+\u0010,\u00a8\u0006-"}, d2={"Lat/hannibal2/skyhanni/features/inventory/StockOfStonkFeature;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/InventoryOpenEvent;", "event", "", "onInventoryOpen", "(Lat/hannibal2/skyhanni/events/InventoryOpenEvent;)V", "Lat/hannibal2/skyhanni/events/InventoryCloseEvent;", "onInventoryClose", "(Lat/hannibal2/skyhanni/events/InventoryCloseEvent;)V", "Lat/hannibal2/skyhanni/events/minecraft/ToolTipEvent;", "onToolTip", "(Lat/hannibal2/skyhanni/events/minecraft/ToolTipEvent;)V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/inventory/InventoryConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/inventory/InventoryConfig;", "config", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "Ljava/util/regex/Pattern;", "inventoryPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getInventoryPattern", "()Ljava/util/regex/Pattern;", "inventoryPattern", "itemPattern$delegate", "getItemPattern", "itemPattern", "topPattern$delegate", "getTopPattern", "topPattern", "bidPattern$delegate", "getBidPattern", "bidPattern", "inInventory", "Z", "getInInventory", "setInInventory", "(Z)V", "1.21.7"})
@SourceDebugExtension(value={"SMAP\nStockOfStonkFeature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StockOfStonkFeature.kt\nat/hannibal2/skyhanni/features/inventory/StockOfStonkFeature\n+ 2 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 CollectionUtils.kt\nat/hannibal2/skyhanni/utils/collection/CollectionUtils\n*L\n1#1,105:1\n8#2:106\n8#2:108\n1#3:107\n1#3:109\n212#4,2:110\n*S KotlinDebug\n*F\n+ 1 StockOfStonkFeature.kt\nat/hannibal2/skyhanni/features/inventory/StockOfStonkFeature\n*L\n86#1:106\n90#1:108\n86#1:107\n90#1:109\n100#1:110,2\n*E\n"})
public final class StockOfStonkFeature {
    @NotNull
    public static final StockOfStonkFeature INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @NotNull
    private static final RepoPattern inventoryPattern$delegate;
    @NotNull
    private static final RepoPattern itemPattern$delegate;
    @NotNull
    private static final RepoPattern topPattern$delegate;
    @NotNull
    private static final RepoPattern bidPattern$delegate;
    private static boolean inInventory;

    private StockOfStonkFeature() {
    }

    private final InventoryConfig getConfig() {
        return SkyHanniMod.feature.getInventory();
    }

    private final Pattern getInventoryPattern() {
        return (Pattern)inventoryPattern$delegate.getValue(this, $$delegatedProperties[0]);
    }

    private final Pattern getItemPattern() {
        return (Pattern)itemPattern$delegate.getValue(this, $$delegatedProperties[1]);
    }

    private final Pattern getTopPattern() {
        return (Pattern)topPattern$delegate.getValue(this, $$delegatedProperties[2]);
    }

    private final Pattern getBidPattern() {
        return (Pattern)bidPattern$delegate.getValue(this, $$delegatedProperties[3]);
    }

    public final boolean getInInventory() {
        return inInventory;
    }

    public final void setInInventory(boolean bl) {
        inInventory = bl;
    }

    @HandleEvent
    public final void onInventoryOpen(@NotNull InventoryOpenEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.isEnabled()) {
            inInventory = RegexUtils.INSTANCE.matches(this.getInventoryPattern(), event.getInventoryName());
        }
    }

    @HandleEvent
    public final void onInventoryClose(@NotNull InventoryCloseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        inInventory = false;
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent
    public final void onToolTip(@NotNull ToolTipEvent event) {
        void $this$onToolTip_u24lambda_u244;
        void $this$transformAt$iv;
        Object this_$iv;
        Object it$iv;
        Object line;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        if (!inInventory) {
            return;
        }
        if (!RegexUtils.INSTANCE.matches(this.getItemPattern(), TextCompatKt.formattedTextCompatLeadingWhiteLessResets(event.getItemStack().method_7964()))) {
            return;
        }
        int stonksReward = 0;
        int index = 0;
        int bestValueIndex = 0;
        long bestRatio = 0L;
        bestRatio = Long.MAX_VALUE;
        while (index < event.getToolTip().size()) {
            line = event.getToolTip().get(index);
            int n = index;
            index = n + 1;
            RegexUtils regexUtils = RegexUtils.INSTANCE;
            Pattern $this$matchMatcher$iv = this.getTopPattern();
            boolean $i$f$matchMatcher = false;
            it$iv = $this$matchMatcher$iv.matcher((CharSequence)line);
            boolean bl = false;
            if (((Matcher)it$iv).matches()) {
                Intrinsics.checkNotNull((Object)it$iv);
                Object $this$onToolTip_u24lambda_u240 = it$iv;
                boolean bl2 = false;
                String string = ((Matcher)$this$onToolTip_u24lambda_u240).group("amount");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                stonksReward = Integer.parseInt(string);
                continue;
            }
            this_$iv = RegexUtils.INSTANCE;
            $this$matchMatcher$iv = this.getBidPattern();
            $i$f$matchMatcher = false;
            it$iv = $this$matchMatcher$iv.matcher((CharSequence)line);
            bl = false;
            if (!((Matcher)it$iv).matches()) continue;
            Intrinsics.checkNotNull((Object)it$iv);
            Object $this$onToolTip_u24lambda_u243 = it$iv;
            boolean bl3 = false;
            String string = ((Matcher)$this$onToolTip_u24lambda_u243).group("amount");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            long cost = RangesKt.coerceAtLeast((long)NumberUtil.INSTANCE.formatLong(string), (long)2000000L);
            long ratio = cost / ((Number)ConditionalUtils.INSTANCE.transformIf(stonksReward, StockOfStonkFeature::onToolTip$lambda$3$lambda$1, StockOfStonkFeature::onToolTip$lambda$3$lambda$2)).longValue();
            event.getToolTip().set(index - 1, (String)line + " \u00a77(paying \u00a76" + NumberUtil.INSTANCE.addSeparators(ratio) + " \u00a77per)");
            if (ratio >= bestRatio) continue;
            bestValueIndex = index - 1;
            bestRatio = ratio;
        }
        line = CollectionUtils.INSTANCE;
        this_$iv = event.getToolTip();
        int index$iv = bestValueIndex;
        boolean $i$f$transformAt = false;
        it$iv = (String)$this$transformAt$iv.get(index$iv);
        int n = index$iv;
        void var17_19 = $this$transformAt$iv;
        boolean bl = false;
        String string = StringsKt.replace$default((String)$this$onToolTip_u24lambda_u244, (String)"\u00a76\u00a76", (String)"\u00a7a", (boolean)false, (int)4, null);
        var17_19.set(n, string);
    }

    private final boolean isEnabled() {
        return SkyBlockUtils.INSTANCE.getInSkyBlock() && this.getConfig().getStonkOfStonkPrice();
    }

    private static final boolean onToolTip$lambda$3$lambda$1(int $this$transformIf) {
        return $this$transformIf == 0;
    }

    private static final int onToolTip$lambda$3$lambda$2(int $this$transformIf) {
        return 1;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(StockOfStonkFeature.class, "inventoryPattern", "getInventoryPattern()Ljava/util/regex/Pattern;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(StockOfStonkFeature.class, "itemPattern", "getItemPattern()Ljava/util/regex/Pattern;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(StockOfStonkFeature.class, "topPattern", "getTopPattern()Ljava/util/regex/Pattern;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(StockOfStonkFeature.class, "bidPattern", "getBidPattern()Ljava/util/regex/Pattern;", 0)))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new StockOfStonkFeature();
        patternGroup = RepoPattern.Companion.group("inventory.stockofstonks");
        inventoryPattern$delegate = patternGroup.pattern("inventory", "Stonks Auction");
        itemPattern$delegate = patternGroup.pattern("item", "\u00a7dStonks Auction");
        topPattern$delegate = patternGroup.pattern("top", "(?:\u00a75\u00a7o)?\u00a77\u00a7.\u25b6 \u00a7.\u00a7lTOP (?<rank>[\\d,]+)\u00a77 - \u00a75Stock of Stonks \u00a78x(?<amount>\\d+)");
        bidPattern$delegate = patternGroup.pattern("bid", "(?:\u00a75\u00a7o)?\u00a77 {3}Minimum Bid: \u00a76(?<amount>[\\d,]+) Coins");
    }
}

