/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.misc;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.CollectionApi;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.commands.CommandCategory;
import at.hannibal2.skyhanni.config.commands.CommandRegistrationEvent;
import at.hannibal2.skyhanni.config.commands.brigadier.ArgContext;
import at.hannibal2.skyhanni.config.commands.brigadier.BaseBrigadierBuilder;
import at.hannibal2.skyhanni.config.commands.brigadier.BrigadierArgument;
import at.hannibal2.skyhanni.config.commands.brigadier.BrigadierArguments;
import at.hannibal2.skyhanni.config.commands.brigadier.BrigadierBuilder;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.NeuInternalName;
import at.hannibal2.skyhanni.utils.NeuItems;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.collection.RenderableCollectionUtils;
import at.hannibal2.skyhanni.utils.compat.TextCompatKt;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import at.hannibal2.skyhanni.utils.renderables.container.HorizontalContainerRenderable;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\f\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0003J\u000f\u0010\u0017\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0003J\u000f\u0010\u0019\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001d\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u001b2\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001e\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u001e\u0010\u0003J\u000f\u0010\u001f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u001f\u0010\u0003J\u000f\u0010 \u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b \u0010\u0003J\u0017\u0010\"\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010%\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020$H\u0007\u00a2\u0006\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020\u00188\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u0018\u0010*\u001a\u0004\u0018\u00010)8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0016\u0010,\u001a\u00020\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010.R\u0016\u00100\u001a\u00020/8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b0\u00101R\u0016\u00102\u001a\u00020/8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b2\u00101R\u0016\u00103\u001a\u00020\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u0010(R\u0016\u00104\u001a\u00020\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b4\u0010(R\u0016\u00105\u001a\u00020/8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b5\u00101R\u0014\u00106\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u0010.R\u0014\u00107\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u0010.R\u0014\u00108\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b8\u0010.R\u0014\u00109\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b9\u0010.R\u0014\u0010:\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b:\u0010.\u00a8\u0006;"}, d2={"Lat/hannibal2/skyhanni/features/misc/CollectionTracker;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;", "event", "", "onCommandRegistration", "(Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;)V", "", "", "args", "command", "([Ljava/lang/String;)V", "rawName", "fixTypo", "(Ljava/lang/String;)Ljava/lang/String;", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "internalName", "name", "setNewCollection", "(Lat/hannibal2/skyhanni/utils/NeuInternalName;Ljava/lang/String;)V", "resetData", "updateDisplay", "", "countCurrentlyInInventory", "()I", "", "handleTabComplete", "(Ljava/lang/String;)Ljava/util/List;", "onTick", "compareInventory", "updateGain", "amount", "gainItems", "(I)V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "RECENT_GAIN_TIME", "I", "Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "display", "Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "itemName", "Ljava/lang/String;", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "", "itemAmount", "J", "goalAmount", "lastAmountInInventory", "recentGain", "lastGainTime", "CACTUS", "CACTUS_GREEN", "YOUNGITE", "OBSOLITE", "TIMITE", "1.21.7"})
@SourceDebugExtension(value={"SMAP\nCollectionTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CollectionTracker.kt\nat/hannibal2/skyhanni/features/misc/CollectionTracker\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 BrigadierBuilder.kt\nat/hannibal2/skyhanni/config/commands/brigadier/BrigadierBuilder\n*L\n1#1,252:1\n37#2:253\n36#2,3:254\n1617#3,9:257\n1869#3:266\n1870#3:268\n1626#3:269\n1563#3:270\n1634#3,3:271\n1#4:267\n162#5,15:274\n*S KotlinDebug\n*F\n+ 1 CollectionTracker.kt\nat/hannibal2/skyhanni/features/misc/CollectionTracker\n*L\n84#1:253\n84#1:254,3\n203#1:257,9\n203#1:266\n203#1:268\n203#1:269\n204#1:270\n204#1:271,3\n203#1:267\n58#1:274,15\n*E\n"})
public final class CollectionTracker {
    @NotNull
    public static final CollectionTracker INSTANCE = new CollectionTracker();
    private static final int RECENT_GAIN_TIME = 1500;
    @Nullable
    private static Renderable display;
    @NotNull
    private static String itemName;
    @Nullable
    private static NeuInternalName internalName;
    private static long itemAmount;
    private static long goalAmount;
    private static int lastAmountInInventory;
    private static int recentGain;
    private static long lastGainTime;
    @NotNull
    private static final NeuInternalName CACTUS;
    @NotNull
    private static final NeuInternalName CACTUS_GREEN;
    @NotNull
    private static final NeuInternalName YOUNGITE;
    @NotNull
    private static final NeuInternalName OBSOLITE;
    @NotNull
    private static final NeuInternalName TIMITE;

    private CollectionTracker() {
    }

    @HandleEvent
    public final void onCommandRegistration(@NotNull CommandRegistrationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.registerBrigadier("shtrackcollection", (Function1<? super BaseBrigadierBuilder, Unit>)((Function1)CollectionTracker::onCommandRegistration$lambda$2));
    }

    private final void command(String[] args) {
        Object[] objectArray;
        String lastArg = (String)ArraysKt.last((Object[])args);
        if (NumberUtil.INSTANCE.isFormatNumber(lastArg)) {
            long goal = NumberUtil.INSTANCE.formatLong(lastArg);
            if (goal <= 0L) {
                ChatUtils.chat$default(ChatUtils.INSTANCE, "Invalid Amount for Goal.", false, null, false, false, null, 62, null);
                return;
            }
            goalAmount = goal;
            Collection $this$toTypedArray$iv = ArraysKt.dropLast((Object[])args, (int)1);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            objectArray = thisCollection$iv.toArray(new String[0]);
        } else {
            goalAmount = -1L;
            objectArray = args;
        }
        Object[] nameArgs = objectArray;
        String string = ArraysKt.joinToString$default((Object[])nameArgs, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String rawName = this.fixTypo(StringsKt.replace$default((String)string, (String)"_", (String)" ", (boolean)false, (int)4, null));
        if (Intrinsics.areEqual((Object)rawName, (Object)"gemstone")) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, "Gemstone collection is not supported!", false, 2, null);
            return;
        }
        if (Intrinsics.areEqual((Object)rawName, (Object)"mushroom")) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, "Mushroom collection is not supported!", false, 2, null);
            return;
        }
        NeuInternalName foundInternalName = NeuInternalName.Companion.fromItemNameOrNull(rawName);
        if (foundInternalName == null) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, "Item '" + rawName + "' does not exist!", false, 2, null);
            return;
        }
        class_1799 stack = NeuItems.INSTANCE.getItemStackOrNull(foundInternalName);
        if (stack == null) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, "Item '" + rawName + "' does not exist!", false, 2, null);
            return;
        }
        this.setNewCollection(foundInternalName, StringUtils.removeColor$default(StringUtils.INSTANCE, TextCompatKt.formattedTextCompatLeadingWhiteLessResets(stack.method_7964()), false, 1, null));
    }

    private final String fixTypo(String rawName) {
        return switch (rawName) {
            case "carrots" -> "carrot";
            case "melons" -> "melon";
            case "seed" -> "seeds";
            case "iron" -> "iron ingot";
            case "gold" -> "gold ingot";
            case "sugar" -> "sugar cane";
            case "cocoa", "cocoa bean" -> "cocoa beans";
            case "lapis" -> "lapis lazuli";
            case "cacti" -> "cactus";
            case "pumpkins" -> "pumpkin";
            case "potatoes" -> "potato";
            case "nether warts", "wart", "warts" -> "nether wart";
            case "stone" -> "cobblestone";
            case "mushrooms", "brown mushroom", "red mushroom" -> "mushroom";
            case "gemstones" -> "gemstone";
            case "caducous" -> "caducous stem";
            case "agaricus" -> "agaricus cap";
            case "quartz" -> "nether quartz";
            case "glowstone" -> "glowstone dust";
            default -> rawName;
        };
    }

    private final void setNewCollection(NeuInternalName internalName2, String name2) {
        Long foundAmount = CollectionApi.INSTANCE.getCollectionCounter(internalName2);
        if (foundAmount == null) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, name2 + " collection not found. Try to open the collection inventory!", false, 2, null);
            return;
        }
        internalName = internalName2;
        itemName = name2;
        itemAmount = foundAmount;
        lastAmountInInventory = this.countCurrentlyInInventory();
        this.updateDisplay();
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Started tracking " + itemName + " \u00a7ecollection.", false, null, false, false, null, 62, null);
    }

    private final void resetData() {
        itemAmount = -1L;
        goalAmount = -1L;
        internalName = null;
        lastAmountInInventory = -1;
        display = null;
        recentGain = 0;
    }

    private final void updateDisplay() {
        String format = NumberUtil.INSTANCE.addSeparators(itemAmount);
        Ref.ObjectRef gainText = new Ref.ObjectRef();
        gainText.element = "";
        if (recentGain != 0) {
            gainText.element = "\u00a7a+" + NumberUtil.INSTANCE.addSeparators(recentGain);
        }
        if (goalAmount != -1L && itemAmount >= goalAmount) {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "Collection goal of \u00a7a" + NumberUtil.INSTANCE.addSeparators(goalAmount) + " reached!", false, null, false, false, null, 62, null);
            goalAmount = -1L;
        }
        String goal = goalAmount == -1L ? "" : " \u00a7f/ \u00a7b" + NumberUtil.INSTANCE.addSeparators(goalAmount) + " \u00a7f(\u00a7a" + NumberUtil.INSTANCE.percentWithColorCode(itemAmount, goalAmount, 1) + "\u00a7f)";
        display = HorizontalContainerRenderable.Companion.horizontal$default(HorizontalContainerRenderable.Companion, Renderable.Companion, 0, null, null, arg_0 -> CollectionTracker.updateDisplay$lambda$4(format, goal, gainText, arg_0), 7, null);
    }

    private final int countCurrentlyInInventory() {
        return InventoryUtils.INSTANCE.countItemsInLowerInventory((Function1<? super class_1799, Boolean>)((Function1)CollectionTracker::countCurrentlyInInventory$lambda$5));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<String> handleTabComplete(@NotNull String command2) {
        void $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
        if (!Intrinsics.areEqual((Object)command2, (Object)"shtrackcollection")) {
            return null;
        }
        Iterable $this$mapNotNull$iv = CollectionApi.INSTANCE.getCollectionValue().keySet();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        class_1799 class_17992 = $this$forEach$iv$iv$iv.iterator();
        while (class_17992.hasNext()) {
            class_1799 it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = class_17992.next();
            boolean bl = false;
            NeuInternalName it = (NeuInternalName)element$iv$iv;
            boolean bl2 = false;
            if (NeuItems.INSTANCE.getItemStackOrNull(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            class_17992 = (class_1799)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.replace$default((String)StringUtils.removeColor$default(StringUtils.INSTANCE, TextCompatKt.formattedTextCompatLeadingWhiteLessResets(it.method_7964()), false, 1, null), (String)" ", (String)"_", (boolean)false, (int)4, null));
        }
        return (List)destination$iv$iv;
    }

    @HandleEvent
    public final void onTick() {
        this.compareInventory();
        this.updateGain();
    }

    private final void compareInventory() {
        if (lastAmountInInventory == -1) {
            return;
        }
        if (class_310.method_1551().field_1755 != null) {
            return;
        }
        int currentlyInInventory = this.countCurrentlyInInventory();
        int diff = currentlyInInventory - lastAmountInInventory;
        if (diff != 0 && diff > 0) {
            this.gainItems(diff);
        }
        lastAmountInInventory = currentlyInInventory;
    }

    private final void updateGain() {
        if (recentGain != 0 && System.currentTimeMillis() > lastGainTime + (long)1500) {
            recentGain = 0;
            this.updateDisplay();
        }
    }

    private final void gainItems(int amount) {
        itemAmount += (long)amount;
        if (System.currentTimeMillis() > lastGainTime + (long)1500) {
            recentGain = 0;
        }
        lastGainTime = System.currentTimeMillis();
        recentGain += amount;
        this.updateDisplay();
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Renderable renderable2 = display;
            if (renderable2 == null) break block0;
            Renderable it = renderable2;
            boolean bl = false;
            RenderUtils.renderRenderable$default(RenderUtils.INSTANCE, SkyHanniMod.feature.misc.getCollectionCounterPos(), it, "Collection Tracker", false, 4, null);
        }
    }

    private static final Unit onCommandRegistration$lambda$2$lambda$1() {
        if (internalName == null) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, "/shtrackcollection <item name> [goal amount]", false, 2, null);
        } else {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "Stopped collection tracker.", false, null, false, false, null, 62, null);
            INSTANCE.resetData();
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit onCommandRegistration$lambda$2(BaseBrigadierBuilder $this$registerBrigadier) {
        void name$iv;
        Intrinsics.checkNotNullParameter((Object)$this$registerBrigadier, (String)"$this$registerBrigadier");
        $this$registerBrigadier.setDescription("Tracks your collection gain over time");
        $this$registerBrigadier.setCategory(CommandCategory.USERS_ACTIVE);
        String string = "args";
        ArgumentType argument$iv = (ArgumentType)BrigadierArguments.INSTANCE.greedyString();
        SuggestionProvider suggestions$iv = null;
        boolean $i$f$arg = false;
        if (!StringUtils.INSTANCE.hasWhitespace((String)name$iv)) {
            ((BrigadierBuilder)$this$registerBrigadier).internalArg((String)name$iv, argument$iv, suggestions$iv, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, String>>, Unit>((String)name$iv){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$internalArg) {
                    void args;
                    Intrinsics.checkNotNullParameter($this$internalArg, (String)"$this$internalArg");
                    BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                    String argumentName$iv = this.$name;
                    boolean $i$f$of = false;
                    BrigadierArgument<String> brigadierArgument = new BrigadierArgument<String>(argumentName$iv, String.class);
                    BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$onCommandRegistration_u24lambda_u242_u24lambda_u240 = $this$internalArg;
                    boolean bl = false;
                    $this$onCommandRegistration_u24lambda_u242_u24lambda_u240.callback((Function1<ArgContext, Unit>)((Function1)new Function1<ArgContext, Unit>((BrigadierArgument<String>)args){
                        final /* synthetic */ BrigadierArgument<String> $args;
                        {
                            this.$args = $args;
                        }

                        public final void invoke(ArgContext $this$callback) {
                            Intrinsics.checkNotNullParameter((Object)$this$callback, (String)"$this$callback");
                            String string = $this$callback.getArg(this.$args);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getArg(...)");
                            String[] stringArray = new String[]{" "};
                            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                            boolean $i$f$toTypedArray = false;
                            Collection thisCollection$iv = $this$toTypedArray$iv;
                            CollectionTracker.access$command(CollectionTracker.INSTANCE, thisCollection$iv.toArray(new String[0]));
                        }
                    }));
                }
            });
        } else {
            Pair<String, String> pair = StringUtils.INSTANCE.splitLastWhitespace((String)name$iv);
            String literalNames$iv = (String)pair.component1();
            String argName$iv = (String)pair.component2();
            String[] stringArray = new String[]{literalNames$iv};
            ((BrigadierBuilder)$this$registerBrigadier).literal(stringArray, (Function1<BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>)((Function1)new Function1<BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>(argName$iv, argument$iv, suggestions$iv){
                final /* synthetic */ String $argName;
                final /* synthetic */ ArgumentType $argument;
                final /* synthetic */ SuggestionProvider $suggestions;
                {
                    this.$argName = $argName;
                    this.$argument = $argument;
                    this.$suggestions = $suggestions;
                }

                public final void invoke(BrigadierBuilder<LiteralArgumentBuilder<Object>> $this$literal) {
                    Intrinsics.checkNotNullParameter($this$literal, (String)"$this$literal");
                    $this$literal.internalArg(this.$argName, this.$argument, (SuggestionProvider<Object>)this.$suggestions, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, String>>, Unit>(this.$argName){
                        final /* synthetic */ String $argName;
                        {
                            this.$argName = $argName;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$internalArg) {
                            void args;
                            Intrinsics.checkNotNullParameter($this$internalArg, (String)"$this$internalArg");
                            BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                            String argumentName$iv = this.$argName;
                            boolean $i$f$of = false;
                            BrigadierArgument<String> brigadierArgument = new BrigadierArgument<String>(argumentName$iv, String.class);
                            BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$onCommandRegistration_u24lambda_u242_u24lambda_u240 = $this$internalArg;
                            boolean bl = false;
                            $this$onCommandRegistration_u24lambda_u242_u24lambda_u240.callback((Function1<ArgContext, Unit>)((Function1)new /* invalid duplicate definition of identical inner class */));
                        }
                    });
                }
            }));
        }
        $this$registerBrigadier.simpleCallback((Function0<Unit>)((Function0)CollectionTracker::onCommandRegistration$lambda$2$lambda$1));
        return Unit.INSTANCE;
    }

    private static final Unit updateDisplay$lambda$4(String $format, String $goal, Ref.ObjectRef $gainText, List $this$horizontal) {
        Intrinsics.checkNotNullParameter((Object)$format, (String)"$format");
        Intrinsics.checkNotNullParameter((Object)$goal, (String)"$goal");
        Intrinsics.checkNotNullParameter((Object)$gainText, (String)"$gainText");
        Intrinsics.checkNotNullParameter((Object)$this$horizontal, (String)"$this$horizontal");
        NeuInternalName neuInternalName = internalName;
        if (neuInternalName != null) {
            NeuInternalName it = neuInternalName;
            boolean bl = false;
            RenderableCollectionUtils.addItemStack$default(RenderableCollectionUtils.INSTANCE, $this$horizontal, NeuItems.INSTANCE.getItemStack(it), false, 0.0, 6, null);
        }
        RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$horizontal, itemName + " collection: \u00a7e" + $format + $goal + " " + $gainText.element, 0.0, null, null, 14, null);
        return Unit.INSTANCE;
    }

    private static final boolean countCurrentlyInInventory$lambda$5(class_1799 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        NeuInternalName name2 = ItemUtils.INSTANCE.getInternalName(it);
        if (Intrinsics.areEqual((Object)internalName, (Object)CACTUS) && Intrinsics.areEqual((Object)name2, (Object)CACTUS_GREEN)) {
            return true;
        }
        if (Intrinsics.areEqual((Object)internalName, (Object)TIMITE) && (Intrinsics.areEqual((Object)name2, (Object)YOUNGITE) || Intrinsics.areEqual((Object)name2, (Object)OBSOLITE))) {
            return true;
        }
        return Intrinsics.areEqual((Object)name2, (Object)internalName);
    }

    public static final /* synthetic */ void access$command(CollectionTracker $this, String[] args) {
        $this.command(args);
    }

    static {
        itemName = "";
        itemAmount = -1L;
        goalAmount = -1L;
        lastAmountInInventory = -1;
        lastGainTime = -1L;
        CACTUS = NeuInternalName.Companion.toInternalName("CACTUS");
        CACTUS_GREEN = NeuInternalName.Companion.toInternalName("INK_SACK-2");
        YOUNGITE = NeuInternalName.Companion.toInternalName("YOUNGITE");
        OBSOLITE = NeuInternalName.Companion.toInternalName("OBSOLITE");
        TIMITE = NeuInternalName.Companion.toInternalName("TIMITE");
    }
}

