/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.commons.net.ftp.parser;

import at.hannibal2.skyhanni.deps.commons.net.ftp.FTPFileEntryParserImpl;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public abstract class RegexFTPFileEntryParserImpl
extends FTPFileEntryParserImpl {
    private Pattern pattern;
    private MatchResult result;
    protected Matcher _matcher_;

    public RegexFTPFileEntryParserImpl(String regex) {
        this.compileRegex(regex, 0);
    }

    public RegexFTPFileEntryParserImpl(String regex, int flags) {
        this.compileRegex(regex, flags);
    }

    private void compileRegex(String regex, int flags) {
        try {
            this.pattern = Pattern.compile(regex, flags);
        }
        catch (PatternSyntaxException pse) {
            throw new IllegalArgumentException("Unparseable regex supplied: " + regex);
        }
    }

    public int getGroupCnt() {
        if (this.result == null) {
            return 0;
        }
        return this.result.groupCount();
    }

    public String getGroupsAsString() {
        StringBuilder b = new StringBuilder();
        for (int i2 = 1; i2 <= this.result.groupCount(); ++i2) {
            b.append(i2).append(") ").append(this.result.group(i2)).append(System.lineSeparator());
        }
        return b.toString();
    }

    public String group(int matchNum) {
        if (this.result == null) {
            return null;
        }
        return this.result.group(matchNum);
    }

    public boolean matches(String s) {
        this.result = null;
        this._matcher_ = this.pattern.matcher(s);
        if (this._matcher_.matches()) {
            this.result = this._matcher_.toMatchResult();
        }
        return null != this.result;
    }

    public boolean setRegex(String regex) {
        this.compileRegex(regex, 0);
        return true;
    }

    public boolean setRegex(String regex, int flags) {
        this.compileRegex(regex, flags);
        return true;
    }
}

