/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.commons.net.finger;

import at.hannibal2.skyhanni.deps.commons.net.SocketClient;
import at.hannibal2.skyhanni.deps.commons.net.util.Charsets;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class FingerClient
extends SocketClient {
    public static final int DEFAULT_PORT = 79;
    private static final String LONG_FLAG = "/W ";
    private final transient char[] buffer = new char[1024];

    public FingerClient() {
        this.setDefaultPort(79);
    }

    public InputStream getInputStream(boolean longOutput) throws IOException {
        return this.getInputStream(longOutput, "");
    }

    public InputStream getInputStream(boolean longOutput, String user) throws IOException {
        return this.getInputStream(longOutput, user, null);
    }

    public InputStream getInputStream(boolean longOutput, String user, String encoding) throws IOException {
        StringBuilder buffer = new StringBuilder(64);
        if (longOutput) {
            buffer.append(LONG_FLAG);
        }
        buffer.append(user);
        buffer.append("\r\n");
        byte[] encodedQuery = buffer.toString().getBytes(Charsets.toCharset(encoding).name());
        DataOutputStream output = new DataOutputStream(new BufferedOutputStream(this.checkOpenOutputStream(), 1024));
        output.write(encodedQuery, 0, encodedQuery.length);
        output.flush();
        return this._input_;
    }

    public String query(boolean longOutput) throws IOException {
        return this.query(longOutput, "");
    }

    public String query(boolean longOutput, String user) throws IOException {
        StringBuilder result2 = new StringBuilder(this.buffer.length);
        try (BufferedReader input2 = new BufferedReader(new InputStreamReader(this.getInputStream(longOutput, user), this.getCharset()));){
            int read;
            while ((read = input2.read(this.buffer, 0, this.buffer.length)) > 0) {
                result2.append(this.buffer, 0, read);
            }
        }
        return result2.toString();
    }
}

