/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.misc.discordrpc;

import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.features.dungeon.DungeonApi;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\u0007R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000bR \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lat/hannibal2/skyhanni/features/misc/discordrpc/DiscordLocationKey;", "", "<init>", "()V", "", "location", "getAmbiguousKey", "(Ljava/lang/String;)Ljava/lang/String;", "getDiscordIconKey", "", "normalRPC", "Ljava/util/Set;", "", "specialRPC", "Ljava/util/Map;", "", "specialNetherRPC", "[Ljava/lang/String;", "specialRiftRPC", "1.21.10"})
public final class DiscordLocationKey {
    @NotNull
    public static final DiscordLocationKey INSTANCE = new DiscordLocationKey();
    @NotNull
    private static final Set<String> normalRPC;
    @NotNull
    private static final Map<String, String> specialRPC;
    @NotNull
    private static final String[] specialNetherRPC;
    @NotNull
    private static final Map<String, String> specialRiftRPC;

    private DiscordLocationKey() {
    }

    private final String getAmbiguousKey(String location) {
        IslandType island = SkyBlockUtils.INSTANCE.getCurrentIsland();
        String string = DungeonApi.INSTANCE.getDungeonFloor();
        if (string != null) {
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            string = string2;
            if (string2 != null) {
                String it = string;
                boolean bl = false;
                if (StringsKt.startsWith$default((String)it, (String)"m", (boolean)false, (int)2, null)) {
                    return "master-mode";
                }
                if (StringsKt.startsWith$default((String)it, (String)"f", (boolean)false, (int)2, null)) {
                    return "dungeon";
                }
            }
        }
        return switch (location) {
            case "Wizard Tower" -> {
                switch (WhenMappings.$EnumSwitchMapping$0[island.ordinal()]) {
                    case 1: {
                        yield "rift-tower";
                    }
                    case 2: {
                        yield "wizard-tower";
                    }
                }
                yield "skyblock-logo";
            }
            case "The Bastion" -> {
                switch (WhenMappings.$EnumSwitchMapping$0[island.ordinal()]) {
                    case 1: {
                        yield "wyld-woods";
                    }
                    case 3: {
                        yield "crimson-isle";
                    }
                }
                yield "skyblock-logo";
            }
            case "Community Center" -> {
                switch (WhenMappings.$EnumSwitchMapping$0[island.ordinal()]) {
                    case 2: {
                        yield "village";
                    }
                    case 3: {
                        yield "crimson-isle";
                    }
                }
                yield "skyblock-logo";
            }
            case "Colosseum" -> {
                switch (WhenMappings.$EnumSwitchMapping$0[island.ordinal()]) {
                    case 2: {
                        yield "colosseum";
                    }
                    case 1: {
                        yield "around-colosseum";
                    }
                }
                yield "skyblock-logo";
            }
            default -> "skyblock-logo";
        };
    }

    @NotNull
    public final String getDiscordIconKey(@NotNull String location) {
        String string;
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        String string2 = location.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String keyIfNormal = StringsKt.replace$default((String)string2, (char)' ', (char)'-', (boolean)false, (int)4, null);
        if (normalRPC.contains(keyIfNormal)) {
            string = keyIfNormal;
        } else if (specialRPC.containsKey(location)) {
            string = specialRPC.get(location);
            if (string == null) {
                string = this.getAmbiguousKey(location);
            }
        } else if (ArraysKt.contains((Object[])specialNetherRPC, (Object)location)) {
            string = "crimson-isle";
        } else if (specialRiftRPC.containsKey(location)) {
            string = specialRiftRPC.get(location);
            if (string == null) {
                string = this.getAmbiguousKey(location);
            }
        } else {
            string = this.getAmbiguousKey(location);
        }
        return string;
    }

    static {
        Object[] objectArray = new String[]{"auction-house", "bank", "canvas-room", "coal-mine", "crimson-isle", "farm", "fashion-shop", "flower-house", "forest", "graveyard", "library", "mountain", "ruins", "tavern", "unincorporated", "village", "wilderness", "birch-park", "spruce-woods", "savanna-woodland", "dark-thicket", "jungle-island", "gold-mine", "slimehill", "the-barn", "mushroom-desert", "the-end", "around-colosseum", "barrier-street", "dreadfarm", "empty-bank", "lagoon-hut", "living-cave", "rift-gallery", "the-rift", "village-plaza", "wyld-woods", "glacite-tunnels", "jungle", "mithril-deposits", "precursor-remnants", "goblin-holdout", "magma-fields", "crystal-nucleus", "dungeon-hub"};
        normalRPC = SetsKt.setOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"Fisherman's Hut", (Object)"fishermans-hut"), TuplesKt.to((Object)"Farmhouse", (Object)"farm"), TuplesKt.to((Object)"Dragon's Nest", (Object)"dragons-nest"), TuplesKt.to((Object)"Windmill", (Object)"the-barn"), TuplesKt.to((Object)"Dark Auction", (Object)"wilderness"), TuplesKt.to((Object)"Catacombs Entrance", (Object)"coal-mine"), TuplesKt.to((Object)"Colosseum Arena", (Object)"colosseum"), TuplesKt.to((Object)"Museum", (Object)"unincorporated"), TuplesKt.to((Object)"Personal Garden", (Object)"garden"), TuplesKt.to((Object)"Jerry's Workshop", (Object)"winter-island"), TuplesKt.to((Object)"Jerry Pond", (Object)"winter-island"), TuplesKt.to((Object)"Mount Jerry", (Object)"winter-island"), TuplesKt.to((Object)"Gary's Shack", (Object)"winter-island"), TuplesKt.to((Object)"Glacial Cave", (Object)"winter-island"), TuplesKt.to((Object)"Terry's Shack", (Object)"winter-island"), TuplesKt.to((Object)"Hot Springs", (Object)"winter-island"), TuplesKt.to((Object)"Jerry Pond", (Object)"winter-island"), TuplesKt.to((Object)"Reflective Pond", (Object)"winter-island"), TuplesKt.to((Object)"Sunken Jerry Pond", (Object)"winter-island"), TuplesKt.to((Object)"Sherry's Showroom", (Object)"winter-island"), TuplesKt.to((Object)"Einary's Emporium", (Object)"winter-island"), TuplesKt.to((Object)"Archery Range", (Object)"village"), TuplesKt.to((Object)"Bazaar Alley", (Object)"village"), TuplesKt.to((Object)"Blacksmith", (Object)"village"), TuplesKt.to((Object)"Builder's House", (Object)"village"), TuplesKt.to((Object)"Election Room", (Object)"village"), TuplesKt.to((Object)"Hexatorum", (Object)"village"), TuplesKt.to((Object)"Thaumaturgist", (Object)"village"), TuplesKt.to((Object)"Weaponsmith", (Object)"village"), TuplesKt.to((Object)"Void Sepulture", (Object)"the-end"), TuplesKt.to((Object)"Void Slate", (Object)"the-end"), TuplesKt.to((Object)"Zealot Bruiser Hideout", (Object)"dragons-nest"), TuplesKt.to((Object)"Desert Settlement", (Object)"mushroom-desert"), TuplesKt.to((Object)"Oasis", (Object)"mushroom-desert"), TuplesKt.to((Object)"Desert Mountain", (Object)"mushroom-desert"), TuplesKt.to((Object)"Jake's House", (Object)"mushroom-desert"), TuplesKt.to((Object)"Trapper's Den", (Object)"mushroom-desert"), TuplesKt.to((Object)"Mushroom Gorge", (Object)"mushroom-desert"), TuplesKt.to((Object)"Glowing Mushroom Cave", (Object)"mushroom-desert"), TuplesKt.to((Object)"Overgrown Mushroom Cave", (Object)"mushroom-desert"), TuplesKt.to((Object)"Shepherd's Keep", (Object)"mushroom-desert"), TuplesKt.to((Object)"Treasure Hunter Camp", (Object)"mushroom-desert"), TuplesKt.to((Object)"Spider's Den", (Object)"spiders-den"), TuplesKt.to((Object)"Arachne's Burrow", (Object)"spiders-den"), TuplesKt.to((Object)"Arachne's Sanctuary", (Object)"spiders-den"), TuplesKt.to((Object)"Archaeologist's Camp", (Object)"spiders-den"), TuplesKt.to((Object)"Grandma's House", (Object)"spiders-den"), TuplesKt.to((Object)"Gravel Mines", (Object)"spiders-den"), TuplesKt.to((Object)"Spider Mound", (Object)"spiders-den"), TuplesKt.to((Object)"Melody's Plateau", (Object)"savanna-woodland"), TuplesKt.to((Object)"Viking Longhouse", (Object)"spruce-woods"), TuplesKt.to((Object)"Lonely Island", (Object)"spruce-woods"), TuplesKt.to((Object)"Howling Cave", (Object)"birch-park"), TuplesKt.to((Object)"Aristocrat Passage", (Object)"dwarven-mines"), TuplesKt.to((Object)"Barracks of Heroes", (Object)"dwarven-mines"), TuplesKt.to((Object)"C&C Minecarts Co.", (Object)"dwarven-mines"), TuplesKt.to((Object)"Cliffside Veins", (Object)"dwarven-mines"), TuplesKt.to((Object)"Divan's Gateway", (Object)"dwarven-mines"), TuplesKt.to((Object)"Dwarven Tavern", (Object)"dwarven-mines"), TuplesKt.to((Object)"Dwarven Village", (Object)"dwarven-mines"), TuplesKt.to((Object)"Far Reserve", (Object)"dwarven-mines"), TuplesKt.to((Object)"Forge Basin", (Object)"dwarven-mines"), TuplesKt.to((Object)"Gates to the Mines", (Object)"dwarven-mines"), TuplesKt.to((Object)"Goblin Burrows", (Object)"dwarven-mines"), TuplesKt.to((Object)"Grand Library", (Object)"dwarven-mines"), TuplesKt.to((Object)"Great Ice Wall", (Object)"dwarven-mines"), TuplesKt.to((Object)"Hanging Court", (Object)"dwarven-mines"), TuplesKt.to((Object)"Lava Springs", (Object)"dwarven-mines"), TuplesKt.to((Object)"Miner's Guild", (Object)"dwarven-mines"), TuplesKt.to((Object)"Palace Bridge", (Object)"dwarven-mines"), TuplesKt.to((Object)"Rampart's Quarry", (Object)"dwarven-mines"), TuplesKt.to((Object)"Royal Mines", (Object)"dwarven-mines"), TuplesKt.to((Object)"Royal Palace", (Object)"dwarven-mines"), TuplesKt.to((Object)"Royal Quarters", (Object)"dwarven-mines"), TuplesKt.to((Object)"The Forge", (Object)"dwarven-mines"), TuplesKt.to((Object)"The Lift", (Object)"dwarven-mines"), TuplesKt.to((Object)"The Mist", (Object)"dwarven-mines"), TuplesKt.to((Object)"Upper Mines", (Object)"dwarven-mines"), TuplesKt.to((Object)"Dragon's Lair", (Object)"mithril-deposits"), TuplesKt.to((Object)"Fairy Grotto", (Object)"crystal-nucleus"), TuplesKt.to((Object)"Goblin Queen's Den", (Object)"goblin-holdout"), TuplesKt.to((Object)"Jungle Temple", (Object)"jungle"), TuplesKt.to((Object)"Khazad-d\u00fbm", (Object)"magma-fields"), TuplesKt.to((Object)"Lost Precursor City", (Object)"precursor-remnants"), TuplesKt.to((Object)"Mines of Divan", (Object)"mithril-deposits"), TuplesKt.to((Object)"Diamond Reserve", (Object)"coal-mine"), TuplesKt.to((Object)"Gunpowder Mines", (Object)"coal-mine"), TuplesKt.to((Object)"Lapis Quarry", (Object)"coal-mine"), TuplesKt.to((Object)"Obsidian Sanctuary", (Object)"coal-mine"), TuplesKt.to((Object)"Pigmen's Den", (Object)"coal-mine"), TuplesKt.to((Object)"Dwarven Base Camp", (Object)"glacite-tunnels"), TuplesKt.to((Object)"Fossil Research Center", (Object)"glacite-tunnels"), TuplesKt.to((Object)"Great Glacite Lake", (Object)"glacite-tunnels"), TuplesKt.to((Object)"Glacite Mineshafts", (Object)"glacite-tunnels")};
        specialRPC = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new String[]{"Aura's Lab", "Barbarian Outpost", "Belly of the Beast", "Blazing Volcano", "Burning Desert", "Cathedral", "Chief's Hut", "Courtyard", "Crimson Fields", "Dojo", "Dragontail Auction House", "Dragontail Bank", "Dragontail Bazaar", "Dragontail Blacksmith", "Dragontail Townsquare", "Dragontail", "Forgotten Skull", "Igrupan's Chicken Coop", "Igrupan's House", "Kuudra's Hollow", "Mage Council", "Mage Outpost", "Magma Chamber", "Matriarch's Lair", "Minion Shop", "Mystic Marsh", "Odger's Hut", "Plhlegblast Pool", "Ruins of Ashfang", "Scarleton Auction House", "Scarleton Bank", "Scarleton Bazaar", "Scarleton Blacksmith", "Scarleton Minion Shop", "Scarleton Plaza", "Scarleton", "Smoldering Tomb", "Stronghold", "The Dukedom", "The Wasteland", "Throne Room"};
        specialNetherRPC = objectArray;
        objectArray = new Pair[]{TuplesKt.to((Object)"Enigma's Crib", (Object)"wyld-woods"), TuplesKt.to((Object)"Broken Cage", (Object)"wyld-woods"), TuplesKt.to((Object)"Shifted Tavern", (Object)"wyld-woods"), TuplesKt.to((Object)"Pumpgrotto", (Object)"wyld-woods"), TuplesKt.to((Object)"Otherside", (Object)"wyld-woods"), TuplesKt.to((Object)"Black Lagoon", (Object)"the-rift"), TuplesKt.to((Object)"Lagoon Cave", (Object)"the-rift"), TuplesKt.to((Object)"Leeches Lair", (Object)"the-rift"), TuplesKt.to((Object)"Dolphin Trainer", (Object)"the-rift"), TuplesKt.to((Object)"Mirrorverse", (Object)"the-rift"), TuplesKt.to((Object)"Book In A Book", (Object)"the-rift"), TuplesKt.to((Object)"\"Your\" Island", (Object)"the-rift"), TuplesKt.to((Object)"Lagoon Hut", (Object)"lagoon-hut"), TuplesKt.to((Object)"Around Colosseum", (Object)"around-colosseum"), TuplesKt.to((Object)"Rift Gallery Entrance", (Object)"rift-gallery"), TuplesKt.to((Object)"Great Beanstalk", (Object)"dreadfarm"), TuplesKt.to((Object)"Taylor's", (Object)"taylors"), TuplesKt.to((Object)"Lonely Terrace", (Object)"taylors"), TuplesKt.to((Object)"Half-Eaten Cave", (Object)"half-cave"), TuplesKt.to((Object)"D\u00e9j\u00e0 Vu Alley", (Object)"living-cave"), TuplesKt.to((Object)"Living Stillness", (Object)"living-cave"), TuplesKt.to((Object)"West Village", (Object)"village-plaza"), TuplesKt.to((Object)"Cake House", (Object)"village-plaza"), TuplesKt.to((Object)"Infested House", (Object)"village-plaza"), TuplesKt.to((Object)"Murder House", (Object)"village-plaza"), TuplesKt.to((Object)"Barry Center", (Object)"village-plaza"), TuplesKt.to((Object)"Barry HQ", (Object)"village-plaza"), TuplesKt.to((Object)"Photon Pathway", (Object)"stillgore-chateau"), TuplesKt.to((Object)"Stillgore Ch\u00e2teau", (Object)"stillgore-chateau"), TuplesKt.to((Object)"Oubliette", (Object)"stillgore-chateau"), TuplesKt.to((Object)"Fairylosopher Tower", (Object)"stillgore-chateau")};
        specialRiftRPC = MapsKt.mapOf((Pair[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IslandType.values().length];
            try {
                nArray[IslandType.THE_RIFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IslandType.HUB.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IslandType.CRIMSON_ISLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

