/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.misc.reminders;

import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import com.google.gson.annotations.Expose;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u000e\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0015\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0013\u0010\u0016\u001a\u00020\u0015*\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0018\u0010\nJ\u0010\u0010\u001b\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001d\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u001c\u0010\u001aJ.\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001a\u0010\"\u001a\u00020\u000e2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\"\u0010#J\u0010\u0010%\u001a\u00020$H\u00d6\u0001\u00a2\u0006\u0004\b%\u0010&J\u0010\u0010'\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b'\u0010\nR\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010(\u001a\u0004\b)\u0010\n\"\u0004\b*\u0010+R\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010,\u001a\u0004\b-\u0010\u001a\"\u0004\b.\u0010/R\"\u0010\u0006\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0006\u0010,\u001a\u0004\b0\u0010\u001a\"\u0004\b1\u0010/\u00a8\u00062"}, d2={"Lat/hannibal2/skyhanni/features/misc/reminders/Reminder;", "", "", "reason", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "remindAt", "lastReminder", "<init>", "(Ljava/lang/String;JJLkotlin/jvm/internal/DefaultConstructorMarker;)V", "formatShort", "()Ljava/lang/String;", "formatFull", "Lkotlin/time/Duration;", "interval", "", "shouldRemind-LRDsOJo", "(J)Z", "shouldRemind", "Ljava/time/ZonedDateTime;", "getRemindTime", "()Ljava/time/ZonedDateTime;", "Ljava/time/format/DateTimeFormatter;", "withDefaultLocale", "(Ljava/time/format/DateTimeFormatter;)Ljava/time/format/DateTimeFormatter;", "component1", "component2-uFjCsEo", "()J", "component2", "component3-uFjCsEo", "component3", "copy-c4H7LzA", "(Ljava/lang/String;JJ)Lat/hannibal2/skyhanni/features/misc/reminders/Reminder;", "copy", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getReason", "setReason", "(Ljava/lang/String;)V", "J", "getRemindAt-uFjCsEo", "setRemindAt-gJLAdNM", "(J)V", "getLastReminder-uFjCsEo", "setLastReminder-gJLAdNM", "1.21.10"})
public final class Reminder {
    @Expose
    @NotNull
    private String reason;
    @Expose
    private long remindAt;
    @Expose
    private long lastReminder;

    private Reminder(String reason, long remindAt, long lastReminder) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        this.reason = reason;
        this.remindAt = remindAt;
        this.lastReminder = lastReminder;
    }

    public /* synthetic */ Reminder(String string, long l, long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            l2 = SimpleTimeMark.Companion.farPast();
        }
        this(string, l, l2, null);
    }

    @NotNull
    public final String getReason() {
        return this.reason;
    }

    public final void setReason(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.reason = string;
    }

    public final long getRemindAt-uFjCsEo() {
        return this.remindAt;
    }

    public final void setRemindAt-gJLAdNM(long l) {
        this.remindAt = l;
    }

    public final long getLastReminder-uFjCsEo() {
        return this.lastReminder;
    }

    public final void setLastReminder-gJLAdNM(long l) {
        this.lastReminder = l;
    }

    @NotNull
    public final String formatShort() {
        ZonedDateTime time = this.getRemindTime();
        LocalDate date = time.toLocalDate();
        if (date.isEqual(LocalDate.now())) {
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT);
            Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofLocalizedTime(...)");
            String string = time.format(this.withDefaultLocale(dateTimeFormatter));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            return string;
        }
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT);
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofLocalizedDate(...)");
        String string = date.format(this.withDefaultLocale(dateTimeFormatter));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @NotNull
    public final String formatFull() {
        ZonedDateTime zonedDateTime = this.getRemindTime();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT);
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofLocalizedDateTime(...)");
        String string = zonedDateTime.format(this.withDefaultLocale(dateTimeFormatter));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    public final boolean shouldRemind-LRDsOJo(long interval) {
        return SimpleTimeMark.isInPast-impl(this.remindAt) && Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(this.lastReminder), (long)interval) >= 0;
    }

    private final ZonedDateTime getRemindTime() {
        ZonedDateTime zonedDateTime = Instant.ofEpochMilli(SimpleTimeMark.toMillis-impl(this.remindAt)).atZone(ZoneId.systemDefault());
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"atZone(...)");
        return zonedDateTime;
    }

    private final DateTimeFormatter withDefaultLocale(DateTimeFormatter $this$withDefaultLocale) {
        DateTimeFormatter dateTimeFormatter = $this$withDefaultLocale.withLocale(Locale.getDefault());
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"withLocale(...)");
        return dateTimeFormatter;
    }

    @NotNull
    public final String component1() {
        return this.reason;
    }

    public final long component2-uFjCsEo() {
        return this.remindAt;
    }

    public final long component3-uFjCsEo() {
        return this.lastReminder;
    }

    @NotNull
    public final Reminder copy-c4H7LzA(@NotNull String reason, long remindAt, long lastReminder) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        return new Reminder(reason, remindAt, lastReminder, null);
    }

    public static /* synthetic */ Reminder copy-c4H7LzA$default(Reminder reminder, String string, long l, long l2, int n, Object object) {
        if ((n & 1) != 0) {
            string = reminder.reason;
        }
        if ((n & 2) != 0) {
            l = reminder.remindAt;
        }
        if ((n & 4) != 0) {
            l2 = reminder.lastReminder;
        }
        return reminder.copy-c4H7LzA(string, l, l2);
    }

    @NotNull
    public String toString() {
        return "Reminder(reason=" + this.reason + ", remindAt=" + SimpleTimeMark.toString-impl(this.remindAt) + ", lastReminder=" + SimpleTimeMark.toString-impl(this.lastReminder) + ")";
    }

    public int hashCode() {
        int result2 = this.reason.hashCode();
        result2 = result2 * 31 + SimpleTimeMark.hashCode-impl(this.remindAt);
        result2 = result2 * 31 + SimpleTimeMark.hashCode-impl(this.lastReminder);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Reminder)) {
            return false;
        }
        Reminder reminder = (Reminder)other;
        if (!Intrinsics.areEqual((Object)this.reason, (Object)reminder.reason)) {
            return false;
        }
        if (!SimpleTimeMark.equals-impl0(this.remindAt, reminder.remindAt)) {
            return false;
        }
        return SimpleTimeMark.equals-impl0(this.lastReminder, reminder.lastReminder);
    }

    public /* synthetic */ Reminder(String reason, long remindAt, long lastReminder, DefaultConstructorMarker $constructor_marker) {
        this(reason, remindAt, lastReminder);
    }
}

