/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.rift.area.livingcave;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.rift.area.livingcave.LivingCaveLivingMetalConfig;
import at.hannibal2.skyhanni.data.ClickType;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.deps.moulconfig.ChromaColour;
import at.hannibal2.skyhanni.events.BlockClickEvent;
import at.hannibal2.skyhanni.events.ReceiveParticleEvent;
import at.hannibal2.skyhanni.events.ServerBlockChangeEvent;
import at.hannibal2.skyhanni.events.TitleReceivedEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniRenderWorldEvent;
import at.hannibal2.skyhanni.features.rift.RiftApi;
import at.hannibal2.skyhanni.utils.ColorUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.render.WorldRenderUtils;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\r\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0014\u0010\u001b\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u001c8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR$\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0016\u0010#\u001a\u00020\"8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0011\u0010(\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006)"}, d2={"Lat/hannibal2/skyhanni/features/rift/area/livingcave/LivingCaveLivingMetalHelper;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/BlockClickEvent;", "event", "", "onBlockClick", "(Lat/hannibal2/skyhanni/events/BlockClickEvent;)V", "Lat/hannibal2/skyhanni/events/ServerBlockChangeEvent;", "onBlockChange", "(Lat/hannibal2/skyhanni/events/ServerBlockChangeEvent;)V", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;)V", "Lat/hannibal2/skyhanni/events/ReceiveParticleEvent;", "onReceiveParticle", "(Lat/hannibal2/skyhanni/events/ReceiveParticleEvent;)V", "Lat/hannibal2/skyhanni/events/TitleReceivedEvent;", "onTitleReceived", "(Lat/hannibal2/skyhanni/events/TitleReceivedEvent;)V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/rift/area/livingcave/LivingCaveLivingMetalConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/rift/area/livingcave/LivingCaveLivingMetalConfig;", "config", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "lastClicked", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "Lkotlin/Pair;", "pair", "Lkotlin/Pair;", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "animationStartTime", "J", "Ljava/awt/Color;", "getColor", "()Ljava/awt/Color;", "color", "1.21.10"})
public final class LivingCaveLivingMetalHelper {
    @NotNull
    public static final LivingCaveLivingMetalHelper INSTANCE = new LivingCaveLivingMetalHelper();
    @Nullable
    private static LorenzVec lastClicked;
    @Nullable
    private static Pair<LorenzVec, LorenzVec> pair;
    private static long animationStartTime;

    private LivingCaveLivingMetalHelper() {
    }

    private final LivingCaveLivingMetalConfig getConfig() {
        return RiftApi.INSTANCE.getConfig().getArea().getLivingCave().getLivingMetal();
    }

    @HandleEvent(onlyOnIsland=IslandType.THE_RIFT)
    public final void onBlockClick(@NotNull BlockClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        if (event.getClickType() == ClickType.LEFT_CLICK) {
            String string = event.getGetBlockState().method_26204().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String name2 = string;
            if (StringsKt.contains$default((CharSequence)name2, (CharSequence)"lapis_ore", (boolean)false, (int)2, null)) {
                lastClicked = event.getPosition();
            }
        }
    }

    @HandleEvent
    public final void onBlockChange(@NotNull ServerBlockChangeEvent event) {
        block7: {
            Object it;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!this.isEnabled()) {
                return;
            }
            LorenzVec location = event.getLocation();
            if (LocationUtils.INSTANCE.distanceToPlayer(location) >= 7.0) {
                return;
            }
            if (Intrinsics.areEqual((Object)event.getOld(), (Object)"lapis_ore")) {
                Pair<LorenzVec, LorenzVec> pair = LivingCaveLivingMetalHelper.pair;
                if (pair != null) {
                    it = pair;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.getSecond(), (Object)location)) {
                        LivingCaveLivingMetalHelper.pair = null;
                    }
                }
            }
            if (!Intrinsics.areEqual((Object)event.getNew(), (Object)"lapis_ore")) {
                return;
            }
            LorenzVec lorenzVec = lastClicked;
            if (lorenzVec == null) break block7;
            it = lorenzVec;
            boolean bl = false;
            double distance = location.distance((LorenzVec)it);
            if (distance < 2.0) {
                pair = new Pair(it, (Object)location);
                animationStartTime = SimpleTimeMark.Companion.now-uFjCsEo();
            }
        }
    }

    @HandleEvent
    public final void onRenderWorld(@NotNull SkyHanniRenderWorldEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        Pair<LorenzVec, LorenzVec> pair = LivingCaveLivingMetalHelper.pair;
        if (pair == null) {
            return;
        }
        Pair<LorenzVec, LorenzVec> pair2 = pair;
        LorenzVec a = (LorenzVec)pair2.component1();
        LorenzVec b = (LorenzVec)pair2.component2();
        if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(animationStartTime), (long)DurationKt.toDuration((int)4, (DurationUnit)DurationUnit.SECONDS)) > 0) {
            return;
        }
        long maxTime = DurationKt.toDuration((int)500, (DurationUnit)DurationUnit.MILLISECONDS);
        LorenzVec location = LocationUtils.INSTANCE.interpolateOverTime-Oud1_DA(animationStartTime, maxTime, a, b);
        WorldRenderUtils.drawWaypointFilled$default(WorldRenderUtils.INSTANCE, event, location, this.getColor(), LocationUtils.INSTANCE.distanceToPlayer(location) < 10.0, false, 0.0, 0.0, 0.0, 0.0f, false, 504, null);
    }

    @HandleEvent
    public final void onReceiveParticle(@NotNull ReceiveParticleEvent event) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!this.isEnabled()) {
                return;
            }
            if (!this.getConfig().getHideParticles()) {
                return;
            }
            Pair<LorenzVec, LorenzVec> pair = LivingCaveLivingMetalHelper.pair;
            if (pair == null) break block3;
            Pair<LorenzVec, LorenzVec> it = pair;
            boolean bl = false;
            if (((LorenzVec)it.getSecond()).distance(event.getLocation()) < 3.0) {
                event.cancel();
            }
        }
    }

    @HandleEvent
    public final void onTitleReceived(@NotNull TitleReceivedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        if (StringsKt.contains$default((CharSequence)event.getTitle(), (CharSequence)"Living Metal", (boolean)false, (int)2, null)) {
            pair = null;
        }
    }

    @NotNull
    public final Color getColor() {
        Object t = this.getConfig().getColor().get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        return ColorUtils.INSTANCE.toColor((ChromaColour)t);
    }

    public final boolean isEnabled() {
        return RiftApi.INSTANCE.inRift() && (RiftApi.INSTANCE.inLivingCave() || RiftApi.INSTANCE.inLivingStillness()) && this.getConfig().getEnabled();
    }

    static {
        animationStartTime = SimpleTimeMark.Companion.farPast();
    }
}

