/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.skillprogress;

import at.hannibal2.skyhanni.api.SkillApi;
import at.hannibal2.skyhanni.features.skillprogress.SkillLevel;
import at.hannibal2.skyhanni.features.skillprogress.SkillType;
import com.google.common.base.Splitter;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u000f\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\t\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\t\u00a2\u0006\u0004\b\u0015\u0010\rJ\u0015\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\t\u00a2\u0006\u0004\b\u0017\u0010\rJ\u001d\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\t\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u001f\u0010\u001f\u001a\n \u001e*\u0004\u0018\u00010\u001d0\u001d8\u0006\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lat/hannibal2/skyhanni/features/skillprogress/SkillUtil;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/features/skillprogress/SkillType;", "skill", "Lat/hannibal2/skyhanni/api/SkillApi$SkillInfo;", "getSkillInfo", "(Lat/hannibal2/skyhanni/features/skillprogress/SkillType;)Lat/hannibal2/skyhanni/api/SkillApi$SkillInfo;", "", "desiredLevel", "", "xpRequiredForLevel", "(I)J", "neededXP", "getLevelExact", "(J)I", "level", "", "calculateLevelXP", "(I)D", "calculateXPForCurrentLevel", "currentLevel", "calculateXPToNextLevel", "currentXP", "maxSkillCap", "Lat/hannibal2/skyhanni/features/skillprogress/SkillLevel;", "calculateSkillLevel", "(JI)Lat/hannibal2/skyhanni/features/skillprogress/SkillLevel;", "Lcom/google/common/base/Splitter;", "kotlin.jvm.PlatformType", "SPACE_SPLITTER", "Lcom/google/common/base/Splitter;", "getSPACE_SPLITTER", "()Lcom/google/common/base/Splitter;", "XP_NEEDED_FOR_60", "J", "1.21.10"})
@SourceDebugExtension(value={"SMAP\nSkillUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkillUtil.kt\nat/hannibal2/skyhanni/features/skillprogress/SkillUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1#2:117\n*E\n"})
public final class SkillUtil {
    @NotNull
    public static final SkillUtil INSTANCE = new SkillUtil();
    private static final Splitter SPACE_SPLITTER = Splitter.on((String)"  ").omitEmptyStrings().trimResults();
    private static final long XP_NEEDED_FOR_60 = 111672425L;

    private SkillUtil() {
    }

    public final Splitter getSPACE_SPLITTER() {
        return SPACE_SPLITTER;
    }

    @Nullable
    public final SkillApi.SkillInfo getSkillInfo(@NotNull SkillType skill) {
        Intrinsics.checkNotNullParameter((Object)((Object)skill), (String)"skill");
        Map<SkillType, SkillApi.SkillInfo> map = SkillApi.INSTANCE.getStorage();
        return map != null ? map.get((Object)skill) : null;
    }

    public final long xpRequiredForLevel(int desiredLevel) {
        long totalXP = 0L;
        int maxLevel = 60;
        if (desiredLevel <= maxLevel) {
            int level = 1;
            if (level <= desiredLevel) {
                while (true) {
                    Integer n = SkillApi.INSTANCE.getLevelingMap().get(level);
                    totalXP += n != null ? (long)n.intValue() : 0L;
                    if (level != desiredLevel) {
                        ++level;
                        continue;
                    }
                    break;
                }
            }
        } else {
            long xpNeeded = 111672425L;
            totalXP += xpNeeded;
            int level = 60;
            long xpForNext = 7600000L;
            long slope = 600000L;
            while (level < desiredLevel) {
                totalXP += xpForNext;
                xpForNext += slope;
                if (++level % 10 != 0) continue;
                slope *= (long)2;
            }
        }
        return totalXP;
    }

    public final int getLevelExact(long neededXP) {
        SkillType skillType = SkillApi.INSTANCE.getActiveSkill();
        return ((Number)SkillApi.INSTANCE.getExactLevelingMap().getOrDefault((int)neededXP, skillType != null ? skillType.getMaxLevel() : 60)).intValue();
    }

    /*
     * WARNING - void declaration
     */
    public final double calculateLevelXP(int level) {
        Sequence sequence2 = SequencesKt.take((Sequence)CollectionsKt.asSequence((Iterable)SkillApi.INSTANCE.getLevelArray()), (int)(level + 1));
        double d = 0.0;
        for (Object e : sequence2) {
            void it;
            int n = ((Number)e).intValue();
            double d2 = d;
            boolean bl = false;
            double d3 = (double)it;
            d = d2 + d3;
        }
        return d;
    }

    public final long calculateXPForCurrentLevel(int level) {
        Integer n = (Integer)CollectionsKt.getOrNull(SkillApi.INSTANCE.getLevelArray(), (int)level);
        return n != null ? (long)n.intValue() : 4000000L;
    }

    public final long calculateXPToNextLevel(int currentLevel) {
        Integer n = (Integer)CollectionsKt.getOrNull(SkillApi.INSTANCE.getLevelArray(), (int)currentLevel);
        long xpForCurrentLevel = n != null ? (long)n.intValue() : 4000000L;
        Integer n2 = (Integer)CollectionsKt.getOrNull(SkillApi.INSTANCE.getLevelArray(), (int)(currentLevel + 1));
        long xpForNextLevel = n2 != null ? (long)n2.intValue() : 4300000L;
        return xpForNextLevel - xpForCurrentLevel;
    }

    @NotNull
    public final SkillLevel calculateSkillLevel(long currentXP, int maxSkillCap) {
        long xpNeeded;
        int level;
        long xpCurrent = currentXP;
        int maxLevel = RangesKt.coerceAtMost((int)maxSkillCap, (int)60);
        for (level = 0; level < maxLevel; ++level) {
            Integer n = SkillApi.INSTANCE.getLevelingMap().get(level + 1);
            if (xpCurrent < (n != null ? (long)n.intValue() : Long.MAX_VALUE)) break;
            Integer n2 = SkillApi.INSTANCE.getLevelingMap().get(level + 1);
            long xpForNextLevel = n2 != null ? (long)n2.intValue() : Long.MAX_VALUE;
            xpCurrent -= xpForNextLevel;
        }
        Integer n = SkillApi.INSTANCE.getLevelingMap().get(level + 1);
        long xpForNext = n != null ? (long)n.intValue() : 0L;
        long overflowXP = 0L;
        if (level >= maxLevel && currentXP >= (xpNeeded = this.xpRequiredForLevel(maxLevel))) {
            long xpForCurr;
            xpCurrent = overflowXP = currentXP - xpNeeded;
            long slope = this.calculateXPToNextLevel(maxLevel);
            for (xpForCurr = this.calculateXPForCurrentLevel(maxLevel) + slope; xpCurrent >= xpForCurr && level < 60; xpCurrent -= xpForCurr, xpForCurr += slope) {
                slope = this.calculateXPToNextLevel(++level);
            }
            if (level >= 60) {
                slope = 600000L;
                for (xpForCurr = 7000000L + slope; xpCurrent >= xpForCurr; xpCurrent -= xpForCurr, xpForCurr += slope) {
                    if (++level % 10 != 0) continue;
                    slope *= (long)2;
                }
            }
            xpForNext = xpForCurr;
        }
        return new SkillLevel(level, xpCurrent, xpForNext, overflowXP);
    }
}

