/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils;

import at.hannibal2.skyhanni.utils.BezierCurve;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.PolynomialFitter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0010\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0013\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\r\u0010\u0015\u001a\u00020\b\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0017R\u001d\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u00188\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0018\u0010!\u001a\u0004\u0018\u00010\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Lat/hannibal2/skyhanni/utils/BezierFitter;", "", "", "degree", "<init>", "(I)V", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "point", "", "addPoint", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)V", "getLastPoint", "()Lat/hannibal2/skyhanni/utils/LorenzVec;", "", "isEmpty", "()Z", "count", "()I", "Lat/hannibal2/skyhanni/utils/BezierCurve;", "fit", "()Lat/hannibal2/skyhanni/utils/BezierCurve;", "reset", "()V", "I", "", "points", "Ljava/util/List;", "getPoints", "()Ljava/util/List;", "", "Lat/hannibal2/skyhanni/utils/PolynomialFitter;", "fitters", "[Lat/hannibal2/skyhanni/utils/PolynomialFitter;", "lastCurve", "Lat/hannibal2/skyhanni/utils/BezierCurve;", "1.21.10"})
@SourceDebugExtension(value={"SMAP\nPolynomialFitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolynomialFitter.kt\nat/hannibal2/skyhanni/utils/BezierFitter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,117:1\n1#2:118\n11228#3:119\n11563#3,3:120\n11228#3:123\n11563#3,3:124\n*S KotlinDebug\n*F\n+ 1 PolynomialFitter.kt\nat/hannibal2/skyhanni/utils/BezierFitter\n*L\n63#1:119\n63#1:120,3\n70#1:123\n70#1:124,3\n*E\n"})
public class BezierFitter {
    private final int degree;
    @NotNull
    private final List<LorenzVec> points;
    @NotNull
    private final PolynomialFitter[] fitters;
    @Nullable
    private BezierCurve lastCurve;

    public BezierFitter(int degree) {
        this.degree = degree;
        this.points = new ArrayList();
        PolynomialFitter[] polynomialFitterArray = new PolynomialFitter[]{new PolynomialFitter(this.degree), new PolynomialFitter(this.degree), new PolynomialFitter(this.degree)};
        this.fitters = polynomialFitterArray;
    }

    @NotNull
    public final List<LorenzVec> getPoints() {
        return this.points;
    }

    public final void addPoint(@NotNull LorenzVec point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        if (!(Math.abs(point.getX()) <= Double.MAX_VALUE && Math.abs(point.getY()) <= Double.MAX_VALUE && Math.abs(point.getZ()) <= Double.MAX_VALUE)) {
            boolean bl = false;
            String string = "Points may not contain NaN!";
            throw new IllegalArgumentException(string.toString());
        }
        Double[] locationArray = point.toDoubleArray();
        PolynomialFitter[] polynomialFitterArray = this.fitters;
        int n = polynomialFitterArray.length;
        for (int j = 0; j < n; ++j) {
            int i2 = j;
            PolynomialFitter fitter = polynomialFitterArray[j];
            fitter.addPoint(this.points.size(), locationArray[i2]);
        }
        this.points.add(point);
        this.lastCurve = null;
    }

    @Nullable
    public final LorenzVec getLastPoint() {
        return (LorenzVec)CollectionsKt.lastOrNull(this.points);
    }

    public final boolean isEmpty() {
        return this.points.isEmpty();
    }

    public final int count() {
        return this.points.size();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final BezierCurve fit() {
        void $this$mapTo$iv$iv;
        if (this.points.size() <= this.degree) {
            return null;
        }
        if (this.lastCurve != null) {
            return this.lastCurve;
        }
        PolynomialFitter[] $this$map$iv = this.fitters;
        boolean $i$f$map = false;
        PolynomialFitter[] polynomialFitterArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv$iv;
            void var10_9 = item$iv$iv = $this$mapTo$iv$iv[j];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.fit());
        }
        List coefficients = (List)destination$iv$iv;
        this.lastCurve = new BezierCurve(coefficients);
        return this.lastCurve;
    }

    /*
     * WARNING - void declaration
     */
    public final void reset() {
        void $this$mapTo$iv$iv;
        this.points.clear();
        PolynomialFitter[] $this$map$iv = this.fitters;
        boolean $i$f$map = false;
        PolynomialFitter[] polynomialFitterArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv$iv;
            void var9_9 = item$iv$iv = $this$mapTo$iv$iv[j];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            it.reset();
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        this.lastCurve = null;
    }
}

