/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.data.mob;

import at.hannibal2.skyhanni.data.ElectionApi;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.mob.Mob;
import at.hannibal2.skyhanni.data.mob.MobData;
import at.hannibal2.skyhanni.data.mob.MobFactories;
import at.hannibal2.skyhanni.data.mob.MobFilter;
import at.hannibal2.skyhanni.utils.EntityUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzVecKt;
import at.hannibal2.skyhanni.utils.MobUtils;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.compat.EntityCompatKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGiantZombie;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0004\b\n\u0010\u000bJ-\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0004\b\r\u0010\u000bJ#\u0010\u000e\u001a\u0004\u0018\u00010\t2\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ-\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J-\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u000bJ\u0019\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0019\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0014J#\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J-\u0010\u0018\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u000bJ\u0019\u0010\u0019\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0014J#\u0010\u001a\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0019\u0010\u001c\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u0014J#\u0010\u001e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u001d2\b\u0010\b\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010 \u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b \u0010\u0014R\u0014\u0010\"\u001a\u00020!8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020!8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b$\u0010#\u00a8\u0006%"}, d2={"Lat/hannibal2/skyhanni/data/mob/IslandExceptions;", "", "<init>", "()V", "Lnet/minecraft/entity/EntityLivingBase;", "baseEntity", "Lnet/minecraft/entity/item/EntityArmorStand;", "armorStand", "nextEntity", "Lat/hannibal2/skyhanni/data/mob/MobData$MobResult;", "islandSpecificExceptions$1_8_9", "(Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/entity/item/EntityArmorStand;Lnet/minecraft/entity/EntityLivingBase;)Lat/hannibal2/skyhanni/data/mob/MobData$MobResult;", "islandSpecificExceptions", "dungeon", "privateIsland", "(Lnet/minecraft/entity/item/EntityArmorStand;Lnet/minecraft/entity/EntityLivingBase;)Lat/hannibal2/skyhanni/data/mob/MobData$MobResult;", "theRift", "(Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/entity/item/EntityArmorStand;)Lat/hannibal2/skyhanni/data/mob/MobData$MobResult;", "crimsonIsle", "deepCaverns", "(Lnet/minecraft/entity/EntityLivingBase;)Lat/hannibal2/skyhanni/data/mob/MobData$MobResult;", "dwarvenMines", "crystalHollows", "(Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/entity/item/EntityArmorStand;)Lat/hannibal2/skyhanni/data/mob/MobData$MobResult;", "hub", "garden", "kuudraArena", "(Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/entity/EntityLivingBase;)Lat/hannibal2/skyhanni/data/mob/MobData$MobResult;", "winterIsland", "Lnet/minecraft/entity/monster/EntityZombie;", "ratHandler", "(Lnet/minecraft/entity/monster/EntityZombie;Lnet/minecraft/entity/EntityLivingBase;)Lat/hannibal2/skyhanni/data/mob/MobData$MobResult;", "petCareHandler", "", "RAT_SEARCH_START", "I", "RAT_SEARCH_UP_TO", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nIslandExceptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IslandExceptions.kt\nat/hannibal2/skyhanni/data/mob/IslandExceptions\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n*L\n1#1,292:1\n1#2:293\n1#2:306\n1#2:310\n183#3,2:294\n1611#4,9:296\n1863#4:305\n1864#4:307\n1620#4:308\n8#5:309\n*S KotlinDebug\n*F\n+ 1 IslandExceptions.kt\nat/hannibal2/skyhanni/data/mob/IslandExceptions\n*L\n276#1:306\n278#1:310\n267#1:294,2\n276#1:296,9\n276#1:305\n276#1:307\n276#1:308\n278#1:309\n*E\n"})
public final class IslandExceptions {
    @NotNull
    public static final IslandExceptions INSTANCE = new IslandExceptions();
    private static final int RAT_SEARCH_START = 1;
    private static final int RAT_SEARCH_UP_TO = 11;

    private IslandExceptions() {
    }

    @Nullable
    public final MobData.MobResult islandSpecificExceptions$1_8_9(@NotNull EntityLivingBase baseEntity, @Nullable EntityArmorStand armorStand, @Nullable EntityLivingBase nextEntity) {
        MobData.MobResult mobResult;
        Intrinsics.checkNotNullParameter(baseEntity, "baseEntity");
        switch (WhenMappings.$EnumSwitchMapping$0[SkyBlockUtils.INSTANCE.getCurrentIsland().ordinal()]) {
            case 1: {
                mobResult = this.dungeon(baseEntity, armorStand, nextEntity);
                break;
            }
            case 2: {
                mobResult = this.privateIsland(armorStand, baseEntity);
                break;
            }
            case 3: {
                mobResult = this.theRift(baseEntity, nextEntity, armorStand);
                break;
            }
            case 4: {
                mobResult = this.crimsonIsle(baseEntity, armorStand, nextEntity);
                break;
            }
            case 5: {
                mobResult = this.deepCaverns(baseEntity);
                break;
            }
            case 6: {
                mobResult = this.dwarvenMines(baseEntity);
                break;
            }
            case 7: {
                mobResult = this.crystalHollows(baseEntity, armorStand);
                break;
            }
            case 8: {
                mobResult = this.hub(baseEntity, armorStand, nextEntity);
                break;
            }
            case 9: {
                mobResult = this.garden(baseEntity);
                break;
            }
            case 10: {
                mobResult = this.kuudraArena(baseEntity, nextEntity);
                break;
            }
            case 11: {
                mobResult = this.winterIsland(baseEntity);
                break;
            }
            default: {
                mobResult = null;
            }
        }
        return mobResult;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final MobData.MobResult dungeon(EntityLivingBase baseEntity, EntityArmorStand armorStand, EntityLivingBase nextEntity) {
        MobData.MobResult mobResult;
        if (baseEntity instanceof EntityZombie && armorStand != null && (Intrinsics.areEqual(armorStand.func_70005_c_(), "\u00a7e\ufd3e \u00a75\u2643 \u00a7c\u00a7lThe Watcher\u00a7r\u00a7r \u00a7e\ufd3f") || Intrinsics.areEqual(armorStand.func_70005_c_(), "\u00a73\u00a7lWatchful Eye\u00a7r"))) {
            mobResult = MobData.MobResult.Companion.found(MobFactories.INSTANCE.special(baseEntity, EntityUtils.INSTANCE.cleanName((Entity)armorStand), armorStand));
            return mobResult;
        }
        if (baseEntity instanceof EntityCaveSpider) {
            mobResult = MobFilter.INSTANCE.makeMobResult$1_8_9(MobUtils.INSTANCE.takeNonDefault(MobUtils.INSTANCE.getClosestArmorStand((Entity)baseEntity, 2.0)), arg_0 -> IslandExceptions.dungeon$lambda$0(baseEntity, arg_0));
            return mobResult;
        }
        if (baseEntity instanceof EntityOtherPlayerMP && EntityUtils.INSTANCE.isNpc((EntityPlayer)baseEntity) && Intrinsics.areEqual(((EntityOtherPlayerMP)baseEntity).func_70005_c_(), "Shadow Assassin")) {
            mobResult = MobFilter.INSTANCE.makeMobResult$1_8_9(MobUtils.INSTANCE.getClosestArmorStandWithName((Entity)baseEntity, 3.0, "Shadow Assassin"), arg_0 -> IslandExceptions.dungeon$lambda$1(baseEntity, arg_0));
            return mobResult;
        }
        if (baseEntity instanceof EntityOtherPlayerMP && EntityUtils.INSTANCE.isNpc((EntityPlayer)baseEntity) && Intrinsics.areEqual(((EntityOtherPlayerMP)baseEntity).func_70005_c_(), "The Professor")) {
            mobResult = MobFilter.INSTANCE.makeMobResult$1_8_9(MobUtils.INSTANCE.getArmorStand((Entity)baseEntity, 9), arg_0 -> IslandExceptions.dungeon$lambda$2(baseEntity, arg_0));
            return mobResult;
        }
        if (baseEntity instanceof EntityOtherPlayerMP && EntityUtils.INSTANCE.isNpc((EntityPlayer)baseEntity) && (nextEntity instanceof EntityGiantZombie || nextEntity == null)) {
            String string = ((EntityOtherPlayerMP)baseEntity).func_70005_c_();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            if (StringsKt.contains$default((CharSequence)string, "Livid", false, 2, null)) {
                Object object;
                MobFilter mobFilter = MobFilter.INSTANCE;
                EntityArmorStand entityArmorStand = MobUtils.INSTANCE.getArmorStand((Entity)baseEntity, 10);
                if (entityArmorStand != null) {
                    Object object2;
                    void it;
                    EntityArmorStand entityArmorStand2;
                    EntityArmorStand entityArmorStand3 = entityArmorStand2 = entityArmorStand;
                    MobFilter mobFilter2 = mobFilter;
                    boolean bl = false;
                    Entity entity = MobUtils.INSTANCE.getNextEntity((Entity)it, -1);
                    if (entity != null) {
                        Entity entity2;
                        Entity entity3 = entity2 = entity;
                        boolean bl2 = false;
                        String string2 = entity3.func_70005_c_();
                        Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
                        object2 = StringsKt.contains$default((CharSequence)string2, "Livid", false, 2, null) ? entity2 : null;
                    } else {
                        object2 = null;
                    }
                    boolean bl3 = object2 == null;
                    mobFilter = mobFilter2;
                    object = bl3 ? entityArmorStand2 : null;
                } else {
                    object = null;
                }
                mobResult = mobFilter.makeMobResult$1_8_9((EntityArmorStand)object, arg_0 -> IslandExceptions.dungeon$lambda$5(baseEntity, arg_0));
                return mobResult;
            }
        }
        if (!(baseEntity instanceof EntityIronGolem)) return null;
        Pattern pattern = MobFilter.INSTANCE.getWokeSleepingGolemPattern();
        EntityArmorStand entityArmorStand = armorStand;
        String string = entityArmorStand != null ? entityArmorStand.func_70005_c_() : null;
        if (string == null) {
            string = "";
        }
        if (!RegexUtils.INSTANCE.matches(pattern, string)) return null;
        mobResult = MobData.MobResult.Companion.found(new Mob(baseEntity, Mob.Type.DUNGEON, armorStand, "Sleeping Golem", null, null, false, null, 0, null, 1008, null));
        return mobResult;
    }

    private final MobData.MobResult privateIsland(EntityArmorStand armorStand, EntityLivingBase baseEntity) {
        EntityArmorStand entityArmorStand = armorStand;
        boolean bl = entityArmorStand != null ? !MobUtils.INSTANCE.isDefaultValue(entityArmorStand) : false;
        return !bl ? (LorenzVecKt.getLorenzVec((Entity)baseEntity).distanceChebyshevIgnoreY(LocationUtils.INSTANCE.playerLocation()) < 15.0 ? MobData.MobResult.Companion.found(MobFactories.INSTANCE.minionMob(baseEntity)) : MobData.MobResult.Companion.getNotYetFound()) : null;
    }

    private final MobData.MobResult theRift(EntityLivingBase baseEntity, EntityLivingBase nextEntity, EntityArmorStand armorStand) {
        return baseEntity instanceof EntitySlime && nextEntity instanceof EntitySlime ? MobData.MobResult.Companion.found(new Mob(baseEntity, Mob.Type.SPECIAL, armorStand, "Bacte Tentacle", null, null, false, null, 0, null, 1008, null)) : (baseEntity instanceof EntitySlime && armorStand != null && StringsKt.startsWith$default(EntityUtils.INSTANCE.cleanName((Entity)armorStand), "\ufd3e [Lv10] B", false, 2, null) ? MobData.MobResult.Companion.found(new Mob(baseEntity, Mob.Type.BOSS, armorStand, "Bacte", null, null, false, null, 0, null, 1008, null)) : (baseEntity instanceof EntityOtherPlayerMP && EntityUtils.INSTANCE.isNpc((EntityPlayer)baseEntity) && Intrinsics.areEqual(((EntityOtherPlayerMP)baseEntity).func_70005_c_(), "Branchstrutter ") ? MobData.MobResult.Companion.found(new Mob(baseEntity, Mob.Type.DISPLAY_NPC, null, "Branchstrutter", null, null, false, null, 0, null, 1012, null)) : null));
    }

    /*
     * Enabled aggressive block sorting
     */
    private final MobData.MobResult crimsonIsle(EntityLivingBase baseEntity, EntityArmorStand armorStand, EntityLivingBase nextEntity) {
        MobData.MobResult mobResult;
        if (baseEntity instanceof EntitySlime) {
            EntityArmorStand entityArmorStand = armorStand;
            if (RegexUtils.INSTANCE.matches(MobFilter.INSTANCE.getHeavyPearlPattern(), entityArmorStand != null ? entityArmorStand.func_70005_c_() : null)) {
                mobResult = MobData.MobResult.Companion.found(MobFactories.special$default(MobFactories.INSTANCE, baseEntity, "Heavy Pearl", null, 4, null));
                return mobResult;
            }
        }
        if (baseEntity instanceof EntityPig && nextEntity instanceof EntityPig) {
            mobResult = MobData.MobResult.Companion.getIllegal();
            return mobResult;
        }
        if (baseEntity instanceof EntityOtherPlayerMP && EntityUtils.INSTANCE.isNpc((EntityPlayer)baseEntity) && Intrinsics.areEqual(((EntityOtherPlayerMP)baseEntity).func_70005_c_(), "BarbarianGuard ")) {
            mobResult = MobData.MobResult.Companion.found(new Mob(baseEntity, Mob.Type.DISPLAY_NPC, null, "Barbarian Guard", null, null, false, null, 0, null, 1012, null));
            return mobResult;
        }
        if (baseEntity instanceof EntityOtherPlayerMP && EntityUtils.INSTANCE.isNpc((EntityPlayer)baseEntity) && Intrinsics.areEqual(((EntityOtherPlayerMP)baseEntity).func_70005_c_(), "MageGuard ")) {
            mobResult = MobData.MobResult.Companion.found(new Mob(baseEntity, Mob.Type.DISPLAY_NPC, null, "Mage Guard", null, null, false, null, 0, null, 1012, null));
            return mobResult;
        }
        if (baseEntity instanceof EntityOtherPlayerMP && EntityUtils.INSTANCE.isNpc((EntityPlayer)baseEntity) && Intrinsics.areEqual(((EntityOtherPlayerMP)baseEntity).func_70005_c_(), "Mage Outlaw")) {
            mobResult = MobData.MobResult.Companion.found(new Mob(baseEntity, Mob.Type.BOSS, armorStand, "Mage Outlaw", null, null, false, null, 0, null, 1008, null));
            return mobResult;
        }
        if (baseEntity instanceof EntityPigZombie) {
            ItemStack itemStack = EntityCompatKt.getEntityHelmet((EntityLiving)baseEntity);
            if (Intrinsics.areEqual(itemStack != null ? ItemUtils.INSTANCE.getSkullTexture(itemStack) : null, MobFilter.INSTANCE.getNPC_TURD_SKULL$1_8_9())) {
                mobResult = MobData.MobResult.Companion.found(new Mob(baseEntity, Mob.Type.DISPLAY_NPC, null, "Turd", null, null, false, null, 0, null, 1012, null));
                return mobResult;
            }
        }
        if (!(baseEntity instanceof EntityOcelot)) {
            return null;
        }
        if (MobFilter.INSTANCE.createDisplayNpc(baseEntity)) {
            mobResult = MobData.MobResult.Companion.getIllegal();
            return mobResult;
        }
        mobResult = MobData.MobResult.Companion.getNotYetFound();
        return mobResult;
    }

    private final MobData.MobResult deepCaverns(EntityLivingBase baseEntity) {
        return baseEntity instanceof EntityCreeper && ElectionApi.INSTANCE.derpy(EntityUtils.INSTANCE.getBaseMaxHealth(baseEntity)) == 120 ? MobData.MobResult.Companion.found(new Mob(baseEntity, Mob.Type.BASIC, null, "Sneaky Creeper", null, null, false, null, 3, null, 756, null)) : null;
    }

    private final MobData.MobResult dwarvenMines(EntityLivingBase baseEntity) {
        return baseEntity instanceof EntityCreeper && ElectionApi.INSTANCE.derpy(EntityUtils.INSTANCE.getBaseMaxHealth(baseEntity)) == 1000000 ? MobData.MobResult.Companion.found(MobFactories.INSTANCE.basic(baseEntity, "Ghost")) : null;
    }

    private final MobData.MobResult crystalHollows(EntityLivingBase baseEntity, EntityArmorStand armorStand) {
        return baseEntity instanceof EntityMagmaCube && armorStand != null && Intrinsics.areEqual(EntityUtils.INSTANCE.cleanName((Entity)armorStand), "[Lv100] Bal ???\u2764") ? MobData.MobResult.Companion.found(new Mob(baseEntity, Mob.Type.BOSS, armorStand, "Bal", null, null, false, null, 100, null, 752, null)) : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final MobData.MobResult hub(EntityLivingBase baseEntity, EntityArmorStand armorStand, EntityLivingBase nextEntity) {
        MobData.MobResult mobResult;
        if (baseEntity instanceof EntityOcelot) {
            EntityArmorStand entityArmorStand = armorStand;
            boolean bl = entityArmorStand != null ? !MobUtils.INSTANCE.isDefaultValue(entityArmorStand) : false;
            if (bl) {
                String string = armorStand.func_70005_c_();
                Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                if (StringsKt.startsWith$default(string, "\u00a78[\u00a77Lv155\u00a78] \u00a7cAzrael\u00a7r", false, 2, null)) {
                    mobResult = MobFilter.INSTANCE.makeMobResult$1_8_9(MobUtils.INSTANCE.getArmorStand((Entity)baseEntity, 1), arg_0 -> IslandExceptions.hub$lambda$6(baseEntity, arg_0));
                    return mobResult;
                }
            }
        }
        if (baseEntity instanceof EntityOcelot && (nextEntity instanceof EntityOcelot || nextEntity == null)) {
            mobResult = MobFilter.INSTANCE.makeMobResult$1_8_9(MobUtils.INSTANCE.getArmorStand((Entity)baseEntity, 3), arg_0 -> IslandExceptions.hub$lambda$7(baseEntity, arg_0));
            return mobResult;
        }
        if (baseEntity instanceof EntityOtherPlayerMP) {
            String it = ((EntityOtherPlayerMP)baseEntity).func_70005_c_();
            boolean bl = false;
            boolean bl2 = Intrinsics.areEqual(it, "Minos Champion") || Intrinsics.areEqual(it, "Minos Inquisitor") || Intrinsics.areEqual(it, "Minotaur ");
            if (bl2 && armorStand != null) {
                mobResult = MobFilter.INSTANCE.makeMobResult$1_8_9(MobUtils.INSTANCE.getArmorStand((Entity)baseEntity, 2), arg_0 -> IslandExceptions.hub$lambda$9(baseEntity, armorStand, arg_0));
                return mobResult;
            }
        }
        if (baseEntity instanceof EntityZombie) {
            EntityArmorStand entityArmorStand = armorStand;
            boolean bl = entityArmorStand != null ? MobUtils.INSTANCE.isDefaultValue(entityArmorStand) : false;
            if (bl) {
                Object object = MobUtils.INSTANCE.getNextEntity((Entity)baseEntity, 4);
                boolean bl3 = object != null && (object = object.func_70005_c_()) != null ? StringsKt.startsWith$default((String)object, "\u00a7e", false, 2, null) : false;
                if (bl3) {
                    mobResult = this.petCareHandler(baseEntity);
                    return mobResult;
                }
            }
        }
        if (baseEntity instanceof EntityZombie && armorStand != null && !MobUtils.INSTANCE.isDefaultValue(armorStand)) {
            return null;
        }
        if (baseEntity instanceof EntityZombie) {
            mobResult = this.ratHandler((EntityZombie)baseEntity, nextEntity);
            return mobResult;
        }
        if (!(baseEntity instanceof EntityPig)) return null;
        EntityArmorStand entityArmorStand = armorStand;
        if (!RegexUtils.INSTANCE.matches(MobFilter.INSTANCE.getShinyPig(), entityArmorStand != null ? EntityUtils.INSTANCE.cleanName((Entity)entityArmorStand) : null)) return null;
        mobResult = MobData.MobResult.Companion.found(new Mob(baseEntity, Mob.Type.SPECIAL, armorStand, "SHINY PIG", null, null, false, null, 0, null, 1008, null));
        return mobResult;
    }

    private final MobData.MobResult garden(EntityLivingBase baseEntity) {
        return baseEntity instanceof EntityOtherPlayerMP && EntityUtils.INSTANCE.isNpc((EntityPlayer)baseEntity) ? MobData.MobResult.Companion.found(new Mob(baseEntity, Mob.Type.DISPLAY_NPC, null, EntityUtils.INSTANCE.cleanName((Entity)baseEntity), null, null, false, null, 0, null, 1012, null)) : null;
    }

    private final MobData.MobResult kuudraArena(EntityLivingBase baseEntity, EntityLivingBase nextEntity) {
        return baseEntity instanceof EntityMagmaCube && nextEntity instanceof EntityMagmaCube ? MobData.MobResult.Companion.getIllegal() : (baseEntity instanceof EntityZombie && nextEntity instanceof EntityZombie ? MobData.MobResult.Companion.getIllegal() : (baseEntity instanceof EntityZombie && nextEntity instanceof EntityGiantZombie ? MobData.MobResult.Companion.getIllegal() : null));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final MobData.MobResult winterIsland(EntityLivingBase baseEntity) {
        EntityArmorStand armorStand = MobUtils.INSTANCE.getArmorStand((Entity)baseEntity, 2);
        if (!(baseEntity instanceof EntityMagmaCube)) return null;
        EntityArmorStand entityArmorStand = armorStand;
        if (!RegexUtils.INSTANCE.matches(MobFilter.INSTANCE.getJerryMagmaCubePattern(), entityArmorStand != null ? entityArmorStand.func_70005_c_() : null)) return null;
        MobData.MobResult mobResult = MobData.MobResult.Companion.found(new Mob(baseEntity, Mob.Type.BOSS, armorStand, "Jerry Magma Cube", null, null, false, null, 0, null, 1008, null));
        return mobResult;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final MobData.MobResult ratHandler(EntityZombie baseEntity, EntityLivingBase nextEntity) {
        Object object;
        Object v0;
        Object object2;
        block3: {
            void $this$firstOrNull$iv;
            object2 = SequencesKt.map(SequencesKt.take(SequencesKt.generateSequence(1, IslandExceptions::ratHandler$lambda$10), 11), arg_0 -> IslandExceptions.ratHandler$lambda$11(baseEntity, arg_0));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                EntityArmorStand it = (EntityArmorStand)element$iv;
                boolean bl = false;
                if (!(it != null && LocationUtils.INSTANCE.distanceTo((Entity)it, (Entity)baseEntity) < 4.0 && EntityUtils.INSTANCE.wearingSkullTexture(it, MobFilter.INSTANCE.getRAT_SKULL_TEXTURE$1_8_9()))) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        EntityArmorStand entityArmorStand = v0;
        if (entityArmorStand != null) {
            EntityArmorStand it = entityArmorStand;
            boolean bl = false;
            object2 = MobData.MobResult.Companion.found(new Mob((EntityLivingBase)baseEntity, Mob.Type.BASIC, it, "Rat", null, null, false, null, 0, null, 1008, null));
            if (object2 != null) {
                object = object2;
                return object;
            }
        }
        if (!(nextEntity instanceof EntityZombie)) return null;
        object = MobData.MobResult.Companion.getNotYetFound();
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final MobData.MobResult petCareHandler(EntityLivingBase baseEntity) {
        MobData.MobResult mobResult;
        void $this$matchMatcher$iv;
        Pattern $this$mapNotNullTo$iv$iv;
        Integer[] integerArray = new Integer[]{1, 2, 3, 4};
        Iterable $this$mapNotNull$iv = CollectionsKt.listOf(integerArray);
        boolean $i$f$mapNotNull22 = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            EntityArmorStand it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            int it = ((Number)element$iv$iv).intValue();
            boolean bl2 = false;
            if (MobUtils.INSTANCE.getArmorStand((Entity)baseEntity, it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List extraEntityList = (List)destination$iv$iv;
        if (extraEntityList.size() != 4) {
            return MobData.MobResult.Companion.getNotYetFound();
        }
        RegexUtils $i$f$mapNotNull22 = RegexUtils.INSTANCE;
        $this$mapNotNullTo$iv$iv = MobFilter.INSTANCE.getPetCareNamePattern();
        String text$iv = EntityUtils.INSTANCE.cleanName((Entity)extraEntityList.get(1));
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(text$iv);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$petCareHandler_u24lambda_u2415 = it$iv;
            boolean bl4 = false;
            EntityArmorStand entityArmorStand = (EntityArmorStand)extraEntityList.get(1);
            String string = $this$petCareHandler_u24lambda_u2415.group("name");
            Intrinsics.checkNotNullExpressionValue(string, "group(...)");
            String string2 = $this$petCareHandler_u24lambda_u2415.group("level");
            Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
            mobResult = MobData.MobResult.Companion.found(new Mob(baseEntity, Mob.Type.SPECIAL, entityArmorStand, string, extraEntityList, null, false, null, Integer.parseInt(string2), null, 736, null));
        } else {
            mobResult = null;
        }
        MobData.MobResult mobResult2 = mobResult;
        if (mobResult == null) {
            mobResult2 = MobData.MobResult.Companion.getSomethingWentWrong();
        }
        return mobResult2;
    }

    private static final Mob dungeon$lambda$0(EntityLivingBase $baseEntity, EntityArmorStand it) {
        Intrinsics.checkNotNullParameter($baseEntity, "$baseEntity");
        Intrinsics.checkNotNullParameter(it, "it");
        return MobFactories.dungeon$default(MobFactories.INSTANCE, $baseEntity, it, null, 4, null);
    }

    private static final Mob dungeon$lambda$1(EntityLivingBase $baseEntity, EntityArmorStand it) {
        Intrinsics.checkNotNullParameter($baseEntity, "$baseEntity");
        Intrinsics.checkNotNullParameter(it, "it");
        return MobFactories.dungeon$default(MobFactories.INSTANCE, $baseEntity, it, null, 4, null);
    }

    private static final Mob dungeon$lambda$2(EntityLivingBase $baseEntity, EntityArmorStand it) {
        Intrinsics.checkNotNullParameter($baseEntity, "$baseEntity");
        Intrinsics.checkNotNullParameter(it, "it");
        return MobFactories.boss$default(MobFactories.INSTANCE, $baseEntity, it, null, null, 12, null);
    }

    private static final Mob dungeon$lambda$5(EntityLivingBase $baseEntity, EntityArmorStand it) {
        Intrinsics.checkNotNullParameter($baseEntity, "$baseEntity");
        Intrinsics.checkNotNullParameter(it, "it");
        return MobFactories.boss$default(MobFactories.INSTANCE, $baseEntity, it, null, "Real Livid", 4, null);
    }

    private static final Mob hub$lambda$6(EntityLivingBase $baseEntity, EntityArmorStand it) {
        Intrinsics.checkNotNullParameter($baseEntity, "$baseEntity");
        Intrinsics.checkNotNullParameter(it, "it");
        return MobFactories.basic$default(MobFactories.INSTANCE, $baseEntity, it, null, 4, null);
    }

    private static final Mob hub$lambda$7(EntityLivingBase $baseEntity, EntityArmorStand it) {
        Intrinsics.checkNotNullParameter($baseEntity, "$baseEntity");
        Intrinsics.checkNotNullParameter(it, "it");
        return MobFactories.basic$default(MobFactories.INSTANCE, $baseEntity, it, null, 4, null);
    }

    private static final Mob hub$lambda$9(EntityLivingBase $baseEntity, EntityArmorStand $armorStand, EntityArmorStand it) {
        Intrinsics.checkNotNullParameter($baseEntity, "$baseEntity");
        Intrinsics.checkNotNullParameter(it, "it");
        return MobFactories.INSTANCE.basic($baseEntity, it, CollectionsKt.listOf($armorStand));
    }

    private static final Integer ratHandler$lambda$10(int it) {
        return it + 1;
    }

    private static final EntityArmorStand ratHandler$lambda$11(EntityZombie $baseEntity, int i2) {
        Intrinsics.checkNotNullParameter($baseEntity, "$baseEntity");
        return MobUtils.INSTANCE.getArmorStand((Entity)$baseEntity, i2);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IslandType.values().length];
            try {
                nArray[IslandType.CATACOMBS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IslandType.PRIVATE_ISLAND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IslandType.THE_RIFT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IslandType.CRIMSON_ISLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IslandType.DEEP_CAVERNS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IslandType.DWARVEN_MINES.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IslandType.CRYSTAL_HOLLOWS.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IslandType.HUB.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IslandType.GARDEN.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IslandType.KUUDRA_ARENA.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IslandType.WINTER.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

