/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.data.repo;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.data.repo.RepoError;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.ChatUtils;
import java.util.Arrays;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\u0005J\u0015\u0010\t\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\u0005J\u0015\u0010\n\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\n\u0010\u0005J\u001f\u0010\f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00022\b\b\u0002\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0005J\u0015\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0005J\u0015\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001d\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J{\u0010#\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00022.\u0010\u001d\u001a\u0018\u0012\u0014\b\u0001\u0012\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001c0\u001b\"\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001c2\b\b\u0002\u0010\u001e\u001a\u00020\u00162\b\b\u0002\u0010\u001f\u001a\u00020\u00162\b\b\u0002\u0010 \u001a\u00020\u00162\u000e\b\u0002\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160!\u00a2\u0006\u0004\b#\u0010$J\u0015\u0010%\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\u0004\b%\u0010\u0013J\u001d\u0010&\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b&\u0010'R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010(\u00a8\u0006)"}, d2={"Lat/hannibal2/skyhanni/data/repo/RepoLogger;", "", "", "loggingPrefix", "<init>", "(Ljava/lang/String;)V", "message", "", "debug", "preDebug", "warn", "color", "logToChat", "(Ljava/lang/String;Ljava/lang/String;)V", "error", "errorToChat", "logNonDestructiveError", "", "logError", "(Ljava/lang/String;)Ljava/lang/Void;", "", "cause", "", "logErrorWithData", "(Ljava/lang/Throwable;Ljava/lang/String;)Z", "userMessage", "internalMessage", "", "Lkotlin/Pair;", "extraData", "ignoreErrorCache", "noStackTrace", "betaOnly", "Lkotlin/Function0;", "condition", "logErrorStateWithData", "(Ljava/lang/String;Ljava/lang/String;[Lkotlin/Pair;ZZZLkotlin/jvm/functions/Function0;)Z", "throwError", "throwErrorWithCause", "(Ljava/lang/String;Ljava/lang/Throwable;)Ljava/lang/Void;", "Ljava/lang/String;", "1.8.9"})
public final class RepoLogger {
    @NotNull
    private final String loggingPrefix;

    public RepoLogger(@NotNull String loggingPrefix) {
        Intrinsics.checkNotNullParameter(loggingPrefix, "loggingPrefix");
        this.loggingPrefix = loggingPrefix;
    }

    public final void debug(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        SkyHanniMod.INSTANCE.getLogger().debug(this.loggingPrefix + ' ' + message);
    }

    public final void preDebug(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        System.out.println((Object)(this.loggingPrefix + ' ' + message));
    }

    public final void warn(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        SkyHanniMod.INSTANCE.getLogger().warn(this.loggingPrefix + ' ' + message);
    }

    public final void logToChat(@NotNull String message, @NotNull String color) {
        Intrinsics.checkNotNullParameter(message, "message");
        Intrinsics.checkNotNullParameter(color, "color");
        ChatUtils.chat$default(ChatUtils.INSTANCE, color + this.loggingPrefix + ' ' + message, false, null, false, false, null, 60, null);
    }

    public static /* synthetic */ void logToChat$default(RepoLogger repoLogger, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "\u00a7a";
        }
        repoLogger.logToChat(string, string2);
    }

    public final void errorToChat(@NotNull String error) {
        Intrinsics.checkNotNullParameter(error, "error");
        ChatUtils.userError$default(ChatUtils.INSTANCE, "\u00a7c" + this.loggingPrefix + ' ' + error, false, 2, null);
    }

    public final void logNonDestructiveError(@NotNull String error) {
        Intrinsics.checkNotNullParameter(error, "error");
        SkyHanniMod.INSTANCE.getLogger().error(this.loggingPrefix + ' ' + error);
    }

    @NotNull
    public final Void logError(@NotNull String error) {
        Intrinsics.checkNotNullParameter(error, "error");
        ErrorManager.INSTANCE.skyHanniError(this.loggingPrefix + ' ' + error, new Pair[0]);
        throw new KotlinNothingValueException();
    }

    public final boolean logErrorWithData(@NotNull Throwable cause, @NotNull String error) {
        Intrinsics.checkNotNullParameter(cause, "cause");
        Intrinsics.checkNotNullParameter(error, "error");
        return ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, cause, this.loggingPrefix + ' ' + error, new Pair[0], false, false, false, 56, null);
    }

    public final boolean logErrorStateWithData(@NotNull String userMessage, @NotNull String internalMessage, @NotNull Pair<String, ? extends Object>[] extraData, boolean ignoreErrorCache, boolean noStackTrace, boolean betaOnly, @NotNull Function0<Boolean> condition) {
        Intrinsics.checkNotNullParameter(userMessage, "userMessage");
        Intrinsics.checkNotNullParameter(internalMessage, "internalMessage");
        Intrinsics.checkNotNullParameter(extraData, "extraData");
        Intrinsics.checkNotNullParameter(condition, "condition");
        return ErrorManager.INSTANCE.logErrorStateWithData(userMessage, this.loggingPrefix + ' ' + internalMessage, Arrays.copyOf(extraData, extraData.length), ignoreErrorCache, noStackTrace, betaOnly, condition);
    }

    public static /* synthetic */ boolean logErrorStateWithData$default(RepoLogger repoLogger, String string, String string2, Pair[] pairArray, boolean bl, boolean bl2, boolean bl3, Function0 function0, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        if ((n & 0x20) != 0) {
            bl3 = false;
        }
        if ((n & 0x40) != 0) {
            function0 = RepoLogger::logErrorStateWithData$lambda$0;
        }
        return repoLogger.logErrorStateWithData(string, string2, pairArray, bl, bl2, bl3, function0);
    }

    @NotNull
    public final Void throwError(@NotNull String error) {
        Intrinsics.checkNotNullParameter(error, "error");
        throw new RepoError(this.loggingPrefix + ' ' + error);
    }

    @NotNull
    public final Void throwErrorWithCause(@NotNull String error, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter(error, "error");
        Intrinsics.checkNotNullParameter(cause, "cause");
        throw new RepoError(this.loggingPrefix + ' ' + error, cause);
    }

    private static final boolean logErrorStateWithData$lambda$0() {
        return true;
    }
}

