/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.moulconfig;

import com.google.gson.annotations.Expose;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0010\b\u0086\b\u0018\u0000 62\u00020\u0001:\u00016B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0017\u0010\u0018J\r\u0010\u0010\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0010\u0010\u0019J\r\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u001aJ\u000f\u0010\u001c\u001a\u00020\u001bH\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0010\u0010 \u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b \u0010\u001fJ\u0010\u0010!\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b!\u0010\u001fJ\u0010\u0010\"\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\"\u0010\u0019J\u0010\u0010#\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b#\u0010\u0019JB\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0004\b$\u0010%J\u001a\u0010(\u001a\u00020'2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b(\u0010)J\u0010\u0010*\u001a\u00020\u0006H\u00d6\u0001\u00a2\u0006\u0004\b*\u0010\u0019J\u0010\u0010+\u001a\u00020\u001bH\u00d6\u0001\u00a2\u0006\u0004\b+\u0010\u001dR\u001a\u0010\u0003\u001a\u00020\u00028\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010,\u001a\u0004\b-\u0010\u001fR\u001a\u0010\u0004\u001a\u00020\u00028\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010,\u001a\u0004\b.\u0010\u001fR\u001a\u0010\u0005\u001a\u00020\u00028\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010,\u001a\u0004\b/\u0010\u001fR\u001a\u0010\u0007\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0007\u00100\u001a\u0004\b1\u0010\u0019R\u001a\u0010\b\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\b\u00100\u001a\u0004\b2\u0010\u0019R\u0016\u00103\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u00100R\u0016\u00104\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b4\u00105\u00a8\u00067"}, d2={"Lat/hannibal2/skyhanni/deps/moulconfig/ChromaColour;", "", "", "hue", "saturation", "brightness", "", "timeForFullRotationInMillis", "alpha", "<init>", "(FFFII)V", "", "hueShift", "evaluateColourWithShift", "(D)I", "offset", "getEffectiveColourRGB", "(F)I", "Ljava/awt/Color;", "getEffectiveColour", "(F)Ljava/awt/Color;", "getEffectiveColourWithTimeOffsetRGB", "(I)I", "getEffectiveColourWithTimeOffset", "(I)Ljava/awt/Color;", "()I", "()Ljava/awt/Color;", "", "toLegacyString", "()Ljava/lang/String;", "component1", "()F", "component2", "component3", "component4", "component5", "copy", "(FFFII)Lio/github/notenoughupdates/moulconfig/ChromaColour;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "toString", "F", "getHue", "getSaturation", "getBrightness", "I", "getTimeForFullRotationInMillis", "getAlpha", "cachedRGB", "cachedRGBHueOffset", "D", "Companion", "common"})
public final class ChromaColour {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Expose
    private final float hue;
    @Expose
    private final float saturation;
    @Expose
    private final float brightness;
    @Expose
    private final int timeForFullRotationInMillis;
    @Expose
    private final int alpha;
    private transient int cachedRGB;
    private transient double cachedRGBHueOffset;
    private static final int RADIX = 10;
    private static final int MIN_CHROMA_SECS = 1;
    private static final int MAX_CHROMA_SECS = 60;

    public ChromaColour(float hue, float saturation, float brightness, int timeForFullRotationInMillis, int alpha) {
        this.hue = hue;
        this.saturation = saturation;
        this.brightness = brightness;
        this.timeForFullRotationInMillis = timeForFullRotationInMillis;
        this.alpha = alpha;
        this.cachedRGBHueOffset = Double.NaN;
    }

    public final float getHue() {
        return this.hue;
    }

    public final float getSaturation() {
        return this.saturation;
    }

    public final float getBrightness() {
        return this.brightness;
    }

    public final int getTimeForFullRotationInMillis() {
        return this.timeForFullRotationInMillis;
    }

    public final int getAlpha() {
        return this.alpha;
    }

    private final int evaluateColourWithShift(double hueShift) {
        if (Math.abs(this.cachedRGBHueOffset - hueShift) < 0.002777777777777778) {
            return this.cachedRGB;
        }
        float effectiveHue = (float)(((double)this.hue + hueShift) % 1.0);
        int ret = Color.HSBtoRGB(effectiveHue, this.saturation, this.brightness) & 0xFFFFFF | this.alpha << 24;
        this.cachedRGBHueOffset = hueShift;
        this.cachedRGB = ret;
        return ret;
    }

    public final int getEffectiveColourRGB(float offset) {
        double effectiveHueOffset = this.timeForFullRotationInMillis > 0 ? (double)System.currentTimeMillis() / (double)this.timeForFullRotationInMillis : 0.0;
        return this.evaluateColourWithShift(effectiveHueOffset += (double)offset);
    }

    @NotNull
    public final Color getEffectiveColour(float offset) {
        return new Color(this.getEffectiveColourRGB(offset), true);
    }

    public final int getEffectiveColourWithTimeOffsetRGB(int offset) {
        if (this.timeForFullRotationInMillis == 0) {
            return this.evaluateColourWithShift(0.0);
        }
        double effectiveHue = (double)(System.currentTimeMillis() + (long)offset) / (double)this.timeForFullRotationInMillis;
        return this.evaluateColourWithShift(effectiveHue);
    }

    @NotNull
    public final Color getEffectiveColourWithTimeOffset(int offset) {
        return new Color(this.getEffectiveColourWithTimeOffsetRGB(offset), true);
    }

    public final int getEffectiveColourRGB() {
        return this.getEffectiveColourWithTimeOffsetRGB(0);
    }

    @NotNull
    public final Color getEffectiveColour() {
        return this.getEffectiveColourWithTimeOffset(0);
    }

    @Deprecated(message="")
    @NotNull
    public final String toLegacyString() {
        int namedSpeed = this.timeForFullRotationInMillis == 0 ? 0 : Companion.getSpeedForMillis((float)this.timeForFullRotationInMillis / 1000.0f);
        int rgb = this.evaluateColourWithShift(0.0);
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        return Companion.special(namedSpeed, this.alpha, red, green, blue);
    }

    public final float component1() {
        return this.hue;
    }

    public final float component2() {
        return this.saturation;
    }

    public final float component3() {
        return this.brightness;
    }

    public final int component4() {
        return this.timeForFullRotationInMillis;
    }

    public final int component5() {
        return this.alpha;
    }

    @NotNull
    public final ChromaColour copy(float hue, float saturation, float brightness, int timeForFullRotationInMillis, int alpha) {
        return new ChromaColour(hue, saturation, brightness, timeForFullRotationInMillis, alpha);
    }

    public static /* synthetic */ ChromaColour copy$default(ChromaColour chromaColour, float f, float f2, float f3, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            f = chromaColour.hue;
        }
        if ((n3 & 2) != 0) {
            f2 = chromaColour.saturation;
        }
        if ((n3 & 4) != 0) {
            f3 = chromaColour.brightness;
        }
        if ((n3 & 8) != 0) {
            n = chromaColour.timeForFullRotationInMillis;
        }
        if ((n3 & 0x10) != 0) {
            n2 = chromaColour.alpha;
        }
        return chromaColour.copy(f, f2, f3, n, n2);
    }

    @NotNull
    public String toString() {
        return "ChromaColour(hue=" + this.hue + ", saturation=" + this.saturation + ", brightness=" + this.brightness + ", timeForFullRotationInMillis=" + this.timeForFullRotationInMillis + ", alpha=" + this.alpha + ')';
    }

    public int hashCode() {
        int result2 = Float.hashCode(this.hue);
        result2 = result2 * 31 + Float.hashCode(this.saturation);
        result2 = result2 * 31 + Float.hashCode(this.brightness);
        result2 = result2 * 31 + Integer.hashCode(this.timeForFullRotationInMillis);
        result2 = result2 * 31 + Integer.hashCode(this.alpha);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ChromaColour)) {
            return false;
        }
        ChromaColour chromaColour = (ChromaColour)other;
        if (Float.compare(this.hue, chromaColour.hue) != 0) {
            return false;
        }
        if (Float.compare(this.saturation, chromaColour.saturation) != 0) {
            return false;
        }
        if (Float.compare(this.brightness, chromaColour.brightness) != 0) {
            return false;
        }
        if (this.timeForFullRotationInMillis != chromaColour.timeForFullRotationInMillis) {
            return false;
        }
        return this.alpha == chromaColour.alpha;
    }

    @JvmStatic
    @Deprecated(message="")
    @NotNull
    public static final String special(int chromaSpeed, int alpha, int rgb) {
        return Companion.special(chromaSpeed, alpha, rgb);
    }

    @JvmStatic
    @Deprecated(message="")
    @NotNull
    public static final String special(int chromaSpeed, int alpha, int r, int g, int b) {
        return Companion.special(chromaSpeed, alpha, r, g, b);
    }

    @JvmStatic
    private static final int[] decompose(String csv) {
        return ChromaColour.Companion.decompose(csv);
    }

    @JvmStatic
    @Deprecated(message="")
    public static final int specialToSimpleRGB(@NotNull String special) {
        return Companion.specialToSimpleRGB(special);
    }

    @JvmStatic
    @Deprecated(message="")
    public static final int getSpeed(@NotNull String special) {
        return Companion.getSpeed(special);
    }

    @JvmStatic
    @Deprecated(message="")
    public static final float getSecondsForSpeed(int speed) {
        return Companion.getSecondsForSpeed(speed);
    }

    @JvmStatic
    @Deprecated(message="")
    public static final int specialToChromaRGB(@NotNull String special) {
        return Companion.specialToChromaRGB(special);
    }

    @JvmStatic
    @Deprecated(message="")
    public static final int rotateHue(int argb, int degrees) {
        return Companion.rotateHue(argb, degrees);
    }

    @JvmStatic
    @Deprecated(message="")
    @NotNull
    public static final ChromaColour forLegacyString(@NotNull String stringRepresentation) {
        return Companion.forLegacyString(stringRepresentation);
    }

    @JvmStatic
    @NotNull
    public static final ChromaColour fromStaticRGB(int r, int g, int b, int a) {
        return Companion.fromStaticRGB(r, g, b, a);
    }

    @JvmStatic
    @NotNull
    public static final ChromaColour fromRGB(int r, int g, int b, int chromaSpeedMillis, int a) {
        return Companion.fromRGB(r, g, b, chromaSpeedMillis, a);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ7\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\t\u0010\u000eJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\bH\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0015\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0014J\u0017\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0017H\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001d\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\u001d\u0010\u0014J\u001f\u0010 \u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b \u0010!J\u0017\u0010$\u001a\u00020#2\u0006\u0010\"\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b$\u0010%J/\u0010'\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b'\u0010(J7\u0010*\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b*\u0010+R\u0014\u0010,\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0014\u0010.\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b.\u0010-R\u0014\u0010/\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b/\u0010-\u00a8\u00060"}, d2={"Lat/hannibal2/skyhanni/deps/moulconfig/ChromaColour$Companion;", "", "<init>", "()V", "", "chromaSpeed", "alpha", "rgb", "", "special", "(III)Ljava/lang/String;", "r", "g", "b", "(IIIII)Ljava/lang/String;", "csv", "", "decompose", "(Ljava/lang/String;)[I", "specialToSimpleRGB", "(Ljava/lang/String;)I", "getSpeed", "speed", "", "getSecondsForSpeed", "(I)F", "seconds", "getSpeedForMillis", "(F)I", "specialToChromaRGB", "argb", "degrees", "rotateHue", "(II)I", "stringRepresentation", "Lat/hannibal2/skyhanni/deps/moulconfig/ChromaColour;", "forLegacyString", "(Ljava/lang/String;)Lio/github/notenoughupdates/moulconfig/ChromaColour;", "a", "fromStaticRGB", "(IIII)Lio/github/notenoughupdates/moulconfig/ChromaColour;", "chromaSpeedMillis", "fromRGB", "(IIIII)Lio/github/notenoughupdates/moulconfig/ChromaColour;", "RADIX", "I", "MIN_CHROMA_SECS", "MAX_CHROMA_SECS", "common"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Deprecated(message="")
        @NotNull
        public final String special(int chromaSpeed, int alpha, int rgb) {
            return this.special(chromaSpeed, alpha, rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
        }

        @JvmStatic
        @Deprecated(message="")
        @NotNull
        public final String special(int chromaSpeed, int alpha, int r, int g, int b) {
            StringBuilder sb = new StringBuilder();
            String string = Integer.toString(chromaSpeed, CharsKt.checkRadix(10));
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            sb.append(string).append(":");
            String string2 = Integer.toString(alpha, CharsKt.checkRadix(10));
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
            sb.append(string2).append(":");
            String string3 = Integer.toString(r, CharsKt.checkRadix(10));
            Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
            sb.append(string3).append(":");
            String string4 = Integer.toString(g, CharsKt.checkRadix(10));
            Intrinsics.checkNotNullExpressionValue(string4, "toString(...)");
            sb.append(string4).append(":");
            String string5 = Integer.toString(b, CharsKt.checkRadix(10));
            Intrinsics.checkNotNullExpressionValue(string5, "toString(...)");
            sb.append(string5);
            String string6 = sb.toString();
            Intrinsics.checkNotNullExpressionValue(string6, "toString(...)");
            return string6;
        }

        @JvmStatic
        private final int[] decompose(String csv) {
            String[] stringArray = new String[]{":"};
            List split = StringsKt.split$default((CharSequence)csv, stringArray, false, 0, 6, null);
            int[] arr = new int[split.size()];
            int n = ((Collection)split).size();
            for (int i2 = 0; i2 < n; ++i2) {
                try {
                    arr[i2] = Integer.parseInt((String)split.get(split.size() - 1 - i2), CharsKt.checkRadix(10));
                    continue;
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            return arr;
        }

        @JvmStatic
        @Deprecated(message="")
        public final int specialToSimpleRGB(@NotNull String special) {
            Intrinsics.checkNotNullParameter(special, "special");
            int[] nArray = this.decompose(special);
            int b = nArray[0];
            int g = nArray[1];
            int r = nArray[2];
            int a = nArray[3];
            return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        }

        @JvmStatic
        @Deprecated(message="")
        public final int getSpeed(@NotNull String special) {
            Intrinsics.checkNotNullParameter(special, "special");
            return this.decompose(special)[4];
        }

        @JvmStatic
        @Deprecated(message="")
        public final float getSecondsForSpeed(int speed) {
            return (float)(255 - speed) / 254.0f * (float)59 + 1.0f;
        }

        @Deprecated(message="")
        public final int getSpeedForMillis(float seconds) {
            return MathKt.roundToInt((float)255 - (seconds - 1.0f) / (float)59 * (float)254);
        }

        @JvmStatic
        @Deprecated(message="")
        public final int specialToChromaRGB(@NotNull String special) {
            Intrinsics.checkNotNullParameter(special, "special");
            int[] nArray = this.decompose(special);
            int b = nArray[0];
            int g = nArray[1];
            int r = nArray[2];
            int a = nArray[3];
            int chr = nArray[4];
            float[] hsv = Color.RGBtoHSB(r, g, b, null);
            if (chr > 0) {
                float seconds = this.getSecondsForSpeed(chr);
                hsv[0] = hsv[0] + (float)((double)System.currentTimeMillis() / 1000.0 / (double)seconds % 1.0);
                hsv[0] = hsv[0] % 1.0f;
                if (hsv[0] < 0.0f) {
                    hsv[0] = hsv[0] + 1.0f;
                }
            }
            return (a & 0xFF) << 24 | Color.HSBtoRGB(hsv[0], hsv[1], hsv[2]) & 0xFFFFFF;
        }

        @JvmStatic
        @Deprecated(message="")
        public final int rotateHue(int argb, int degrees) {
            int a = argb >> 24 & 0xFF;
            int r = argb >> 16 & 0xFF;
            int g = argb >> 8 & 0xFF;
            int b = argb & 0xFF;
            float[] hsv = Color.RGBtoHSB(r, g, b, null);
            hsv[0] = hsv[0] + (float)degrees / 360.0f;
            hsv[0] = hsv[0] % 1.0f;
            return (a & 0xFF) << 24 | Color.HSBtoRGB(hsv[0], hsv[1], hsv[2]) & 0xFFFFFF;
        }

        @JvmStatic
        @Deprecated(message="")
        @NotNull
        public final ChromaColour forLegacyString(@NotNull String stringRepresentation) {
            boolean bl;
            Intrinsics.checkNotNullParameter(stringRepresentation, "stringRepresentation");
            int[] d = this.decompose(stringRepresentation);
            boolean bl2 = bl = d.length == 5;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            int chr = d[4];
            int a = d[3];
            int r = d[2];
            int g = d[1];
            int b = d[0];
            return this.fromRGB(r, g, b, chr > 0 ? (int)(this.getSecondsForSpeed(chr) * (float)1000) : 0, a);
        }

        @JvmStatic
        @NotNull
        public final ChromaColour fromStaticRGB(int r, int g, int b, int a) {
            return this.fromRGB(r, g, b, 0, a);
        }

        @JvmStatic
        @NotNull
        public final ChromaColour fromRGB(int r, int g, int b, int chromaSpeedMillis, int a) {
            float[] floats = Color.RGBtoHSB(r, g, b, null);
            return new ChromaColour(floats[0], floats[1], floats[2], chromaSpeedMillis, a);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

