/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.misc.update;

import at.hannibal2.skyhanni.config.core.elements.GuiElementButton;
import at.hannibal2.skyhanni.deps.moulconfig.common.IFontRenderer;
import at.hannibal2.skyhanni.deps.moulconfig.common.RenderContext;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiOptionEditor;
import at.hannibal2.skyhanni.deps.moulconfig.processor.ProcessedOption;
import at.hannibal2.skyhanni.features.misc.update.ChangelogViewer;
import at.hannibal2.skyhanni.features.misc.update.UpdateManager;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.ConfigUtils;
import at.hannibal2.skyhanni.utils.compat.MouseCompat;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J/\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J7\u0010\u0017\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\u0016H\u0014\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0017\u0010 \u001a\u00020\u001f8\u0006\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#R\u0017\u0010$\u001a\u00020\u001f8\u0006\u00a2\u0006\f\n\u0004\b$\u0010!\u001a\u0004\b%\u0010#R\u001a\u0010&\u001a\u00020\u001b8\u0006X\u0086D\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)\u00a8\u0006*"}, d2={"Lat/hannibal2/skyhanni/features/misc/update/GuiOptionEditorUpdateCheck;", "Lat/hannibal2/skyhanni/deps/moulconfig/gui/GuiOptionEditor;", "Lat/hannibal2/skyhanni/deps/moulconfig/processor/ProcessedOption;", "option", "<init>", "(Lio/github/notenoughupdates/moulconfig/processor/ProcessedOption;)V", "Lat/hannibal2/skyhanni/deps/moulconfig/common/RenderContext;", "context", "", "x", "y", "width", "", "render", "(Lat/hannibal2/skyhanni/deps/moulconfig/common/RenderContext;III)V", "getButtonPosition", "(I)I", "getChangelogPosition", "getHeight", "()I", "mouseX", "mouseY", "", "mouseInput", "(IIIII)Z", "keyboardInput", "()Z", "", "word", "fulfillsSearch", "(Ljava/lang/String;)Z", "Lat/hannibal2/skyhanni/config/core/elements/GuiElementButton;", "button", "Lat/hannibal2/skyhanni/config/core/elements/GuiElementButton;", "getButton", "()Lat/hannibal2/skyhanni/config/core/elements/GuiElementButton;", "changelog", "getChangelog", "currentVersion", "Ljava/lang/String;", "getCurrentVersion", "()Ljava/lang/String;", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nGuiOptionEditorUpdateCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GuiOptionEditorUpdateCheck.kt\nat/hannibal2/skyhanni/features/misc/update/GuiOptionEditorUpdateCheck\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n1#2:118\n*E\n"})
public final class GuiOptionEditorUpdateCheck
extends GuiOptionEditor {
    @NotNull
    private final GuiElementButton button;
    @NotNull
    private final GuiElementButton changelog;
    @NotNull
    private final String currentVersion;

    /*
     * WARNING - void declaration
     */
    public GuiOptionEditorUpdateCheck(@NotNull ProcessedOption option) {
        void $this$changelog_u24lambda_u240;
        GuiElementButton guiElementButton;
        Intrinsics.checkNotNullParameter(option, "option");
        super(option);
        this.button = new GuiElementButton();
        GuiElementButton guiElementButton2 = guiElementButton = new GuiElementButton();
        GuiOptionEditorUpdateCheck guiOptionEditorUpdateCheck = this;
        boolean bl = false;
        $this$changelog_u24lambda_u240.setText("Show Changelog");
        guiOptionEditorUpdateCheck.changelog = guiElementButton;
        this.currentVersion = "5.2.0";
    }

    @NotNull
    public final GuiElementButton getButton() {
        return this.button;
    }

    @NotNull
    public final GuiElementButton getChangelog() {
        return this.changelog;
    }

    @NotNull
    public final String getCurrentVersion() {
        return this.currentVersion;
    }

    @Override
    public void render(@NotNull RenderContext context2, int x, int y, int width) {
        String string;
        Intrinsics.checkNotNullParameter(context2, "context");
        IFontRenderer fr = context2.getMinecraft().getDefaultFontRenderer();
        context2.pushMatrix();
        context2.translate((float)x + (float)10, y);
        int adjustedWidth = width - 20;
        String nextVersion = UpdateManager.INSTANCE.getNextVersion();
        switch (WhenMappings.$EnumSwitchMapping$0[UpdateManager.INSTANCE.getUpdateState().ordinal()]) {
            case 1: {
                string = "Download update";
                break;
            }
            case 2: {
                string = "Downloading...";
                break;
            }
            case 3: {
                string = "Downloaded";
                break;
            }
            case 4: {
                if (nextVersion == null) {
                    string = "Check for Updates";
                    break;
                }
                string = "Up to date";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.button.setText(string);
        this.button.setWidth(this.button.getWidth(context2));
        this.button.render(context2, this.getButtonPosition(adjustedWidth), 10);
        if (UpdateManager.INSTANCE.getUpdateState() != UpdateManager.UpdateState.NONE) {
            this.changelog.setWidth(this.changelog.getWidth(context2));
            this.changelog.render(context2, this.getChangelogPosition(adjustedWidth), 30);
        }
        int widthRemaining = adjustedWidth - Math.max(this.button.getWidth(), this.changelog.getWidth()) - 10;
        if (UpdateManager.INSTANCE.getUpdateState() == UpdateManager.UpdateState.DOWNLOADED) {
            context2.drawStringCenteredScaledMaxWidth(ConfigUtils.INSTANCE.asStructuredText("\u00a7aThe update will be installed after your next restart."), fr, (float)widthRemaining / 2.0f, 40.0f, true, widthRemaining, -1);
        }
        context2.scale(2.0f, 2.0f);
        boolean sameVersion = StringsKt.equals(this.currentVersion, nextVersion, true);
        String versionText = (UpdateManager.INSTANCE.getUpdateState() == UpdateManager.UpdateState.NONE ? "\u00a7a" : "\u00a7c") + this.currentVersion + (nextVersion != null && !sameVersion ? "\u279c \u00a7a" + nextVersion : "");
        context2.drawStringCenteredScaledMaxWidth(ConfigUtils.INSTANCE.asStructuredText(versionText), fr, (float)widthRemaining / 4.0f, 10.0f, true, widthRemaining / 2, -1);
        context2.popMatrix();
    }

    private final int getButtonPosition(int width) {
        return width - this.button.getWidth();
    }

    private final int getChangelogPosition(int width) {
        return width - this.changelog.getWidth();
    }

    @Override
    public int getHeight() {
        return 55;
    }

    @Override
    protected boolean mouseInput(int x, int y, int width, int mouseX, int mouseY) {
        if (GuiOptionEditorUpdateCheck.mouseInput$isInside(mouseX, x, mouseY, y, this.getButtonPosition(width - 20), 10, this.button)) {
            switch (WhenMappings.$EnumSwitchMapping$0[UpdateManager.INSTANCE.getUpdateState().ordinal()]) {
                case 1: {
                    UpdateManager.INSTANCE.queueUpdate();
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    UpdateManager.checkUpdate$default(UpdateManager.INSTANCE, false, null, 3, null);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return true;
        }
        if (!GuiOptionEditorUpdateCheck.mouseInput$isInside(mouseX, x, mouseY, y, this.getChangelogPosition(width - 20), 30, this.changelog)) {
            return false;
        }
        if (UpdateManager.INSTANCE.getUpdateState() != UpdateManager.UpdateState.NONE) {
            String string = UpdateManager.INSTANCE.getNextVersion();
            if (string != null) {
                String it = string;
                boolean bl = false;
                ChangelogViewer.INSTANCE.showChangelog(this.currentVersion, it);
            } else {
                Pair[] pairArray = new Pair[]{TuplesKt.to("state", UpdateManager.INSTANCE.getUpdateState())};
                ErrorManager.logErrorStateWithData$default(ErrorManager.INSTANCE, "Can't get Changelog because of internal error", "UpdateManager.getNextVersion is null even though updateState is != NONE", pairArray, false, false, false, null, 120, null);
            }
        }
        return true;
    }

    @Override
    protected boolean keyboardInput() {
        return false;
    }

    @Override
    public boolean fulfillsSearch(@NotNull String word) {
        Intrinsics.checkNotNullParameter(word, "word");
        return super.fulfillsSearch(word) || StringsKt.contains$default((CharSequence)"download", word, false, 2, null) || StringsKt.contains$default((CharSequence)"update", word, false, 2, null);
    }

    private static final boolean mouseInput$isInside(int $mouseX, int $x, int $mouseY, int $y, int width, int height, GuiElementButton def) {
        int n = def.getWidth();
        int n2 = $mouseX - width - $x;
        boolean inX = 0 <= n2 ? n2 <= n : false;
        n2 = def.getHeight();
        int n3 = $mouseY - height - $y;
        boolean inY = 0 <= n3 ? n3 <= n2 : false;
        return MouseCompat.INSTANCE.getEventButtonState() && inX && inY;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[UpdateManager.UpdateState.values().length];
            try {
                nArray[UpdateManager.UpdateState.AVAILABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UpdateManager.UpdateState.QUEUED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UpdateManager.UpdateState.DOWNLOADED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UpdateManager.UpdateState.NONE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

