/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Objects;
import org.newsclub.net.unix.AFAddressFamily;

class AFInetAddress {
    private static final byte[] SERIALIZED_INET_ADDRESS_START = new byte[]{-84, -19, 0, 5, 115, 114, 0, 20, 106, 97, 118, 97, 46, 110, 101, 116, 46, 73, 110, 101, 116, 65, 100, 100, 114, 101, 115, 115, 45, -101, 87, -81, -97, -29, -21, -37, 3, 0, 3, 73, 0, 7, 97, 100, 100, 114, 101, 115, 115, 73, 0, 6, 102, 97, 109, 105, 108, 121, 76, 0, 8, 104, 111, 115, 116, 78, 97, 109, 101, 116, 0, 18, 76, 106, 97, 118, 97, 47, 108, 97, 110, 103, 47, 79, 98, 106, 101, 99, 116, 59, 120, 112, 127, 0, 0, -81, 0, 0, 0, 1, 116, 0};
    private static final char PREFIX = '[';
    private static final String MARKER_HEX_ENCODING = "%%";
    static final String INETADDR_SUFFIX = ".junixsocket";

    AFInetAddress() {
    }

    static final String createUnresolvedHostname(byte[] socketAddress, AFAddressFamily<?> af) {
        StringBuilder sb = new StringBuilder(1 + socketAddress.length + INETADDR_SUFFIX.length() + 8);
        sb.append('[');
        try {
            sb.append(URLEncoder.encode(new String(socketAddress, StandardCharsets.ISO_8859_1), StandardCharsets.ISO_8859_1.toString()));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        sb.append('.');
        sb.append(af.getJuxString());
        sb.append(INETADDR_SUFFIX);
        String str = sb.toString();
        if (str.length() < 64 || str.getBytes(StandardCharsets.UTF_8).length <= 255) {
            return str;
        }
        sb.setLength(0);
        sb.append('[');
        sb.append(MARKER_HEX_ENCODING);
        int n = socketAddress.length;
        for (int i2 = 0; i2 < n; ++i2) {
            sb.append(String.format(Locale.ENGLISH, "%02x", socketAddress[i2]));
        }
        sb.append('.');
        sb.append(af.getJuxString());
        sb.append(INETADDR_SUFFIX);
        return sb.toString();
    }

    static final InetAddress wrapAddress(byte[] socketAddress, AFAddressFamily<?> af) {
        InetAddress inetAddress;
        Objects.requireNonNull(af);
        if (socketAddress == null || socketAddress.length == 0) {
            return null;
        }
        byte[] bytes = AFInetAddress.createUnresolvedHostname(socketAddress, af).getBytes(StandardCharsets.UTF_8);
        if (bytes.length > 255) {
            throw new IllegalStateException("junixsocket address is too long to wrap as InetAddress");
        }
        byte[] serializedData = new byte[SERIALIZED_INET_ADDRESS_START.length + 1 + bytes.length + 1];
        System.arraycopy(SERIALIZED_INET_ADDRESS_START, 0, serializedData, 0, SERIALIZED_INET_ADDRESS_START.length);
        serializedData[AFInetAddress.SERIALIZED_INET_ADDRESS_START.length] = (byte)bytes.length;
        System.arraycopy(bytes, 0, serializedData, SERIALIZED_INET_ADDRESS_START.length + 1, bytes.length);
        serializedData[serializedData.length - 1] = 120;
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(serializedData));
        try {
            inetAddress = (InetAddress)ois.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ois.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
        ois.close();
        return inetAddress;
    }

    static final byte[] unwrapAddress(InetAddress addr, AFAddressFamily<?> af) throws SocketException {
        Objects.requireNonNull(addr);
        if (!AFInetAddress.isSupportedAddress(addr, af)) {
            throw new SocketException("Unsupported address");
        }
        String hostname = addr.getHostName();
        try {
            return AFInetAddress.unwrapAddress(hostname, af);
        }
        catch (IllegalArgumentException e) {
            throw (SocketException)new SocketException("Unsupported address").initCause(e);
        }
    }

    static final byte[] unwrapAddress(String hostname, AFAddressFamily<?> af) throws SocketException {
        String juxString;
        Objects.requireNonNull(hostname);
        if (!hostname.endsWith(INETADDR_SUFFIX)) {
            throw new SocketException("Unsupported address");
        }
        int end = hostname.length() - INETADDR_SUFFIX.length();
        int domDot = -1;
        for (int i2 = end - 1; i2 >= 0; --i2) {
            char c = hostname.charAt(i2);
            if (c != '.') continue;
            domDot = i2;
            break;
        }
        if (AFAddressFamily.getAddressFamily(juxString = hostname.substring(domDot + 1, end)) != af) {
            throw new SocketException("Incompatible address");
        }
        String encodedHostname = hostname.substring(1, domDot);
        if (encodedHostname.startsWith(MARKER_HEX_ENCODING)) {
            int len = encodedHostname.length();
            if ((len & 1) == 1) {
                throw new IllegalStateException("Length of hex-encoded wrapping must be even");
            }
            byte[] unwrapped = new byte[(len - 2) / 2];
            int i3 = 2;
            int n = encodedHostname.length();
            int o = 0;
            while (i3 < n) {
                int v = Integer.parseInt(encodedHostname.substring(i3, i3 + 2), 16);
                unwrapped[o] = (byte)(v & 0xFF);
                i3 += 2;
                ++o;
            }
            return unwrapped;
        }
        try {
            return URLDecoder.decode(encodedHostname, StandardCharsets.ISO_8859_1.toString()).getBytes(StandardCharsets.ISO_8859_1);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    static boolean isSupportedAddress(InetAddress addr, AFAddressFamily<?> af) {
        if (addr instanceof Inet4Address && addr.isLoopbackAddress()) {
            String hostname = addr.getHostName();
            return hostname.endsWith(af.getJuxInetAddressSuffix());
        }
        return false;
    }
}

