/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.api.hypixelapi;

import at.hannibal2.skyhanni.api.hypixelapi.HypixelLocationApi;
import at.hannibal2.skyhanni.events.hypixel.modapi.HypixelApiJoinEvent;
import at.hannibal2.skyhanni.events.hypixel.modapi.HypixelApiServerChangeEvent;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import net.hypixel.data.region.Environment;
import net.hypixel.data.type.ServerType;
import net.hypixel.modapi.HypixelModAPI;
import net.hypixel.modapi.packet.HypixelPacket;
import net.hypixel.modapi.packet.impl.clientbound.ClientboundHelloPacket;
import net.hypixel.modapi.packet.impl.clientbound.event.ClientboundLocationPacket;
import net.hypixel.modapi.packet.impl.serverbound.ServerboundVersionedPacket;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lat/hannibal2/skyhanni/api/hypixelapi/HypixelEventApi;", "", "<init>", "()V", "Lnet/hypixel/modapi/packet/impl/clientbound/ClientboundHelloPacket;", "packet", "", "onHelloPacket", "(Lnet/hypixel/modapi/packet/impl/clientbound/ClientboundHelloPacket;)V", "Lnet/hypixel/modapi/packet/impl/clientbound/event/ClientboundLocationPacket;", "onLocationPacket", "(Lnet/hypixel/modapi/packet/impl/clientbound/event/ClientboundLocationPacket;)V", "Lnet/hypixel/modapi/packet/impl/serverbound/ServerboundVersionedPacket;", "sendPacket", "(Lnet/hypixel/modapi/packet/impl/serverbound/ServerboundVersionedPacket;)V", "Lnet/hypixel/modapi/HypixelModAPI;", "modApi", "Lnet/hypixel/modapi/HypixelModAPI;", "1.21.5"})
public final class HypixelEventApi {
    @NotNull
    public static final HypixelEventApi INSTANCE = new HypixelEventApi();
    @NotNull
    private static final HypixelModAPI modApi;

    private HypixelEventApi() {
    }

    private final void onHelloPacket(ClientboundHelloPacket packet) {
        if (!HypixelLocationApi.INSTANCE.getConfig()) {
            return;
        }
        boolean isAlpha = packet.getEnvironment() != Environment.PRODUCTION;
        new HypixelApiJoinEvent(isAlpha).post();
    }

    private final void onLocationPacket(ClientboundLocationPacket packet) {
        if (!HypixelLocationApi.INSTANCE.getConfig()) {
            return;
        }
        String string = packet.getServerName();
        Optional optional = packet.getServerType();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getServerType(...)");
        ServerType serverType = (ServerType)OptionalsKt.getOrNull((Optional)optional);
        Optional optional2 = packet.getLobbyName();
        Intrinsics.checkNotNullExpressionValue((Object)optional2, (String)"getLobbyName(...)");
        String string2 = (String)OptionalsKt.getOrNull((Optional)optional2);
        Optional optional3 = packet.getMode();
        Intrinsics.checkNotNullExpressionValue((Object)optional3, (String)"getMode(...)");
        String string3 = (String)OptionalsKt.getOrNull((Optional)optional3);
        Optional optional4 = packet.getMap();
        Intrinsics.checkNotNullExpressionValue((Object)optional4, (String)"getMap(...)");
        new HypixelApiServerChangeEvent(string, serverType, string2, string3, (String)OptionalsKt.getOrNull((Optional)optional4)).post();
    }

    public final void sendPacket(@NotNull ServerboundVersionedPacket packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        try {
            modApi.sendPacket((HypixelPacket)packet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        HypixelModAPI hypixelModAPI = HypixelModAPI.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)hypixelModAPI, (String)"getInstance(...)");
        modApi = hypixelModAPI;
        modApi.subscribeToEventPacket(ClientboundLocationPacket.class);
        modApi.createHandler(ClientboundHelloPacket.class, INSTANCE::onHelloPacket);
        modApi.createHandler(ClientboundLocationPacket.class, INSTANCE::onLocationPacket);
    }
}

